test_that("Output of function 'pIntrinsic' stays the same.", {
    # set all possible parameters
    grid <- expand.grid(
        p = c(1e-4, 0.5, 0.999999),
        z = seq(-4, 4, length.out = 5L),
        alternative = c("one.sided", "two.sided"),
        type = c("Held", "Matthews"),
        stringsAsFactors = FALSE
    )
    out <- lapply(
        seq_len(nrow(grid)),
        function(i) {
            tryCatch({
                pIntrinsic(
                    p = grid[i, "p"],
                    z = grid[i, "z"],
                    alternative = grid[i, "alternative"],
                    type = grid[i, "type"]
                )
            },
            warning = function(w) "warning!",
            error = function(e) "error!"
            )
        }
    )
    res <- list(
        0.00427248731343792, 0.5, 0.999611946832777, 0.00427248731343792,
        0.5, 0.999611946832777, 0.00427248731343792, 0.5, 0.999611946832777,
        0.00427248731343792, 0.5, 0.999611946832777, 0.00427248731343792,
        0.5, 0.999611946832777, 0.00594020536563311, 0.633407499183923,
        0.999999292893219, 0.00594020536563311, 0.633407499183923,
        0.999999292893219, 0.00594020536563311, 0.633407499183923,
        0.999999292893219, 0.00594020536563311, 0.633407499183923,
        0.999999292893219, 0.00594020536563311, 0.633407499183923,
        0.999999292893219, 0.00172943449396743, 0.5, 0.99990685261243,
        0.00172943449396743, 0.5, 0.99990685261243, 0.00172943449396743,
        0.5, 0.99990685261243, 0.00172943449396743, 0.5, 0.99990685261243,
        0.00172943449396743, 0.5, 0.99990685261243, 0.00222378173673518,
        0.595937883003954, 0.999999213848622, 0.00222378173673518,
        0.595937883003954, 0.999999213848622, 0.00222378173673518,
        0.595937883003954, 0.999999213848622, 0.00222378173673518,
        0.595937883003954, 0.999999213848622, 0.00222378173673518,
        0.595937883003954, 0.999999213848622
    )
    expect_equal(out, res)
})