% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/powerEdgington.R
\name{powerEdgington}
\alias{powerEdgington}
\title{Computes the power for replication success with Edgington's method}
\usage{
powerEdgington(
  zo = NULL,
  po = NULL,
  r = 1,
  c = 1,
  level = 0.025,
  designPrior = "conditional",
  shrinkage = 0
)
}
\arguments{
\item{zo}{Numeric vector of z-values from original studies.}

\item{po}{Numeric vector of original one-sided p-values}

\item{r}{Numeric vector of ratios of replication to original weight.}

\item{c}{Numeric vector of variance ratios of the original and replication
effect estimates. This is usually the ratio of the sample
size of the replication study to the sample size of the original study.}

\item{level}{One-sided significance level. Default is 0.025.}

\item{designPrior}{Either "conditional" (default) or "predictive".}

\item{shrinkage}{Numeric vector with values in [0,1). Defaults to 0.
Specifies the shrinkage of the original effect estimate towards zero, e.g.,
the effect is shrunken by a factor of 25\% for \code{shrinkage = 0.25}.}
}
\value{
The power with Edgington's method
}
\description{
The power with Edgington's method is computed based on the result of
the original study (z-value or one-sided p-value),
the corresponding variance ratio, and the ratio of the
weight of the replication study over the weight of the
original study
}
\details{
Either \code{zo} or \code{po} must be specified.
}
\examples{
powerEdgington(po = 0.025, level = 0.025, c = 1.4)
}
\references{
Held, L., Pawel, S., Micheloud, C. (2024). The assessment of
    replicability using the sum of p-values. \emph{Royal Society Open
    Science}. 11(8):11240149. \doi{10.1098/rsos.240149}
}
\author{
Charlotte Micheloud, Leonhard Held, Samuel Pawel
}
