% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effectSizeSignificance.R
\name{effectSizeSignificance}
\alias{effectSizeSignificance}
\title{Computes the minimum relative effect size to achieve significance of the replication study}
\usage{
effectSizeSignificance(
  zo,
  c = 1,
  level = 0.025,
  alternative = c("one.sided", "two.sided")
)
}
\arguments{
\item{zo}{Numeric vector of z-values from original studies.}

\item{c}{Numeric vector of variance ratios of the original and replication effect estimates.
This is usually the ratio of the sample size of the replication study to the sample
size of the original study.}

\item{level}{Significance level. Default is 0.025.}

\item{alternative}{Specifies if the significance level is "one.sided" (default) or "two.sided".
If the significance level is one-sided, then effect size calculations are based on a one-sided assessment of
significance in the direction of the original effect estimate.}
}
\value{
The minimum relative effect size to achieve significance in the replication study.
}
\description{
The minimum relative effect size (replication to original) to achieve significance
of the replication study is computed based on the result of the original study and
the corresponding variance ratio.
}
\details{
\code{effectSizeSignificance} is the vectorized version of
the internal function \code{.effectSizeSignificance_}.
\code{\link[base]{Vectorize}} is used to vectorize the function.
}
\examples{
po <- c(0.001, 0.002, 0.01, 0.02, 0.025)
zo <- p2z(po, alternative = "one.sided")

effectSizeSignificance(zo = zo, c = 1, level = 0.025,
                       alternative = "one.sided")

effectSizeSignificance(zo = zo, c = 1, level = 0.05,
                       alternative = "two.sided")

effectSizeSignificance(zo = zo, c = 50, level = 0.025,
                       alternative = "one.sided")
}
\references{
Held, L., Micheloud, C., Pawel, S. (2022). The assessment of
    replication success based on relative effect size. The Annals of Applied
    Statistics. 16:706-720. \doi{10.1214/21-AOAS1502}
}
\seealso{
\code{\link{effectSizeReplicationSuccess}}
}
\author{
Charlotte Micheloud, Samuel Pawel, Florian Gerber
}
