% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/devices-tags.R
\name{devices_tags}
\alias{devices_tags}
\alias{devices_tags_upsert}
\alias{devices_tags_list}
\alias{devices_tags_delete}
\title{Tags (of devices) API methods}
\usage{
devices_tags_upsert(
  device_id,
  key,
  value,
  store_token = "option",
  token = NULL,
  silent = FALSE
)

devices_tags_list(
  device_id,
  store_token = "option",
  token = NULL,
  silent = FALSE
)

devices_tags_delete(
  device_id,
  key,
  store_token = "option",
  token = NULL,
  silent = FALSE
)
}
\arguments{
\item{device_id}{The id of the device}

\item{key}{The key of the tag (no spaces allowed)}

\item{value}{The value of the tag (no spaces allowed)}

\item{store_token}{Where your token is stored. If \code{option} it will be retrieved from the .Rprofile (not cross-session and default),
if \code{envir} it will be retrieved from environmental variables list (cross-session).}

\item{token}{A valid token created with \code{create_auth_token} or manually.
It not \code{NULL} it has higher priority then \code{store_token}.}

\item{silent}{Whether to hide or show API method success messages (default \code{FALSE})}
}
\value{
A tibble showing information about chosen tag or list of tags for given device
}
\description{
Upsert (create/update), List and Delete tags associated to a given device

Official documentation:
\itemize{
\item \href{https://www.arduino.cc/reference/en/iot/api/#api-DevicesV2Tags-devicesV2TagsUpsert}{devicesV2TagsUpsert}
\item \href{https://www.arduino.cc/reference/en/iot/api/#api-DevicesV2Tags-devicesV2TagsList}{devicesV2TagsList}
\item \href{https://www.arduino.cc/reference/en/iot/api/#api-DevicesV2Tags-devicesV2TagsDelete}{devicesV2TagsDelete}
}
}
\examples{
\dontrun{
Sys.setenv(ARDUINO_API_CLIENT_ID = 'INSERT CLIENT_ID HERE')
Sys.setenv(ARDUINO_API_CLIENT_SECRET = 'INSERT CLIENT_SECRET HERE')
create_auth_token()

device_id = "fa7ee291-8dc8-4713-92c7-9027969e4aa1"
### create/modify tag ###
devices_tags_upsert(device_id = device_id, key = "1", value = "test")

### check tags list ###
devices_tags_list(device_id = device_id)

### delete tag ###
devices_tags_delete(device_id = device_id, key = "1")
}
}
