% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shared.R
\name{generate_W_base_and_sort}
\alias{generate_W_base_and_sort}
\title{Generate Base Assignments and Sorts}
\usage{
generate_W_base_and_sort(
  X,
  max_designs = 25000,
  imbalance_function = "mahal_dist",
  r = 0,
  max_max_iters = 5
)
}
\arguments{
\item{X}{The data as an \eqn{n \times p} matrix.}

\item{max_designs}{The maximum number of designs. Default is 25,000.}

\item{imbalance_function}{A string indicating the imbalance function. Currently,
"abs_sum_difference" and "mahal_dist" are the options with the
latter being the default.}

\item{r}{An experimental feature that adds lower imbalance vectors
to the base set using the \code{GreedyExperimentalDesign}
package. This controls the number of vectors to search through
on each iteration.}

\item{max_max_iters}{An experimental feature that adds lower imbalance vectors
to the base set using the \code{GreedyExperimentalDesign}
package. The maximum number of iterations to use for the greedy search.}
}
\value{
A list including all arguments plus a matrix \code{W_base_sorted}
								whose \code{max_designs} rows are \code{n}-length allocation vectors
								and the allocation vectors are in
}
\description{
Generates the base vectors to be used when locating the optimal rerandomization threshold
}
\examples{
 n = 100
 p = 10
 X = matrix(rnorm(n * p), nrow = n, ncol = p)
 X = apply(X, 2, function(xj){(xj - mean(xj)) / sd(xj)})
 S = 1000
 
 W_base_obj = generate_W_base_and_sort(X, max_designs = S)
 W_base_obj
}
\author{
Adam Kapelner
}
