% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Stepwise.R
\name{Stepwise}
\alias{Stepwise}
\title{Funcao excluir coeficientes de regressao pela metodologia Stepwise}
\usage{
Stepwise(object, Save=NULL,scope=NULL, scale = 0,
direction = c("both", "backward", "forward"),
trace = 1, keep = NULL, steps = 1000, k = 2)
}
\arguments{
\item{object}{an object representing a model of an appropriate class (mainly "lm" and "glm"). This is used as the initial model in the Stepwise search.}

\item{Save}{Nome do aquivo a ser salvo o relatorio da metodologia Stepwise (Ex: "Resultado.txt").
Se for `NULL` nao sera salvo o relatorio de exclusao dos coeficientes.}

\item{scope}{defines the range of models examined in the Stepwise search. This should be either a single formula, or a list containing components upper and lower, both formulae. See the details for how to specify the formulae and how they are used.}

\item{scale}{used in the definition of the AIC statistic for selecting the models, currently only for lm, aov and glm models. The default value, 0, indicates the scale should be estimated: see extractAIC.}

\item{direction}{the mode of Stepwise search, can be one of "both", "backward", or "forward", with a default of "both". If the scope argument is missing the default for direction is "backward". Values can be abbreviated.}

\item{trace}{if positive, information is printed during the running of step. Larger values may give more detailed information.}

\item{keep}{a filter function whose input is a fitted model object and the associated AIC statistic, and whose output is arbitrary. Typically keep will select a subset of the components of the object and return them. The default is not to keep anything.}

\item{steps}{the maximum number of steps to be considered. The default is 1000 (essentially as many as required). It is typically used to stop the process early.}

\item{k}{the multiple of the number of degrees of freedom used for the penalty. Only k = 2 gives the genuine AIC: k = log(n) is sometimes referred to as BIC or SBC.}
}
\value{
Retorna resultados do modelo de regressao obtido pela metodologia Stepwise.
}
\description{
Esta funcao exclui coeficientes de regressao pela metodologia Stepwise.
}
\examples{
data("DadosPalma")
X=DadosPalma[,-7]
Y=DadosPalma[,7]
model=CreateModel(X,Intercept = TRUE, Simple =TRUE, InteractionLL = TRUE)
model
Ajust=FitModel(X,Y,Model=model)
Ajust
Stepwise(Ajust)

}
\references{
Tutoriais onlines:
https://www.youtube.com/channel/UCDGyvLCJnv9RtTY1YMBMVNQ
}
\seealso{
\code{\link{FitModel}}, \code{\link{CreateModel}}, \code{\link{PredictModel}}
}
