% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/6.modules.R
\name{module_eigen}
\alias{module_eigen}
\alias{module_expression}
\title{Calculate the eigenvalue of each module and correlation of nodes and eigenvalue (node_eigen_cor).}
\usage{
module_eigen(go_m, totu, cor_method = "spearman")

module_expression(
  go_m,
  totu,
  group = NULL,
  r_threshold = 0.6,
  x_order = NULL,
  facet_param = NULL,
  plot_eigen = FALSE
)
}
\arguments{
\item{go_m}{module metanet}

\item{totu}{original abundance table used for module_eigen().}

\item{cor_method}{"pearson", "kendall", "spearman"}

\item{group}{group variable for totu}

\item{r_threshold}{the threshold for node_eigen_cor, default: 0.6.}

\item{x_order}{order the x axis.}

\item{facet_param}{parameters parse to \code{\link[ggplot2]{facet_wrap}}, e.g. nrow=2.}

\item{plot_eigen}{plot the eigen value line.}
}
\value{
module metanet with module_eigen
}
\description{
Calculate the eigenvalue of each module and correlation of nodes and eigenvalue (node_eigen_cor).

Plot the expression of each modules
}
\examples{
data("otutab", package = "pcutils")
t(otutab) -> totu
data("c_net")
module_detect(co_net, n_node_in_module = 30) -> co_net_modu
module_eigen(co_net_modu, totu) -> co_net_modu
module_expression(co_net_modu, totu)
}
\seealso{
Other module: 
\code{\link{filter_n_module}()},
\code{\link{get_community}()},
\code{\link{get_module}()},
\code{\link{get_module_eigen}()},
\code{\link{module_detect}()},
\code{\link{module_net}()},
\code{\link{summary_module}()},
\code{\link{to_module_net}()},
\code{\link{zp_analyse}()}
}
\concept{module}
