# MDPIexploreR <img src="man/figures/logo.png" align="right" height="125"/>

<!-- badges: start -->

[![R-CMD-check](https://github.com/pgomba/MDPI_explorer/actions/workflows/R-CMD-check.yaml/badge.svg)](https://github.com/pgomba/MDPI_explorer/actions/workflows/R-CMD-check.yaml)

[![CRAN status](https://www.r-pkg.org/badges/version/MDPIexploreR)](https://CRAN.R-project.org/package=MDPIexploreR)
<!-- badges: end -->

Welcome to the wonders of `MDPIexploreR`, an R package created to provide comprehensive tools to scrape and analyze data from the MDPI journals. It allows users to extract metrics such as submission-to-acceptance times, article types, and whether articles are part of special issues. The package can also visualize this information through plots. Additionally, `MDPIexploreR` offers tools to explore patterns of self-citations within articles and provides insights into guest-edited special issues.

## Installation

You can install and load `MDPIexploreR` CRAN version with:

``` r
install.packages("MDPIexploreR")
library(MDPIexploreR)
```
or try the latest Github version with:

``` r
devtools::install_github("pgomba/MDPI_explorer")
library(MDPIexploreR)
```

## Citation

If you use `MDPIexploreR` in a publication or report, please cite it. Find the correct citation [here](https://pgomba.github.io/MDPI_explorer/authors.html#citation) or running this code:

``` r
citation("MDPIexploreR")

```

Head to [Introduction to `MDPIexploreR`](https://pgomba.github.io/MDPI_explorer/articles/introduction_MDPIexploreR.html) to get a glimpse of the functionalities of `MDPIexploreR`:
