% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poisson.R
\name{plotPois}
\alias{plotPois}
\title{Probability Mass and/or Distribution Function Representations associated with a Poisson Distribution}
\usage{
plotPois(lambda, type = "b", col = "grey")
}
\arguments{
\item{lambda}{mean of the Poisson distribution.}

\item{type}{a character string giving the type of desired plot. The following values are possible:
"b" (default) for probability mass function and distribution function representations together,
"d" for distribution function representation and "p" for probability mass function representation.}

\item{col}{a single colour associated with the probability mass function representation; default to "grey".}
}
\value{
A matrix containing the probability mass and the distribution function associated with each point
of the support of a Poisson distribution with parameter \code{lambda}.
}
\description{
\code{plotPois} represents the probability mass and/or the distribution function associated with a Poisson
 distribution with parameter \code{lambda}.
}
\examples{
lambda=2
plotPois(lambda,type="d")
plotPois(lambda,type="p",col="pink")
plotPois(lambda)
}
