% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Mean.CI.R
\name{Mean.CI}
\alias{Mean.CI}
\title{Confidence Interval for the Mean of a Normal Population}
\usage{
Mean.CI(x, sigma = NULL, sc = NULL, s = NULL, n = NULL, conf.level)
}
\arguments{
\item{x}{numeric value or vector containing either the sample or the sample mean.}

\item{sigma}{if known, a single numeric value corresponding with the population standard deviation.}

\item{sc}{a single numeric value corresponding with the cuasi-standard deviation; not needed if if the sample is provided.}

\item{s}{a single numeric value corresponding with the sample standard deviation; not needed if the sample is provided.}

\item{n}{a single positive integer corresponding with the sample size; not needed if the sample is provided.}

\item{conf.level}{a single value corresponding with the confidence level of the interval; must be a value in (0,1).}
}
\value{
A list containing the following components:
\item{estimate}{a numeric value corresponding with the sample mean.}
\item{CI}{a numeric vector of length two containing the lower and upper bounds of the confidence interval.}
Independently on the user saving those values, the function provides a summary of the result on the console.
}
\description{
\code{Mean.CI} provides a pointwise estimation and a confidence interval for the mean of a Normal population in both scenarios: known and unknown population variance.
}
\details{
The formula interface is applicable when the user provides the sample and also when the user provides the value of the sample characteristics (sample mean, cuasi-standard deviation or sample standard deviation, jointly with the sample size).
}
\examples{
#Given the sample with known population variance
dat=rnorm(20,mean=2,sd=1)
Mean.CI(dat, sigma=1, conf.level=0.95)

#Given the sample with unknown population variance
dat=rnorm(20,mean=2,sd=1)
Mean.CI(dat, conf.level=0.95)

#Given the sample mean with known population variance:
dat=rnorm(20,mean=2,sd=1)
Mean.CI(mean(dat),sigma=1,n=20,conf.level=0.95)

#Given the sample mean with unknown population variance:
dat=rnorm(20,mean=2,sd=1)
Mean.CI(mean(dat),sc=sd(dat),n=20,conf.level=0.95)

}
