% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/groups.R
\name{yearOverYearIndexes}
\alias{yearOverYearIndexes}
\title{Estimate year-over-year indexes}
\usage{
yearOverYearIndexes(freq, indexFunction, indexArgs)
}
\arguments{
\item{freq}{the frequency of the data. Either "monthly" or "quarterly".}

\item{indexFunction}{the name of the function to use to calculate the
index as a string. Available options are `priceIndex`, `GEKSIndex`,
`GKIndex`, `WTPDIndex`.}

\item{indexArgs}{arguments for the price index function as a named list.
All arguments must be named.}
}
\value{
a list of indexes with one element for each month or quarter
}
\description{
Year-over-year indexes are indexes where the months or quarters of the
year are split in separate datasets and an index estimated on each.
Therefore, year-over-year indexes estimated on a dataset with five full years
of observations at a monthly frequency will have 12 separate indexes,
each with 5 observations.
}
\examples{
argsList <- list(x = CES_sigma_2, pvar = "prices", qvar = "quantities", pervar = "time",
prodID = "prodID", indexMethod = "fisher", output = "chained")

yearOverYearIndexes("quarterly", "priceIndex", argsList)

}
