% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transdistfuncs.r
\name{est.wt.matrix.weights}
\alias{est.wt.matrix.weights}
\title{Estimate matrix of basic Wallinga-Teunis weights}
\usage{
est.wt.matrix.weights(case.times, gen.t.dist)
}
\arguments{
\item{case.times}{a vector giving the occurrence time for each case}

\item{gen.t.dist}{a vector giving the generation time distribution for the infecting pathogen}
}
\value{
a numerical matrix with the number of columns and rows equal to the number of time steps in the epidemic
}
\description{
A function called by \code{est.wt.matrix}, which calculates the basic weights in the Wallinga-Teunis matrix given
the time of each case occurrence and the generation time distribution of the pathogen. Code adapted from the \pkg{R0} package.
}
\examples{
\donttest{

case.times <- c(1,2,2,3,3)
gen <- c(0, 2/3, 1/3, 0, 0)
t.density <- gen/sum(gen)

a <- est.wt.matrix.weights(case.times=case.times, gen.t.dist=t.density)

}
}
\references{
Boelle P and Obadia T (2015). R0: Estimation of R0 and Real-Time Reproduction Number from Epidemics. R package version 1.2-6, \href{https://CRAN.R-project.org/package=R0}{https://CRAN.R-project.org/package=R0}.

Salje H, Cummings DAT and Lessler J (2016). “Estimating infectious disease transmission distances using the overall distribution of cases.” Epidemics, 17, pp. 10–18. ISSN 1755-4365, doi: \href{https://www.sciencedirect.com/science/article/pii/S1755436516300317}{10.1016/j.epidem.2016.10.001}.
}
\seealso{
Other est.wt: 
\code{\link{est.transdist}()},
\code{\link{est.wt.matrix}()}
}
\author{
John Giles, Justin Lessler, and Henrik Salje
}
\concept{est.wt}
