% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Imputation.R
\name{hapiImupte}
\alias{hapiImupte}
\title{Imputation of missing genotypes in the framework}
\usage{
hapiImupte(gmt, nSPT = 2, allowNA = 0)
}
\arguments{
\item{gmt}{a dataframe of genotype data of gamete cells in the framework}

\item{nSPT}{a numeric value of the minumum number of supports 
for an imputation}

\item{allowNA}{a numeric value of the maximum number of gametes with 
NA at a locus}
}
\value{
a dataframe of imputed genotypes in the framework
}
\description{
Imputation of missing genotypes in the framework
}
\examples{
ref <- rep(0,500)
alt <- rep(1,500)

gmtFrame <- data.frame(gmt1=ref, gmt2=alt, gmt3=ref,
gmt4=ref, gmt5=c(alt[1:250], ref[251:500]),
stringsAsFactors = FALSE)

idx1 <- sort(sample(seq_len(500), 30, replace = FALSE))
idx2 <- sort(sample(seq_len(500), 30, replace = FALSE))
idx3 <- sort(sample(seq_len(500), 30, replace = FALSE))

gmtFrame[idx1,1] <- NA
gmtFrame[idx2,2] <- NA
gmtFrame[idx3,3] <- NA
imputedFrame <- hapiImupte(gmtFrame, nSPT=2, allowNA=0)
}
\author{
Ruidong Li
}
