\name{aliquot}
\alias{aliquot}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Generate the Aliquot Sequence.
}
\description{
Each term in the aliquot sequence is generated by summing all proper divisors of the previous term. The value "1" is included in this collection of divisors. 
In number theory, aliquot is closely related to terms such as "sociable" and "amicable" numbers
}
\usage{
aliquot(x, maxiter = 100)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x}{
An integer , \code{bigz} integer, or character string representing an integer to start the desired sequence
}
  \item{maxiter}{
Set a limit on the number of terms to calculate. See Details for reasons why to do so. 
}
}
\details{
While many aliquot sequences terminate in the values c(prime_number, 1, 0), many numbers drop into a short loop or a repeating value (perfect numbers do this).  If the sequence repeats or terminates, the sequence is returned. If  \code{maxiter} is reached, the output \code{converged} is set to FALSE and the sequence so far is returned. 
}
\value{
A list containing
theseq, the sequence generated
converged, a logical value indicating whether convergence (including cyclic) was reached.
thecycle, the subset of \code{theseq} which is cyclic
}

\author{
Carl Witthoft,  \email{carl@witthoft.com} 
%%  ~~who you are~~
}


\examples{
aliquot(20)
# $theseq
# Big Integer ('bigz') object of length 7:
# [1] 20 22 14 10 8  7  1 
# $converged
# [1] TRUE
# $thecycle
# Big Integer ('bigz') :
# [1] 1
# (aliquot(1264460))
# $theseq
# Big Integer ('bigz') object of length 5:
# [1] 1264460 1547860 1727636 1305184 1264460
# $converged
# [1] TRUE
# $thecycle
# Big Integer ('bigz') object of length 5:
# [1] 1264460 1547860 1727636 1305184 1264460
}
