% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update.R
\name{update}
\alias{update}
\title{Update the FVDDP when new observations are collected}
\usage{
update(fvddp, y.new)
}
\arguments{
\item{fvddp}{An object of class \code{fvddp}; it can be created via \code{\link[=initialize]{initialize()}}.}

\item{y.new}{A vector of new values to update the process.}
}
\value{
An object which is similar to the one given as an input. In particular,
the multiplicities of \code{y.new} will be added to each row of \code{M}, and the weights
\code{w} will be multiplied times the probability of drawing \code{y.new} form each row
of the matrix \code{M} according to Polya urn sampling scheme.
}
\description{
Update the FVDDP when new observations are collected
}
\examples{
#initialize and propagate a object
FVDDP = initialize(1, function(x) rpois(x, 3),
                   function(x) dpois(x, 3), TRUE)
update(fvddp = FVDDP, y.new = c(4,5))

#in this case, update after a propagation to see the diiffent effect of polya urn on the weights
FVDDP=initialize(3, function(x) rnorm(x, -1,3),
                 function(x) dnorm(x, -1, 3), FALSE)
FVDDP = update(FVDDP, c(-1.145, 0.553, 0.553))
FVDDP = propagate(FVDDP, 0.6)
update(fvddp = FVDDP, y.new = c(0.553, -0.316, -1.145))

}
\references{
{
\insertRef{PapaspiliopoulosRuggieroSpanò2016}{FVDDPpkg}
}
}
