% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meanWH.R
\name{meanWH}
\alias{meanWH}
\title{Arithmetic, Harmonic, Geometric and Weighted Mean}
\usage{
meanWH(x, meth = NULL, narm = FALSE, dec = NULL)
}
\arguments{
\item{x}{Numeric. A vector of the data set.}

\item{meth}{Character. To compute the arithmetic (meth="a"), harmonic ("h"), geometric ("g") or weighted ("w") mean. Only for
weighted mean option, an additional column including the weight of values is required.}

\item{narm}{Logical. Optional argument used to compute the mean removing NA values.}

\item{dec}{Numeric. A value to define the number of decimals in the returns.}
}
\value{
This function returns a numerical value representing the mean depending on used method.
}
\description{
Function used to compute different kind of mean in variables.
}
\details{
This function shows the mean as a numerical value from the data set. For the case of weighted mean, an additional column
must be included in the dataset containing the assigned weigths of each value. The weighted mean is computed taking into account the
total percentage of weights, that is, for cases that the sumed of wights is 100\% or different (i.e. 90\%, 120\%, etc).
}
\examples{
#Example 1
data1=c(7,6,NA,8,NA)
meanWH(x=data1,meth="a",narm=TRUE)
#Example 2
data2=rnorm(10,50,3)
meanWH(x=data2,meth="a",dec=2)
#Example 3
data3=rnorm(100,50,11)
meanWH(x=data3,meth="g")
#Example 4
data4=rnorm(10,20,4)
meanWH(data4,meth="h")
#Example 5  (total weight is closed to 100\%)
df1=data.frame(value=c(9,8,7,8),weight=c(0.5,0.2,0.2,0.1))
meanWH(df1,meth="w")
#Example 6  (total weight is not closed 100\%)
df2=data.frame(value=c(9,8,7,8),weight=c(0.5,0.2,0.2,0.2))
meanWH(df2,meth="w")
}
