% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measure_retention.R
\name{measure_retention}
\alias{measure_retention}
\title{Measure Length of Use Pattern before Dropout}
\usage{
measure_retention(use_pattern, missing_is = "o")
}
\arguments{
\item{use_pattern}{A character string showing the daily, by visit, or weekly
substance use pattern for a single subject}

\item{missing_is}{Which single character is used to mark missing UDS in a
use pattern string? Defaults to \code{"o"}.}
}
\value{
An integer measuring the number of visits before the subject was lost
to follow-up. If the subject's entire use pattern is missing, then this
will be 0.
}
\description{
Find the number of visits in the pattern until the last subject
contact
}
\details{
At current, we allow for many symbols in the use pattern "word",
such as "_" for missing by study design, "o" missing for protocol
non-compliance (the most common form of missing), "+" for positive, "-" for
negative, and "*" for mixed positive and negative results (this usually
comes up when the visit represents multiple days and there are both
positive and negative results in those days; for example, a subject is
tested weekly; they provided a positive test on Tuesday but came back to
provide a negative test the following day).
}
\examples{
  pattern_char <- "__++++*o-------+--+-o-o-o+o+oooooo"
  measure_retention(pattern_char)
  
  pattern2_char <- "ooooooooooo"
  measure_retention(pattern2_char)
  
}
