% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_brazil_holidays.R
\name{get_brazil_holidays}
\alias{get_brazil_holidays}
\title{Get Official Public Holidays in Brazil for a Given Year}
\source{
Data obtained from the Nager.Date API: \url{https://date.nager.at/}
}
\usage{
get_brazil_holidays(year)
}
\arguments{
\item{year}{An integer indicating the year (e.g., 2024 or 2025).}
}
\value{
A tibble with the following columns:
\itemize{
  \item \code{date}: Date of the holiday (class \code{Date})
  \item \code{local_name}: Holiday name in the local language (Portuguese)
  \item \code{name}: Holiday name in English
}
}
\description{
Retrieves the list of official public holidays in Brazil for a specific year
using the Nager.Date public holidays API.
This function returns a tibble containing the date of the holiday, the name
in the local language (Portuguese), and the English name.
It is useful for academic, planning, and data analysis purposes.
The information is retrieved directly from the Nager.Date API and reflects
the current status of holidays for the requested year.
The field names returned are consistent with the API structure.
}
\examples{
get_brazil_holidays(2024)
get_brazil_holidays(2025)

}
