test_that("BRISE works on simulated data", {
  set.seed(1)
  X <- matrix(rnorm(50*200, mean = 0), nrow = 50)
  Y <- matrix(rnorm(50*200, mean = 0.3), nrow = 50)

  # add structured missingness
  X[1:20, 1:100] <- 0
  X[30:50, 101:200] <- 0
  Y[1:10, 1:100] <- 0
  Y[30:40, 101:200] <- 0

  out <- BRISE(X = X, Y = Y, k = 5, perm = 10, ver = "con")

  # sanity checks
  expect_type(out, "list")
  expect_true("test.statistic" %in% names(out))
  expect_true("pval.approx" %in% names(out))
  expect_true(is.numeric(out$test.statistic))
  expect_true(is.numeric(out$pval.approx))
})
