% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zero_inflated_poisson.R
\name{bi.dist.zero_inflated_poisson}
\alias{bi.dist.zero_inflated_poisson}
\title{A Zero Inflated Poisson distribution.}
\usage{
bi.dist.zero_inflated_poisson(
  gate,
  rate = 1,
  validate_args = py_none(),
  name = "x",
  obs = py_none(),
  mask = py_none(),
  sample = FALSE,
  seed = py_none(),
  shape = c(),
  event = 0,
  create_obj = FALSE,
  to_jax = TRUE
)
}
\arguments{
\item{gate}{The gate parameter.}

\item{rate}{A numeric vector, matrix, or array representing the rate parameter of the underlying Poisson distribution.}

\item{validate_args}{Logical: Whether to validate parameter values.  Defaults to `reticulate::py_none()`.}

\item{name}{A character string representing the name of the random variable
within a model. This is used to uniquely identify the variable. Defaults to 'x'.}

\item{obs}{A numeric vector or array of observed values. If provided, the
random variable is conditioned on these values. If `NULL`, the variable is
treated as a latent (unobserved) variable. Defaults to `NULL`.}

\item{mask}{An optional boolean vector, matrix, or array to mask observations.}

\item{sample}{A logical value that controls the function's behavior. If `TRUE`,
the function will directly draw samples from the distribution. If `FALSE`,
it will create a random variable within a model. Defaults to `FALSE`.}

\item{seed}{An integer used to set the random seed for reproducibility when
`sample = TRUE`. This argument has no effect when `sample = FALSE`, as
randomness is handled by the model's inference engine. Defaults to 0.}

\item{shape}{A numeric vector used to shape the distribution. When `sample=False` (model building), this is used with `.expand(shape)` to set the distribution's batch shape. When `sample=True` (direct sampling), this is used as `sample_shape` to draw a raw JAX array of the given shape.}

\item{event}{The number of batch dimensions to reinterpret as event dimensions (used in model building).}

\item{create_obj}{Logical; If `TRUE`, returns the raw BI distribution object instead of creating a sample site.}

\item{to_jax}{Logical. Defaults to TRUE.}
}
\value{
\itemize{
  \item When \code{sample=FALSE}, a BI Zero Inflated Poisson distribution object (for model building).
  \item When \code{sample=TRUE}, a JAX array of samples drawn from the Zero Inflated Poisson distribution (for direct sampling).
  \item When \code{create_obj=TRUE}, the raw BI distribution object (for advanced use cases).
}
}
\description{
The Zero-Inflated Poisson distribution is a discrete count-distribution designed for data with *more zeros*
than would be expected under a standard Poisson. Essentially, it assumes two underlying processes:
* With probability \deqn{\pi} you are in a "structural zero" state (i.e., you automatically get a zero count).
* With probability \deqn{1 - \pi} you draw from a standard Poisson distribution with parameter \deqn{\lambda}.

This results in a mixture distribution that places more mass at zero than a Poisson alone would.
It's widely used in, for instance, ecology (species counts with many zeros), insurance/claims problems, and any count-data setting with excess zeros.
}
\examples{
\donttest{
library(BayesianInference)
m <- importBI(platform = "cpu")
bi.dist.zero_inflated_poisson(gate = 0.3, rate = 5, sample = TRUE)
}
}
