% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AutoScore_Ordinal.R
\name{AutoScore_rank_Ordinal}
\alias{AutoScore_rank_Ordinal}
\title{AutoScore STEP (i) for ordinal outcomes: Generate variable ranking
  list by machine learning (AutoScore Module 1)}
\usage{
AutoScore_rank_Ordinal(train_set, ntree = 100)
}
\arguments{
\item{train_set}{A processed \code{data.frame} that contains data to be analyzed, for training.}

\item{ntree}{Number of trees in the random forest (Default: 100).}
}
\value{
Returns a vector containing the list of variables and its ranking generated by machine learning (random forest)
}
\description{
AutoScore STEP (i) for ordinal outcomes: Generate variable ranking
  list by machine learning (AutoScore Module 1)
}
\details{
The first step in the AutoScore framework is variable ranking. We
  use random forest (RF) for multiclass classification to identify the
  top-ranking predictors for subsequent score generation. This step
  corresponds to Module 1 in the AutoScore-Ordinal paper.
}
\examples{
\dontrun{
# see AutoScore-Ordinal Guidebook for the whole 5-step workflow
data("sample_data_ordinal") # Output is named `label`
ranking <- AutoScore_rank_ordinal(sample_data_ordinal, ntree = 50)
}
}
\references{
\itemize{
 \item{Breiman, L. (2001), Random Forests, Machine Learning 45(1), 5-32}
 \item{Saffari SE, Ning Y, Feng X, Chakraborty B, Volovici V, Vaughan R, Ong
       ME, Liu N, AutoScore-Ordinal: An interpretable machine learning framework for
       generating scoring models for ordinal outcomes, arXiv:2202.08407}
}
}
\seealso{
\code{\link{AutoScore_parsimony_Ordinal}},
  \code{\link{AutoScore_weighting_Ordinal}},
  \code{\link{AutoScore_fine_tuning_Ordinal}},
  \code{\link{AutoScore_testing_Ordinal}}.
}
