/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import org.scilab.forge.jlatexmath.MacroInfo;
import org.scilab.forge.jlatexmath.ResourceParseException;
import org.scilab.forge.jlatexmath.TeXConstants;
import org.scilab.forge.jlatexmath.TeXFormula;
import org.scilab.forge.jlatexmath.XMLResourceParseException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TeXFormulaParser {
    private static final String ARG_VAL_ATTR = "value";
    private static final String RETURN_EL = "Return";
    private static final String ARG_OBJ_ATTR = "formula";
    private static Map<String, Class<?>> classMappings = new HashMap();
    private final Map<String, ArgumentValueParser> argValueParsers = new HashMap<String, ArgumentValueParser>();
    private final Map<String, ActionParser> actionParsers = new HashMap<String, ActionParser>();
    private final Map<String, TeXFormula> tempFormulas = new HashMap<String, TeXFormula>();
    private final Map<String, MacroInfo> tempCommands = new HashMap<String, MacroInfo>();
    private Object result = new Object();
    private final String formulaName;
    private final Element formula;
    private static final int COMMAND = 0;
    private static final int TEXFORMULA = 1;
    private int type;

    public TeXFormulaParser(String name, Element formula, String type) {
        this.formulaName = name;
        this.formula = formula;
        int n = this.type = "Command".equals(type) ? 0 : 1;
        if ("Command".equals(type)) {
            this.actionParsers.put("CreateCommand", new CreateCommandParser());
        } else {
            this.actionParsers.put("CreateTeXFormula", new CreateTeXFormulaParser());
        }
        this.actionParsers.put("MethodInvocation", new MethodInvocationParser());
        this.actionParsers.put(RETURN_EL, new ReturnParser());
        this.argValueParsers.put("TeXConstants", new TeXConstantsValueParser());
        this.argValueParsers.put("TeXFormula", new TeXFormulaValueParser());
        this.argValueParsers.put("String", new StringValueParser());
        this.argValueParsers.put("float", new FloatValueParser());
        this.argValueParsers.put("int", new IntValueParser());
        this.argValueParsers.put("boolean", new BooleanValueParser());
        this.argValueParsers.put("char", new CharValueParser());
        this.argValueParsers.put("ColorConstant", new ColorConstantValueParser());
    }

    public Object parse() throws ResourceParseException {
        NodeList list = this.formula.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Element el;
            ActionParser p;
            Node node = list.item(i);
            if (node.getNodeType() == 3 || (p = this.actionParsers.get((el = (Element)node).getTagName())) == null) continue;
            p.parse(el);
        }
        return this.result;
    }

    private Object[] getArgumentValues(NodeList args) {
        Object[] res = new Object[args.getLength()];
        int i = 0;
        for (int j = 0; j < args.getLength(); ++j) {
            Element arg = (Element)args.item(j);
            String type = TeXFormulaParser.getAttrValueAndCheckIfNotNull("type", arg);
            String value = arg.getAttribute(ARG_VAL_ATTR);
            res[i] = this.argValueParsers.get(type).parseValue(value, type);
            ++i;
        }
        return res;
    }

    private static Class[] getArgumentClasses(NodeList args) throws ResourceParseException {
        Class[] res = new Class[args.getLength()];
        int i = 0;
        for (int j = 0; j < args.getLength(); ++j) {
            Element arg = (Element)args.item(j);
            String type = TeXFormulaParser.getAttrValueAndCheckIfNotNull("type", arg);
            Class<?> cl = classMappings.get(type);
            if (cl == null) {
                throw new XMLResourceParseException("PredefinedTeXFormulas.xml", "Argument", "type", "has an invalid class name value!");
            }
            res[i] = cl;
            ++i;
        }
        return res;
    }

    private static void checkNullValue(String value, String type) throws ResourceParseException {
        if (value.equals("")) {
            throw new XMLResourceParseException("PredefinedTeXFormulas.xml", "Argument", ARG_VAL_ATTR, "is required for an argument of type '" + type + "'!");
        }
    }

    private static String getAttrValueAndCheckIfNotNull(String attrName, Element element) throws ResourceParseException {
        String attrValue = element.getAttribute(attrName);
        if (attrValue.equals("")) {
            throw new XMLResourceParseException("PredefinedTeXFormulas.xml", element.getTagName(), attrName, null);
        }
        return attrValue;
    }

    static {
        classMappings.put("TeXConstants", Integer.TYPE);
        classMappings.put("TeXFormula", TeXFormula.class);
        classMappings.put("String", String.class);
        classMappings.put("float", Float.TYPE);
        classMappings.put("int", Integer.TYPE);
        classMappings.put("boolean", Boolean.TYPE);
        classMappings.put("char", Character.TYPE);
        classMappings.put("ColorConstant", Color.class);
    }

    private class ColorConstantValueParser
    implements ArgumentValueParser {
        ColorConstantValueParser() {
        }

        public Object parseValue(String value, String type) throws ResourceParseException {
            TeXFormulaParser.checkNullValue(value, type);
            try {
                return Color.class.getDeclaredField(value).get(null);
            }
            catch (Exception e) {
                throw new XMLResourceParseException("PredefinedTeXFormulas.xml", "Argument", TeXFormulaParser.ARG_VAL_ATTR, "has an unknown color constant name as value : '" + value + "'!", e);
            }
        }
    }

    private class TeXConstantsValueParser
    implements ArgumentValueParser {
        TeXConstantsValueParser() {
        }

        public Object parseValue(String value, String type) throws ResourceParseException {
            TeXFormulaParser.checkNullValue(value, type);
            try {
                int constant = TeXConstants.class.getDeclaredField(value).getInt(null);
                return constant;
            }
            catch (Exception e) {
                throw new XMLResourceParseException("PredefinedTeXFormulas.xml", "Argument", TeXFormulaParser.ARG_VAL_ATTR, "has an unknown constant name as value : '" + value + "'!", e);
            }
        }
    }

    private class TeXFormulaValueParser
    implements ArgumentValueParser {
        TeXFormulaValueParser() {
        }

        public Object parseValue(String value, String type) throws ResourceParseException {
            if (value == null) {
                return null;
            }
            Object formula = TeXFormulaParser.this.tempFormulas.get(value);
            if (formula == null) {
                throw new XMLResourceParseException("PredefinedTeXFormulas.xml", "Argument", TeXFormulaParser.ARG_VAL_ATTR, "has an unknown temporary TeXFormula name as value : '" + value + "'!");
            }
            return (TeXFormula)formula;
        }
    }

    private class StringValueParser
    implements ArgumentValueParser {
        StringValueParser() {
        }

        public Object parseValue(String value, String type) throws ResourceParseException {
            return value;
        }
    }

    private class ReturnParser
    implements ActionParser {
        ReturnParser() {
        }

        public void parse(Element el) throws ResourceParseException {
            Object res;
            String name = TeXFormulaParser.getAttrValueAndCheckIfNotNull("name", el);
            Object v = res = TeXFormulaParser.this.type == 0 ? TeXFormulaParser.this.tempCommands.get(name) : TeXFormulaParser.this.tempFormulas.get(name);
            if (res == null) {
                throw new XMLResourceParseException("PredefinedTeXFormulas.xml", TeXFormulaParser.RETURN_EL, "name", "contains an unknown temporary TeXFormula variable name '" + name + "' for the predefined TeXFormula '" + TeXFormulaParser.this.formulaName + "'!");
            }
            TeXFormulaParser.this.result = res;
        }
    }

    private class IntValueParser
    implements ArgumentValueParser {
        IntValueParser() {
        }

        public Object parseValue(String value, String type) throws ResourceParseException {
            TeXFormulaParser.checkNullValue(value, type);
            try {
                int val = Integer.parseInt(value);
                return new Float(val);
            }
            catch (NumberFormatException e) {
                throw new XMLResourceParseException("PredefinedTeXFormulas.xml", "Argument", TeXFormulaParser.ARG_VAL_ATTR, "has an invalid '" + type + "'-value : '" + value + "'!", e);
            }
        }
    }

    private class BooleanValueParser
    implements ArgumentValueParser {
        BooleanValueParser() {
        }

        public Object parseValue(String value, String type) throws ResourceParseException {
            TeXFormulaParser.checkNullValue(value, type);
            if ("true".equals(value)) {
                return Boolean.TRUE;
            }
            if ("false".equals(value)) {
                return Boolean.FALSE;
            }
            throw new XMLResourceParseException("PredefinedTeXFormulas.xml", "Argument", TeXFormulaParser.ARG_VAL_ATTR, "has an invalid '" + type + "'-value : '" + value + "'!");
        }
    }

    private class CharValueParser
    implements ArgumentValueParser {
        CharValueParser() {
        }

        public Object parseValue(String value, String type) throws ResourceParseException {
            TeXFormulaParser.checkNullValue(value, type);
            if (value.length() == 1) {
                return new Character(value.charAt(0));
            }
            throw new XMLResourceParseException("PredefinedTeXFormulas.xml", "Argument", TeXFormulaParser.ARG_VAL_ATTR, "must have a value that consists of exactly 1 character!");
        }
    }

    private class FloatValueParser
    implements ArgumentValueParser {
        FloatValueParser() {
        }

        public Object parseValue(String value, String type) throws ResourceParseException {
            TeXFormulaParser.checkNullValue(value, type);
            try {
                return new Float(Float.parseFloat(value));
            }
            catch (NumberFormatException e) {
                throw new XMLResourceParseException("PredefinedTeXFormulas.xml", "Argument", TeXFormulaParser.ARG_VAL_ATTR, "has an invalid '" + type + "'-value : '" + value + "'!", e);
            }
        }
    }

    private class CreateCommandParser
    implements ActionParser {
        CreateCommandParser() {
        }

        public void parse(Element el) throws ResourceParseException {
            String name = TeXFormulaParser.getAttrValueAndCheckIfNotNull("name", el);
            NodeList args = el.getElementsByTagName("Argument");
            Class[] argClasses = TeXFormulaParser.getArgumentClasses(args);
            Object[] argValues = TeXFormulaParser.this.getArgumentValues(args);
            try {
                MacroInfo f = (MacroInfo)MacroInfo.class.getConstructor(argClasses).newInstance(argValues);
                TeXFormulaParser.this.tempCommands.put(name, f);
            }
            catch (IllegalArgumentException e) {
                String err = "IllegalArgumentException:\n";
                err = err + "ClassLoader to load this class (TeXFormulaParser): " + this.getClass().getClassLoader() + "\n";
                for (Class cl : argClasses) {
                    err = err + "Created class: " + cl + " loaded with the ClassLoader: " + cl.getClassLoader() + "\n";
                }
                for (Object obj : argValues) {
                    err = err + "Created object: " + obj + "\n";
                }
                throw new XMLResourceParseException("Error creating the temporary command '" + name + "' while constructing the predefined command '" + TeXFormulaParser.this.formulaName + "'!\n" + err);
            }
            catch (Exception e) {
                throw new XMLResourceParseException("Error creating the temporary command '" + name + "' while constructing the predefined command '" + TeXFormulaParser.this.formulaName + "'!\n" + e.toString());
            }
        }
    }

    private class CreateTeXFormulaParser
    implements ActionParser {
        CreateTeXFormulaParser() {
        }

        public void parse(Element el) throws ResourceParseException {
            String name = TeXFormulaParser.getAttrValueAndCheckIfNotNull("name", el);
            NodeList args = el.getElementsByTagName("Argument");
            Class[] argClasses = TeXFormulaParser.getArgumentClasses(args);
            Object[] argValues = TeXFormulaParser.this.getArgumentValues(args);
            try {
                TeXFormula f = (TeXFormula)TeXFormula.class.getConstructor(argClasses).newInstance(argValues);
                TeXFormulaParser.this.tempFormulas.put(name, f);
            }
            catch (Exception e) {
                throw new XMLResourceParseException("Error creating the temporary TeXFormula '" + name + "' while constructing the predefined TeXFormula '" + TeXFormulaParser.this.formulaName + "'!\n" + e.toString());
            }
        }
    }

    private class MethodInvocationParser
    implements ActionParser {
        MethodInvocationParser() {
        }

        public void parse(Element el) throws ResourceParseException {
            String methodName = TeXFormulaParser.getAttrValueAndCheckIfNotNull("name", el);
            String objectName = TeXFormulaParser.getAttrValueAndCheckIfNotNull(TeXFormulaParser.ARG_OBJ_ATTR, el);
            Object object = TeXFormulaParser.this.tempFormulas.get(objectName);
            if (object == null) {
                throw new XMLResourceParseException("PredefinedTeXFormulas.xml", "Argument", TeXFormulaParser.ARG_OBJ_ATTR, "has an unknown temporary TeXFormula name as value : '" + objectName + "'!");
            }
            NodeList args = el.getElementsByTagName("Argument");
            Class[] argClasses = TeXFormulaParser.getArgumentClasses(args);
            Object[] argValues = TeXFormulaParser.this.getArgumentValues(args);
            try {
                TeXFormula.class.getMethod(methodName, argClasses).invoke((Object)((TeXFormula)object), argValues);
            }
            catch (Exception e) {
                throw new XMLResourceParseException("Error invoking the method '" + methodName + "' on the temporary TeXFormula '" + objectName + "' while constructing the predefined TeXFormula '" + TeXFormulaParser.this.formulaName + "'!\n" + e.toString());
            }
        }
    }

    private static interface ArgumentValueParser {
        public Object parseValue(String var1, String var2) throws ResourceParseException;
    }

    private static interface ActionParser {
        public void parse(Element var1) throws ResourceParseException;
    }
}

