/*
 * Copyright 1991 Pei-Yuan Wei.	All rights reserved.
 *
 * Permission to use, copy, and/or distribute for any purpose and
 * without fee is hereby granted, provided that both the above copyright
 * notice and this permission notice appear in all copies and derived works.
 * Fees for distribution or use of this software or derived works may only
 * be charged with express written permission of the copyright holder.
 * This software is provided ``as is'' without express or implied warranty.
 */
/*
 * Packet Routines
 */
#include <stdio.h>
#include <ctype.h>
#include "mystrings.h"
#include "hash.h"
#include "obj.h"
#include "packet.h"
#include "slotaccess.h"

#include "class.h"

char *packetTypeStr[] = {
	"INT",
	"FLT",
	"STR", 
	"CHR",
	"OBJ",
	"PKT",
	"ATR",
	"VLT",
	"ARY",
};

#define PACKET_STACK_SIZE	500

Packet *scrap_packet;
Packet *packetStack;
int 	packetStackIdx = -1;
int	packetStackSize = PACKET_STACK_SIZE;

int init_packet()
{
	packetStack = (Packet*)malloc(sizeof(struct Packet) * packetStackSize);
	return 1;
}

Packet *makePacket()
{
	Packet *new;

	new = (Packet*)malloc(sizeof(struct Packet));
	new->type = 0;
	new->info.i = 0;

	return new;
}

Packet *borrowPacket()
{
	if (++packetStackIdx > packetStackSize) {
		/* try to make a larger packet stack... */
		fprintf(stderr,
			"internal error: Packet stack overflow.\n");
		fprintf(stderr,
			"use ``-pstack'' option to allocate larger stack.\n");
		/* XXX unimplemented */
		exit(1);
	}
	packetStack[packetStackIdx].info.i = NULL;
	packetStack[packetStackIdx].type = 0;
	return &packetStack[packetStackIdx];
}

void returnPacket()
{
	if (packetStackIdx < 0) {
		fprintf(stderr, 
			"internal error: returnPacket() stack underflow...\n");
		return;
	}
	scrap_packet = &packetStack[packetStackIdx--];
/*
	if (PkFreeable(scrap_packet) && PkContent(scrap_packet))
		free(PkContent(scrap_packet));
*/
}

void returnPackets(n)
     int n;
{
	while (n-- > 0) {
		if (packetStackIdx < 0) {
			fprintf(stderr, 
				"internal error: returnPackets() stack underflow...\n");
			return;
		}
		scrap_packet = &packetStack[packetStackIdx--];
/*
		if (PkFreeable(scrap_packet) && PkContent(scrap_packet))
			free(PkContent(scrap_packet));
*/
	}
}

void dumpPacket(packet) 
	Packet *packet;
{

	printf("(%d %s) ", packet->type, packetTypeStr[packet->type]);
	switch (packet->type) {

	case PKT_INT:
		printf("%d", packet->info.i);
	break;

	case PKT_FLT:
		printf("%f", packet->info.f);
	break;

	case PKT_STR:
		if (packet->info.s)
			printf("\"%s\"", packet->info.s);
		else
			printf("(NULL)");
	break;

	case PKT_CHR:
		printf("'%c'", packet->info.c);
	break;

	case PKT_OBJ:
		if (packet->info.o)
			printf("%s", GET_name(packet->info.o));
		else
			printf("(NULL)");
	break;

	case PKT_PKT:
		printf("%x", packet->info.p);
	break;

	case PKT_ATR:
		printf("%x", packet->info.a);
	break;

	case PKT_VLT:
		printf("%x", packet->info.l);
	break;

	case PKT_ARY:
		if (packet->info.y) {
			int i;
			printf("size=%d: ", packet->info.y->size);
			for (i = 0; i < packet->info.y->size; i++) {
				printf("%d ", packet->info.y->info[i]);
			}
		}
	break;

	default:
		printf("(%d)", packet->info.i);
	break;
	}
}

Packet *clearPacket(packet)
	Packet *packet;
{
	packet->info.i = 0;
	packet->type   = 0;
	return packet;
}

Packet *copyPacket(packetTo, packetFrom)
	Packet *packetTo;
	Packet *packetFrom;
{
	packetTo->info.i = packetFrom->info.i;
	packetTo->type = packetFrom->type;
	return packetTo;
}

