/*
 * Copyright 1990 Pei-Yuan Wei.	All rights reserved.
 *
 * Permission to use, copy, and/or distribute for any purpose and
 * without fee is hereby granted, provided that both the above copyright
 * notice and this permission notice appear in all copies and derived works.
 * Fees for distribution or use of this software or derived works may only
 * be charged with express written permission of the copyright holder.
 * This software is provided ``as is'' without express or implied warranty.
 */
/*
 * class	: BCard
 * superClass	: field
 */
#include <stdio.h>
#include <ctype.h>
#include "error.h"
#include "mystrings.h"
#include "hash.h"
#include "ident.h"
#include "obj.h"
#include "packet.h"
#include "class.h"
#include "slotaccess.h"
#include "classlist.h"
#include "cl_BCard.h"
#include "misc.h"
#include "glib.h"

SlotInfo cl_BCard_NCSlots[] = {
	NULL
};
SlotInfo cl_BCard_NPSlots[] = {
	NULL
};
SlotInfo cl_BCard_CSlots[] = {
{
	STR_class,
	PTRS | SLOT_RW,
	(long)"BCard"
},{
	NULL
}
};
SlotInfo cl_BCard_PSlots[] = {
{
	STR__classInfo,
	CLSI,
	(long)&class_BCard
},{
	NULL
}
};

SlotInfo *slots_BCard[] = {
	(SlotInfo*)cl_BCard_NCSlots,
	(SlotInfo*)cl_BCard_NPSlots,
	(SlotInfo*)cl_BCard_CSlots,
	(SlotInfo*)cl_BCard_PSlots
};

MethodInfo meths_BCard[] = {
	/* local methods */
{
	STR_config,
	meth_BCard_config
},{
	STR_expose,
	meth_BCard_expose
},{
	STR_get,
	meth_BCard_get,
},{
	STR_initialize,
	meth_BCard_initialize
},{
	STR_render,
	meth_BCard_render
},{
	STR_set,
	meth_BCard_set
},{
	NULL
}
};

ClassInfo class_BCard = {
	slots_BCard,		/* class slot information	*/
	meths_BCard,		/* class methods		*/
	STR_BCard,		/* class identifier number	*/
	&class_field,		/* super class info		*/
};

int meth_BCard_config(self, result, argc, argv)
	VObj *self;
	Packet *result;
	int argc;
	Packet argv[];
{
	if (!meth_field_config(self, result, argc, argv)) return 0;
	return 1;
}

int meth_BCard_expose(self, result, argc, argv)
	VObj *self;
	Packet *result;
	int argc;
	Packet argv[];
{
	return meth_field_render(self, result, argc, argv);
}

int meth_BCard_get(self, result, argc, argv)
	VObj *self;
	Packet *result;
	int argc;
	Packet argv[];
{
	return meth_field_get(self, result, argc, argv);
}

int meth_BCard_initialize(self, result, argc, argv)
	VObj *self;
	Packet *result;
	int argc;
	Packet argv[];
{
	meth_field_initialize(self, result, argc, argv);
	return 1;
}

int meth_BCard_render(self, result, argc, argv)
	VObj *self;
	Packet *result;
	int argc;
	Packet argv[];
{
	Window w = GET_window(self);
	Pixmap pixmap;

	if (!w) meth_field_render(self, result, argc, argv);
	if (!(w = GET_window(self))) return 0;
	return 1;
}

/*
 * returns non-zero if set operation succeded, zero otherwise.
 */
int meth_BCard_set(self, result, argc, argv)
	VObj *self;
	Packet *result;
	int argc;
	Packet argv[];
{
	return meth_field_set(self, result, argc, argv);
}








