/*
 * packet.h
 */
/***************************************************************************
 *
 * Info Packet Structure
 *
 * biop.c depends (for convenient direct mapping) on:
 *	PKT_INT = 0, PKT_CHR = 1, PKT_FLT = 2, PKT_STR = 3
 */
enum {
	PKT_INT, /* 0 */
	PKT_CHR, /* 1 */
	PKT_FLT, /* 2 */
	PKT_STR, /* 3 */
	PKT_OBJ, /* 4 */
	PKT_PKT, /* 5 */
	PKT_ATR, /* 6 */
	PKT_VLT, /* 7 */
	PKT_ARY, /* 8 */
};

/*
extern char *packetTypeStr;
*/

typedef struct Packet {
	union {
		VObj	*o;
		int	i;
		float	f;
		char	c;
		char	*s;
		FILE	*fp;
		struct Packet *p;
		struct Attr *a;
		struct Array *y;
		struct VList *l;
	} info;
	short	type;
} Packet;

typedef struct Array {
	int size;
	int *info;
} Array;



extern int init_packet();
extern Packet *makePacket();
extern Packet *borrowPacket();
extern Packet *clearPacket();
extern Packet *copyPacket();
extern void returnPacket();
extern void returnPackets();
extern void dumpPacket();



