/*
 * Copyright 1990 Pei-Yuan Wei.	All rights reserved.
 *
 * Permission to use, copy, and/or distribute for any purpose and
 * without fee is hereby granted, provided that both the above copyright
 * notice and this permission notice appear in all copies and derived works.
 * Fees for distribution or use of this software or derived works may only
 * be charged with express written permission of the copyright holder.
 * This software is provided ``as is'' without express or implied warranty.
 */
/*
 * class	: GIF
 * superClass	: field
 */
#include <stdio.h>
#include <ctype.h>
#include "error.h"
#include "mystrings.h"
#include "hash.h"
#include "ident.h"
#include "obj.h"
#include "packet.h"
#include "class.h"
#include "slotaccess.h"
#include "classlist.h"
#include "cl_GIF.h"
#include "misc.h"
#include "glib.h"
#include "event.h"

SlotInfo cl_GIF_NCSlots[] = {
	NULL
};
SlotInfo cl_GIF_NPSlots[] = {
	NULL
};
SlotInfo cl_GIF_CSlots[] = {
{
	STR_class,
	PTRS | SLOT_RW,
	(long)"GIF"
},{
	NULL
}
};
SlotInfo cl_GIF_PSlots[] = {
{
	STR__classInfo,
	CLSI,
	(long)&class_GIF
},{
	NULL
}
};

SlotInfo *slots_GIF[] = {
	(SlotInfo*)cl_GIF_NCSlots,
	(SlotInfo*)cl_GIF_NPSlots,
	(SlotInfo*)cl_GIF_CSlots,
	(SlotInfo*)cl_GIF_PSlots
};

MethodInfo meths_GIF[] = {
	/* local methods */
{
	STR_config,
	meth_GIF_config
},{
	STR_expose,
	meth_GIF_expose
},{
	STR_get,
	meth_GIF_get,
},{
	STR_initialize,
	meth_GIF_initialize
},{
	STR_render,
	meth_GIF_render
},{
	STR_set,
	meth_GIF_set
},{
	NULL
}
};

ClassInfo class_GIF = {
	slots_GIF,		/* class slot information	*/
	meths_GIF,		/* class methods		*/
	STR_GIF,		/* class identifier number	*/
	&class_field,		/* super class info		*/
};

int meth_GIF_config(self, result, argc, argv)
	VObj *self;
	Packet *result;
	int argc;
	Packet argv[];
{
	if (!meth_field_config(self, result, argc, argv)) return 0;
	return 1;
}

int meth_GIF_expose(self, result, argc, argv)
	VObj *self;
	Packet *result;
	int argc;
	Packet argv[];
{
	return meth_field_render(self, result, argc, argv);
}

int meth_GIF_get(self, result, argc, argv)
	VObj *self;
	Packet *result;
	int argc;
	Packet argv[];
{
	return meth_field_get(self, result, argc, argv);
}

int meth_GIF_initialize(self, result, argc, argv)
	VObj *self;
	Packet *result;
	int argc;
	Packet argv[];
{
	meth_field_initialize(self, result, argc, argv);
	return 1;
}

int meth_GIF_render(self, result, argc, argv)
	VObj *self;
	Packet *result;
	int argc;
	Packet argv[];
{
	Window w = GET_window(self);
	Pixmap pixmap;

	if (!w) meth_field_render(self, result, argc, argv);
	if (!(w = GET_window(self))) return 0;
	return 1;
}

/*
 * returns non-zero if set operation succeded, zero otherwise.
 */
int meth_GIF_set(self, result, argc, argv)
	VObj *self;
	Packet *result;
	int argc;
	Packet argv[];
{
	return meth_field_set(self, result, argc, argv);
}








