#include <stdio.h>
#include <math.h>
#include "mystrings.h"
#include "hash.h"
#include "ident.h"
#include "obj.h"
#include "glib.h"
#include "packet.h"
#include "class.h"
#include "classlist.h"
#include "loader.h"
#include "cgen.h"
#include "cexec.h"
#include "slotaccess.h"
#include "misc.h"
#include "file.h"

#define DFLT_USR_WWW_HOME "WWW" /* patched */

char *version = "Viola=2.1.2, date=July 14, 1992";
char *usage = {"Usage:\n\
-cli			command line interface.\n\
-c			.\n\n\
-laf <mode>		(unsupported) look and feel mode (0 for expensive drawing).\n\n\
-obj <object name>	startup object (send \"render\" to it).\n\
-o <object name>	.\n\n\
-path <file path>	object file lookup path.\n\
-p <file path>		.\n\n\
-release		print release info.\n\
-r			.\n\n\
-snipet	<statement>	script snipet to interpret.\n\
-s <statement>		.\n\n\
-verbose		verbose mode.\n\
-v			.\n\n\
(for debugging)\n\
-pa			print AST.\n\
-pc			print PCode.\n\
-pe			print PCode execution trace.\n\
-wt			window tracking.\n\
"};

#ifndef DEFAULT_VIOLA_PATH
#define DEFAULT_VIOLA_PATH "/usr/lib/apps"
#endif

void main(argc, argv)
	int argc;
	char **argv;
{
	extern char **environ;
	Packet *result;
	HashEntry *entry;
	int i = 0, startWithCommandLineInterpreter = 0;
	char *defaultViolaPath = DEFAULT_VIOLA_PATH;
	char *violaPath;
	char *scriptSnipet = NULL;

	lookAndFeel = 1;

	if (violaPath = getEnvironVars(environ, "VIOLA_PATH", buff))
		violaPath = saveString(violaPath);

	while (argv[++i]) {
		/*fprintf(stderr, "arg[%d]=%s\n", i, argv[i]);*/

		if (noCaseStrCmp(argv[i], "-f")) {

		} else if (noCaseStrCmp(argv[i], "-cli") ||
			   noCaseStrCmp(argv[i], "-c")) {

			startWithCommandLineInterpreter = 1;

		} else if (noCaseStrCmp(argv[i], "-nocliprompt")) {
			extern int flag_cliprompt;
			flag_cliprompt = 0;

		} else if (noCaseStrCmp(argv[i], "-cmd_history")) {

			cmd_history = 1;

		} else if (noCaseStrCmp(argv[i], "-ar")) {

			passthru_argument = argv[++i];

		} else if (noCaseStrCmp(argv[i], "-pa")) {

			flag_printAST = 1;

		} else if (noCaseStrCmp(argv[i], "-pc")) {

			flag_printPCode = 1;

		} else if (noCaseStrCmp(argv[i], "-pe")) {

			flag_printExec = 1;

		} else if (noCaseStrCmp(argv[i], "-LAF") || 
			   noCaseStrCmp(argv[i], "-laf") || 
			   noCaseStrCmp(argv[i], "-l")) {

			if (!argv[++i]) {
				/* assume simple mode (1) */
				lookAndFeel = 1;
			} else {
				lookAndFeel = atoi(argv[i]);
			}
			
		} else if (noCaseStrCmp(argv[i], "-noarg")) {

		} else if (noCaseStrCmp(argv[i], "-path") ||
		           noCaseStrCmp(argv[i], "-p")) {

			violaPath = argv[++i];

		} else if (noCaseStrCmp(argv[i], "-release") || 
			   noCaseStrCmp(argv[i], "-r")) {

			fprintf(stderr, "%s\n", version);

		} else if (noCaseStrCmp(argv[i], "-snipet") ||
		           noCaseStrCmp(argv[i], "-s")) {

			scriptSnipet = argv[++i];

		} else if (noCaseStrCmp(argv[i], "-verbose") ||
			   noCaseStrCmp(argv[i], "-v")) {

			verbose = 1;
			
		} else if (noCaseStrCmp(argv[i], "-wt")) {

			extern int flag_window_tracking;
			flag_window_tracking = 1;

		} else {
			fputs(usage, stderr);
			exit(0);
		}
		if (i >= argc) break;
	}
      (void) initUserWWW(DFLT_USR_WWW_HOME); /*PATCHED*/

	if (!init_tfed()) exit(1);
	if (!init_sys()) exit(2);
	if (!init_ident()) exit(4);
	if (!init_class()) exit(5);
	if (!init_obj()) exit(6);
	if (!init_scanutils()) exit(7);
	if (!init_ast()) exit(8);
	if (!init_packet()) exit(9);
	if (!init_glib()) exit(10);
	if (!init_event()) exit(11);
	if (!init_cexec()) exit(12);
	if (!init_html()) exit(13);

	if (violaPath) {
		if (init_loader(violaPath)) {
			if (verbose)
				fprintf(stderr, "Using VIOLA_PATH=``%s''\n", 
					violaPath);
		}
	} else if (init_loader(defaultViolaPath)) {
		if (verbose)
			fprintf(stderr, "Using default violaPath=``%s''\n", 
				defaultViolaPath);
	} else {
		fprintf(stderr, 
			"Can't find application files. Check VIOLA_PATH.\n");
		exit(20);
	}

	if (!setHTMLStyle()) exit(14);

	load_object("res.font.v");
	entry = getHashEntry(objID2Obj, storeIdent("res.font"));
	if (!entry) {
		fprintf(stderr, 
			"can't find: font resource file (\"res.font.v\").\n");
		exit(21);
	}
	if (verbose) 
		fprintf(stderr, 
			"loaded: font resource file (\"res.font.v\").\n");

	VFontResourceObj = (VObj*)entry->val;
	if (!init_fonts()) {
		fprintf(stderr, "aborting due to font related problem.\n");
		exit(22);
	}

	if (verbose) fprintf(stderr, "initialized font resources.\n");

	load_object("res.v");
	entry = getHashEntry(objID2Obj, storeIdent("res"));
	if (!entry) {
		fprintf(stderr, "can't find: resource file (\"res.v\").\n");
		exit(23);
	}
	if (!(entry->val)) {
		fprintf(stderr, "can't find: resource file (\"res.v\").\n");
		exit(24);
	}
	VPrevObj = VTargetObj = VResourceObj = VCurrentObj = (VObj*)entry->val;

	result = borrowPacket();

	if (startWithCommandLineInterpreter)
		meth_generic_cli(VCurrentObj, result, 0, 0);

	sendMessage1(VCurrentObj, "render");

	if (scriptSnipet) {
		execScript(VCurrentObj, result, scriptSnipet);
	}

	if (verbose) fprintf(stderr, "entering event loop.\n");

	eventLoop();

	returnPacket();
	exit(0);
}


/* Bede McCall <bede@mitre.org> MITRE Corp */
#include <errno.h>
#include <pwd.h>

extern int errno;
extern char *sys_errlist[];
extern int sys_nerr;

initUserWWW ( www )
     char *www;
{
    int Errno;
    char *cp, *cuserid();
    static char path[128];

    Errno = 0;
    bzero(path, 128);
    cp = cuserid((char *)NULL);
    if ( cp ) {
      struct passwd *getpwnam();
      struct passwd *pw = getpwnam(cp);

      (void) strcat(path, pw->pw_dir);
      (void) strcat(path, "/");
      (void) strcat(path, www);

      if ( mkdir(path, 0x755) ) {
          Errno = errno;
          if ( verbose ) {
              if ( Errno < sys_nerr )
                (void) printf("mkdir(%s), error %d: %s\n", path, Errno, sys_errlist[Errno]);
              else
                (void) printf("mkdir(%s), error %d\n", path, Errno);
          }
      }
      else if ( verbose ) {
          (void) printf("created %s\n", path);
      }
    }
    (void) fflush(stdout);
}



