/*
 * html.c
 * 
 * Parts of this file originated from the lineMode browser 
 * (HTBrowse.c and GridText.c) by Nicola Pellow and Tim Berners-Lee.
 *
 * Authors: Nicola Pellow, Tim Berners-Lee, Pei-Yuan Wei.
 *
 */
#include <stdio.h>
#include "../libWWW/src/HTUtils.h"
#include "../libWWW/src/HTString.h"
#include "../libWWW/src/tcp.h"
#include "../libWWW/src/WWW.h"
#include "../libWWW/src/HTTCP.h"
#include "../libWWW/src/HTAnchor.h"
#include "../libWWW/src/HTParse.h"
#include "../libWWW/src/HTAccess.h"
#include "../libWWW/src/HTHistory.h"
#include "../libWWW/src/HTML.h"
#include "../libWWW/src/HText.h"
#include "../libWWW/src/HTList.h"
/*#include "HTFont.h"*/
#include "../libWWW/src/HTStyle.h"

#include "mystrings.h"
#include "hash.h"
#include "ident.h"
#include "obj.h"
#include "packet.h"
#include "class.h"
#include "slotaccess.h"
#include "vlist.h"
#include "attr.h"
#include "glib.h"
#include "slib.h"
#include "misc.h"
#include "tfed.h"
#include "html.h"
#include "DefaultStyles.h"

#ifdef TRACE
#undef TRACE
#define TRACE WWW_TraceFlag
#endif

int loaded_limit = 30;			/* default cache limit */
char *default_default = 0; /* @@ Parse home relative to this */

/* Forward decls
 */
TFStruct *html_updateTFtruct();
int html_buildTFCLine();
int html_convertStrToNodeLines();
int moveToSelectedAnchor();
HText *html_findHTextByAddress();
HText *html_loadDocument();

/* Used to by HText_new() to get Viola information
 */
TFStruct *new_tfstruct;

/*	From default style sheet:
*/
extern HTStyleSheet * styleSheet;	/* Default or overridden */

PRIVATE HTStyle default_style =
	{ 0,  "(Unstyled)", "",
	HT_NORMAL, 1.0, HT_BLACK,	0, 0,
	0, 0, 0, HT_LEFT,		1, 0,	0, 
	NO, NO, 0, 0,			0 };	

typedef struct _line {
	struct _line	*next;
	struct _line	*prev;
	short unsigned	offset;		/* Implicit initial spaces */
	short unsigned	size;		/* Number of characters */
	BOOL	split_after;		/* Can we split after? */
	BOOL	bullet;			/* Do we bullet? */
	char	data[1];		/* Space for terminator at least! */
	int	pixel_x;		/* current pixel size */
} HTLine;

typedef struct _TextAnchor {
	struct _TextAnchor *	next;
	int			number;		/* For user interface */
	int			start;		/* Characters */
	int			extent;		/* Characters */
	int			beginLine;	/* Line# in text field */
	int			endLine;	/* Line# in text field */
	HTChildAnchor *		anchor;
} TextAnchor;


struct _HText {
	HTParentAnchor *	node_anchor;
	char *			expandedAddress;
	char *			simpleAddress;
	char *			title;
	HTLine * 		last_line;
	int			lines;		/* Number of them */
	int			chars;		/* Number of them */
	TextAnchor *		first_anchor;	/* Singly linked list */
	TextAnchor *		last_anchor;
	int			last_anchor_number;	/* user number */
/* For Internal use: */	
	HTStyle *		style;			/* Current style */
	HTStyle *		next_style;		/* next style */
	int			permissible_split;	/* in last line */
	BOOL			in_line_1;		/* of paragraph */
/* For Viola use: */
	TFStruct		*tfstruct;
	TFLineNode 		*currentp;
	TFLineNode 		*insertp;
	int 			size;
	int 			offsetpx;
	int 			px;
	int 			fontID;
	int 			next_fontID;
	int 			tagID;
	TFChar 			*tbuff;
	int 			tbuffi;
	int 			tbufftags[TAGINFO_SIZE];
	int 			maxFontHeight;
	int 			maxFontDescent;
	int			flags;
	char			*htmlSrc;
	int 			htmlSrcSize;
	int 			isIndex;
};

PUBLIC HText * HTMainText = 0;		/* Equivalent of main window */
PUBLIC HTParentAnchor * HTMainAnchor = 0;	/* Anchor for HTMainText */

char *srcBuff;
char *srcName = "";
int srcBuffi = 0;
int srcBuffSize = 100000; /*XXX*/

PRIVATE HTList * loaded_texts;	/* A list of all those in memory */

/* Define Statements */
/* ================= */

#ifndef EOF
#define EOF (-1)                    /* End of file character defined as -1 */
#endif

#define WHITE_SPACE(c) ((c==' ')||(c=='\t')||(c=='\n')||(c=='\r'))
                                  /* Definition for any kind of white space */

/*	Public Variables
**	================
*/

PUBLIC  int  WWW_TraceFlag = 0;         /* Off unless -v option given */
PUBLIC FILE * logfile = 0;		/* File to output one-liners to */
PUBLIC char * HTClientHost = 0;		/* Name or number of telnetting host */

/* Arrays for storing the HyperText References */ 
PRIVATE char *	     logfile_root = 0;	    /* Log file name */
PRIVATE char *	     logfile_name = 0;	    /* Root of log file name */


/* Misc Externs */
/* ================================ */
extern char *saveString(); /* in mystrings.c */

/* Forward Declaration of Functions */
/* ================================ */

void History_List NOPARAMS; 

#define TBUFFSIZE 1024 /*XXX maximum line length. Used by tfed_buildLines() */
TFChar tbuff[TBUFFSIZE];

#define HBUFFSIZE 5000 /* buffer for hidden/embedding text (scripts) */
char hbuff[HBUFFSIZE];
int hbuffi;
int inHiddenState = 0;

int init_html()
{
	extern char *getwd();
        char wd[MAXPATHLEN];
        char *result = getwd(wd);

	WWW_TraceFlag = verbose ? 1 : 0;

	/* Eg file://cernvax.cern.ch */
	StrAllocCopy(default_default, "file://");
	StrAllocCat(default_default, HTHostName());

#ifdef MAXPATHLEN  
	if (result) {
		StrAllocCat(default_default, wd);
	} else {
		fprintf(stderr, 
			"HTBrowse: Can't read working directory.\n");
		StrAllocCat(default_default, "/default.html");
	}
#else
    if (TRACE) fprintf(stderr,
    	"HTBrowse: This platform does not support getwd()\n");
    StrAllocCat(default_default, "/");
#endif

	srcBuff = (char*)malloc(sizeof(char) * srcBuffSize);
	if (!srcBuff) return 0;
	srcBuffi = 0;

	return 1;
}

int html_backtrack()
{
	if (!HTHistory_canBacktrack()) {
		return 0;
	}
	HTLoadAnchor(HTHistory_backtrack());
	return 1;
}

TFStruct *html_clone(oldtf)
	TFStruct *oldtf;
{
	TFStruct *newtf = NULL;
	HText *oldhtext, *newhtext;

	if (!oldtf) return NULL;

	if (tfed_render(oldtf)) {
		newtf = updateEStrUser(oldtf->self);
	}
/*	
	newhtext = (TFStruct*)malloc(sizeof(*newhtext));
	if (!newhtext) {
		perror("malloc");
		return NULL;
	}
	bcopy(oldhtext, newhtext, sizeof(*newhtext));
*/
	return newtf;
}

int html_search(self, keyword)
	VObj *self;
	char *keyword;
{
	HText *htext;
	TFStruct *oldtf, *tf;
	int status;
	char *address = HTAnchor_address((HTAnchor*)HTMainAnchor);
	char *newAddress;
	char *p;	          /* pointer to first non-blank */
	char *q, *s;

	/* instead of changing HTSearch(), its code is transplanted here 
	 * for edition
	 */
	p = HTStrip(keyword);
	for (q=p; *q; q++) if (WHITE(*q)) *q = '+';
	newAddress = saveString(address);
	s=strchr(newAddress, '?');		/* Find old search string */
	if (s) *s = 0;			        /* Chop old search off */
	StrAllocCat(newAddress, "?");
	StrAllocCat(newAddress, p);

	if (htext = html_findHTextByAddress(self, newAddress)) {
		tf = htext->tfstruct;
	} else {
		oldtf = GET__TFStruct(self);

		new_tfstruct = oldtf;

		status = HTLoadRelative(newAddress);
		if (verbose) fprintf(stderr, "HTSearch result=%d\n", status);
		if (!status) return 0;

		HTHistory_record((HTAnchor*)HTMainAnchor);
		htext = HTMainText;
		newAddress = HTAnchor_address((HTAnchor*)HTMainAnchor);
		htext->simpleAddress = newAddress;
		htext->title = 
			saveString(HTAnchor_title(htext->node_anchor));
		htext->expandedAddress = 
			saveString(htext->node_anchor->address);

		htext->htmlSrc = saveString(srcBuff);
		htext->htmlSrcSize = srcBuffi;
		htext->isIndex = HTAnchor_isIndex(htext->node_anchor) ? 1 : 0;
/*		htext->isIndex = HTAnchor_isIndex(HTMainText) ? 1 : 0;
*/
		tf = (TFStruct*)malloc(sizeof(struct TFStruct));
		if (!tf) {
			perror("malloc");
			return 0;
		}
		bcopy(oldtf, tf, sizeof(struct TFStruct));

		tf->lineNodeCount = tf->lineVisibleCount = htext->lines;
		tf->firstp = htext->insertp;
		tf->offsetp = tf->firstp;
		tf->currentp = tf->firstp;
		tf->current_row = 0;
		tf->current_col_sticky = tf->current_col = 0;
		tf->screen_col_offset = 0;
		tf->screen_row_offset = 0;
		tf->shownPosition = 0;
		tf->shownSize = 0;
	}
	SET__TFStruct(self, tf);
	SET_HTMLAddress(self, newAddress ? newAddress : "?");
	SET_HTMLAnchor(self, "");
	SET_HTMLIsIndex(self, htext->isIndex);
	SET_HTMLTitle(self, htext->title ? htext->title : "");
	SET_HTMLSource(self, htext->htmlSrc);

	renderTF(tf);

	free(address);
	return 1;
}

char *html_pathSimplify(path)
	char *path;
{
	HTSimplify(path);
	return path;
}

/*			Creation Method
**			---------------
*/
PUBLIC HText *	HText_new ARGS1(HTParentAnchor *,anchor)
{
	HText * htObj = (HText*) malloc(sizeof(*htObj));

	if (!htObj) {
		fprintf(stderr, "malloc failed\n");
		return 0;
	}
    
	if (!loaded_texts) loaded_texts = HTList_new();
	HTList_addObject(loaded_texts, htObj);
	if (HTList_count(loaded_texts) >= loaded_limit) {
		if (TRACE) fprintf(stderr, 
				"html: Freeing off cached doc.\n"); 
		HText_free((HText *)HTList_removeFirstObject(loaded_texts));
	}
	htObj->last_line = NULL;
	htObj->lines = htObj->chars = 0;
	htObj->title = NULL;
	htObj->expandedAddress = NULL;
	htObj->simpleAddress = NULL;
	htObj->first_anchor = htObj->last_anchor = 0;
	htObj->style = &default_style;
	htObj->next_style = &default_style; /* badness... */
	htObj->node_anchor = anchor;
	htObj->last_anchor_number = 0;	/* Numbering of them for references */
	htObj->permissible_split = 0;
	htObj->in_line_1 = 0;		/* of paragraph */	

	htObj->tfstruct = new_tfstruct;
	htObj->size = 0;
	htObj->offsetpx = 0;
	htObj->px = 0;
	htObj->flags = NULL;
	htObj->currentp = NULL;
	htObj->insertp = NULL;
	htObj->fontID = NULL;
	htObj->tbuff = tbuff;	/* XXX non-reentrant */
	htObj->tbuffi = 0;
	htObj->tagID = 0;
	htObj->maxFontHeight = 0;
	htObj->maxFontDescent = 0;

	htObj->htmlSrc = NULL;
	htObj->htmlSrcSize = 0;

	bzero(htObj->tbufftags, sizeof (int) * TAGINFO_SIZE);

	HTAnchor_setDocument(anchor, (HyperDoc *)htObj);

	htObj->node_anchor = anchor;
	htObj->isIndex = 0;

	HTMainText = htObj;
	HTMainAnchor = anchor;
	
	return htObj;
}


/*	Free Entire Text
**	----------------
*/
PUBLIC void	HText_free ARGS1(HText *,self)
{
	HTAnchor_setDocument(self->node_anchor, (HyperDoc *)0);

#ifdef oneOfThoseThingsIShouldDoButNotDoingHTFREE
	while(YES) {		/* Free off line array */
		HTLine * l = self->last_line;
	l->next->prev = l->prev;
	l->prev->next = l->next;	/* Unlink l */
	self->last_line = l->prev;
	free(l);
	if (l == self->last_line) break;	/* empty */
	};
	
	while(self->first_anchor) {		/* Free off anchor array */
		TextAnchor * l = self->first_anchor;
	self->first_anchor = l->next;
	free(l);
	}
#endif
	free(self);
}

/*	Object Building methods
**	-----------------------
**
**	These are used by a parser to build the text in an object
*/
PUBLIC void HText_beginAppend ARGS1(HText *,text)
{
	text->permissible_split = 0;
	text->in_line_1 = YES;
	text->tbuffi = 0;
}

PUBLIC void HText_beginHiddenAppend ARGS1(HText *,text)
{
	hbuffi = 0;
	inHiddenState = 1;
}

/*	Add a new line of text
**	----------------------
**
** On entry,
**
**	split	is zero for newline function, else number of characters
**		before split.
** On exit,
**		A new line has been made, justified according to the
**		current style. Text after the split (if split nonzero)
**		is taken over onto the next line.
*/
PRIVATE void new_line ARGS1(HText *,text)
{
	PRIVATE void split_line();
	split_line(text, text->tbuffi);
	return;
}

#define VERBOSE_SPLIT_LINE 0
PRIVATE void split_line ARGS2(HText *,text, int,split)
{
	HTStyle *style = text->style;
	TFLineNode *newp;
	TFChar *tfcp, itfc;
	int size_offset, size_split;
	int offset, indent, i;
	int spare;
	static int spaceWidth;
	static int fontID = -1;
	int bullets = 0;


if (VERBOSE_SPLIT_LINE)
	fprintf(stderr, 
		"SPLITLINE1: using style %s (%d). fontID: tbuff=%d text=%d next=%d\n", 
		style->name, style->font, TFCFontID(text->tbuff), text->fontID, text->next_fontID);

	if (fontID != TFCFontID(text->tbuff)) {
		fontID = TFCFontID(text->tbuff);
		spaceWidth = FontWidths(fontID)[' '];
		if (spaceWidth <= 0) {
			fprintf(stderr, 
				"Error: font width ' ' == 0!\n");
			spaceWidth = FontWidths(text->fontID)['n'];
		}
	}
if (VERBOSE_SPLIT_LINE)
	fprintf(stderr, 
		"SPLITLINE2: using style %s (%d). fontID: tbuff=%d text=%d next=%d\n", 
		style->name, style->font, TFCFontID(text->tbuff), text->fontID, text->next_fontID);


	if (split < 0) return;	/* just in case */

if (VERBOSE_SPLIT_LINE) {
printf("SPLIT_LINE split=%d, tbuffi=%d, tagID=%d\n", 
       split, text->tbuffi, text->tagID);
	printf("::>>");
	dumpTFCArray(text->tbuff, text->tbufftags);
	printf("<<\n");
}

	newp = (TFLineNode *)malloc(sizeof(struct TFLineNode));
	if (!newp) {
		fprintf(stderr, "malloc failed\n");
		return;
	}

	bzero(newp->tagInfo, sizeof(int) * TAGINFO_SIZE);
	newp->maxPixelExtentX = 0;
	newp->maxPixelExtentY = 0;

	newp->maxFontHeight = text->maxFontHeight;
	newp->maxFontDescent = text->maxFontDescent;

	text->maxFontHeight = FontMaxHeight(fontID);
	text->maxFontDescent = FontDescent(fontID);

	if (text->tbuffi > 0) {

		/* Align left, right or center
		 */
		indent = text->in_line_1 ? 
			text->style->indent1st : text->style->leftIndent;
		spare = text->tfstruct->width - style->rightIndent -
			style->leftIndent - text->px;
		switch (style->alignment) {
		case HT_CENTER :
			text->offsetpx = spare / 2;
			break;
		case HT_RIGHT :
			text->offsetpx = indent + spare;
			break;
		case HT_LEFT :
		case HT_JUSTIFY :		/* Not implemented */
		default:
			text->offsetpx = indent;
			break;
		}

if (VERBOSE_SPLIT_LINE) {
printf("**** lindent=%f rindent=%f\n", style->leftIndent, style->rightIndent);
printf("**** indent=%d offsetpx=%d\n", indent, text->offsetpx);
}

		for (offset = 0, i = spaceWidth; i < text->offsetpx; offset++)
			i += spaceWidth;

		newp->breakc = 1;
		newp->length = split + offset;

		if (style == &HTStyleList || 
		    style == &HTStyleListCompact ||
		    style == &HTStyleColumns16) {
	    
			if (text->in_line_1) {
				bullets = 7 - FontWidths(fontID)['*'] / 
						FontWidths(fontID)[' '];
			} else {
				bullets = 6;
			}
		}
		size_offset = sizeof(struct TFChar) * (offset + bullets);
		size_split = sizeof(struct TFChar) * split;
	} else {
		newp->breakc = 1;
		newp->length = 0;
		offset = 0;
		size_offset = 0;
		size_split = 0;
	}
	size_offset = sizeof(struct TFChar) * (offset + bullets);
	size_split = sizeof(struct TFChar) * split;

	newp->linep = (TFChar*)malloc(size_offset + size_split +
				      sizeof(struct TFChar));
	if (!newp->linep) {
		fprintf(stderr, "malloc failed\n");
		return;
	}

	TFCChar(&itfc) = ' ';
	TFCFontID(&itfc) = fontID;
	TFCTagID(&itfc) = 0;
	TFCFlags(&itfc) = NULL;
	for (tfcp = newp->linep, i = 0; i < offset; tfcp++, i++)
		bcopy(&itfc, tfcp, sizeof(struct TFChar));

	text->px = 0;

	if (bullets) {
		if (text->in_line_1) {
			bullets--;
			TFCChar(tfcp) = '*';
			TFCFontID(tfcp) = fontID;
			TFCTagID(tfcp) = 0;
			TFCFlags(tfcp) = NULL;
			tfcp++;
			i++;
			newp->length++;
			text->px += FontWidths(fontID)['*'];
		}
		while (bullets--) {
			TFCChar(tfcp) = ' ';
			TFCFontID(tfcp) = fontID;
			TFCTagID(tfcp) = 0;
			TFCFlags(tfcp) = NULL;
			tfcp++;
			i++;
			newp->length++;
			text->px += spaceWidth;
		}
	}
	if (TFCChar(text->tbuff) == ' ') {
		if (split > 1) {
			bcopy(text->tbuff + 1, newp->linep + i, 
			      size_split - sizeof(struct TFChar));
			newp->length--;
			TFCClear(newp->linep + newp->length);
		} else {
			newp->length = 1;
			TFCClear(newp->linep); 
		}
	} else {
		bcopy(text->tbuff, newp->linep + i, size_split);
		TFCClear(newp->linep + newp->length);
	}

	bcopy(text->tbufftags, newp->tagInfo, sizeof(int) * TAGINFO_SIZE);
	bzero(text->tbufftags, sizeof(int) * TAGINFO_SIZE);

if (VERBOSE_SPLIT_LINE) {
	printf("made line:>>");
	dumpTFCArray(newp->linep, newp->tagInfo);
	printf("<<\n");
}
	/*
	 * Link the new line to tf struct
	 */
	if (text->currentp) {
		if (text->currentp->next) text->currentp->next->prev = newp;
		newp->prev = text->currentp;
		newp->next = text->currentp->next;
		text->currentp->next = newp;
		text->currentp = newp;
	} else {
		text->currentp = newp;
		text->insertp = newp;
		newp->prev = NULL;
		newp->next = NULL;
	}
	text->lines++;
	text->tagID = 0;
	text->offsetpx = 0; /*text->next_style->leftIndent;*/

	if (text->tbuffi - split > 0) {
		TFChar *tfcp2;
		int skip = 0;

		tfcp = text->tbuff + split;
		if (TFCChar(tfcp) == ' ') {
			tfcp++;
			split++;
		}
		tfcp2 = text->tbuff;

		/* skip extraneous spaces */
		for (i = text->tbuffi - split; i > 0; i--) {
			if (!ISSPACE(TFCChar(tfcp)) || TFCFlags(tfcp)) break;
			tfcp++;
			skip++;
		}
		for (; i > 0; i--) {
			TFCChar(tfcp2) = TFCChar(tfcp);
			TFCFontID(tfcp2) = fontID;
			TFCTagID(tfcp2) = TFCTagID(tfcp);
			TFCFlags(tfcp2) = TFCFlags(tfcp);
			text->px += TFCWidth(tfcp2);
			tfcp++;
			tfcp2++;
		}
		text->tbuffi = text->size = text->tbuffi - split - skip;
	} else {
		text->tbuffi = text->size = text->tbuffi - split;
	}
if (VERBOSE_SPLIT_LINE) {
	printf("tbuffi=%d\n", text->tbuffi);
}

	text->in_line_1 = NO;		/* unless caller sets it otherwise */

	text->style = text->next_style;
/*	text->fontID = text->next_fontID;*/
}


/*	Allow vertical blank space
**	--------------------------
*/
PRIVATE void blank_lines ARGS2(HText *,text, int,newlines)
{
	TFLineNode *lnp = text->currentp;

	if (text->tbuffi == 0) {
		if (lnp) {
			if (lnp->length == 0) {
				do {
					if (newlines == 0) break;
					newlines--;
					lnp = lnp->prev;
				} while (lnp && (lnp->length == 0));
			} else {
				if (newlines == 0) newlines++;
			}
		}
	} else {
		newlines++;
	}

	while (newlines--) new_line(text);
	text->in_line_1 = YES;
}


/* New paragraph in current style
 * See also: setStyle.
 */
PUBLIC void HText_appendParagraph ARGS1(HText *,text)
{
	int after = text->style->spaceAfter;
	int before = text->style->spaceBefore;
	int i = after>before ? after : before;

/*	if (!before && !after) blank_lines(text, 1);
	else if (i) blank_lines(text, i);
*/
	blank_lines(text, i);
}

/* Set Style
 *
 */
PUBLIC void HText_setStyle ARGS2(HText *,text, HTStyle *,style)
{
	int after, before;

	if (!style) {
	  	return;
	}

	after = text->style->spaceAfter;
	before = style->spaceBefore;

	if (TRACE) {
		fprintf(stderr, 
			"HTML: Changing to style %s (%d). fontID=%d\n", 
			style->name, style->font, text->fontID);
	}

	/*	if (text->style != style) {*/
	if (1) {

		if (style->font == HT_NORMAL) {
			text->flags = NULL;
			text->fontID = fontID_normal;
		} else if (style->font & HT_BOLD) {
			text->fontID = fontID_bold;
		} else if (style->font & HT_NORMAL_LARGE) {
			text->fontID = fontID_normal_large;
		} else if (style->font & HT_BOLD_LARGE) {
			text->fontID = fontID_bold_large;
		} else if (style->font & HT_NORMAL_LARGEST) {
			text->fontID = fontID_normal_largest;
		} else if (style->font & HT_BOLD_LARGEST) {
			text->fontID = fontID_bold_largest;
		} else if (style->font & HT_FIXED) {
			text->fontID = fontID_fixed;
		}
		if (style->font & HT_INVERSE) {
			text->flags |= MASK_REVERSE;
		}
		if (style->font & HT_UNDERLINE) {
			text->flags |= MASK_UNDER;
		}
		if (text->maxFontHeight < FontMaxHeight(text->fontID)) {
			text->maxFontHeight = FontMaxHeight(text->fontID);
		}
		if (text->maxFontDescent < FontDescent(text->fontID)) {
			text->maxFontDescent = FontDescent(text->fontID);
		}
		text->style = text->next_style;
		text->next_style = style;
		text->next_fontID = text->fontID;

		if (TRACE) {
			fprintf(stderr, 
				"HTML: New fontID=%d    l=%f r=%f\n", 
				text->fontID, style->leftIndent, style->rightIndent);
		}
	}
	blank_lines (text, after>before ? after : before);
}

#define VERBOSE_APPENDCHARACTER 0
/*	Append a character to the text object
**	-------------------------------------
*/
PUBLIC void HText_appendCharacter ARGS2(HText *,text, char,ch)
{
	HTStyle *style = text->style;
	HTFont font = style->font;
	TFChar *tfcp;
	int indent = text->in_line_1 ? style->indent1st : style->leftIndent;
	int charWidth;
	char c;

if (VERBOSE_APPENDCHARACTER) {
	printf("APPENDCHARACTER: %c      px=%d  fontID=%d\n", 
		ch, text->px, text->fontID);
}
	if (ch == '\r') {
		return; /* badness? */
	}
	if (ch == '\n') {
		new_line(text);
		text->in_line_1 = YES;	/* First line of new paragraph */
		return;
	}
	if (ch == '\t') {

		HTTabStop * tab;
		int target;	/* Where to tab to, in pixel value */
		int here = indent + text->px;
		int limit = text->tfstruct->width - style->rightIndent;

		if (style->tabs) {
			int i, spaceWidth = FontWidths(text->fontID)['n'];
			target = 0;

			if (spaceWidth <= 0) {
				fprintf(stderr, 
				    "HTML: S.O.S. font width of 'n' == 0!\n");
				spaceWidth = FontWidths(text->fontID)['h'];
			}

			for (i = 0; ; i++) {
				target = style->tabs[i].position * spaceWidth
					+ indent;
if (VERBOSE_APPENDCHARACTER) 
	printf("[%d] here=%d, target=%d\n", i, here, target);

				if (target > here) break;
				if (target == -1) {
					new_line(text);
					return;
				}
			}
		} else if (style->leftIndent) {   /* Use 2nd indent */
			if (here >= style->leftIndent) {
				new_line(text); /* wrap */
				return;
			} else {
			        target = style->leftIndent;
			}
		} else {
			int tabWidth = FontWidths(text->fontID)['n'] * 9;
			target = here + tabWidth - (here % tabWidth);
		}
if (VERBOSE_APPENDCHARACTER) 
		printf(">>> here=%d, target=%d\n", here, target);

		if (target > limit) {
			new_line(text);
			return;
		} else {
			TFChar spacetfc;
			int i, count = 0;
			int spaceWidth;

			spaceWidth = FontWidths(text->fontID)[' '];
			if (spaceWidth <= 0) {
				fprintf(stderr, 
					"HTML: Eh? How is it that I think the font width of ' ' is 0? Please inform Pei about this insanity.\n");
				spaceWidth = FontWidths(text->fontID)['n'];
			}

			TFCChar(&spacetfc) = ' ';
			TFCFontID(&spacetfc) = text->fontID;
			TFCTagID(&spacetfc) = 0;
			TFCFlags(&spacetfc) = text->flags;

			/* Can split here */
			text->permissible_split = text->size;

if (VERBOSE_APPENDCHARACTER) 
			printf("here=%d, target=%d\n", here, target);

			tfcp = text->tbuff + text->tbuffi;

			for (i = target - here - spaceWidth; i > 0; 
				i -= spaceWidth) {
				/* Put character into line */
				bcopy(&spacetfc, tfcp, 
					sizeof(struct TFChar));
				tfcp++;
				count++;
			}
			text->px += spaceWidth * count;
			text->size += count;
			text->tbuffi += count;
			if (text->tbuffi > TBUFFSIZE) {
				/* badnedd... */
			}
			return;
		}
	}
	
	if (ch == ' ') {
		text->permissible_split = text->size;	/* Can split here */
	}

	/*	Check for end of line
	 */	
	c = font & HT_CAPITALS ? TOUPPER(ch) : ch;
	charWidth = FontWidths(text->fontID)[c];

	if (indent + text->px + charWidth + style->rightIndent 
		>= text->tfstruct->width) {
		/*printf("\nexceed param limit.\n");*/
		if (text->next_style->wordWrap) {
			split_line(text, text->permissible_split);
			if (ch == ' ') {
				return; /* Ignore space causing split */
			}
		} else {
			new_line(text);
		}
	}

	/*	Insert normal characters
	 */
	if (ch == HT_NON_BREAK_SPACE) {
		c = ' ';
		charWidth = FontWidths(text->fontID)[c];
	}
 	tfcp = text->tbuff + text->tbuffi;

	TFCChar(tfcp) = c;
	TFCFontID(tfcp) = text->fontID;
	TFCTagID(tfcp) = 0;
	TFCFlags(tfcp) = text->flags;
	TFCWidth(tfcp) = charWidth;

	text->px += charWidth;
	text->size++;

	if (++(text->tbuffi) > TBUFFSIZE) {
		/* error. lossing info... */
		return;
	}
	TFCFlags(tfcp + 1) = text->flags;
}


/*	Append a (hidden) character to the text object
**	-------------------------------------
*/
PUBLIC void HText_appendHiddenCharacter ARGS2(HText *,text, char,ch)
{
	hbuff[hbuffi++] = ch;
	if (hbuffi > HBUFFSIZE) {
		printf("html: tbuffi exceeded HBUFFSIZE\n");
	}
	inHiddenState = 0;

	return;
}

/*	Anchor handling
**	---------------
*/
PUBLIC void HText_beginAnchor ARGS2(HText *,text, HTChildAnchor *,anc)
{
	TextAnchor * a = (TextAnchor *) malloc(sizeof(*a));

	if (!a) {
		fprintf(stderr, "malloc failed\n");
		return;
	}

	a->start = text->chars + text->size;/* ?? */
	a->extent = 0;
	a->beginLine = text->lines;

	if (text->last_anchor) {
		text->last_anchor->next = a;
	} else {
		text->first_anchor = a;
	}
	a->next = 0;
	a->anchor = anc;
	text->last_anchor = a;
	
	if (HTAnchor_followMainLink((HTAnchor*)anc)) {
		a->number = ++(text->last_anchor_number);
	} else {
		a->number = 0;
	}
	if (anc->mainLink.dest) {
		text->flags |= MASK_BUTTON;
		if (lookAndFeel != 1) 
			HText_appendCharacter(text, HT_NON_BREAK_SPACE);
	}
}

PUBLIC void HText_endAnchor ARGS1(HText *,text)
{
	TextAnchor * a = text->last_anchor;
	char *cp, *tattr;
	char marker[100];
	HTLink *htlink;

	htlink = (HTLink*)((HTChildAnchor*)(a->anchor));
	tattr = HTAnchor_address(htlink->dest);

	/*
	 * embed string
	 */
	if (tattr) {
		TFChar *tfcp;

		cp = malloc(sizeof(char) * (strlen(tattr) + 1));
		if (!cp) {
			fprintf(stderr, "malloc failed\n");
			return;
		}
		strcpy(cp, tattr);

		HText_appendCharacter(text, HT_NON_BREAK_SPACE);
		tfcp = text->tbuff + text->tbuffi - 1;

		if (text->tagID < TAGINFO_SIZE) {
			text->tagID++;
			/*printf("\\\\\\tagID = %d [%s]\n", text->tagID, cp);*/
			TFCTagID(tfcp) = text->tagID;
			text->tbufftags[text->tagID] = (int)cp;
		} else {
			printf("Error: exceeded tag limit(%d).\n",
				TAGINFO_SIZE);
		}
		text->flags &= ~MASK_BUTTON;
		if (lookAndFeel != 1)
			HText_appendCharacter(text, HT_NON_BREAK_SPACE);
	}
	a->endLine = text->lines;
/*
	printf("ANCHOR #=%d tag=``%s'' delim:%d %d\n", 
		a->number, a->anchor->tag, a->beginLine, a->endLine);
*/
}

PUBLIC void HText_appendText ARGS2(HText *,text, char *,str)
{
	char *p;

	for (p = str; *p; p++) {
		HText_appendCharacter(text, *p);
	}
}

PUBLIC void HText_endAppend ARGS1(HText *,text)
{
	new_line(text);
}

PUBLIC void HText_endHiddenAppend ARGS1(HText *,text)
{
	char *cp;
	TFChar *tfcp;

	hbuff[hbuffi++] = '\0';
	cp = malloc(sizeof(char) * hbuffi);
	if (!cp) {
		fprintf(stderr, "malloc failed\n");
		return;
	}
	strcpy(cp, hbuff);
	tfcp = text->tbuff + text->tbuffi - 1;
	if (text->tagID < TAGINFO_SIZE) {
		text->tagID++;
		/*printf("hidden tagID = %d [%s]\n", text->tagID, cp);*/
		TFCTagID(tfcp) = text->tagID;
		text->tbufftags[text->tagID] = (int)cp;
	} else {
		fprintf(stderr, "Error: exceeded tag limit(%d).\n",
			TAGINFO_SIZE);
	}
}

/* 	Dump diagnostics to stderr
*/
PUBLIC void HText_dump ARGS1(HText *,text)
{
	fprintf(stderr, "HText: Dump called\n");
}
	

/*	Return the anchor associated with this node
*/
PUBLIC HTParentAnchor * HText_nodeAnchor ARGS1(HText *,text)
{
	return text->node_anchor;
}

/*	GridText specials
**	=================
**	Return the anchor with index N
**
**	The index corresponds to the number we print in the anchor.
*/
PUBLIC HTChildAnchor * HText_childNumber ARGS2(HText *,text, int,number)
{
	TextAnchor * a;
	for (a = text->first_anchor; a; a = a->next) {
		if (a->number == number) return a->anchor;
	}
	return (HTChildAnchor *)0;	/* Fail */
}

/*		Browsing functions
**		==================
*/
PUBLIC BOOL HText_select ARGS1(HText *,text)
{
	HTMainText = text;
	return YES;
}

PUBLIC BOOL HText_selectAnchor ARGS2(HText *,text, HTChildAnchor *,anchor)
{
	TextAnchor * a;

	for(a=text->first_anchor; a; a=a->next) {
        	if (a->anchor == anchor) break;
	}
	if (!a) {
	        if (TRACE) fprintf(stderr, 
				"HText: No such anchor in this text!\n");
	        return NO;
	}
	{
		int l = 1;
		if (1) fprintf(stderr,
			"HText: Selecting anchor [%d] at character %d, line %d\n",
			a->number, a->start, l);

	}
	return YES;
} 

/*		Editing functions		- NOT IMPLEMENTED
**		=================
**
**	These are called from the application. There are many more functions
**	not included here from the orginal text object.
*/

/*	Style handling:
**	Apply this style to the selection
*/
PUBLIC void HText_applyStyle ARGS2(HText *, me, HTStyle *,style)
{
	printf("HText_applyStyle.\n");
}

/*	Update all text with changed style.
*/
PUBLIC void HText_updateStyle ARGS2(HText *, me, HTStyle *,style)
{
	printf("HText_updateStyle.\n");
}

/*	Return style of  selection
*/
PUBLIC HTStyle * HText_selectionStyle ARGS2(
	HText *,me,
	HTStyleSheet *,sheet)
{
	printf("HText_selectionStyle.\n");
	return 0;
}

/*	Paste in styled text
*/
PUBLIC void HText_replaceSel ARGS3(
	HText *,me,
	char *,aString, 
	HTStyle *,aStyle)
{
	printf("HText_replaceSel.\n");
}

/*	Apply this style to the selection and all similarly formatted text
**	(style recovery only)
*/
PUBLIC void HTextApplyToSimilar ARGS2(HText *,me, HTStyle *,style)
{
	printf("HTextApplyToSimilar.\n");
}
 
/*	Select the first unstyled run.
**	(style recovery only)
*/
PUBLIC void HTextSelectUnstyled ARGS2(HText *,me, HTStyleSheet *,sheet)
{
	printf("HTextSelectUnstyled.\n");
}

/*	Anchor handling:
*/
PUBLIC void HText_unlinkSelection ARGS1(HText *,me)
{
	printf("HText_unlinkSelection.\n");
}

PUBLIC HTAnchor * HText_referenceSelected ARGS1(HText *,me)
{
	printf("HText_referenceSelected.\n");
	return 0;   
}

PUBLIC HTParentAnchor *	HText_referenceAll ARGS1(HText *,me)
{
	printf("HText_referenceAll.\n");
	return HTMainAnchor;
}

PUBLIC HTAnchor * HText_linkSelTo ARGS2(HText *,me, HTAnchor *,anchor)
{
	printf("HText_linkSelTo.\n");
	return 0;
}

/*
 *
 *
 *
 *
 * initializes and sets up a text field structure 
 */
TFStruct *html_setUpTFStruct(self, text)
	VObj *self;
	char *text;
{
	TFStruct *tf = GET__TFStruct(self);

	if (!tf) {
		tf = (TFStruct*)malloc(sizeof(struct TFStruct));
		if (!tf) {
			fprintf(stderr, "malloc failed\n");
			return 0;
		}
		SET__TFStruct(self, tf);

		tf->firstp =
		tf->lastp =
		tf->offsetp = 
		tf->currentp = NULL;

		tf->current_col_sticky = tf->current_col = 0;
		tf->current_row = 0;

		tf->csr_px_sticky = tf->csr_px = 0;
		tf->csr_py = 0;

		tf->screen_col_offset =
		tf->screen_row_offset = 0;

		tf->lineNodeCount = 0;
		tf->lineVisibleCount = 0;

		tf->num_of_lines = 0;		/* in field view ? */

		tf->w = NULL;
		tf->xUL = tf->yUL =
		tf->xLR = tf->yLR = 
		tf->width = tf->height = 0;

		tf->esc_toggle = 0;
		tf->bufferUsed = 0;
		tf->self = self;
		tf->fontID = 0;
		tf->currentFontID = 0;

		tf->cursorTimeInfo = 0;
		tf->cursorIsVisible = 0;
		tf->cursorBlinkDelay = 250;
		tf->highLiteFrom_cx = -1;
		tf->highLiteFrom_cy = -1;
		tf->highLiteTo_cx = -1;
		tf->highLiteTo_cy = -1;

		tf->isRenderAble = 0;
	}
	tf->wrap = GET_wrap(self);

	html_updateTFStruct(self, text);

	return tf;
}

TFStruct *html_updateTFStruct(self, address)
	VObj *self;
	char *address;
{
	TFStruct *tf = GET__TFStruct(self);
	int fontID = GET__font(self);
	int newWidth, newHeight;
	int geometryChanged = 0;
	char *title = NULL;
	char *simpleAddress;
	char *anchorSearch;
	HText *htext;

	if (!tf || !address) return NULL;

	/* 
	 * update geometry of the field
	 */
	/* to allow space between border and characters */
	newWidth = GET_width(self);
	newHeight = GET_height(self);
	if (newWidth <= 1 && newHeight <= 1) return NULL;
	tf->xUL = 1;
	tf->yUL = 1;
	tf->xLR = GET_width(self) - 2;
	tf->yLR = GET_height(self) - 2;

	/* this could be smarter */
	if (newWidth != tf->width || newHeight != tf->height) {
		tf->width = newWidth;
		tf->height = newHeight;
		tf->csr_px = tf->xUL;
		tf->csr_py = tf->yUL;
		geometryChanged = 1;
	}
	tf->w = GET_window(self);
	tf->wrap = GET_wrap(self);
	tf->fontID = tf->currentFontID = fontID;

	tf->isRenderAble = (tf->w && newWidth > 2 && newHeight > 2) ? 1 : 0;

	if (newWidth > 2 && newHeight > 2) {
		if (!(htext = html_loadDocument(self, address, &title, 
					&simpleAddress, &anchorSearch))) {
			return NULL;
		}
		tf = htext->tfstruct;

		htext->simpleAddress = simpleAddress;

 		if (htext->simpleAddress) {
			SET_HTMLAddress(self, htext->simpleAddress);
		} else {
			return NULL; /* eh? */
		}
		SET_HTMLAnchor(self, (anchorSearch ? anchorSearch : ""));
		SET_HTMLTitle(self, (title ? title : ""));
		SET_HTMLIsIndex(self, htext->isIndex);
		SET_HTMLSource(self, htext->htmlSrc);

		if (geometryChanged && tf->isRenderAble) renderTF(tf);
	}
	SET__TFStruct(self, tf);

	return tf;
}

/*
 * return new tf, if different document
 */
HText *html_loadDocument(self, address, title, simpleAddress, anchorSearch)
	VObj *self;
	char *address;
	char **title;
	char **simpleAddress;
	char **anchorSearch;
{
	TFLineNode *currentp = NULL;
	TFChar tbuff[TBUFFSIZE];
	int tbuffi = 0, sameDoc = 0;
	int i, j;
	int status = 0;
	HText *htext;
	char anchorInfo[64];
	TFStruct *oldtf, *tf;

	oldtf = tf = GET__TFStruct(self);

	trimEdgeSpaces(address);

	/* get full address, without anchor */
	*simpleAddress = saveString(HTParse(address, default_default, 
					    PARSE_ACCESS | PARSE_HOST | 
					    PARSE_PATH | PARSE_PUNCTUATION));
	HTSimplify(*simpleAddress);

	/* extract anchor info, if any */
	*anchorSearch = "";
	for (i = 0; address[i]; i++) {
		if (address[i] == '#') {
			strcpy(anchorInfo, address + i + 1);
			*anchorSearch = saveString(anchorInfo);
			break;
		}
	}

	if (htext = html_findHTextByAddress(self, *simpleAddress)) {
		tf = htext->tfstruct;
		status = 1;
	}
	if (!status) {
		int filter = 0;

		tf = (TFStruct*)malloc(sizeof(struct TFStruct));
		if (!tf) {
			perror("malloc");
			return 0;
		}
		bcopy(oldtf, tf, sizeof(struct TFStruct));

		/* set this global (oh well) for HText_new() to pick up */
		new_tfstruct = tf;

		if (HTLoadAbsolute(*simpleAddress, filter)) {
			HTHistory_record((HTAnchor *)HTMainAnchor);
			htext = HTMainText;
			htext->title = 
				saveString(HTAnchor_title(htext->node_anchor));
			htext->expandedAddress = 
				saveString(htext->node_anchor->address);
			htext->isIndex = 
				HTAnchor_isIndex(htext->node_anchor) ? 1 : 0;

			htext->htmlSrc = saveString(srcBuff);
			htext->htmlSrcSize = srcBuffi;

			/* make sure can scroll to see last line text */
			new_line(htext); new_line(htext);

			status = 2;
			if (verbose) 
				fprintf(stderr, 
					"html: Accessed ``%s''\n",
					*simpleAddress);
		} else {
			if (verbose)
				fprintf(stderr, 
					"html: Failed to access ``%s''\n", 
					*simpleAddress);
			free(tf);
			return NULL;
		}
		htext->tfstruct = tf;
	}
	*title = htext->title;

	if (status > 0) {
		if (status > 1) {
			tf->lineNodeCount = tf->lineVisibleCount = 
				htext->lines;
			tf->firstp = htext->insertp;
			tf->offsetp = tf->currentp = tf->firstp;
			tf->current_row = 0;
			tf->current_col_sticky = tf->current_col = 0;
			tf->screen_col_offset = tf->screen_row_offset = 0;
		}
		if ((*anchorSearch)[0]) {
			tf->lineNodeCount = tf->lineVisibleCount = 
				htext->lines;
			tf->firstp = htext->insertp;
			tf->offsetp = tf->currentp = tf->firstp;




			tf->current_row = 0;
			tf->current_col_sticky = tf->current_col = 0;
			tf->screen_col_offset = tf->screen_row_offset = 0;
			moveToSelectedAnchor(htext, *anchorSearch);
		}
		return htext;
	}
/* ahem...
			lp = oldp = tf->firstp;
			if (oldp != tf->firstp) {
				while (lp) {
					oldp = lp;
					lp = lp->next;
					if (oldp->linep) free(oldp->linep);
					free(oldp);
				}
			}
*/
	return NULL;
}

int moveToSelectedAnchor ARGS2(HText *,text, char *, anchorInfo)
{
	int i;
	TFStruct *tf = text->tfstruct;
	TextAnchor *a;

	if (!tf) return 0;
	for(a = text->first_anchor; a; a = a->next) {

/*		printf("[%d]anchor tag = ``%s''.\n", 
			a->number, a->anchor->tag);
*/
		if (a->anchor) 
			if (a->anchor->tag)
				if (!strcmp((a->anchor->tag), anchorInfo)) {
					int beginLine = a->beginLine;

					for (i = 0; i < beginLine; i++) {
						if (!tf->offsetp) break;
						tf->offsetp = 
							tf->offsetp->next;
						tf->current_row++;
						tf->screen_row_offset++;
					}
					tf->currentp = tf->offsetp;
					return beginLine;
				}
	}
	return -1;
}

HText *html_findHTextByAddress(self, address)
	VObj *self;
	char *address;
{
	HTList *list;
	HText *htext;

	trimEdgeSpaces(address);

	for (list = loaded_texts; list; list = list->next) {
		htext = (HText*)list->object;
		if (htext) {
			if (htext->tfstruct->self == self) {
				if (htext->simpleAddress) {
					if (verbose) 
						fprintf(stderr, 
							"html: FTBA %s, %s\n", 
							htext->simpleAddress, 
							address);
					if (!strcmp(htext->simpleAddress, 
							address)) {
						return list->object;
					}
				}
			}
		}
	} 
	return NULL;
}

/*
 * given address, return associated title
 */
char *html_get_title(self, address)
	VObj *self;
	char *address;
{
	HText *text;

	trimEdgeSpaces(address);

	if (text = html_findHTextByAddress(self, address)) {
		if (text->title) return text->title;
	}
	return NULL;
}

/*
 * given address, return html source text
 */
char *html_get_src(address)
	char *address;
{
	return NULL;	
}

/*
 * for force updates
 */
int html_deleteDoc(self, address)
	VObj *self;
	char *address;
{
	HText *text;

	if (text = html_findHTextByAddress(self, address)) {
		if (HTList_removeObject(loaded_texts, text) == YES) return 1;
	}
	return 0;
}

int html_setCacheLimit(n)
	int n;
{
	loaded_limit = n;
	return n;
}

int html_clearCache()
{
	loaded_texts = NULL; /* how evil */
	HTAnchor_purgeCache();
	return 1;
}

int setHTMLStyle()
{
	Attr *attrp;
	char *tagName, *styleList, *cp;
	Packet *pk = borrowPacket();
	Packet *objpk = borrowPacket();
	VObj *obj;
	char font[100], align[32];
	int i, wrap, free, first, left, right, before, after;
	HTStyle *style;
	extern int numberOfFontIDs;

	objpk->info.s = "res.HTMLStyle";
	objpk->type = PKT_STR;
	meth_cosmic_object(VResourceObj, pk, 1, objpk);
	obj = pk->info.o;

	if (!obj) {
		if (verbose) 
			fprintf(stderr, 
				"object ``res.HTMLStyle'' not found. Using default style.\n");
		returnPackets(2);
		return 1;
	}

	if (verbose) fprintf(stderr, "Processing HTML Style sheet\n");

	attrp = GET__varList(obj);
	for (; attrp; attrp = attrp->next) {
		tagName = (char*)getHashEntry(symID2Str, attrp->id)->val;
		pk = (Packet*)(attrp->val);
		styleList = PkInfo2Str(pk);
		if (styleList[0] != '\0') {
			if (verbose)
				fprintf(stderr, 
				"tagName=%s, styleList=``%s''\n", 
				tagName, styleList);
			sscanf(styleList, 
				"%s %s %d %d %d %d %d %d %d",
				font, align, &wrap, &free, &first, 
				&left, &right, &before, &after);

			for (style = styleSheet->styles; style; 
				style = style->next) {
				if (!STRCMP(tagName, style->SGMLTag)) {

					for (i = 0; i < numberOfFontIDs; i++) {
						if (!STRCMP(FontRef(i), font))
							style->font = i;
					}

					if (!STRCMP(align, "left"))
						style->alignment = HT_LEFT;
					else if (!STRCMP(align, "right"))
						style->alignment = HT_RIGHT;
					else if (!STRCMP(align, "center"))
						style->alignment = HT_CENTER;
					else 
						fprintf(stderr, 
					     "unknown alignment style: %s\n", 
							align);

					style->wordWrap = wrap;
					style->freeFormat = free;
					style->indent1st = first;
					style->leftIndent = left;
					style->rightIndent = right;
					style->spaceBefore = before;
					style->spaceAfter = after;
				}
			}
		}
	}
	returnPackets(2);
	return 1;
}

char *html_headerInfo(self)
	VObj *self;
{
	char *cp;
	return NULL;
}
