/*		SGML Parser definitions
*/
/*	(c) Copyright CERN 1991 - See Copyright.html
*/

#ifndef SGML_H
#define SGML_H

typedef struct {
    char *	name;		/* The (constant) name of the attribute */
    BOOL	present;	/* Was attribute specified for this tag? */
    char *	value;		/* Malloced. Valid only if present is YES. */
} attr;

/*	A tag structure describes an SGML element.
**
**	If the tag has an end tag, then treat and end must be non-zero.
**	If the tag does not, they must be zero.
**
**	begin	is called when the tag has been parsed, and the
**		attribute values set. The element pointer points
**		to the top of the new element stack.
**	end	is called when the end tag has been parsed.
**		The element pointer points to the top of the new element
**		stack.
*/
typedef struct _tag HTTag;
typedef struct _HTElement HTElement;
struct _tag{
    char * name;		/* The name of the tag */
    attr * attributes;		/* The list of acceptable attributes */
    void * style;		/* Not used by the SGML engine */
    BOOL  litteral;		/* End only on end tag @@ */		
    void (*begin) PARAMS((HTTag * t, HTElement * e));	/* Action on begin tag */
    void (*treat) PARAMS((char c));	/* Action when character is parsed */
    void (*end) PARAMS((HTTag * t, HTElement * e));	/* Action on </tag> or 0 if empty */
};

/*	Stack of previous tags:
**
**	This allows us to return down the stack reselcting styles.
**	As we return, attribute values will be garbage in general.
*/
struct _HTElement {
	HTElement *	next;	/* Previously nested element or 0 */
	HTTag	*	tag;	/* The tag at this level */
	void *		info;	/* Free to be used by caller only */
};


typedef struct _entity {
    char * name;
    char * representation;
} entity;

typedef struct {
    HTTag *	tags;
    HTTag *	default_tag;
    entity *	entities;
} SGML_dtd;

extern void  SGML_begin PARAMS((SGML_dtd * dtd));
extern void  SGML_character PARAMS((SGML_dtd * dtd, char c));
extern void  SGML_end PARAMS((SGML_dtd * dtd));



#endif	/* SGML_H */
