/*			HyperText Object			HText.h
**			================
**	This is the C equivalelnt of a class definition file for an editable
**	hypertext object.
*/

#ifndef HTEXT_H
#define HTEXT_H
#include "HTAnchor.h"
#include "HTStyle.h"

typedef struct _HText HText;

extern HText * HTMainText;		/* Pointer to current main text */
extern HTParentAnchor * HTMainAnchor;	/* Pointer to current text's anchor */

/*				Class methods
*/
extern HText *	HText_new PARAMS((HTParentAnchor * anchor));


/*				Object methods
*/
extern void 	HText_free PARAMS((HText * me));


/*			Object Building methods
**			-----------------------
**
**	These are used by a parser to build the text in an object
*/
extern void HText_beginAppend PARAMS((HText * text));
extern void HText_setStyle PARAMS((HText * text, HTStyle * style));
extern void HText_appendCharacter PARAMS((HText * text, char ch));
extern void HText_appendParagraph PARAMS((HText * text));
extern void HText_beginAnchor PARAMS((HText * text, HTChildAnchor * anc));
extern void HText_endAnchor PARAMS((HText * text));
extern void HText_appendText PARAMS((HText * text, CONST char * str));
extern void HText_endAppend PARAMS((HText * text));

/*	Set one-line title
*/
extern void HText_setTitle PARAMS((HText * me, CONST char *title));

/* 	Dump diagnostics to stderr
*/
extern void HText_dump PARAMS((HText * me));	

/*	Return the anchor associated with this node
*/
extern HTParentAnchor * HText_nodeAnchor PARAMS((HText * me));

/*		Browsing functions
**		------------------
*/

/* Bring to front and highlight it
*/

extern BOOL HText_select PARAMS((HText * text)); 
extern BOOL HText_selectAnchor PARAMS((HText * text, HTChildAnchor* anchor)); 

/*		Editing functions
**		-----------------
**
**	These are called from the application. There are many more functions
**	not included here from the orginal text object.
*/

/*	Style handling:
*/
/*	Apply this style to the selection
*/
extern void HText_applyStyle PARAMS((HText * me, HTStyle *style));

/*	Update all text with changed style.
*/
extern void HText_updateStyle PARAMS((HText * me, HTStyle *style));

/*	Return style of  selection
*/
extern HTStyle * HText_selectionStyle PARAMS((
	HText * me,
	HTStyleSheet* sheet));

/*	Paste in styled text
*/
extern void HText_replaceSel PARAMS((HText * me,
	CONST char *aString, 
	HTStyle* aStyle));

/*	Apply this style to the selection and all similarly formatted text
**	(style recovery only)
*/
extern void HTextApplyToSimilar PARAMS((HText * me, HTStyle *style));
 
/*	Select the first unstyled run.
**	(style recovery only)
*/
extern void HTextSelectUnstyled PARAMS((HText * me, HTStyleSheet *sheet));


/*	Anchor handling:
*/
extern void		HText_unlinkSelection PARAMS((HText * me));
extern HTAnchor *	HText_referenceSelected PARAMS((HText * me));
extern HTParentAnchor *	HText_referenceAll PARAMS((HText * me));
extern HTAnchor *	HText_linkSelTo PARAMS((HText * me, HTAnchor* anchor));


#endif HTEXT_H
