/*		Chunk handling:	Flexible arrays
**		===============================
**
*/


typedef struct {
	int	size;		/* In bytes			*/
	int	growby;		/* Allocation unit in bytes	*/
	int	allocated;	/* Current size of *data	*/
	char *	data;		/* Pointer to malloced area or 0 */
} HTChunk;

#ifdef SHORT_NAMES
#define HTChunkClear		HTChClea
#define HTChunkPutc		HTChPutc
#define HTChunkPuts		HTChPuts
#define HTChunkCreate		HTChCrea
#define HTChunkTerminate	HTChTerm
#define HTChunkEnsure		HtChEnsu
#endif

#ifdef __STDC__
extern HTChunk * HTChunkCreate(int growby);
extern void HTChunkClear(HTChunk * ch);
extern void HTChunkEnsure(HTChunk * ch, int s);
extern void HTChunkPutc(HTChunk * ch, char c);
extern void HTChunkPuts(HTChunk * ch, const char *s);
extern void HTChunkTerminate(HTChunk * ch);
#else
extern HTChunk * HTChunkCreate();
extern void HTChunkClear();
extern void HTChunkEnsure();
extern void HTChunkPutc();
extern void HTChunkPuts();
extern void HTChunkTerminate();
#endif
