/*
 * glib_x.h
 */
#include "X11/Xlib.h"
#include "X11/Xmu/Xmu.h"
#include "X11/cursorfont.h"
#include "X11/keysym.h"
#include <X11/Xatom.h>
#include "X11/keysymdef.h"

#define eventWindow(e) 		((e).xany.window)
#define eventType(e)		((e).type)
#define mouseX(e) 		(int)(((XButtonEvent *)&e)->x)
#define mouseY(e) 		(int)(((XButtonEvent *)&e)->y)
#define rootX(e) 		(int)(((XButtonEvent *)&e)->x_root)
#define rootY(e) 		(int)(((XButtonEvent *)&e)->y_root)
#define buttonNumber(e)		(int)(((XButtonEvent *)&e)->button)
#define eventRegionX(e) 	((e).eventSpecific.exposure.regionX)
#define eventExposeX(e) 	(int)((e).xexpose.x)
#define eventExposeY(e) 	(int)((e).xexpose.y)
#define eventExposeWidth(e)     (int)((e).xexpose.width)
#define eventExposeHeight(e)    (int)((e).xexpose.height)
#define eventExposeCount(e)     (int)((e).xexpose.count)
#define eventExposeSerial(e)    (int)((e).xexpose.serial)
#define eventRegionY(e)		((e).eventSpecific.exposure.regionY)
#define eventRegionHeight(e)    ((e).eventSpecific.exposure.height)
#define eventRegionWidth(e)	((e).eventSpecific.exposure.width)

typedef struct eventMaskNameStruct {
	int	mask;
	char 	*name;
};

extern struct eventMaskNameStruct eventMaskName[];

#define ANYWINDOW ((Window) NULL)

#define FG_COLOR "white"
#define BG_COLOR "black"
#define BD_COLOR "white"

typedef int InkColor;

typedef struct ColorStruct {
	char *name;
	XColor xcolor;
} ColorStruct;
typedef struct ColorInfoStruct {
	ColorStruct bg;   /* background color */
	ColorStruct fg;   /* foreground color */
	ColorStruct bd;   /* border color */
} ColorInfo;

#define FGColorName(visual) (colorInfo->fg.name)
#define BGColorName(visual) (colorInfo->bg.name)
#define BDGColorName(visual) (colorInfo->bd.name)

extern XEvent e;
extern char keybuf[];
extern Display *display;
extern int screen_number;
extern Screen *screen;
extern int FGPixel, BGPixel, BDPixel, InvertPixel;
extern GC gc;
extern GC gc_fg;
extern GC gc_bg;
extern GC gc_bd;
extern GC gc_invert;
extern GC gc_invert_dash;
extern GC gc_copy;
extern GC gc_or;
extern GC gc_dash;
extern GC gc_mesh;
extern GC gc_subWindow;
extern int mouseCursorIsBusy;
extern short *bits;
extern int bits_width, bits_height;
extern int x_hot_spot, y_hot_spot;
extern Window rootWindow;
extern int pen_x, pen_y;
extern InkColor currentInkColor;
extern InkColor saveInkColor;
extern int screenDPI;

#define menuPixmap_width 8
#define menuPixmap_height 8
extern Pixmap menuPixmap;

#define togglePixmap_width 16
#define togglePixmap_height 16
extern Pixmap togglePixmap_button0;
extern Pixmap togglePixmap_button1;
extern Pixmap togglePixmap_disc0;
extern Pixmap togglePixmap_disc1;
extern Pixmap togglePixmap_check0;
extern Pixmap togglePixmap_check1;

/****************************************************************************
 * procedures
 */
/* window 
 */
Window 	GLOpenWindow();
Window 	GLCloseWindow();
int 	GLDestroyWindow();
int 	GLWindowSize();
int 	GLClearWindow();
void 	GLLowerWindow();
void 	GLRaiseWindow();
int 	GLSetWindowName();
Window 	GLQueryWindow();

/* cursor 
 */
void 	GLRootPosition();
Window 	GLQueryMouse();
void 	GLChangeToBusyMouseCursor();
void 	GLChangeToNormalMouseCursor();

/* line 
 */
int 	GLPaintLine();

#define GLDrawLine(w, x1, y1, x2, y2)\
	GLPaintLine(w, gc_fg, x1, y1, x2, y2)

#define GLEraseLine(w, x1, y1, x2, y2)\
	GLPaintLine(w, gc_bg, x1, y1, x2, y2)

#define GLInvertLine(w, x1, y1, x2, y2)\
	GLPaintLine(w, gc_invert, x1, y1, x2, y2)

/* rectangle
 */
int 	GLPaintRect();

#define GLDrawRect(w, x1, y1, x2, y2)\
	GLPaintRect(w, gc_fg, x1, y1, x2, y2)

#define GLEraseRect(w, x1, y1, x2, y2)\
	GLPaintRect(w, gc_bg, x1, y1, x2, y2)

#define GLInvertRect(w, x1, y1, x2, y2)\
	GLPaintRect(w, gc_invert, x1, y1, x2, y2)

int 	GLPaintRect();

#define GLDrawFillRect(w, x1, y1, x2, y2)\
	GLPaintFillRect(w, gc_fg, x1, y1, x2, y2)

#define GLEraseFillRect(w, x1, y1, x2, y2)\
	GLPaintFillRect(w, gc_bg, x1, y1, x2, y2)

#define GLInvertFillRect(w, x1, y1, x2, y2)\
	GLPaintFillRect(w, gc_invert, x1, y1, x2, y2)

/* circle/oval
 */
int 	GLPaintOval();

#define	GLDrawOval(w, x, y, width, height)\
	GLPaintOval(w, gc_fg, x, y, width, height)

#define	GLEraseOval(w, x, y, width, height)\
	GLPaintOval(w, gc_bg, x, y, width, height)

#define	GLInvertOval(w, x, y, width, height)\
	GLPaintOval(w, gc_invert, x, y, width, height)

int 	GLPaintFillOval();

#define	GLDrawFillOval(w, x, y, width, height)\
	GLPaintFillOval(w, gc_fg, x, y, width, height)

#define	GLEraseFillOval(w, x, y, width, height)\
	GLPaintFillOval(w, gc_bg, x, y, width, height)

#define	GLInvertFillOval(w, x, y, width, height)\
	GLPaintFillOval(w, gc_invert, x, y, width, height)

/* text
 */
int 	GLDefineNewFont();
int 	GLUpdateFontInfo();
int 	GLTextWidth();
int 	GLTextHeight();

int 	GLPaintText();
int 	GLPaintTextLength();

#define GLDrawText(w, fontID, x0, y0, str)\
	GLPaintText(w, gc_fg, fontID, x0, y0, str)
#define GLDrawTextLength(w, fontID, x0, y0, str, length)\
	GLPaintTextLength(w, gc_fg, fontID, x0, y0, length);

#define GLEraseText(w, fontID, x0, y0, str)\
	GLPaintText(w, gc_bg, fontID, x0, y0, str)
#define GLEraseTextLength(w, fontID, x0, y0, str, length)\
	GLPaintTextLength(w, gc_bg, fontID, x0, y0, str, length)

#define GLInvertText(w, fontID, x0, y0, str)\
	GLPaintText(w, gc_invert, fontID, x0, y0, str)
#define GLInvertTextLength(w, fontID, x0, y0, str, length)\
	GLPaintTextLength(w, gc_invert, fontID, x0, y0, str, length)

/* bitmap
 */
Pixmap 	GLMakeXBMFromASCII();
Pixmap 	GLMakeXPMFromASCII();
int 	GLDisplayXBMFromASCII();
int 	GLDisplayXPMFromASCII();
int 	GLDisplayXBM();
int 	GLDisplayXPM();
int 	GLFreeXBM();
int 	GLFreeXPM();
XImage 	*GLReadBitmapImage();

/* widget drawings
 */
void 	GLDrawBorder();
void 	GLEraseBorder();
int 	GLDrawRubberFrame();
void 	GLDrawScrollBarH();
void 	GLDrawScrollBarV();

/* widget geometry
 */
void 	GLUpdateGeometry();
void 	GLUpdatePosition();

/* widget color 
 */
int 	GLSetColor();
int 	GLSetBDColor();
int 	GLSetBGColor();
int 	GLSetFGColor();
char 	*GLGetBGColor();
char 	*GLGetFGColor();
char 	*GLGetBDColor();
void 	GLUpdateColorReference();
ColorInfo *GLPrepareObjColor();
void 	GLDumpColorRef();

/* cut buffer 
 */
void GLClearSelection();
int GLGetSelection();
int GLSetSelection();


