/*
 * file.c
 */
/*
 * Copyright 1991 Pei-Yuan Wei.  All rights reserved.
 *
 * Permission to use, copy, and/or distribute for any purpose and
 * without fee is hereby granted, provided that both the above copyright
 * notice and this permission notice appear in all copies and derived works.
 * Fees for distribution or use of this software or derived works may only
 * be charged with express written permission of the copyright holder.
 * This software is provided ``as is'' without express or implied warranty.
 */
#include <pwd.h>
#include <stdio.h>
#include "mystrings.h"
#include "file.h"

int io_stat;

char *expandPath(path, buffer)
	char *path;
	char *buffer;
{
	if (path[0] == '~') {
		extern char *getlogin();
		struct passwd *info;
		char userName[256];
		int i = 0;

		if (path[1] == '\0' || path[1] == '/') {
			char *cp = getlogin();

			/* assume path looks like: "~" "~/viola" */
			if (cp) {
				strcpy(userName, cp);
			} else {
				getpw(getuid(), userName);

				while (userName[i++] != ':');
				userName[i] = '\0';
			}
		} else {
			char c;
			/* ie: "~wei/viola" */

			/* get user's name */
			for (; c = path[i + 1]; i++) {
				if (isalpha(c)) userName[i] = c;
				else break;
			}
			userName[i] = '\0';
		}
		if (info = getpwnam(userName)) {
			strcpy(buffer, info->pw_dir);
			strcat(buffer, &path[i + 1]);
			return buffer;
		}
	} else {
		strcpy(buffer, path);
		return buffer;
	}
	fprintf(stderr, "failed to expand ~ for \"%s\"\n", path);
	return NULL;
}

/*
 * enter environment variables into the resource's variable list.
 * 
 */
char *getEnvironVars(argv, name, content)
	char *argv[];
	char *name;
	char *content;
{
	if (argv) {
		int ai = 0, i;
		char label[100];

		while (argv[ai]) {
/*			fprintf(stderr, "argv[%d] = [%s]\n",ai,argv[ai]);*/
			for (i = 0; (label[i] = argv[ai][i]) != '='; i++);
			label[i] = '\0';
			if (!STRCMP(name, label)) {
				strcpy(content, &argv[ai][++i]);
/*				fprintf(stderr, "name=[%s] content= [%s]\n", name, content);*/
				return content;
			}
			++ai;
		}
	}
	return NULL;
}

/*
 * loads a file from disk, and puts it in str.
 *
 * return: -1 if unable to open file.
 */
int loadFile(fileName, strp)
	char *fileName;
	char **strp;
{
	FILE *fp;
	int i = 0;
	long size;

	/* printf("loading file '%s'\n",fileName); */
	fp = fopen(fileName, "r");
	if(fp == NULL){
		io_stat = -1;
		return -1;
	}
	/* determine size of file */
	while (fgetc(fp) != EOF);
	size = ftell(fp) + 1;
	*strp = (char*)malloc(sizeof(char) * (int)size);
	rewind(fp);

	for (; ((*strp)[i] = fgetc(fp)) != EOF; i++);
	(*strp)[i] = '\0';

	fclose(fp);
	/* printf("%d characters in file '%s'.\n", i, fileName);*/

	io_stat = i;
	return i;
}

/*
 * saves a str to a file
 *
 * return: -1 if unable to open file.
 */
int saveFile(fileName, str)
	char *fileName;
	char *str;
{
	FILE *fp;

	/*printf("save: name='%s'	 content='%s'\n",fileName,str);*/
	fp = fopen(fileName, "w");

	if (fp == NULL){
		printf("Unable to open file '%s'. aborted.\n", fileName);
		return -1;
	}
	fprintf(fp, "%s", str);
	fclose(fp);
	/* printf("%d characters saved in file '%s'.\n", strlen(str), fileName);*/

	return 0;
}
