/*
 * Copyright 1990 Pei-Yuan Wei.	All rights reserved.
 *
 * Permission to use, copy, and/or distribute for any purpose and
 * without fee is hereby granted, provided that both the above copyright
 * notice and this permission notice appear in all copies and derived works.
 * Fees for distribution or use of this software or derived works may only
 * be charged with express written permission of the copyright holder.
 * This software is provided ``as is'' without express or implied warranty.
 */
/*
 * class	: pane
 * superClass	: field
 */
#include <stdio.h>
#include <ctype.h>
#include "error.h"
#include "mystrings.h"
#include "hash.h"
#include "ident.h"
#include "obj.h"
#include "packet.h"
#include "class.h"
#include "slotaccess.h"
#include "classlist.h"
#include "cl_pane.h"
#include "misc.h"
#include "glib.h"

char *paneConfigStr[] = {
	"freeForm",
	"northToSouth",
	"southToNorth",
	"westToEast",
	"eastToWest",
	"northToSouth_edge",
	"southToNorth_edge",
	"westToEast_edge",
	"eastToWest_edge",
	"center",
	NULL
};

SlotInfo cl_pane_NCSlots[] = {
	NULL
};
SlotInfo cl_pane_NPSlots[] = {
{
	STR_paneConfig,
 	PTRS | SLOT_RW,
	(long)"freeForm"
},{
	STR__paneConfig,
 	LONG,
	PANE_CONFIG_FREE
},{
	NULL
}
};
SlotInfo cl_pane_CSlots[] = {
{
	STR_class,
	PTRS | SLOT_RW,
	(long)"pane"
},{
	STR_classScript,
	PTRS,
	(long)"\n\
		switch (arg[0]) {\n\
		case \"config\":\n\
			config(arg[1], arg[2], arg[3], arg[4]);\n\
		break;\n\
		case \"expose\":\n\
		case \"render\":\n\
			render();\n\
		break;\n\
		case \"mouseMove\":\n\
		case \"enter\":\n\
		case \"leave\":\n\
		case \"buttonPress\":\n\
		case \"buttonRelease\":\n\
		case \"keyPress\":\n\
		case \"keyRelease\":\n\
		case \"shownPositionH\":\n\
		case \"shownPositionV\":\n\
		break;\n\
		case \"init\":\n\
			initialize();\n\
		break;\n\
		case \"info\":\n\
			info();\n\
		break;\n\
		default:\n\
			print(\"unknown message, clsss = pane: args: \");\n\
			for (i = 0; i < arg[]; i++) print(arg[i], \", \");\n\
			print(\"\n\");\n\
		break;\n\
		}\n\
	",
},{
	NULL
}
};
SlotInfo cl_pane_PSlots[] = {
{
	STR__classInfo,
	CLSI,
	(long)&class_pane
},{
	NULL
}
};

SlotInfo *slots_pane[] = {
	(SlotInfo*)cl_pane_NCSlots,
	(SlotInfo*)cl_pane_NPSlots,
	(SlotInfo*)cl_pane_CSlots,
	(SlotInfo*)cl_pane_PSlots
};

MethodInfo meths_pane[] = {
	/* local methods */
{
	STR_clone,
	meth_pane_clone
},{
	STR_clone2,
	meth_pane_clone2
},{
	STR_config,
	meth_pane_config
},{
	STR_expose,
	meth_pane_expose,
},{
	STR_get,
	meth_pane_get,
},{
	STR_initialize,
	meth_pane_initialize
},{
	STR_render,
	meth_pane_render
},{
	STR_set,
	meth_pane_set
},{
	NULL
}
};

ClassInfo class_pane = {
	slots_pane,		/* class slot information	*/
	meths_pane,		/* class methods		*/
	STR_pane,		/* class identifier number	*/
	&class_field,		/* super class info		*/
};

/*
 * clone(clone name suffix)
 * 
 * Make a clone self
 *
 * Result: clone object, and optinally name it
 * Return: 1 if successful, 0 if error occured
 */
int meth_pane_clone(self, result, argc, argv)
	VObj *self;
	Packet *result;
	int argc;
	Packet argv[];
{
	VObj *cloneObj;

	if (!meth_pane_clone2(self, result, argc, argv)) return 0;
	cloneObj = result->info.o;
	if (cloneObj) {
		sendInitToChildren(cloneObj);
		result->type = PKT_OBJ;
		result->info.o = cloneObj;
		return 1;
	}
	result->type = PKT_OBJ;
	result->info.o = NULL;
	return 0;
}

int meth_pane_clone2(self, result, argc, argv)
	VObj *self;
	Packet *result;
	int argc;
	Packet argv[];
{
	if (!meth_field_clone2(self, result, argc, argv)) return 0;
	return 1;
}

/*
 */
/* used to hold position, span, spanOther info */
#define CHILD_POSN(i) 	geomBuff[i][0]
#define CHILD_SPAN(i) 	geomBuff[i][1]
#define CHILD_SPANO(i) 	geomBuff[i][2]
#define CHILD_MAX	64
helper_pane_config(self)
	VObj *self;
{
	VObjList *olist, *children = GET__children(self);
	int loopbreak = 20; /* precaution to infinite loop -- breaking limit */
	int i, doit = 1, positive = 1;
	int posIdx, spanIdx, spanOtherIdx, minIdx, maxIdx;
	static int geomBuff[CHILD_MAX][3];

	if (children) {
		switch (GET__paneConfig(self)) {
		case PANE_CONFIG_N2S_EDGE:
		case PANE_CONFIG_N2S:
			posIdx = 1;
			spanIdx = PTR_height(self) - (long *) self;
			spanOtherIdx = PTR_width(self) - (long *) self;
			minIdx = PTR_minHeight(self) - (long *) self;
			maxIdx = PTR_maxHeight(self) - (long *) self;
			break;
		case PANE_CONFIG_S2N_EDGE:
		case PANE_CONFIG_S2N:
			posIdx = 1;
			spanIdx = PTR_height(self) - (long *) self;
			spanOtherIdx = PTR_width(self) - (long *) self;
			minIdx = PTR_minHeight(self) - (long *) self;
			maxIdx = PTR_maxHeight(self) - (long *) self;
			positive = 0;
		break;
		case PANE_CONFIG_W2E_EDGE:
		case PANE_CONFIG_W2E:
			posIdx = 0;
			spanIdx = PTR_width(self) - (long *) self;
			spanOtherIdx = PTR_height(self) - (long *) self;
			minIdx = PTR_minWidth(self) - (long *) self;
			maxIdx = PTR_maxWidth(self) - (long *) self;
		break;
		case PANE_CONFIG_E2W_EDGE:
		case PANE_CONFIG_E2W:
			posIdx = 0;
			spanIdx = PTR_width(self) - (long *) self;
			spanOtherIdx = PTR_height(self) - (long *) self;
			minIdx = PTR_minWidth(self) - (long *) self;
			maxIdx = PTR_maxWidth(self) - (long *) self;
			positive = 0;
		break;
		case PANE_CONFIG_FREE:
		default:
			doit = 0;
		}
	} else {
		doit = 0;
	}

	if (doit) {
		int nchildren = 0, span, position = 0, bd;
		int nmarked = 0, markedsum = 0;
		int pbd = borderStyleThickness[GET_border(self)] * 2;

		/* 0 indicates undetermined value */
		for (olist = children; olist; olist = olist->next) {
			if (nchildren < CHILD_MAX)
				CHILD_SPAN(nchildren) = 0;
			else
				printf("Internal error: pane config buffer overflowed.\n");
			nchildren++;
		}
		while (loopbreak--) {
			if (nchildren - nmarked == 0) {
				/*printf("pane config error\n");*/
				break;
			}
			span = (self[spanIdx] - markedsum) / 
				(nchildren - nmarked);
			i = 0;
			for (olist = children; olist; olist = olist->next) {
				if (!olist->o) {
					printf("error: pane, NULL child.");
					break;
				}
				bd = borderStyleThickness[GET_border(olist->o)]
					* 1;
				if (!CHILD_SPAN(i)) {
					if (span <= olist->o[minIdx] + bd) {
						CHILD_SPAN(i) = 
							olist->o[minIdx];
						markedsum += CHILD_SPAN(i)+bd;
						++nmarked;
						goto escape;
					} else if (span >= olist->o[maxIdx]+bd){
						CHILD_SPAN(i) = 
							olist->o[maxIdx];
						markedsum += CHILD_SPAN(i)+bd;
						++nmarked;
						goto escape;
					}
				}
				i++;
			}
			break;
		escape:;
		}
		if (positive) {
			for (i = 0; i < nchildren; i++) {
				if (!CHILD_SPAN(i)) CHILD_SPAN(i) = span;
				CHILD_SPANO(i) = self[spanOtherIdx];
				CHILD_POSN(i) = position - 1;
				position += CHILD_SPAN(i) + 1;
			}
		} else {
			position = self[spanIdx];
			for (i = nchildren - 1; i >= 0; i--) {
				if (!CHILD_SPAN(i)) CHILD_SPAN(i) = span;
				CHILD_SPANO(i) = self[spanOtherIdx];
				position -= CHILD_SPAN(i) - 1;
				CHILD_POSN(i) = position + 1;
			}
		}
	}

	if (posIdx == 1) {
		for (i = 0, olist = children; olist; olist = olist->next, i++){
			if (!olist->o) {
				printf("error: pane, NULL child.");
				break;
			}
			if (CHILD_SPAN(i) <= 0) CHILD_SPAN(i) = 0;
			if (CHILD_SPANO(i) <= 0) CHILD_SPANO(i) = 0;

			if (GET_y(olist->o) != CHILD_POSN(i) ||
			    GET_width(olist->o) != CHILD_SPANO(i) ||
			    GET_height(olist->o) != CHILD_SPAN(i)) {

				if (verbose) 
					fprintf(stderr, 
						"pane y: %s : %d %d %d %d\n", 
						GET_name(olist->o),
						GET_x(olist->o), CHILD_POSN(i),
						CHILD_SPANO(i), CHILD_SPAN(i));

				if (GET_window(olist->o))
					if (CHILD_SPANO(i) > 1 &&
					    CHILD_SPAN(i) > 1)
					  GLUpdateGeometry(0,
						GET_window(olist->o),
						GET_x(olist->o), CHILD_POSN(i),
						CHILD_SPANO(i), CHILD_SPAN(i));
			}
		}
	} else {
		for (i = 0, olist = children; olist; olist = olist->next, i++){
			if (!olist->o) {
				printf("error: pane, NULL child.");
				break;
			}
			if (CHILD_SPAN(i) <= 0) CHILD_SPAN(i) = 0;
			if (CHILD_SPANO(i) <= 0) CHILD_SPANO(i) = 0;

			if (GET_x(olist->o) != CHILD_POSN(i) ||
			    GET_width(olist->o) != CHILD_SPAN(i) ||
			    GET_height(olist->o) != CHILD_SPANO(i)) {

				if (verbose) 
					fprintf(stderr, 
						"pane x: %s : %d %d %d %d\n", 
						GET_name(olist->o),
						CHILD_POSN(i), GET_y(olist->o),
						CHILD_SPAN(i), CHILD_SPANO(i));

				if (GET_window(olist->o))
					if (CHILD_SPANO(i) > 1 &&
					    CHILD_SPAN(i) > 1)
					  GLUpdateGeometry(0,
						GET_window(olist->o),
						CHILD_POSN(i), GET_y(olist->o),
						CHILD_SPAN(i), CHILD_SPANO(i));
			}
		}
	}
}

int meth_pane_config(self, result, argc, argv)
	VObj *self;
	Packet *result;
	int argc;
	Packet argv[];
{
	if (!meth_field_config(self, result, argc, argv)) return 0;

	if (GET__paneConfig(self) != PANE_CONFIG_FREE)
		if (GET__children(self)) helper_pane_config(self);

	return 1;
}

int meth_pane_get(self, result, argc, argv)
	VObj *self;
	Packet *result;
	int argc;
	Packet argv[];
{
	int labelID = getIdent(PkInfo2Str(argv));

	switch (labelID) {
	case STR_paneConfig:
		result->info.s = GET_paneConfig(self);
		result->type = PKT_STR;
		return 1;
	}
	return meth_field_get(self, result, argc, argv);
}

int meth_pane_expose(self, result, argc, argv)
	VObj *self;
	Packet *result;
	int argc;
	Packet argv[];
{
	return meth_field_expose(self, result, argc, argv);
}

int meth_pane_initialize(self, result, argc, argv)
	VObj *self;
	Packet *result;
	int argc;
	Packet argv[];
{
	Packet pks[2];

	if (!meth_field_initialize(self, result, argc, argv)) return 0;

	pks[0].type = PKT_STR;
	pks[0].info.s = "paneConfig";
	pks[1].type = PKT_STR;
	pks[1].info.s = GET_paneConfig(self);
	callMeth(self, result, 2, &pks[0], STR_set);

	if (GET__paneConfig(self) != PANE_CONFIG_FREE) {
		SET_x(self, 0);
		SET_y(self, 0);
	}
	return 1;
}

int meth_pane_render(self, result, argc, argv)
	VObj *self;
	Packet *result;
	int argc;
	Packet argv[];
{
	if (!meth_field_render(self, result, argc, argv)) return 0;
	if (GET__paneConfig(self) != PANE_CONFIG_FREE)
		if (GET__children(self)) helper_pane_config(self);
	return 1;
}

/*
 * returns non-zero if set operation succeded, zero otherwise.
 */
int meth_pane_set(self, result, argc, argv)
	VObj *self;
	Packet *result;
	int argc;
	Packet argv[];
{
	int labelID = getIdent(PkInfo2Str(argv));

	switch (labelID) {
	case STR_paneConfig: {
		int i;
		char *cp = PkInfo2Str(&argv[1]);

		result->type = PKT_STR;
		for (i = 0; paneConfigStr[i]; i++) {
			if (!STRCMP(paneConfigStr[i], cp)) {
				SET_paneConfig(self, saveString(cp));
				SET__paneConfig(self, i);
				result->info.s = GET_paneConfig(self);
				return 1;
			}
		}
		result->info.s = GET_paneConfig(self);
		return 0;
	}
	}
	return meth_field_set(self, result, argc, argv);
}

