/*
 * Abstract Syntax Tree abstraction.
 */

#define DEFAULT_AST_STACK_SIZE 3000

#define SCRIPT_ORIGIN_OBJ_SCRIPT	0
#define SCRIPT_ORIGIN_CLASS_SCRIPT	1
#define SCRIPT_ORIGIN_TEMPORARY		2

extern FILE	*yyin, *yyout;
extern char	yytext[];
/*
extern unsigned char	*yysptr, yysbuf[];
*/
extern int	yylineno;
extern int	yytchar;
extern int	yyleng;
extern char 	*yyscript;
extern int	yyscriptidx;
extern char	*yyobjcontext;
extern int	yyscriptcontext;

extern char myinput();
#ifdef input
#undef input
#endif
#define input() myinput()
#ifdef unput
#undef unput
#endif
#define unput(c) {if ((yyscript[--yyscriptidx] = c) == '\n') yylineno--;}

enum ASTTypes {
	AST_EXPR_PLUS,
	AST_EXPR_MINUS,
	AST_EXPR_MOD,
	AST_EXPR_MULT,
	AST_EXPR_DIV,
	AST_EXPR_EQ,
	AST_EXPR_NE,
	AST_EXPR_LT,
	AST_EXPR_LE,
	AST_EXPR_GT,
	AST_EXPR_GE,
	AST_EXPR_AND,
	AST_EXPR_OR,

	AST_EXPR_CMP,
	AST_LIST,
	AST_LISTC,
	AST_STACK,
	AST_MOVTO,
	AST_MOVTO_LIST,
	AST_CALL,
	AST_CHAR,
	AST_IF,
	AST_INTEGER,
	AST_FLOAT,
	AST_STMTS,
	AST_STRING,
	AST_WHILE,
	AST_RETURN,
	AST_SWITCH,
	AST_CASE,
	AST_CASE_SEG,
	AST_CASE_CLAUSE,
	AST_DEFAULT_CLAUSE,
	AST_BREAK,
	AST_BODY,
	AST_EXPR,
	AST_DO,
	AST_FOR,
	AST_INC_PRE,
	AST_INC_POST,
	AST_DEC_PRE,
	AST_DEC_POST,
	AST_UMINUS,
	AST_PLUS_MOVTO,
	AST_MINUS_MOVTO,
	AST_MOD_MOVTO,
	AST_MULT_MOVTO,
	AST_DIV_MOVTO,
	AST_PERSISTENT,
	AST_REF,
	AST_LIST_REF,
};

/* Attributes holder for AST (see below) */
typedef struct ATT {
	struct ATT	*next;
	union {
		int	i;
		float	f;
		char	c;
		char	*s;
	} info;
} ATT;

/* Abstract Syntac Tree */
typedef struct AST {
	struct AST	*next;			/* sibling nodes 	*/
	struct AST	*children;		/* children nodes	*/
	struct AST	*parent;		/* parent node 		*/
	struct ATT	attribute;		/* attribute	 	*/
	int		lineno;			/* source line number	*/
	int		type;			/* node type 		*/
} AST;

extern int ASTStackIdx;
extern int ASTTypeStrSize;
extern char *ASTTypeStr[];

#define clearASTStack() ASTStackIdx = 0

extern int init_ast();
extern int countASTSiblings();
extern AST *makeAST();
