\name {wwwHistory}
\class {vpane}
\parent {}
\script	{
	switch (arg[0]) {
	case "add":
		wwwHistory.list.tf("add", arg[1], arg[2]);
		return;
	break;
	case "prev":
		wwwHistory.list.tf("prev");
		return;
	break;
	case "peek_prev":
		wwwHistory.list.tf("peek_prev");
		return;
	break;
	case "next":
		wwwHistory.list.tf("next");
		return;
	break;
	case "peek_next":
		wwwHistory.list.tf("peek_next");
		return;
	break;
	case "back":
		wwwHistory.list.tf("back");
		return;
	break;
	case "peek_back":
		wwwHistory.list.tf("peek_back");
		return;
	break;
	case "visible":
		set("visible", arg[1]);
		return;
	break;
	case "dismiss":
		set("visible", 0);
		return;
	break;
	case "render":
		set("visible", 1);
		return;
	break;
	}
	usual();
}
\width {500}
\height {150}
\children {wwwHistory.top wwwHistory.list}
\
\name {wwwHistory.top}
\class {hpane}
\parent	{wwwHistory}
\children {wwwHistory.top.prev wwwHistory.top.back wwwHistory.top.next wwwHistory.top.title wwwHistory.top.dismiss}
\maxHeight {20}
\
\name {wwwHistory.top.switch}
\class {txtButton}
\parent	{wwwHistory.top}
\label {Switch to Recall List}
\script {
	switch (arg[0]) {
	case "buttonRelease":
		if (state == 0) {
			state = 1;
			set("label", "Switch to History List");
		} else {
			state = 0;
			set("label", "Switch to Recall List");
		}
		render();
	break;
	case "init":
		state = 0;
	break;
	}
	usual();
}
\font {normal}
\maxHeight {100}
\BDColor {grey99}
\BGColor {grey50}
\FGColor {grey99}
\
\name {wwwHistory.top.prev}
\class {txtButton}
\parent	{wwwHistory.top}
\label {<Prev}
\font {normal}
\script {
	switch (arg[0]) {
	case "buttonRelease":
		docAddr = wwwHistory.list.tf("prev");
		if (isBlank(docAddr) != 1) www("showButNoRecord", docAddr);
	break;
	}
	usual();
}
\maxWidth {70}
\BDColor {white}
\BGColor {grey45}
\
\name {wwwHistory.top.back}
\class {txtButton}
\parent	{wwwHistory.top}
\label {^Back}
\font {normal}
\script {
	switch (arg[0]) {
	case "buttonRelease":
		docAddr = wwwHistory.list.tf("back");
		if (isBlank(docAddr) != 1) www("showButNoRecord", docAddr);
	break;
	}
	usual();
}
\maxWidth {70}
\BDColor {white}
\BGColor {grey45}
\
\name {wwwHistory.top.next}
\class {txtButton}
\parent	{wwwHistory.top}
\label {Next>}
\font {normal}
\script {
	switch (arg[0]) {
	case "buttonRelease":
		docAddr = wwwHistory.list.tf("next");
		if (isBlank(docAddr) != 1) www("showButNoRecord", docAddr);
	break;
	}
	usual();
}
\maxWidth {70}
\BDColor {white}
\BGColor {grey45}
\
\name {wwwHistory.top.title}
\class {txtLabel}
\parent	{wwwHistory.top}
\label {World-Wide Web Travels}
\font {bold}
\script {
	switch (arg[0]) {
	case "buttonRelease":
		wwwHistory.list.tf("add", "abba", "doodi");
	break;
	}
	usual();
}
\FGColor {black}
\BGColor {grey45}
\
\name {wwwHistory.top.dismiss}
\class {txtButton}
\parent	{wwwHistory.top}
\label {Dismiss}
\font {normal}
\script {
	switch (arg[0]) {
	case "buttonRelease":
		wwwHistory("dismiss");
		return;
	break;
	}
	usual();
}
\maxWidth {70}
\BDColor {white}
\BGColor {grey45}
\
\name {wwwHistory.list}
\class {hpane}
\parent {wwwHistory}
\children {wwwHistory.list.sb wwwHistory.list.tf}
\
\name {wwwHistory.list.sb}
\class {slider}
\parent {wwwHistory.list}
\shownNotify {wwwHistory.list.tf}
\BDColor {grey99}
\BGColor {grey45}
\FGColor {grey80}
\maxWidth {20}
\
\name {wwwHistory.list.tf}
\parent {wwwHistory.list}
\class {txtDisp}
\script	{
	switch (arg[0]) {
	case "buttonRelease":
		deHighLight(index);
		previousDocIndx = index;
		index = lineRowOffset() + cursorRow();
		highLight(index);

/*		print("*** history request address: index=", index, ",", 
			docAddr[index], "\n");
*/
		www("showButNoRecord", docAddr[index]);
	break;
	case "prev":
		if (index > 0) {
			deHighLight(index);
			previousDocIndx = index;
			index = index - 1;
			highLight(index);
			return docAddr[index];
		} else {
			return "";
		}
	break;
	case "peek_prev":
		if (index > 0) return docTitle[index - 1];
		else return "none";
	break;
	case "next":
		if (index < count - 1) {
			deHighLight(index);
			previousDocIndx = index;
			index = index + 1;
			highLight(index);
			return docAddr[index];
		} else {
			return "";
		}
	break;
	case "peek_next":
		if (index + 1 < count) return docTitle[index + 1];
		else return "none";
	break;
	case "back":
		if (previousDocIndx == -1) {
			return "";
		} else {
			deHighLight(index);
			temp = index;
			index = previousDocIndx;
			previousDocIndx = temp;
			highLight(index);
			return docAddr[index];
		}
	break;
	case "peek_back":
		if (previousDocIndx != -1) return docTitle[previousDocIndx];
		else return "none";
	break;
	case "add":
		if (isBlank(arg[1]) == 1) {
			docTitle[count] = "no title";
		} else {
			docTitle[count] = arg[1];
		}
		docAddr[count] = arg[2];

		deHighLight(index);
		previousDocIndx = index;
		index = count;
		count = count + 1;
		append(docTitle[index]);
		if (get("window")) render();
		highLight(index);
		return;
	break;
	case "query": /* query(n) -> text on line n */
		return nthLine(get("content"), arg[1]);
	break;
	case "save":
		/* won't work */
		saveFile("~/.WWWHistory", get("content"));
		return;
	break;
	case "load":
		/* won't work */
		set("content", loadFile("~/.WWWHistory"));
		render();
		return;
	break;
	case "clear":
		set("content", "");
	break;
	case "keyPress":
		return; /* necessary to prevent cataconic stress */
	break;
	case "enter":
/*		set("cursor", 0); 
		return;
*/
	break;
	case "init":
		previousDocIndx = -1;
		index = 0;
		count = 0;
	break;
	}
	usual();
}
\shownDepend {wwwHistory.list.sb}
\font {fixed}
\BGColor {lightyellow}
\FGColor {black}
\BDColor {grey75}
\
