\class {vpane}
\name {www}
\parent {}
\children {www.top www.title www.view www.idx www.mesg www.udi}
\script {
	/* ViolaWWW
	 * Author: Pei Y. Wei (wei@xcf.berkeley.edu)
	 */
	switch (arg[0]) {
	case "show":
		if (www.view.html("show", arg[1]))
			www.view.html("historyRecord");
		return;
	break;
	case "search":
		www.view.html("search", arg[1]);
		return;
	break;
	case "showButNoRecord":
		www.view.html("show", arg[1]);
		return;
	break;
	case "about":
		www.view.html("about");
		return;
	break;
	case "help":
		www.view.html("help");
		return;
	break;
	case "home":
		www.view.html("home");
		return;
	break;
	case "render":
		if (get("window")) windowName("violaWWW");
	break;
	case "quit":
		quit();
		return;
	break;
	}
	usual();
}
\width {567}
\height {704}
\BDColor {55 55 55}
\BGColor {25 25 25}
\FGColor {99 99 99}
\
\class {hpane}
\name {www.top}
\parent {www}
\children {www.top.home www.top.prev www.top.back www.top.next www.top.mark www.top.links www.top.gap www.top.icon www.top.help www.top.quit}
\script {usual();
}
\maxHeight {32}
\BDColor {55 55 55}
\BGColor {grey45}
\FGColor {white}
\
\class {XPMButton}
\name {www.top.home}
\parent {www.top}
\script {
	switch (arg[0]) {
	case "buttonRelease":
		www.view.html("home");
	break;
	case "enter":
	case "leave":
		www.mesg.tf("suggest", get("name"), arg[0]);
		return;
	break;
	case "hint":
		return "Click the house icon to visit home page.";
	break;
	}
	usual();
}
\label {/* XPM */
static char * home [] = {
/* gb pixmap
 * width height ncolors chars_per_pixel */
"32 32 9 1",
" 	s c0	c grey45",
".	s c46	c red",
"X	s c46	c brown",
"o	s c46	c gray",
"O	s c23	c white",
"+	c black",
"@	c cyan",
"#	c yellow",
"$	c green",
/* pixels */
"                                ",
"                                ",
"                                ",
"             .....X oooo        ",
"           .X..X....oOOo        ",
"          ..+X+..X..oooo        ",
"         .X+XXX+....ooOO        ",
"        ..+XXXXX+...oooo        ",
"       ..+XX+++XX+.XOOOo.       ",
"      .X+XX++@++XX+..ooo..      ",
"     ..+XX+@+@+@+XX+..oo...     ",
"    ..+XXX+@+@+@+XXX+.X..X..    ",
"   X.+XXXX+@+@+@+XXXX+..X....   ",
"  ..+XXXXX+++++++XXXXX+....X.   ",
"  .XXXXXXXXXXXXXXXXXXXX+......  ",
"   +XXXXXXXXXXXXXXXXXXXX+++++   ",
"   +XXXXXXXXXXXXXXXXXXX+XXXX+   ",
"   +XXX@@XX++++XXX@@XXXXXXXX+   ",
"   +X+@@@@X+###X+@@@@XX+XXXX+   ",
"   +X+@@@@X+###X+@@@@XXXXXXX+   ",
"   +X+@@@@X+###X+@@@@XX+XXXX+   ",
"   +X+@@@@X+###X+@@@@XXXXXXX+   ",
"   +X+@@@@X+#O#X+@@@@XX+XXXX+   ",
"   +X+++++X+###X+++++XXXXXXX+   ",
"   +XXXXXXX+###XXXXXXXX+XXXX+   ",
"   +XXXXXXX+###XXXXXXXXXXXXX+$  ",
" $$+XXXXXXX+###XXXXXXXX+XXXX+$$ ",
" $$$$$$$$$$$$$$$$$$$$$$$$$$$$$  ",
"  $$$$$$$$$$$$$$$$$ $$$$$$$$$   ",
"     $$  $$$ $$$$$$$$$$$$$      ",
"  $   $           $ $ $$        ",
"                                "};
}
\maxWidth {32}
\BDColor {grey20}
\BGColor {grey45}
\FGColor {99 99 99}
\
\class {XBMButton}
\name {www.top.prev}
\parent {www.top}
\script {
	switch (arg[0]) {
	case "buttonRelease":
		www.view.html("prev");
	break;
	case "enter":
	case "leave":
		www.mesg.tf("suggest", get("name"), arg[0]);
		encounter = enconter + 1;
		return;
	break;
	case "hint":
		return concatenate("Click to visit the previous document = ",
				wwwHistory("peek_prev"));
	break;
	}
	usual();
}
\content {}
\label {#define prev_width 32
#define prev_height 32
static char prev_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0xff, 0x3f, 0x00,
   0xe0, 0xff, 0x5f, 0x00, 0xe0, 0xff, 0xdf, 0x00, 0xe0, 0xff, 0xdf, 0x01,
   0xe0, 0xff, 0xdf, 0x03, 0xe0, 0xff, 0x1f, 0x04, 0xe0, 0x7f, 0xfc, 0x07,
   0xe0, 0x3f, 0xfc, 0x07, 0xe0, 0x1f, 0xfc, 0x07, 0xe0, 0x0f, 0xfc, 0x07,
   0xe0, 0x07, 0xfc, 0x07, 0xe0, 0x03, 0xfc, 0x07, 0xe0, 0x07, 0xfc, 0x07,
   0xe0, 0x0f, 0xfc, 0x07, 0xe0, 0x1f, 0xfc, 0x07, 0xe0, 0x3f, 0xfc, 0x07,
   0xe0, 0x7f, 0xfc, 0x07, 0xe0, 0xff, 0xff, 0x07, 0xe0, 0xff, 0xff, 0x07,
   0xe0, 0xff, 0xff, 0x07, 0xe0, 0xff, 0xff, 0x07, 0xe0, 0xff, 0xff, 0x07,
   0xe0, 0xff, 0xff, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
}
\maxWidth {32}
\BDColor {grey20}
\BGColor {grey45}
\FGColor {lightyellow}
\
\class {XBMButton}
\name {www.top.back}
\parent {www.top}
\script {
	switch (arg[0]) {
	case "buttonRelease":
		www.view.html("back");
	break;
	case "enter":
	case "leave":
		www.mesg.tf("suggest", get("name"), arg[0]);
		return;
	break;
	case "hint":
		return concatenate("Click to go back. document = ",
				wwwHistory("peek_back"));
	break;
	}
	usual();
}
\label {#define back_width 32
#define back_height 32
static char back_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0xff, 0x3f, 0x00,
   0xe0, 0xff, 0x5f, 0x00, 0xe0, 0xff, 0xdf, 0x00, 0xe0, 0xff, 0xdf, 0x01,
   0xe0, 0xff, 0xdf, 0x03, 0xe0, 0xff, 0x1f, 0x04, 0xe0, 0xbf, 0xff, 0x07,
   0xe0, 0x1f, 0xff, 0x07, 0xe0, 0x0f, 0xfe, 0x07, 0xe0, 0x07, 0xfc, 0x07,
   0xe0, 0x03, 0xf8, 0x07, 0xe0, 0x01, 0xf0, 0x07, 0xe0, 0x01, 0xf0, 0x07,
   0xe0, 0x01, 0xf0, 0x07, 0xe0, 0xff, 0xff, 0x07, 0xe0, 0xff, 0xff, 0x07,
   0xe0, 0xff, 0xff, 0x07, 0xe0, 0xff, 0xff, 0x07, 0xe0, 0xff, 0xff, 0x07,
   0xe0, 0xff, 0xff, 0x07, 0xe0, 0xff, 0xff, 0x07, 0xe0, 0xff, 0xff, 0x07,
   0xe0, 0xff, 0xff, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
}
\maxWidth {32}
\BDColor {grey20}
\BGColor {grey45}
\FGColor {lightyellow}
\
\class {XBMButton}
\name {www.top.next}
\parent {www.top}
\script {
	switch (arg[0]) {
	case "buttonRelease":
		www.view.html("next");
	break;
	case "enter":
	case "leave":
		www.mesg.tf("suggest", get("name"), arg[0]);
		return;
	break;
	case "hint":
		return concatenate("Click to visit the next document = ",
				wwwHistory("peek_next"));
	break;
	}
	usual();
}
\label {#define next_width 32
#define next_height 32
static char next_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0xff, 0x3f, 0x00,
   0xe0, 0xff, 0x5f, 0x00, 0xe0, 0xff, 0xdf, 0x00, 0xe0, 0xff, 0xdf, 0x01,
   0xe0, 0xff, 0xdf, 0x03, 0xe0, 0xff, 0x1f, 0x04, 0xe0, 0x8f, 0xff, 0x07,
   0xe0, 0x0f, 0xff, 0x07, 0xe0, 0x0f, 0xfe, 0x07, 0xe0, 0x0f, 0xfc, 0x07,
   0xe0, 0x0f, 0xf8, 0x07, 0xe0, 0x0f, 0xf0, 0x07, 0xe0, 0x0f, 0xf8, 0x07,
   0xe0, 0x0f, 0xfc, 0x07, 0xe0, 0x0f, 0xfe, 0x07, 0xe0, 0x0f, 0xff, 0x07,
   0xe0, 0x8f, 0xff, 0x07, 0xe0, 0xff, 0xff, 0x07, 0xe0, 0xff, 0xff, 0x07,
   0xe0, 0xff, 0xff, 0x07, 0xe0, 0xff, 0xff, 0x07, 0xe0, 0xff, 0xff, 0x07,
   0xe0, 0xff, 0xff, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
}
\maxWidth {32}
\BDColor {grey20}
\BGColor {grey45}
\FGColor {lightyellow}
\
\class {XBMButton}
\name {www.top.mark}
\parent {www.top}
\script {
	switch (arg[0]) {
	case "buttonRelease":
		title = www.view.html("queryTitle");
		address = www.view.html("queryAddress");
		www.top.links("add", title, address);
	break;
	case "enter":
	case "leave":
		www.mesg.tf("suggest", get("name"), arg[0]);
		return;
	break;
	case "hint":
		return "Click it to mark the current document.";
	break;
	}
	usual();
}
\label {#define mark_width 32
#define mark_height 32
static char mark_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0xff, 0x1f, 0x00,
   0xe0, 0xff, 0x2f, 0x00, 0xe0, 0xff, 0x6f, 0x00, 0xe0, 0xff, 0xef, 0x00,
   0xe0, 0xff, 0x0f, 0x01, 0xe0, 0xff, 0xff, 0x01, 0xe0, 0xff, 0xff, 0x09,
   0xe0, 0xff, 0xff, 0x19, 0xe0, 0xff, 0xff, 0x39, 0xe0, 0xff, 0x01, 0x7e,
   0xe0, 0xff, 0xff, 0x39, 0xe0, 0xff, 0xff, 0x59, 0xe0, 0xff, 0xff, 0x29,
   0xe0, 0xff, 0xff, 0x11, 0xe0, 0xff, 0xff, 0x09, 0xe0, 0xff, 0xff, 0x01,
   0xe0, 0xff, 0xff, 0x01, 0xe0, 0xff, 0xff, 0x01, 0xe0, 0xff, 0xff, 0x01,
   0xe0, 0xff, 0xff, 0x01, 0xa4, 0x33, 0xb6, 0x01, 0x8c, 0xa1, 0xd5, 0x01,
   0x94, 0xad, 0xe5, 0x01, 0x44, 0x52, 0x38, 0x00, 0x44, 0x52, 0x49, 0x00,
   0x44, 0x52, 0x8a, 0x00, 0x00, 0x00, 0x00, 0x00};
}
\maxWidth {32}
\BDColor {grey20}
\BGColor {grey45}
\FGColor {lightyellow}
\
\class {menu}
\name {www.top.links}
\parent {www.top}
\script {
	switch (arg[0]) {
	case "add":
		set("menuConfig", concatenate(get("menuConfig"), "\n", 
			".{", arg[1], "} {www(\"show\", \"", arg[2], "\");}"));
		return;
	break;
	case "init":
		path = accessible("~/.WWWBookMarks");
		if (path != "") {
			set("menuConfig", loadFile(path));
		} else {
			set("menuConfig", get("content"));
		}
	break;
	case "enter":
	case "leave":
		www.mesg.tf("suggest", get("name"), arg[0]);
		return;
	break;
	case "hint":
		return "Pull that menu down to see the marked documents.";
	break;
	}
	usual();
}
\content {
.{World-Wide Web                        } {www("show", "http://info.cern.ch/hypertext/WWW/TheProject.html");}
.{Information sources by subject} {www("show", "http://info.cern.ch/hypertext/DataSources/bySubject/Overview.html");}
}
\label {Marked Documents}
\BDColor {white}
\BGColor {grey45}
\FGColor {white}
\paneConfig {freeForm}
\font {any}
\
\class {field}
\name {www.top.gap}
\parent {www.top}
\BDColor {grey20}
\BGColor {grey45}
\maxWidth {10}
\
\class {XPMButton}
\name {www.top.icon}
\parent {www.top}
\script {
	/*
	 * Got any niffty rotating pixmaps? If so, please send them to me!
	 */
	switch (arg[0]) {
	case "rotate": 
		/* Politically correct map-icon of the globe :-)
		 * thou only 2 views exists, for now...
		 */
		xx = get("label");
		set("label", get("content"));
		set("content", xx);
		clearWindow();
		render();
		after(120000, "www.top.icon", "rotate"); /* 2 minutes */
		return;
	break;
	case "init":
		after(120000, "www.top.icon", "rotate");
	break;
	case "buttonRelease":
		www("about");
	break;
	case "enter":
	case "leave":
		www.mesg.tf("suggest", get("name"), arg[0]);
		return;
	break;
	case "hint":
		return "Click to see some general project information.";
	break;
	}
	usual();
}
\content {/* XPM */
static char * gb2 [] = {
/* g30 pixmap
 * width height ncolors chars_per_pixel */
"32 32 7 1",
" 	s c0	c grey45",
".	s c23	c white",
"X	s c5	c blue",
"o	s c27	c #fbfbfb",
"O	s c46	c darkgreen",
"+	s c19	c lightblue",
"@	s c11	c brown",
/* pixels */
"          .Xo.XooOo...          ",
"        .OOoOOOOooOO..o.        ",
"      O.O+OOOOOOOO+oooO...      ",
"     ..XXXX+.OOOOooOOoo.+X.     ",
"    ..ooXXXX.oooOOOOOOOO.o..    ",
"   .XXXXXoXXOOoOOOOOOOO.XXX.+   ",
"  .XXXoXXXXXOOooOOOOOOXXXX.XX   ",
"  .XXXoXXXXXXOOOooO@OOOXX+XXX.  ",
" ..XXXXXXXXXXXOOOo@@O...XXXXXX. ",
" .oXXXXXXXXXXX.O.OOXX+OO+XXXXXX ",
"X.oXXXXXXXXXXXXXOO+O.OO.OXXXXX..",
".X+XXXXXXXXXXXXXX+OOO+X..X.XXXX.",
".XXXXXXXXXXXXXXXXXXXO+.X.O.XXXXX",
".XXXXXXXXXXXXXXXXXXXX+OOOOO+XXX.",
".XXXXXXXXXXXXXXXXXXXX+X++OOOOOXX",
".XXXXXXXXXXXXXXXXXX+XX+OOOOOOoX.",
".X+XXXXXXXXXXXXXXXX.+XOOOOOOOoo.",
"O.XXXXXXXXXXXXXXXXXXXX.OOOOOOooO",
". .++XXXXXXXXXXXXXXXXO.OOOoOOOOO",
"...XXXXXXXXXXXXXXXXXXXX+OOOOOOO.",
".+XXX..+XXXXXXXXXXXXXXXXOOOOOOX.",
"X..X.XXXXXXXXXXXXXXXXXXXXOOOOOO.",
" .XXXX+XXoXXXXXXXXXXXXX+OOOOO.X ",
" ..XXXX+XXXXXXXXXXXXXX+XOoOOO.. ",
"  .XXXXXXXXXXXXXXXXXXX.OoOOOX.  ",
"  .XXXXXXXXXXXXXXXXXXX+OOOX+X   ",
"   OOXXXXXXXoXXXXoXXXX+OO.X..   ",
"    OOXXXXXXXXXXXXXXX.O.XX..    ",
"     .OXXXXXXXXXXXXXXOOO..      ",
"      .XXXXXooXXXXXO+...        ",
"        .ooXXooooooXoX.         ",
"          ..ooooooo...          "};
}
\label {/* XPM */
static char * gb [] = {
/* gb pixmap
 * width height ncolors chars_per_pixel */
"32 32 9 1",
" 	s c0	c grey45",
".	s c23	c white",
"X	s c19	c lightblue",
"o	s c46	c darkgreen",
"O	s c9	c gray",
"+	s c5	c blue",
"@	s c27	c #fbfbfb",
"#	s c29	c gray97",
"$	s c11	c brown",
/* pixels */
"           ...........          ",
"        X..........oo...        ",
"      XOO++.+.@...oo.oo..O      ",
"     XOO++++X..ooo.o.o....O     ",
"    XOO+O++#O..OO..oo.o....O    ",
"   .XO+O+++X...O.OOo.oo.ooo..   ",
"  .XO++OO++X+...OOOOXOOo.oo..O  ",
"  .++++++@++ooo..+.XO.o.oo.o..  ",
" ..+++++@++oooooooooo.oo...oo.O ",
" .+X+++++Xooooooooooo..o...X....",
" o+++++XXooooooooooooo..oo.XX..O",
"oo++++XX.ooooooooooooo+..+...XX+",
"oo++++++.ooooXoooo$oooo.XX++..X+",
"X..+++++X.$$o$.$o$oX$$XoXX++++O+",
"XX...++++X.XXX..Xo$$$$$ooX++++O+",
".....X++.+++..X..$$o$$.oX.++++++",
".oo....++++.++.XoooooooX..++++++",
"oooo.X.X+++++++..oooooo.+.+@+@+O",
"oooXo++..X+++++.Xoooooo.++.+++++",
"ooooX++++XX+++++XooooooX+.+X+++O",
"ooooo++++++++++XooooooXX..X++++O",
"oooo.++++++++++XXooooX.....+++O ",
" ooo.+++++++++++Xoooo....X+++++ ",
" ooo++++++++++++XXoo..+OO++++O  ",
"  oo+++++++++++++.oX.++OX++++O  ",
"  ooO++++++++++++..++XOX+++++O  ",
"   XX+++++++++++++++XO++++++O   ",
"    oo+++++++++++++OO++++++O    ",
"     o+X++++++++O+OO+++X++O     ",
"      +X+OO++.OOXXXX+X+OOO      ",
"        ++..OX...O.....O        ",
"           ..........           "};
}
\maxWidth {31}
\BDColor {grey20}
\BGColor {25 25 25}
\FGColor {99 99 99}
\
\class {XBMButton}
\name {www.top.help}
\parent {www.top}
\script {
	switch (arg[0]) {
	case "buttonRelease":
		www("help");
	break;
	case "enter":
	case "leave":
		www.mesg.tf("suggest", get("name"), arg[0]);
		return;
	break;
	case "hint":
		return "Click it to access a guide to this application.";
	break;
	}
	usual();
}
\label {#define help_width 32
#define help_height 32
static char help_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0xfc, 0x03, 0x00, 0x00, 0xff, 0x0f, 0x00, 0x80, 0xff, 0x1f, 0x00,
   0xc0, 0x0f, 0x3e, 0x00, 0xc0, 0x03, 0x38, 0x00, 0xe0, 0x03, 0x78, 0x00,
   0xe0, 0x07, 0x78, 0x00, 0xe0, 0x07, 0x78, 0x00, 0xc0, 0x07, 0x3c, 0x00,
   0x80, 0x03, 0x3c, 0x00, 0x00, 0x00, 0x3e, 0x00, 0x00, 0x00, 0x1f, 0x00,
   0x00, 0x80, 0x0f, 0x00, 0x00, 0xc0, 0x03, 0x00, 0x00, 0xc0, 0x01, 0x00,
   0x00, 0xe0, 0x00, 0x00, 0x00, 0xe0, 0x01, 0x00, 0x00, 0xe0, 0x01, 0x00,
   0x00, 0xe0, 0x01, 0x00, 0x00, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0xe0, 0x01, 0x00, 0x00, 0xf0, 0x03, 0x00, 0x00, 0xf0, 0x03, 0x00,
   0x00, 0xf0, 0x03, 0x00, 0x00, 0xe0, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
}
\maxWidth {32}
\BDColor {grey20}
\BGColor {grey45}
\FGColor {lightyellow}
\
\class {txtButton}
\name {www.top.quit}
\parent {www.top}
\script {
	switch (arg[0]) {
	case "buttonRelease":
		www("quit");
	break;
	case "enter":
	case "leave":
		www.mesg.tf("suggest", get("name"), arg[0]);
		return;
	break;
	case "hint":
		return "Clint says: Go ahead. Make my day.";
	break;
	}
	usual();
}
\label {Quit}
\maxWidth {40}
\BDColor {white}
\BGColor {grey45}
\FGColor {white}
\paneConfig {freeForm}
\font {any}
\
\class {txtLabel}
\name {www.title}
\parent {www}
\script {
	switch (arg[0]) {
	case "show":
		if (isBlank(arg[1])) {
			set("label", "<No Title>");
		} else {
			set("label", arg[1]);
		}
		render();
		return;
	break;
	case "buttonRelease":
		www.view.html("reload");
	break;
	}
	usual();
}
\label {Home page}
\maxHeight {22}
\BDColor {55 55 55}
\BGColor {grey45}
\FGColor {white}
\paneConfig {freeForm}
\font {bold_large}
\
\class {hpane}
\name {www.view}
\parent {www}
\children {www.view.sb www.view.html}
\script {
	switch (arg[0]) {
	case "tear":
		tearPageID = tearPageID + 1;
		new = clone(tearPageID);
		tweak(new, "set(\"parent\", \"\");");
		send(new, "torn");
		send(new, "render");
		return;
	break;
	case "torn":
		windowName(send(nthChild(1), "queryTitle"));
		objectListSend("children", "torn");
		return;
	break;
	case "init":
		tearPageID = 0;
	break;
	case "quit":
		set("visible", 0);
		return;
	break;
	}
	usual();
}
\BDColor {55 55 55}
\BGColor {25 25 25}
\FGColor {99 99 99}
\
\class {vpane}
\name {www.view.sb}
\parent {www.view}
\children {www.view.sb.tear www.view.sb.up www.view.sb.down www.view.sb.slider}
\script {
	switch (arg[0]) {
	case "tear":
	case "quit":
		send(get("parent"), arg[0]);
		return;
	break;
	case "torn":
		send(nthChild(0), "torn");
		return;
	break;
	}
	usual();
}
\maxWidth {20}
\BDColor {55 55 55}
\BGColor {25 25 25}
\FGColor {99 99 99}
\
\class {XBMButton}
\name {www.view.sb.tear}
\parent {www.view.sb}
\script {
	switch (arg[0]) {
	case "buttonRelease":
		if (isTorn == 1) {
			send(get("parent"), "quit");
		} else {
			send(get("parent"), "tear");
		}
	break;
	case "torn":
		set("label", get("content"));
		if (get("window")) {
			cycleColors(0);
			render();
		}
		isTorn = 1;
		return;
	break;
	case "enter":
	case "leave":
		www.mesg.tf("suggest", get("name"), arg[0]);
		return;
	break;
	case "hint":
		if (isTorn == 1) {
			return "Click to dismiss the page.";
		} else {
			return "Click to tear out a clone page.";
		}
	break;
	}
	usual();
}
\content {#define destroy_width 16
#define destroy_height 16
static char destroy_bits[] = {
   0xe0, 0x04, 0x00, 0x07, 0x00, 0x38, 0xf0, 0x3f, 0x10, 0x20, 0x50, 0x35,
   0x50, 0x35, 0x50, 0x35, 0x50, 0x35, 0x50, 0x35, 0x50, 0x35, 0x50, 0x35,
   0x58, 0x35, 0x14, 0x20, 0xe6, 0x1f, 0x00, 0x00};
}
\label {#define tear_width 16
#define tear_height 16
static char tear_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0xfc, 0x0f, 0x0e, 0x0c, 0xfc, 0x0f, 0x0a, 0x0c,
   0xfc, 0x1f, 0x1a, 0x18, 0xf4, 0x3f, 0x3a, 0x70, 0xf4, 0xff, 0xea, 0x0f,
   0x54, 0x15, 0xaa, 0x0a, 0x54, 0x15, 0x00, 0x00};
}
\maxHeight {19}
\BDColor {grey20}
\BGColor {grey45}
\FGColor {white}
\
\class {XBMButton}
\name {www.view.sb.up}
\parent {www.view.sb}
\script {
	if (arg[0] == "buttonRelease") send(nthSibling(3), "scroll", "up");
	usual();
}
\label {#define upButton20_width 20
#define upButton20_height 20
static char upButton20_bits[] = {
   0x00, 0x00, 0x00, 0xfe, 0xff, 0x07, 0xfe, 0xff, 0x03, 0x56, 0x55, 0x05,
   0xae, 0xae, 0x00, 0x56, 0x59, 0x05, 0xae, 0xb0, 0x00, 0x56, 0x60, 0x05,
   0x2e, 0xc0, 0x00, 0x16, 0x80, 0x05, 0xae, 0xb0, 0x00, 0x56, 0x51, 0x05,
   0xae, 0xb0, 0x00, 0x56, 0x51, 0x05, 0xae, 0xb0, 0x00, 0x56, 0x55, 0x05,
   0xae, 0xaa, 0x00, 0x06, 0x00, 0x04, 0xaa, 0xaa, 0x02, 0x00, 0x00, 0x00};
}
\maxHeight {19}
\BDColor {grey75}
\BGColor {grey40}
\FGColor {grey99}
\
\class {XBMButton}
\name {www.view.sb.down}
\parent {www.view.sb}
\script {
	if (arg[0] == "buttonRelease") send(nthSibling(3), "scroll", "down");
	usual();
}
\label {#define fff_width 20
#define fff_height 20
static char fff_bits[] = {
   0x00, 0x00, 0x00, 0xfe, 0xff, 0x03, 0xfe, 0xff, 0x05, 0xae, 0xaa, 0x00,
   0x56, 0x55, 0x05, 0xae, 0xb0, 0x00, 0x56, 0x51, 0x05, 0xae, 0xb0, 0x00,
   0x56, 0x51, 0x05, 0xae, 0xb0, 0x00, 0x16, 0x80, 0x05, 0x2e, 0xc0, 0x00,
   0x56, 0x60, 0x05, 0xae, 0xb0, 0x00, 0x56, 0x59, 0x05, 0xae, 0xae, 0x00,
   0x56, 0x55, 0x05, 0x06, 0x00, 0x00, 0xaa, 0xaa, 0x02, 0x00, 0x00, 0x00};
}
\maxHeight {19}
\BDColor {grey75}
\BGColor {grey40}
\FGColor {grey99}
\
\class {slider}
\name {www.view.sb.slider}
\parent {www.view.sb}
\shownNotify {www.view.html}
\BDColor {grey99}
\BGColor {grey45}
\FGColor {grey80}
\
\class {HTML}
\name {www.view.html}
\parent {www.view}
\script {
	switch (arg[0]) {
	case "buttonRelease":
		if (charButtonMask() > 0) {
			/* has pressed inside a ``button'' */
			tag = nextTag();
			if (tag) {
				if (nthChar(tag, 1) == '*') {
					/*print("script:\n");*/
					interpret(tag);
				} else {
					if (www.view.html("show", tag))
						www.view.html("historyRecord");
				}
			} else {
				bell();
				www.mesg.tf("warn", 
					 "Try clicking the ending parts.");
			}
		} else {
			/* lets user complete cut/paste */
		}
		return;
	break;
	case "home":
		www.view.html("show", homeDoc);
		return;
	break;
	case "about":
		www.view.html("show", www.about("handle"));
		system(concatenate("rm -f ", handle));
		return;
	break;
	case "help":
		www.view.html("show", www.help("handle"));
		system(concatenate("rm -f ", handle));
		return;
	break;
	case "show":
		www.mesg.tf("show",
			    concatenate("Getting ", arg[1], " ..."));
		cursorShape("busy");

		if (isBlank(set("HTMLAddress", arg[1]))) {
			www.mesg.tf("show", 
				    concatenate("Failed to get ", arg[1]));
			cursorShape("idle");
			return 0;
		} else {
			www.title("show", get("HTMLTitle"));
			render();
			n = float(totalLineCount() - numberOfLinesDisplayed());
			if (n > 0) {
				www.view.sb.slider("shownPositionV", 
					float(lineRowOffset()) / n * 100.0);
				p = float(lineRowOffset()) / n * 100.0;
			} else {
				www.view.sb.slider("shownPositionV", 0);
			}
			www.mesg.tf("show", "");
			www.udi.tf("show", arg[1]);
			www.idx.label("index", get("HTMLIsIndex"));
			www.idx.tf("index", get("HTMLIsIndex"));

			cursorShape("idle");
			return 1;
		}
	break;
	case "reload":
		purgeCache();
		set("HTMLAddress", get("HTMLAddress"));
		render();
		return;
	break;
	case "historyRecord":
		wwwHistory("add", get("HTMLTitle"), get("HTMLAddress"));
		return;
	break;
	case "search":
		cursorShape("busy");
		search(arg[1]);
		cursorShape("idle");
		return;
	break;
	case "prev":
		wantIt = wwwHistory("prev");
		if (isBlank(wantIt)) {
			www.mesg.tf("alert", 
				"No ``previous'' document to go to.");
		} else {
			www.view.html("show", wantIt);
		}
		return;
	break;
	case "next":
		wantIt = wwwHistory("next");
		if (isBlank(wantIt)) {
			www.mesg.tf("alert", 
				"No ``next'' document to go to.");
		} else {
			www.view.html("show", wantIt);
		}
		return;
	break;
	case "back":
		wantIt = wwwHistory("back");
		if (isBlank(wantIt)) {
			www.mesg.tf("alert", 
				    "No Previous document to go back to.");
		} else {
			www.view.html("show", wantIt);
		}
		return;
	break;
	case "keyPress":
		www.idx.tf("focus");
		return;
	break;
	case "save":
		tmp = "/usr/tmp/out.html";	/* later, use dialog box */
		cmd = concatenate("www -n ", 
				get("HTMLAddress"), " > ", 
				tmp);
		system(cmd);
		return;
	break;
	case "queryAddress":
		return get("HTMLAddress");
	break;
	case "queryTitle":
		return get("HTMLTitle");
	break;
	case "queryIsIndex":
		return get("HTMLIsIndex");
	break;
	case "tree":
		/* produce a n-level anchors tree by recursively fetching
		 * anchor links 
		 */
		return;
	break;
	case "init":
		initialize();

		homeDoc = environVar("WWW_HOME");
		if (isBlank(homeDoc) == 1) {
			homeDoc = accessible("/usr/local/lib/WWW/default.html");
			if (isBlank(homeDoc) == 1)
			    homeDoc = "http://info.cern.ch/hypertext/WWW/TheProject.html";
		}
		print("WWW: home = ", homeDoc, "\n");

		set("HTMLAddress", homeDoc);
		wwwHistory("add", get("HTMLTitle"), get("HTMLAddress"));

		return;
	break;
	case "editSrc":
		wwwSrc("show", get("HTMLAddress"), get("HTMLSource"));
		return;
	break;
	case "print":
		/* This facility could be much better. But for now...
		 * Possible solutions:
		 *	convert to TeX
		 * 	generate postscript (use variable width font)
		 * 	use internal formatter (no need to call www)
		 * 	use cached HTMLSource (no need to fetch html file)
		 */
		lprCmd = environVar("WWW_LPR");
		if (isBlank(lprCmd)) lprCmd = "lpr ";
		tmp = concatenate(makeTempFile(), ".html");
		www.mesg.tf("flash", 
			concatenate("Printing command: ", lprCmd));
		system(concatenate("www -n ", get("HTMLAddress"), " > ", tmp));
		system(concatenate(lprCmd, " ", tmp));
		system(concatenate("rm -f ", tmp));
		return;
 	break;
	case "cycleColors":
		cycleColors(1);
		render();
		return;
 	break;
	case "reverseVideo":
		cycleColors(1);
		cycleColors(1);
		render();
		return;
	break;
	case "colorsBGFGBD":
		set("BGColor", arg[1]);
		set("FGColor", arg[2]);
		set("BDColor", arg[3]);
		render();
		return;
 	break;
	case "randomColors!":
		set("BGColor", concatenate(random(0) / 20000000, " ", 
					   random(0) / 20000000, " ", 
					   random(0) / 20000000));
		set("BDColor", concatenate(random(0) / 20000000, " ", 
					   random(0) / 20000000, " ", 
					   random(0) / 20000000));
		set("FGColor", concatenate(random(0) / 20000000, " ", 
					   random(0) / 20000000, " ", 
					   random(0) / 20000000));
		render();
		return;
 	break;
	case "torn":
		isTorn = 1;
		return;
	break;
	case "enter":
		set("cursor", 0); 
		return;
	break;
	}
	usual();
}
\shownDepend {www.view.sb.slider}
\BDColor {grey75}
\BGColor {100 100 85}
\FGColor {black}
\paneConfig {freeForm}
\font {usual_medium}
\
\class {hpane}
\name {www.idx}
\parent {www}
\children {www.idx.label www.idx.tf www.pref.label www.prt.label www.src.label}
\maxHeight {18}
\BDColor {55 55 55}
\BGColor {25 25 25}
\FGColor {99 99 99}
\
\class {txtLabel}
\name {www.idx.label}
\parent {www.idx}
\script {
	switch (arg[0]) {
	case "index":
		if (arg[1] == 1) {
			set("label", "Is Index");
			canSearchP = 1;
		} else {
			set("label", "Not Index");
			canSearchP = 0;
		}
		render();
		return;
	break;
	case "enter":
	case "leave":
		www.mesg.tf("suggest", get("name"), arg[0]);
		return;
	break;
	case "hint":
		if (canSearchP) 
			return "Keyword search mode indicator (now on)";
		else 
			return "Keyword search mode indicator (now off)";
	break;
	}
	usual();
}
\label {}
\maxWidth {80}
\BDColor {grey20}
\BGColor {grey45}
\FGColor {white}
\
\class {txtDisp}
\name {www.idx.tf}
\parent {www.idx}
\script {
	switch (arg[0]) {
	case "keyPress":
		if (canSearchP == 0) {
			bell();
			www.mesg.tf("warn", 
				"Document is not index; no searching allowed."); 
		} else {
			c = key();
			if (c == '\r') {
				if (saveMouse) {
					/* restore mouse position */
					setMouse(saveMousePos[0], 
						saveMousePos[1]);
					saveMouse = 0;
				}
				www("search", currentLine());
				insert(c);
				if (cursorRow() != 0) {
					/* a kludgy safe guard to simulate
					 * carriage-return then ctrl-p 
					 */
					insert("\r\16"); 
				}
			} else {
				insert(c);
			}
		}
		return;
	break;
	case "index":
		if (arg[1] == 1) {
			canSearchP = 1;
		} else {
			canSearchP = 0;
		}
		return;
	break;
	case "show":
		set("content", arg[1]);
		render();
		return;
	break;
	case "focus":
		/* move cursor to www.idx.tf */
		saveMousePos = mouse();
		saveMouse = 1;
		winPos = windowPosition();
		setMouse(winPos[0] + 18, winPos[1] + 18);
		www.idx.tf("enter");
		www.idx.tf("keyPress"); /* redirect keypresses */
		return;
	break;
	case "enter":
		www.mesg.tf("suggest", get("name"), arg[0]);
		if (canSearchP == 0) set("cursor", 0);
	break;
	case "leave":
		/* cancel mouse warp to avoid confusion */
		if (saveMouse) saveMouse = 0;
		www.mesg.tf("suggest", get("name"), arg[0]);
	break;
	case "hint":
		if (canSearchP) 
			return "Keyword search entry field (valid, can enter a keyword now)";
		else
			return "Keyword search entry field (invalid)";
	break;
	case "init":
		canSearchP = 0;
		saveMouse = 0;
	break;
	}
	usual();
}
\BDColor {grey20}
\BGColor {grey45}
\FGColor {white}
\paneConfig {freeForm}
\font {any}
\
\class {menu}
\name {www.pref.label}
\parent {www.idx}
\script {
	switch (arg[0]) {
	case "enter":
	case "leave":
		www.mesg.tf("suggest", get("name"), arg[0]);
		return;
	break;
	case "hint":
		return "Preference settings.";
	break;
	}
	usual();
}
\label {C}
\menuConfig {
.{Papery}		{www.view.html("colorsBGFGBD", "100 100 85", "black", "grey75");}
.{Woody}		{www.view.html("colorsBGFGBD", "burlywood", "black", "grey75");}
.{Blue}			{www.view.html("colorsBGFGBD", "deepSkyBlue4", "white", "grey75");}
.{Green}		{www.view.html("colorsBGFGBD", "black", "green1", "grey75");}
.{Amber}		{www.view.html("colorsBGFGBD", "black", "orange1", "grey75");}
.{Bisque}		{www.view.html("colorsBGFGBD", "bisque4", "bisque1", "grey75");}
.{B/W}			{www.view.html("colorsBGFGBD", "black", "white", "grey75");}
.{W/B}			{www.view.html("colorsBGFGBD", "white", "black", "grey75");}
.{Lights out}		{www.view.html("colorsBGFGBD", "black", "black", "grey75");}
.{Randomize}		{www.view.html("randomColors!");}
.{Reverse Video}	{www.view.html("reverseVideo");}
.{Cycle Colors}		{www.view.html("cycleColors");}
.{wais}			{wais("render");}
}
\maxWidth {20}
\BDColor {grey75}
\BGColor {grey45}
\FGColor {white}
\
\class {XBMButton}
\name {www.prt.label}
\parent {www.idx}
\script {
	switch (arg[0]) {
	case "buttonRelease":
		www.view.html("print");
	break;
	case "enter":
	case "leave":
		www.mesg.tf("suggest", get("name"), arg[0]);
		return;
	break;
	case "hint":
		return "Click to print a hardcopy of the current document.";
	break;
	}
	usual();
}
\label {#define prt_width 16
#define prt_height 16
static char prt_bits[] = {
   0x00, 0x00, 0xf8, 0x03, 0x88, 0x06, 0xf8, 0x0e, 0x88, 0x08, 0xf8, 0x0f,
   0x08, 0x08, 0xf8, 0x0f, 0x08, 0x08, 0xfc, 0x1f, 0x02, 0x20, 0x02, 0x60,
   0x1a, 0x60, 0x02, 0x20, 0xfe, 0x3f, 0x00, 0x00};
}
\maxWidth {16}
\BDColor {grey20}
\BGColor {grey45}
\FGColor {white}
\
\class {XBMButton}
\name {www.src.label}
\parent {www.idx}
\script {
	switch (arg[0]) {
	case "buttonRelease":
		www.view.html("editSrc");
	break;
	case "enter":
	case "leave":
		www.mesg.tf("suggest", get("name"), arg[0]);
		return;
	break;
	case "hint":
		return "Click to see the HTML source of the current document.";
	break;
	}
	usual();
}
\label {#define src_width 16
#define src_height 16
static char src_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xcc, 0x31, 0x52, 0x0a, 0x42, 0x0a,
   0x42, 0x0a, 0xc4, 0x0b, 0x48, 0x09, 0x50, 0x09, 0x50, 0x09, 0x52, 0x0a,
   0x4c, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
}
\maxWidth {16}
\BDColor {grey20}
\BGColor {grey45}
\FGColor {white}
\
\class {hpane}
\name {www.mesg}
\parent {www}
\children {www.mesg.label www.mesg.tf www.ahelp.label www.hist.label}
\maxHeight {18}
\BDColor {55 55 55}
\BGColor {25 25 25}
\FGColor {99 99 99}
\
\class {txtLabel}
\name {www.mesg.label}
\parent {www.mesg}
\label {Message:}
\maxWidth {80}
\BDColor {grey20}
\BGColor {grey45}
\FGColor {white}
\paneConfig {freeForm}
\font {any}
\
\class {txtDisp}
\name {www.mesg.tf}
\parent {www.mesg}
\script {
	switch (arg[0]) {
	case "suggest":
		if (suggest == 0) return;
		if (get("render")) {
			if (arg[2] == "leave") {
				set("content", "");
				render();
			} else {
				hint = send(arg[1], "hint");
				if (isBlank(hint) == 0) {
					set("content", hint);
					if (get("window")) {
						set("FGColor", "100 90 70");
						render();
					}
				}
			}
		}
		return;
	break;
	case "show":
		set("content", arg[1]);
		if (get("window")) {
			set("FGColor", "100 90 70");
			render();
		}
		return;
	break;
	case "alert":
		if (get("render")) {
			set("BGColor", "red");
			set("content", " ");
			render();
			set("BGColor", "grey45");
			set("FGColor", "90 90 90");
			set("content", arg[1]);
			render();
			after(1000, "www.mesg.tf", "clear");
		}
		return;
	break;
	case "warn":
		if (get("render")) {
			set("BGColor", "yellow");
			set("content", " ");
			render();
			set("BGColor", "grey45");
			set("FGColor", "90 90 90");
			set("content", arg[1]);
			render();
			after(1000, "www.mesg.tf", "clear");
		}
		return;
	break;
	case "flash":
		if (get("render")) {
			set("BGColor", "green");
			set("content", " ");
			render();
			set("BGColor", "grey45");
			set("FGColor", "90 90 90");
			set("content", arg[1]);
			render();
			after(1000, "www.mesg.tf", "clear");
		}
		return;
	break;
	case "clear":
		set("content", "");
		render();
		return;
	break;
	case "enter":
		set("cursor", 0);
		www.mesg.tf("suggest", get("name"), arg[0]);
		return;
	break;
	case "leave":
		www.mesg.tf("suggest", get("name"), arg[0]);
		return;
	break;
	case "hint":
		return "The active hints/message text field.... (is it helpful?)";
	break;
	case "keyPress":
		return;
	break;
	case "turnOffSuggest":
		suggest = 0;
		www.mesg.tf("warn", "Active help is now off.");
		return;
	break;
	case "toggleSuggest":
		if (suggest == 1) {
			suggest = 0;
			www.mesg.tf("warn", "Active help is now off.");
		} else {
			suggest = 1;
			www.mesg.tf("warn", "Active help is now on.");
		}
		return;
	break;
	case "init":
		after(50000, "www.mesg.tf", "clear");
		suggest = 0;
/*		after(100000, "www.ahelp.label", "buttonRelease");*/
	break;
	}
	usual();
}
\BDColor {grey20}
\BGColor {grey45}
\FGColor {100 80 60}
\paneConfig {freeForm}
\font {fixed}
\
\class {XBMButton}
\name {www.ahelp.label}
\parent {www.mesg}
\script {
	switch (arg[0]) {
	case "buttonRelease":
		xx = get("label");
		set("label", get("content"));
		set("content", xx);
		render();
		www.mesg.tf("toggleSuggest");
		return;
	break;
	case "enter":
	case "leave":
		www.mesg.tf("suggest", get("name"), arg[0]);
		return;
	break;
	case "hint":
		return "Click to toggle active helper.";
	break;
	}
	usual();
}
\content {#define bubble0_width 16
#define bubble0_height 16
static char bubble0_bits[] = {
   0x00, 0x00, 0xe0, 0x07, 0xf8, 0x1f, 0xfc, 0x3f, 0x8c, 0x24, 0xae, 0x76,
   0xae, 0x64, 0xae, 0x76, 0xae, 0x76, 0xac, 0x36, 0x8c, 0x36, 0xf8, 0x1f,
   0xe0, 0x07, 0x78, 0x00, 0x06, 0x00, 0x00, 0x00};
}
\label {#define bubble1_width 16
#define bubble1_height 16
static char bubble1_bits[] = {
   0x00, 0x00, 0xe0, 0x07, 0xf8, 0x1f, 0xfc, 0x3f, 0x8c, 0x36, 0xae, 0x74,
   0xae, 0x74, 0xae, 0x72, 0xae, 0x72, 0xac, 0x36, 0x8c, 0x36, 0xf8, 0x1f,
   0xe0, 0x07, 0x78, 0x00, 0x06, 0x00, 0x00, 0x00};
}
\maxWidth {16}
\BDColor {grey20}
\BGColor {grey45}
\FGColor {white}
\
\class {XBMButton}
\name {www.hist.label}
\parent {www.mesg}
\script {
	switch (arg[0]) {
	case "buttonRelease":
		wwwHistory("render");
	break;
	case "enter":
	case "leave":
		www.mesg.tf("suggest", get("name"), arg[0]);
		return;
	break;
	case "hint":
		return "Click to see the document history list.";
	break;
	}
	usual();
}
\label {#define hist_width 16
#define hist_height 16
static char hist_bits[] = {
   0x00, 0x00, 0xf0, 0x0f, 0x08, 0x10, 0x18, 0x20, 0xfc, 0x7f, 0xfc, 0x07,
   0xfc, 0x07, 0xdc, 0x0e, 0xb8, 0x0d, 0x38, 0x1c, 0xb0, 0x3d, 0xa0, 0x3d,
   0xae, 0x3b, 0xf4, 0x1f, 0xf8, 0x0f, 0x00, 0x00};
}
\maxWidth {16}
\BDColor {grey20}
\BGColor {grey45}
\FGColor {white}
\
\class {hpane}
\name {www.udi}
\parent {www}
\children {www.udi.label www.udi.tf www.udi.setUDI}
\maxHeight {32}
\BDColor {55 55 55}
\BGColor {25 25 25}
\FGColor {99 99 99}
\
\class {txtLabel}
\name {www.udi.label}
\parent {www.udi}
\label {Doc ID:}
\maxWidth {80}
\BDColor {grey20}
\BGColor {grey45}
\FGColor {white}
\font {any}
\
\class {txtDisp}
\name {www.udi.tf}
\parent {www.udi}
\script {
	switch (arg[0]) {
	case "keyPress":
		c = key();
		if (c == '\r') {
			www("show", currentLine());
			set("content", "");
			render();
		} else {
			insert(c);
		}
		return;
	break;
	case "getUDIFromClipBuffer":
/*		print(">>>>>>>>>>>>", getSelection(), "<<<\n");*/
		www("show", getSelection());
		return;
	break;
	case "appendUDIToHome":
		www.mesg.tf("alert", 
			    "Sorry, can't yet append to home page.");
		return;
	break;
	case "show":
		set("content", arg[1]);
		render();
		return;
	break;
	case "enter":
	case "leave":
		usual();
		www.mesg.tf("suggest", get("name"), arg[0]);
		return;
	break;
	case "hint":
		return "It's the current document address.";
	break;
	}
	usual();
}
\BDColor {grey20}
\BGColor {grey45}
\FGColor {white}
\paneConfig {freeForm}
\font {fixed}
\
\class {txtButton}
\name {www.udi.setUDI}
\parent {www.udi}
\script {
	switch (arg[0]) {
	case "buttonRelease":
		www.udi.tf("getUDIFromClipBuffer");
	break;
	case "enter":
	case "leave":
		www.mesg.tf("suggest", get("name"), arg[0]);
		return;
	break;
	case "hint":
		return "Click to read UDI from X selection buffer.";
	break;
	}
	usual();
}
\label {Use Selected}
\maxWidth {100}
\maxHeight {18}
\BDColor {white}
\BGColor {grey45}
\FGColor {white}
\font {any}
\
\class {field}
\name {www.about}
\script {
	switch (arg[0]) {
	case "handle":
		tmp = "/usr/tmp/violaWWWAbout.html";
		saveFile(tmp, get("content"));
		return tmp;
	break;
	}
	usual();
}
\content {
<TITLE>Overview, ViolaWWW</TITLE>
<H1>ViolaWWW Hypertext Browser</H1>
ViolaWWW implements an X-Windows browser client to the 
<A HREF=http://info.cern.ch/hypertext/WWW/TheProject.html>World-Wide Web</A> 
system. This browser has the basic navigation mechanisms of 
clickable-hot-words, history list (previous/back/next document traversal),
and book-mark list. It has keyword search entry, and can do page cloning 
(multiple windows). There exists a simple printer hook, and a HTML source
viewer (not editor).
<P>
ViolaWWW is built using the 
<A HREF=http://xcf.berkeley.edu/ht/projects/viola/overview.html>
Viola</A> interactive media tool(kit).
<P>
See also:
<A HREF=http://xcf.berkeley.edu/ht/projects/viola/violaWWW/todo.html>
ToDo list</A>.
<P>Thanks for taking the time to do bug reports, and suggestions!

<H2>Status</H2>
<DL>
<DT>May 10, 1992
<DD>Beta release.
<DT>March 9 to April 20, 1992
<DD>Releases to the WWW people at CERN for tests.
</DL>

<P>
Check out the 
<A HREF=http://xcf.berkeley.edu/ht/projects/viola/violaWWW/news.html>
ViolaWWW bulletin</A> at the XCF for the latest announcements, releases,
and bug-fixes regarding this software.

<H2>Acknowledgement</H2>
The menu widget used in viola is implemented with the Pull-Aside Menu 
packagepwd
 written by David S. Harrison (davidh@ic.Berkeley.EDU). 
The W3 library is from the 
<A HREF=http://info.cern.ch/hypertext/WWW/TheProject.html>World Wide Web</A>
project at CERN, Switzerland.
<P>
<ADDRESS><A HREF=http://xcf.berkeley.edu/ht/people/wei/disclaimer.html>
Pei Y. Wei</A><P>
Experimental Computing Facility (XCF)<P>
University of California at Berkeley<P>
wei@xcf.Berkeley.EDU
</ADDRESS>
}
\
\class {field}
\name {www.help}
\script {
	switch (arg[0]) {
	case "handle":
		tmp = "/usr/tmp/violaWWWHelp.html";
		saveFile(tmp, get("content"));
		return tmp;
	break;
	}
	usual();
}
\content {<TITLE>User's Guide</TITLE>
<H1>User's Guide to ViolaWWW</H1>
This is a brief guide to the viola-based 
<A HREF=http://info.cern.ch/hypertext/WWW/TheProject.html>World-Wide Web</A> 
browser.
<A HREF=http://xcf.berkeley.edu/ht/projects/viola/violaWWW/news.html>
Check this out </A> for a possible update of this guide. 

<H2>Following links</H2>
Single click to follow a hypertext link.
<P>
Notice that the ``current'' document identifier is displayed in a text
field (next to the label ``Doc ID'') at the bottom of the main window. 
You can type in a document ID there, and cause the browser to fetch the
document. If you want the browser to fetch a document identifier that 
is in X-Window's selection, press the ``Use Selected'' button.
<P>
Beware of this bug: if a line of hot text wraps around the page, 
you should click on the last line of the multiple lines.

<H2>Home</H2>
The house icon in the upper left corner always takes you to the home
page. The WWW_HOME environment variable tells this browser where the
home document is. If WWW_HOME is undefined, the home document is assumed
to be:
<XMP>
/usr/local/lib/WWW/default.html
</XMP>
If that file is inaccessible, then the following address is used:
<XMP>
http://info.cern.ch/hypertext/WWW/TheProject.html
</XMP>

<H2>Revisiting traveled documents (Prev, Back, Next)</H2>
A history list keeps track of your link travels. To see the history
list, click on the paper-scroll icon (with an ``H'') that is near the 
lower right corner of this application. The document titles are listed, 
with the ``current'' document highlighted.
<P>
In the history window, the ``Dismiss'' buttons tells the history window
to go away. You can bring it back again by clicking on the history icon.
<P>
The other three buttons (Prev, Back, Next), also in the history window, 
have exactly the same function and meaning as the three navigation icons 
that are next to the house icon.
<P>
In the history list, you can click on a title to cause the main text field
to show that document.

<H2>Keyword search</H2>
This operation is valid only with documents containing a
<A HREF=http://info.cern.ch/hypertext/WWW/MarkUp/Tags.html#18>IsIndex</A> tag.
The message label, being either "Is Index" or "Not Index", indicates whether
the current document can or can not take keyword for searching.
<P>
You can enter a keyword by moving the cursor into the text field next to 
the message label, then type. Convenience feature: if your mouse cursor is 
in the main text field, you can simply type straight away; the cursor 
will be warpped to the keyword entry field, and warpped back on carriage 
return.
<P>
Bug warning: problem at the first IsIndex document?

<H2>Book mark</H2>
At the top of the main window is a ``Marked Documents'' menu. It is, like 
the home page, a good place to put pointers to frequently needed documents...
<P>
It contains a set of prepackaged document references. To visit a document
marked in the menu, just choose it as you would a menu item. To mark
the current document (append it into the menu), click on the ``mark'' 
icon that is next to the menu.
<P>
When this browser starts up, it looks for the file "~/.WWWBookMarks"
to put into that menu. If you don't have one, a default bookmark (specified
in file "www.v") is used, instead of letting it empty. 
<P>
Below is a shortened version of the default bookmark list. You can 
change the defaults by editing either the bookmark file "~/.WWWBookMarks"
(or the browser application "www.v"!). 
<XMP>
.{World-Wide Web} {www("show", "http://info.cern.ch/hypertext/WWW/TheProject.html");}
.{Information sources by subject} {www("show", "http://info.cern.ch/hypertext/DataSources/bySubject/Overview.html");}
.{Local Weather (SF Bay Area)} {www("show", "gopher://mermaid.micro.umn.edu:150/00/Weather/California/San%20Francisco");}
</XMP>

<H2>Tearing-out a page</H2>
Notice the icon that looks like a-piece-of-paper-about-to-fly-off, 
near the upper left corner of the main text field. Clicking on it 
makes a clone of the hypertext page. The clone page has a trash-can
icon instead of the paper-tear icon, for dismissing the clone.
<P>
Notice that clicking hot text in the cloned page actually causes action 
in the main text field, and not in clone text field.

<H2>Printing</H2>
Use the icon that looks like a printer, near the lower right corner 
of the main window. Currently, to use this function you must have the 
lineMode browser ``www'' installed.
<P>
If you want to specify the printer name, set the WWW_LPR environment variable.
For example, the following will work, if your printer happens to be named 
``lw199b'':
<XMP>
setenv WWW_LPR "lpr -Plw199b"
</XMP>
<P>
The current implementation is pretty rudimentary (delegating formatting 
work to www). If you have your own printing method, it should be easy for 
you to easily incorporate that method into the browser's default printing 
script. Look at the file "www.v", and search for "WWW_LPR" to get to the 
relevant area... If you make improvements, please share! 

<H2>Source viewing</H2>
Use the icon labeled ``SRC'', near the lower right corner of the main window.
It pops a window displaying the 
<A HREF=http://info.cern.ch/hypertext/WWW/MarkUp/MarkUp.html>HTML</A> source
of the current document.

<H2>More information</H2>
The globe icon brings up general project information about this browser.
The question-mark icon brings(brought!) up this document.
The cartoon-speak-bubble toggles the active help on and off (will turn itself
off after a short while).
The smudge, that appears when you press buttons, is a finger-print that
is supposed to provide visual feedback.
Clicking on the document title will reload the document (handy for viewing
a document that you're editing).
<H2>Bugs</H2>
<A HREF=http://xcf.berkeley.edu/ht/projects/viola/violaWWW/todo.html>
Bugs/ToDo list</A>.

<H2>Status</H2>
Very drafty. Last update is May 10, 1992.

<ADDRESS>Bugs/Comments/Suggestions >> wei@xcf.berkeley.edu</ADDRESS>
}
\
\name {www.listen}
\class {TTY}
\path {/usr/users/wei/viola/src/listen}
\script {
	switch (arg[0]) {
	case "init":
		initialize();
                set("inDelimStr1", "\r");
                set("inDelimStr2", "\n");
/*                startClient();*/
		return;
	break;
	case "input":
		in = input();
		if (isBlank(in)) { 
			print("www.listen: bad input = ``", in, "''\n");
		} else {
			docID = nthChar(in, 0, strlen(in)); 
			print("www.listen: input = ``", docID, "''\n");
			www.view.html("show", docID);
		}
		return;
	break;
	}
	usual();
}
\
