\name	{shell}
\class	{vpane}
\parent	{}
\lock {1}
\width {500}
\height {200}
\script	{
	switch (arg[0]) {
	case "targetSet":
		shell.obj("show");
		return;
	break;
	}
	usual();
}
\children {shell.top shell.obj shell.view shell.mesg}
\
\name	{shell.top}
\class	{hpane}
\parent	{shell}
\lock {1}
\children {shell.top.tools shell.top.ops shell.top.attrs shell.top.title shell.top.dismiss}
\maxHeight {25}
\
\name	{shell.top.tools}
\class	{menu}
\parent	{shell.top}
\label {Tools}
\lock {1}
\script	{
	switch (arg[0]) {
	case "tool":
		tool(arg[1]);
		shell.mesg("show", concatenate("current tool: ", arg[1]));
	break;
	}
	usual();
}
\menuConfig {
.	{Action}		{shell.top.tools("tool", "action");}
.	{Target}		{shell.top.tools("tool", "target");}
.	{Move}			{shell.top.tools("tool", "move");}
.	{Resize}		{shell.top.tools("tool", "resize");}
.	{Reparent}		{shell.top.tools("tool", "reparent");}
}
\BGColor {grey25}
\FGColor {white}
\BDColor {grey}
\font {normal}
\maxWidth {70}
\
\name	{shell.top.ops}
\class	{menu}
\parent	{shell.top}
\label {Operations}
\lock {1}
\script	{
	switch (arg[0]) {
	case "cloneTarget":
		new = tweak(target(), "clone(1);");
		print("newobj=", new, "\n");
		tweak(new, "set(\"parent\", \"\");");
		send(new, "info");
		send(new, "render");
		return;
	break;
	}
	usual();
}
\menuConfig {
.	{Clone target}		{shell.top.tools("cloneTarget");}
.	{Info target}		{tweak(target(), "info();");}
.	{Save target}		{tweak(target(), "save();");}
.	{}
.	{Create object}		{op_create("render");}
.	{}
.	{Vicon}			{vicon("render");}
.	{save dump}		{saveAs("foo");}
.	{save command text}	{shell.view.tf("saveText");}
.	{load command text}	{shell.view.tf("loadText");}
.	{Quit}			{quit();}
}
\BGColor {grey25}
\FGColor {white}
\BDColor {grey}
\font {normal}
\maxWidth {100}
\
\name	{shell.top.attrs}
\class	{menu}
\parent	{shell.top}
\label {Attributes}
\lock {1}
\menuConfig {
.	{content}		{ed_TE("edit", target(), "content");}
.	{script}		{ed_TE("edit", target(), "script");}
.	{label}			{ed_label("edit", target());}
.	{BDColor}		{ed_BDColor("render");}
.	{BGColor}		{ed_BGColor("render");}
.	{FGColor}		{ed_FGColor("render");}
.	{content}		{ed_content("render");}
.	{menuConfig}		{ed_menuConfig("render");}
.	{geometry}		{ed_geometry("render");}
.	{script}		{ed_script("render");}
}
\BGColor {grey25}
\FGColor {white}
\BDColor {grey}
\font {normal}
\maxWidth {100}
\
\name	{shell.top.title}
\class	{txtLabel}
\parent	{shell.top}
\lock {1}
\label {Viola Interpreter Shell}
\BGColor {grey45}
\FGColor {black}
\BDColor {grey}
\
\name	{shell.top.dismiss}
\class	{txtButton}
\parent	{shell.top}
\lock {1}
\script	{
	switch (arg[0]) {
	case "buttonRelease":
		tweak("shell", "quit();");
	break;
	}
	usual();
}
\maxWidth {100}
\label {Dismiss}
\BGColor {grey25}
\FGColor {white}
\BDColor {grey}
\
\name	{shell.obj}
\class	{txtDisp}
\parent	{shell}
\script	{
	switch (arg[0]) {
	case "show":
		set("content", target());
		if (get("window")) render();
		return;
	break;
	case "init":
		set("content", target());
	break;
	}
	usual();
}
\BGColor {grey25}
\FGColor {white}
\BDColor {grey}
\maxHeight {18}
\
\name	{shell.view}
\class	{hpane}
\parent	{shell}
\lock {1}
\children {shell.view.sb shell.view.tf}
\
\name	{shell.view.sb}
\class	{slider}
\parent	{shell.view}
\lock {1}
\BDColor {grey99}
\BGColor {grey45}
\FGColor {grey70}
\shownNotify {shell.view.tf}
\maxWidth {15}
\
\name	{shell.view.tf}
\parent	{shell.view}
\class	{txtDisp}
\lock {1}
\script	{
	switch (arg[0]) {
	case "keyPress":
		c = key();
		if (c == '\r') {
			print("issue command:", currentLine(), "\n");
			if (isBlank(target())) target("res");
			ret = tweak(target(), currentLine());
			shell.obj("show");
			insert('\r');
			print("ret = ", ret, "\n");
			insert(ret);
			return;
		} else {
			insert(c);
			return;
		}
	break;
	case "saveText":
		saveFile(".shellCmds", get("content"));
		return;
	break;
	case "loadText":
		path = accessible(".shellCmds");
		if (path != "") {
			set("content", loadFile(path));
			render();
		}
		return;
	break;
	case "init":
		path = accessible(".shellCmds");
		if (path != "") {
			set("content", loadFile(path));
		}
		if (isBlank(target())) target("res");
	break;
	}
	usual();
}
\shownDepend {shell.view.sb}
\BGColor {grey40}
\FGColor {grey90}
\BDColor {grey45}
\verbatim {1}
\font {fixed}
\
\name	{shell.mesg}
\class	{txtDisp}
\parent	{shell}
\lock {1}
\script	{
	if (arg[0] == "show") {
		set("content", arg[1]);
		render();
		return;
	}
	usual();
}
\content {Messages}
\font {usual_small}
\maxHeight {30}
\BGColor {grey45}
\FGColor {white}
\BDColor {grey}
\
