\name	{lx}
\class	{vpane}
\parent	{}
\script	{
	/* Hypertext Tutorial, Lurnix version (Adopted from ViolaWWW)
	 *
	 * Author: Pei Y. Wei (wei@xcf.berkeley.edu)
	 */
	switch (arg[0]) {
	case "show":
		lx.view.html("show", arg[1]);
		return;
	break;
	}
	usual();
}
\width {600}
\height {600}
\children {lx.top lx.title lx.view lx.mesg lx.comment lx.udi}
\
\name	{lx.top}
\class	{hpane}
\parent	{lx}
\children {lx.top.home lx.top.back lx.top.mark lx.top.links lx.top.title lx.top.icon lx.top.help}
\maxHeight {32}
\
\name	{lx.top.links}
\class	{menu}
\parent	{lx.top}
\label {Marked Documents}
\script	{
	switch (arg[0]) {
	case "add":
		set("menuConfig", concatenate(get("menuConfig"), "\n", 
			".{", arg[1], "} {lx(\"show\", \"", arg[2], "\");}"));
		return;
	break;
	case "init":
		set("menuConfig", get("content"));
	break;
	}
	usual();
}
\content {
.{Table of Contents}			   {lx("show", "/usr/users/wei/viola/src/lx/toc.html");}
.{Modules}
..{1  Effective Use of Power Utilities}    {lx("show", "/usr/users/wei/viola/src/lx/md1.html");}
..{2  Using Basic UNIX Utilities} 	   {lx("show", "/usr/users/wei/viola/src/lx/md2.html");}
..{3  Command Interpretation}	 	   {lx("show", "/usr/users/wei/viola/src/lx/md3.html");}
..{4  Using Regular Expressions}	   {lx("show", "/usr/users/wei/viola/src/lx/md4.html");}
..{5  Global Searching and Printing}	   {lx("show", "/usr/users/wei/viola/src/lx/md5.html");}
..{6  Database Report writing with "awk"}  {lx("show", "/usr/users/wei/viola/src/lx/md6.html");}
..{7  Stream Editing with "sed"}	   {lx("show", "/usr/users/wei/viola/src/lx/md7.html");}
..{8  Manipulation Columns of Data}	   {lx("show", "/usr/users/wei/viola/src/lx/md8.html");}
..{9  Using Relational Files with "join"}  {lx("show", "/usr/users/wei/viola/src/lx/md9.html");}
..{10 Locating Files with "find"}	   {lx("show", "/usr/users/wei/viola/src/lx/md10.html");}
.{Command Index}			   {lx("show", "/usr/users/wei/viola/src/lx/cmdIndex.html");}
.{Index}				   {lx("show", "/usr/users/wei/viola/src/lx/regIndex.html");}
.{}
.{Help}					   {lx("show", "/usr/users/wei/viola/src/lx/help.html");}
.{About Lurnix HyperTutorial}		   {lx("show", "/usr/users/wei/viola/src/lx/about.html");}
.{Index}				   {lx("show", "/usr/users/wei/viola/src/lx/index.html");}
.{}
}
\maxWidth {180}
\BGColor {grey45}
\FGColor {white}
\BDColor {white}
\
\name	{lx.top.mark}
\class	{XBMButton}
\parent	{lx.top}
\script	{
	switch (arg[0]) {
	case "buttonRelease":
		title = lx.view.html("queryTitle");
		address = lx.view.html("queryAddress");
		lx.top.links("add", title, address);
	break;
	}
	usual();
}
\maxWidth {32}
\label {#define mark_width 32
#define mark_height 32
static char mark_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0xff, 0x1f, 0x00,
   0xe0, 0xff, 0x2f, 0x00, 0xe0, 0xff, 0x6f, 0x00, 0xe0, 0xff, 0xef, 0x00,
   0xe0, 0xff, 0x0f, 0x01, 0xe0, 0xff, 0xff, 0x01, 0xe0, 0xff, 0xff, 0x09,
   0xe0, 0xff, 0xff, 0x19, 0xe0, 0xff, 0xff, 0x39, 0xe0, 0xff, 0x01, 0x7e,
   0xe0, 0xff, 0xff, 0x39, 0xe0, 0xff, 0xff, 0x59, 0xe0, 0xff, 0xff, 0x29,
   0xe0, 0xff, 0xff, 0x11, 0xe0, 0xff, 0xff, 0x09, 0xe0, 0xff, 0xff, 0x01,
   0xe0, 0xff, 0xff, 0x01, 0xe0, 0xff, 0xff, 0x01, 0xe0, 0xff, 0xff, 0x01,
   0xe0, 0xff, 0xff, 0x01, 0xa4, 0x33, 0xb6, 0x01, 0x8c, 0xa1, 0xd5, 0x01,
   0x94, 0xad, 0xe5, 0x01, 0x44, 0x52, 0x38, 0x00, 0x44, 0x52, 0x49, 0x00,
   0x44, 0x52, 0x8a, 0x00, 0x00, 0x00, 0x00, 0x00};
}
\BGColor {grey45}
\FGColor {lightyellow}
\BDColor {grey20}
\
\name	{lx.top.icon}
\class	{XPM}
\parent	{lx.top}
\script	{
	/*
	 * Got any niffty rotating pixmaps? If so, please send them to me!
	 */
	switch (arg[0]) {
	case "rotate": 
		/* Politically correct map-icon of the globe :-)
		 * thou only 2 views exists, for now...
		 */
		xx = get("label");
		set("label", get("content"));
		set("content", xx);
		clearWindow();
		render();
		after(120000, "lx.top.icon", "rotate"); /* 2 minutes */
		return;
	break;
	case "init":
		after(120000, "lx.top.icon", "rotate");
	break;
	case "buttonRelease":
		handle = lx.about("handle");
		lx.view.html("show", handle);
	break;
	}
	usual();
}
\width {31}
\height {31}
\maxWidth {31}
\label {/* XPM */
static char * gb [] = {
/* gb pixmap
 * width height ncolors chars_per_pixel */
"32 32 9 1",
" 	s c0	c grey45",
".	s c23	c white",
"X	s c19	c lightblue",
"o	s c46	c darkgreen",
"O	s c9	c gray",
"+	s c5	c blue",
"@	s c27	c #fbfbfb",
"#	s c29	c gray97",
"$	s c11	c brown",
/* pixels */
"           ...........          ",
"        X..........oo...        ",
"      XOO++.+.@...oo.oo..O      ",
"     XOO++++X..ooo.o.o....O     ",
"    XOO+O++#O..OO..oo.o....O    ",
"   .XO+O+++X...O.OOo.oo.ooo..   ",
"  .XO++OO++X+...OOOOXOOo.oo..O  ",
"  .++++++@++ooo..+.XO.o.oo.o..  ",
" ..+++++@++oooooooooo.oo...oo.O ",
" .+X+++++Xooooooooooo..o...X....",
" o+++++XXooooooooooooo..oo.XX..O",
"oo++++XX.ooooooooooooo+..+...XX+",
"oo++++++.ooooXoooo$oooo.XX++..X+",
"X..+++++X.$$o$.$o$oX$$XoXX++++O+",
"XX...++++X.XXX..Xo$$$$$ooX++++O+",
".....X++.+++..X..$$o$$.oX.++++++",
".oo....++++.++.XoooooooX..++++++",
"oooo.X.X+++++++..oooooo.+.+@+@+O",
"oooXo++..X+++++.Xoooooo.++.+++++",
"ooooX++++XX+++++XooooooX+.+X+++O",
"ooooo++++++++++XooooooXX..X++++O",
"oooo.++++++++++XXooooX.....+++O ",
" ooo.+++++++++++Xoooo....X+++++ ",
" ooo++++++++++++XXoo..+OO++++O  ",
"  oo+++++++++++++.oX.++OX++++O  ",
"  ooO++++++++++++..++XOX+++++O  ",
"   XX+++++++++++++++XO++++++O   ",
"    oo+++++++++++++OO++++++O    ",
"     o+X++++++++O+OO+++X++O     ",
"      +X+OO++.OOXXXX+X+OOO      ",
"        ++..OX...O.....O        ",
"           ..........           "};
}
\content {/* XPM */
static char * gb2 [] = {
/* g30 pixmap
 * width height ncolors chars_per_pixel */
"32 32 7 1",
" 	s c0	c grey45",
".	s c23	c white",
"X	s c5	c blue",
"o	s c27	c #fbfbfb",
"O	s c46	c darkgreen",
"+	s c19	c lightblue",
"@	s c11	c brown",
/* pixels */
"          .Xo.XooOo...          ",
"        .OOoOOOOooOO..o.        ",
"      O.O+OOOOOOOO+oooO...      ",
"     ..XXXX+.OOOOooOOoo.+X.     ",
"    ..ooXXXX.oooOOOOOOOO.o..    ",
"   .XXXXXoXXOOoOOOOOOOO.XXX.+   ",
"  .XXXoXXXXXOOooOOOOOOXXXX.XX   ",
"  .XXXoXXXXXXOOOooO@OOOXX+XXX.  ",
" ..XXXXXXXXXXXOOOo@@O...XXXXXX. ",
" .oXXXXXXXXXXX.O.OOXX+OO+XXXXXX ",
"X.oXXXXXXXXXXXXXOO+O.OO.OXXXXX..",
".X+XXXXXXXXXXXXXX+OOO+X..X.XXXX.",
".XXXXXXXXXXXXXXXXXXXO+.X.O.XXXXX",
".XXXXXXXXXXXXXXXXXXXX+OOOOO+XXX.",
".XXXXXXXXXXXXXXXXXXXX+X++OOOOOXX",
".XXXXXXXXXXXXXXXXXX+XX+OOOOOOoX.",
".X+XXXXXXXXXXXXXXXX.+XOOOOOOOoo.",
"O.XXXXXXXXXXXXXXXXXXXX.OOOOOOooO",
". .++XXXXXXXXXXXXXXXXO.OOOoOOOOO",
"...XXXXXXXXXXXXXXXXXXXX+OOOOOOO.",
".+XXX..+XXXXXXXXXXXXXXXXOOOOOOX.",
"X..X.XXXXXXXXXXXXXXXXXXXXOOOOOO.",
" .XXXX+XXoXXXXXXXXXXXXX+OOOOO.X ",
" ..XXXX+XXXXXXXXXXXXXX+XOoOOO.. ",
"  .XXXXXXXXXXXXXXXXXXX.OoOOOX.  ",
"  .XXXXXXXXXXXXXXXXXXX+OOOX+X   ",
"   OOXXXXXXXoXXXXoXXXX+OO.X..   ",
"    OOXXXXXXXXXXXXXXX.O.XX..    ",
"     .OXXXXXXXXXXXXXXOOO..      ",
"      .XXXXXooXXXXXO+...        ",
"        .ooXXooooooXoX.         ",
"          ..ooooooo...          "};
}
\BDColor {grey20}
\
\name	{lx.top.title}
\class	{txtLabel}
\parent	{lx.top}
\label {The Thing}
\BGColor {grey45}
\FGColor {black}
\BDColor {grey20}
\font {bold_largest}
\
\name	{lx.top.back}
\class	{XBMButton}
\parent	{lx.top}
\script	{
	switch (arg[0]) {
	case "buttonRelease":
		lx.view.html("back");
	break;
	}
	usual();
}
\maxWidth {32}
\label {#define back_width 32
#define back_height 32
static char back_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0xff, 0x3f, 0x00,
   0xe0, 0xff, 0x5f, 0x00, 0xe0, 0xff, 0xdf, 0x00, 0xe0, 0xff, 0xdf, 0x01,
   0xe0, 0xff, 0xdf, 0x03, 0xe0, 0xff, 0x1f, 0x04, 0xe0, 0xbf, 0xff, 0x07,
   0xe0, 0x1f, 0xff, 0x07, 0xe0, 0x0f, 0xfe, 0x07, 0xe0, 0x07, 0xfc, 0x07,
   0xe0, 0x03, 0xf8, 0x07, 0xe0, 0x01, 0xf0, 0x07, 0xe0, 0x01, 0xf0, 0x07,
   0xe0, 0x01, 0xf0, 0x07, 0xe0, 0xff, 0xff, 0x07, 0xe0, 0xff, 0xff, 0x07,
   0xe0, 0xff, 0xff, 0x07, 0xe0, 0xff, 0xff, 0x07, 0xe0, 0xff, 0xff, 0x07,
   0xe0, 0xff, 0xff, 0x07, 0xe0, 0xff, 0xff, 0x07, 0xe0, 0xff, 0xff, 0x07,
   0xe0, 0xff, 0xff, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
}
\BGColor {grey45}
\FGColor {lightyellow}
\BDColor {grey20}
\
\name	{lx.top.home}
\class	{XPMButton}
\parent	{lx.top}
\script	{
	switch (arg[0]) {
	case "buttonRelease":
		lx("show", "/usr/users/wei/viola/src/lx/home.html");
	break;
	}
	usual();
}
\maxWidth {32}
\label {/* XPM */
static char * home [] = {
/* gb pixmap
 * width height ncolors chars_per_pixel */
"32 32 9 1",
" 	s c0	c grey45",
".	s c46	c red",
"X	s c46	c brown",
"o	s c46	c gray",
"O	s c23	c white",
"+	c black",
"@	c cyan",
"#	c yellow",
"$	c green",
/* pixels */
"                                ",
"                                ",
"                                ",
"             .....X oooo        ",
"           .X..X....oOOo        ",
"          ..+X+..X..oooo        ",
"         .X+XXX+....ooOO        ",
"        ..+XXXXX+...oooo        ",
"       ..+XX+++XX+.XOOOo.       ",
"      .X+XX++@++XX+..ooo..      ",
"     ..+XX+@+@+@+XX+..oo...     ",
"    ..+XXX+@+@+@+XXX+.X..X..    ",
"   X.+XXXX+@+@+@+XXXX+..X....   ",
"  ..+XXXXX+++++++XXXXX+....X.   ",
"  .XXXXXXXXXXXXXXXXXXXX+......  ",
"   +XXXXXXXXXXXXXXXXXXXX+++++   ",
"   +XXXXXXXXXXXXXXXXXXX+XXXX+   ",
"   +XXX@@XX++++XXX@@XXXXXXXX+   ",
"   +X+@@@@X+###X+@@@@XX+XXXX+   ",
"   +X+@@@@X+###X+@@@@XXXXXXX+   ",
"   +X+@@@@X+###X+@@@@XX+XXXX+   ",
"   +X+@@@@X+###X+@@@@XXXXXXX+   ",
"   +X+@@@@X+#O#X+@@@@XX+XXXX+   ",
"   +X+++++X+###X+++++XXXXXXX+   ",
"   +XXXXXXX+###XXXXXXXX+XXXX+   ",
"   +XXXXXXX+###XXXXXXXXXXXXX+$  ",
" $$+XXXXXXX+###XXXXXXXX+XXXX+$$ ",
" $$$$$$$$$$$$$$$$$$$$$$$$$$$$$  ",
"  $$$$$$$$$$$$$$$$$ $$$$$$$$$   ",
"     $$  $$$ $$$$$$$$$$$$$      ",
"  $   $           $ $ $$        ",
"                                "};
}
\BGColor {grey45}
\BDColor {grey20}
\
\name	{lx.top.help}
\class	{XBMButton}
\parent	{lx.top}
\script	{
	switch (arg[0]) {
	case "buttonRelease":
		lx("show", "/usr/users/wei/viola/src/lx/help.html");
	break;
	}
	usual();
}
\maxWidth {32}
\label {#define help_width 32
#define help_height 32
static char help_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0xfc, 0x03, 0x00, 0x00, 0xff, 0x0f, 0x00, 0x80, 0xff, 0x1f, 0x00,
   0xc0, 0x0f, 0x3e, 0x00, 0xc0, 0x03, 0x38, 0x00, 0xe0, 0x03, 0x78, 0x00,
   0xe0, 0x07, 0x78, 0x00, 0xe0, 0x07, 0x78, 0x00, 0xc0, 0x07, 0x3c, 0x00,
   0x80, 0x03, 0x3c, 0x00, 0x00, 0x00, 0x3e, 0x00, 0x00, 0x00, 0x1f, 0x00,
   0x00, 0x80, 0x0f, 0x00, 0x00, 0xc0, 0x03, 0x00, 0x00, 0xc0, 0x01, 0x00,
   0x00, 0xe0, 0x00, 0x00, 0x00, 0xe0, 0x01, 0x00, 0x00, 0xe0, 0x01, 0x00,
   0x00, 0xe0, 0x01, 0x00, 0x00, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0xe0, 0x01, 0x00, 0x00, 0xf0, 0x03, 0x00, 0x00, 0xf0, 0x03, 0x00,
   0x00, 0xf0, 0x03, 0x00, 0x00, 0xe0, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
}
\BGColor {grey45}
\FGColor {lightyellow}
\BDColor {grey20}
\
\name	{lx.title}
\class	{txtLabel}
\parent	{lx}
\script	{
	switch (arg[0]) {
	case "show":
		if (arg[1] == "") {
			set("label", "<No Title>");
		} else {
			set("label", arg[1]);
		}
		render();
		return;
	break;
	}
	usual();
}
\label {Welcome}
\maxHeight {22}
\BGColor {grey45}
\FGColor {white}
\font {bold_large}
\
\name	{lx.view}
\class	{hpane}
\parent	{lx}
\children {lx.view.sb lx.view.html}
\
\name	{lx.view.sb}
\class	{vpane}
\parent	{lx.view}
\maxWidth {20}
\children {lx.view.sb.up lx.view.sb.down lx.view.sb.slider}
\
\name	{lx.view.sb.up}
\class	{XBMButton}
\parent	{lx.view.sb}
\script	{
	switch (arg[0]) {
	case "buttonRelease":
		lx.view.sb.slider("scroll", "up");
	break;
	}
	usual();
}
\BGColor {grey40}
\FGColor {grey99}
\BDColor {grey75}
\label {#define upButton20_width 20
#define upButton20_height 20
static char upButton20_bits[] = {
   0x00, 0x00, 0x00, 0xfe, 0xff, 0x07, 0xfe, 0xff, 0x03, 0x56, 0x55, 0x05,
   0xae, 0xae, 0x00, 0x56, 0x59, 0x05, 0xae, 0xb0, 0x00, 0x56, 0x60, 0x05,
   0x2e, 0xc0, 0x00, 0x16, 0x80, 0x05, 0xae, 0xb0, 0x00, 0x56, 0x51, 0x05,
   0xae, 0xb0, 0x00, 0x56, 0x51, 0x05, 0xae, 0xb0, 0x00, 0x56, 0x55, 0x05,
   0xae, 0xaa, 0x00, 0x06, 0x00, 0x04, 0xaa, 0xaa, 0x02, 0x00, 0x00, 0x00};
}
\maxHeight {19}
\
\name	{lx.view.sb.down}
\class	{XBMButton}
\parent	{lx.view.sb}
\script	{
	switch (arg[0]) {
	case "buttonRelease":
		lx.view.sb.slider("scroll", "down");
	break;
	}
	usual();
}
\BGColor {grey40}
\FGColor {grey99}
\BDColor {grey75}
\label {#define fff_width 20
#define fff_height 20
static char fff_bits[] = {
   0x00, 0x00, 0x00, 0xfe, 0xff, 0x03, 0xfe, 0xff, 0x05, 0xae, 0xaa, 0x00,
   0x56, 0x55, 0x05, 0xae, 0xb0, 0x00, 0x56, 0x51, 0x05, 0xae, 0xb0, 0x00,
   0x56, 0x51, 0x05, 0xae, 0xb0, 0x00, 0x16, 0x80, 0x05, 0x2e, 0xc0, 0x00,
   0x56, 0x60, 0x05, 0xae, 0xb0, 0x00, 0x56, 0x59, 0x05, 0xae, 0xae, 0x00,
   0x56, 0x55, 0x05, 0x06, 0x00, 0x00, 0xaa, 0xaa, 0x02, 0x00, 0x00, 0x00};
}
\maxHeight {19}
\
\name	{lx.view.sb.slider}
\class	{slider}
\parent	{lx.view.sb}
\BDColor {grey99}
\BGColor {grey45}
\FGColor {grey70}
\shownNotify {lx.view.html}
\
\name	{lx.view.html}
\parent	{lx.view}
\class	{HTML}
\script	{
	switch (arg[0]) {
	case "buttonRelease":
		if (tag = nextTag()) {
		} else tag = previousTag();
		if (tag) {
			print("tag={", tag, "}\n");
			if (nthChar(tag, 1) == '*') {
				if (nthChar(tag, 0) == '*') {
					print("comments:\n");
					ln0 = nthLine(tag, 0, 0);
					obj = nthChar(ln0, 2, 999);
					print("ln0>>>", ln0, "<<<\n");
					print("obj>>>", obj, "<<<\n");
					txt = nthLine(tag, 1, 999);
					print("txt>>>", txt, "<<<\n");
					send(obj, "show_HTML", txt);
				} else {
					print("script:\n");
					interpret(tag);
				}
			} else {
				lx.view.html("show", tag);
			}
		} else {
			lx.mesg.tf("offerUsageHelp");
		}
	break;
	case "home":
		lx.view.html("show", homeDoc);
		return;
	break;
	case "show":
		lx.mesg.tf("show", concatenate("Getting ", arg[1], " ..."));
		cursorShape("busy");

		if (set("HTMLAddress", arg[1]) == "") {
			lx.mesg.tf("show", 
				    concatenate("Failed to get ", arg[1]));
			cursorShape("idle");
			return 0;
		} else {
			lx.title("show", get("HTMLTitle"));
			render();
			lx.view.sb.slider("shownPositionV", 
					float(lineRowOffset()) / 
					float(totalLineCount() - 
					numberOfLinesDisplayed()) * 100.0);

			lx.mesg.tf("show", "");
			lx.udi.tf("show", arg[1]);

			previousDoc = currentDoc;
			currentDoc = get("HTMLAddress");
			cursorShape("idle");
			return 1;
		}
	break;
	case "back":
		if (previousDoc != "") {
			lx.view.html("show", previousDoc);
		} else {
			lx.mesg.tf("flash", 
				"No Previous document to go back to.");
		}
		return;
	break;
	case "queryAddress":
		return get("HTMLAddress");
	break;
	case "queryTitle":
		return get("HTMLTitle");
	break;
	case "init":
		initialize();
		homeDoc = environVar("WWW_HOME");
		if (homeDoc == "") 
		    homeDoc = accessible("/usr/local/lib/WWW/default.html");
		if (homeDoc == "") print("ViolaLX: No page for home.\n");

		homeDoc = "/usr/users/wei/viola/src/lx/md6d.html";

		set("HTMLAddress", homeDoc);
		return;
	break;
	case "enter":
		set("cursor", 0);
		return;
	break;
	}
	usual();
}
\shownDepend {lx.view.sb.slider}
\BGColor {lightyellow}
\FGColor {black}
\font {usual_medium}
\
\name	{lx.comment}
\class	{hpane}
\parent	{lx}
\children {lx.comment.sb lx.comment.tf}
\maxHeight {150}
\
\name	{lx.comment.sb}
\class	{vpane}
\parent	{lx.comment}
\maxWidth {20}
\children {lx.comment.sb.up lx.comment.sb.down lx.comment.sb.slider}
\
\name	{lx.comment.sb.up}
\class	{XBMButton}
\parent	{lx.comment.sb}
\script	{
	switch (arg[0]) {
	case "buttonRelease":
		lx.comment.sb.slider("scroll", "up");
	break;
	}
	usual();
}
\BGColor {grey40}
\FGColor {grey99}
\BDColor {grey75}
\label {#define upButton20_width 20
#define upButton20_height 20
static char upButton20_bits[] = {
   0x00, 0x00, 0x00, 0xfe, 0xff, 0x07, 0xfe, 0xff, 0x03, 0x56, 0x55, 0x05,
   0xae, 0xae, 0x00, 0x56, 0x59, 0x05, 0xae, 0xb0, 0x00, 0x56, 0x60, 0x05,
   0x2e, 0xc0, 0x00, 0x16, 0x80, 0x05, 0xae, 0xb0, 0x00, 0x56, 0x51, 0x05,
   0xae, 0xb0, 0x00, 0x56, 0x51, 0x05, 0xae, 0xb0, 0x00, 0x56, 0x55, 0x05,
   0xae, 0xaa, 0x00, 0x06, 0x00, 0x04, 0xaa, 0xaa, 0x02, 0x00, 0x00, 0x00};
}
\maxHeight {19}
\
\name	{lx.comment.sb.down}
\class	{XBMButton}
\parent	{lx.comment.sb}
\script	{
	switch (arg[0]) {
	case "buttonRelease":
		lx.comment.sb.slider("scroll", "down");
	break;
	}
	usual();
}
\BGColor {grey40}
\FGColor {grey99}
\BDColor {grey75}
\label {#define fff_width 20
#define fff_height 20
static char fff_bits[] = {
   0x00, 0x00, 0x00, 0xfe, 0xff, 0x03, 0xfe, 0xff, 0x05, 0xae, 0xaa, 0x00,
   0x56, 0x55, 0x05, 0xae, 0xb0, 0x00, 0x56, 0x51, 0x05, 0xae, 0xb0, 0x00,
   0x56, 0x51, 0x05, 0xae, 0xb0, 0x00, 0x16, 0x80, 0x05, 0x2e, 0xc0, 0x00,
   0x56, 0x60, 0x05, 0xae, 0xb0, 0x00, 0x56, 0x59, 0x05, 0xae, 0xae, 0x00,
   0x56, 0x55, 0x05, 0x06, 0x00, 0x00, 0xaa, 0xaa, 0x02, 0x00, 0x00, 0x00};
}
\maxHeight {19}
\
\name	{lx.comment.sb.slider}
\class	{slider}
\parent	{lx.comment.sb}
\BDColor {grey99}
\BGColor {grey45}
\FGColor {grey70}
\shownNotify {lx.comment.html}
\
\name	{lx.comment.tf}
\parent	{lx.comment}
\class	{HTML}
\script	{
	switch (arg[0]) {
	case "buttonRelease":
		if (tag = nextTag()) {
		} else tag = previousTag();
		if (tag) {
			if (nthChar(tag, 1) == '*') {
				print("script:\n");
				interpret(tag);
			} else {
				lx.comment.html("show", tag);
			}
		} else {
			lx.mesg.tf("offerUsageHelp");
		}
	break;
	case "show":
	case "show_HTML":
		print("HTML>>>", arg[1], "<<<\n");
		saveFile("/tmp/foo.html", arg[1]);
		set("HTMLAddress", "/tmp/foo.html");
	break;
	case "show_literal":
		print("Literal>>>", arg[1], "<<<\n");
		set("content", arg[1]);
		render();
		return;
	break;
	case "show_HTML_withHandle":
	break;
	}
	usual();
}
\shownDepend {lx.comment.sb.slider}
\maxHeight {100}
\BGColor {lightyellow}
\FGColor {black}
\font {usual_medium}
\
\name {lx.mesg}
\class {hpane}
\parent	{lx}
\maxHeight {40}
\children {lx.mesg.label lx.mesg.tf}
\
\name {lx.mesg.label}
\class {txtLabel}
\parent	{lx.mesg}
\label {Message:}
\maxWidth {80}
\BGColor {grey45}
\FGColor {white}
\BDColor {grey20}
\
\name {lx.mesg.tf}
\class {txtDisp}
\parent {lx.mesg}
\script	{
	switch (arg[0]) {
	case "show":
		set("content", arg[1]);
		if (get("window")) {
			set("FGColor", "100 90 70");
			render();
		}
		return;
	break;
	case "offerUsageHelp":
/*		bell();*/
		lx.mesg.tf("flash", 
			 "Only \\b( buttons ) may respond to clicks.");
		return;
	break;
	case "flash":
		set("content", " ");
		set("BGColor", "red");
		if (get("render")) {
			render();
			set("FGColor", "100 90 70");
			set("BGColor", "grey45");
			set("content", arg[1]);
			render();
			after(1000, "lx.mesg.tf", "fade1");
		}
		return;
	break;
	case "fade1":
		set("FGColor", "90 80 60");
		render();
		after(500, "lx.mesg.tf", "fade2");
		return;
	break;
	case "fade2":
		set("FGColor", "80 70 50");
		render();
		after(250, "lx.mesg.tf", "clear");
		return;
	break;
	case "clear":
		set("content", "");
		render();
		return;
	break;
	case "init":
		after(60000, "lx.mesg.tf", "clear");
	break;
	}
	usual();
}
\content {Click on a \b( button ) to follow link.}
\font {fixed}
\BGColor {grey45}
\FGColor {100 80 60}
\BDColor {grey20}
\
\name {lx.udi}
\class {hpane}
\parent	{lx}
\maxHeight {18}
\children {lx.udi.label lx.udi.tf}
\
\name {lx.udi.label}
\class {txtButton}
\parent	{lx.udi}
\label {UDI:}
\script {
	switch (arg[0]) {
	case "buttonRelease":
		lx.udi.tf("getUDIFromClipBuffer");
		return;
	break;
	}
	usual();
}
\BGColor {grey45}
\FGColor {white}
\BDColor {white}
\maxWidth {80}
\
\name {lx.udi.tf}
\class {txtDisp}
\parent {lx.udi}
\script	{
	switch (arg[0]) {
	case "getUDIFromClipBuffer":
		lx("show", getClipBuffer());
	break;
	case "show":
		set("content", arg[1]);
		render();
		return;
	break;
	}
	usual();
}
\font {fixed}
\BGColor {grey45}
\FGColor {white}
\BDColor {grey20}
\
