\name	{lurnix}
\class	{vpane}
\parent	{}
\script	{
	/* Hypertext Tutorial, Lurnix version (Adopted from ViolaWWW)
	 *
	 * Author: Pei Y. Wei (wei@xcf.berkeley.edu)
	 */
	switch (arg[0]) {
	case "show":
		if (lurnix.view.html("show", arg[1]))
			lurnix.view.html("historyRecord");
		return;
	break;
	case "search":
		lurnix.view.html("search", arg[1]);
		return;
	break;
	case "showButNoRecord":
		lurnix.view.html("show", arg[1]);
		return;
	break;
	case "about":
		lurnix.view.html("about");
		return;
	break;
	case "help":
		lurnix.view.html("help");
		return;
	break;
	case "home":
		lurnix.view.html("home");
		return;
	break;
	}
	usual();
}
\width {600}
\height {600}
\children {lurnix.top lurnix.title lurnix.view lurnix.idx lurnix.mesg lurnix.udi}
\
\name	{lurnix.top}
\class	{hpane}
\parent	{lurnix}
\BGColor {grey45}
\FGColor {white}
\children {lurnix.top.home lurnix.top.prev lurnix.top.back lurnix.top.next lurnix.top.mark lurnix.top.links lurnix.top.title lurnix.top.icon lurnix.top.help}
\maxHeight {32}
\
\name	{lurnix.top.links}
\class	{menu}
\parent	{lurnix.top}
\label {Marked Documents}
\script	{
	switch (arg[0]) {
	case "add":
		set("menuConfig", concatenate(get("menuConfig"), "\n", 
			".{", arg[1], "} {lurnix(\"show\", \"", arg[2], "\");}"));
		return;
	break;
	case "init":
		path = accessible("~/.LURNIXBookMarks");
		if (path != "") {
			set("menuConfig", loadFile(path));
		} else {
			set("menuConfig", get("content"));
		}
	break;
	}
	usual();
}
\content {
.{Table of Contents}			   {lurnix("show", "toc.html");}
.{Modules}
..{1  Effective Use of Power Utilities}    {lurnix("show", "module1.html");}
..{2  Using Basic UNIX Utilities} 	   {lurnix("show", "module2.html");}
..{3  Command Interpretation}	 	   {lurnix("show", "module3.html");}
..{4  Using Regular Expressions}	   {lurnix("show", "module4.html");}
..{5  Global Searching and Printing}	   {lurnix("show", "module5.html");}
..{6  Database Report writing with "awk"}  {lurnix("show", "module6.html");}
..{7  Stream Editing with "sed"}	   {lurnix("show", "module7.html");}
..{8  Manipulation Columns of Data}	   {lurnix("show", "module8.html");}
..{9  Using Relational Files with "join"}  {lurnix("show", "module9.html");}
..{10 Locating Files with "find"}	   {lurnix("show", "module10.html");}
.{Command Index}			   {lurnix("show", "cmdIndex.html");}
.{Index}				   {lurnix("show", "regIndex.html");}
.{}
.{Help}					   {lurnix("help");}
.{About Lurnix HyperTutorial}		   {lurnix("about");}
}
\maxWidth {180}
\BGColor {grey45}
\FGColor {white}
\BDColor {white}
\
\name	{lurnix.top.mark}
\class	{XBMButton}
\parent	{lurnix.top}
\script	{
	switch (arg[0]) {
	case "buttonRelease":
		title = lurnix.view.html("queryTitle");
		address = lurnix.view.html("queryAddress");
		lurnix.top.links("add", title, address);
	break;
	}
	usual();
}
\maxWidth {32}
\label {#define mark_width 32
#define mark_height 32
static char mark_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0xff, 0x1f, 0x00,
   0xe0, 0xff, 0x2f, 0x00, 0xe0, 0xff, 0x6f, 0x00, 0xe0, 0xff, 0xef, 0x00,
   0xe0, 0xff, 0x0f, 0x01, 0xe0, 0xff, 0xff, 0x01, 0xe0, 0xff, 0xff, 0x09,
   0xe0, 0xff, 0xff, 0x19, 0xe0, 0xff, 0xff, 0x39, 0xe0, 0xff, 0x01, 0x7e,
   0xe0, 0xff, 0xff, 0x39, 0xe0, 0xff, 0xff, 0x59, 0xe0, 0xff, 0xff, 0x29,
   0xe0, 0xff, 0xff, 0x11, 0xe0, 0xff, 0xff, 0x09, 0xe0, 0xff, 0xff, 0x01,
   0xe0, 0xff, 0xff, 0x01, 0xe0, 0xff, 0xff, 0x01, 0xe0, 0xff, 0xff, 0x01,
   0xe0, 0xff, 0xff, 0x01, 0xa4, 0x33, 0xb6, 0x01, 0x8c, 0xa1, 0xd5, 0x01,
   0x94, 0xad, 0xe5, 0x01, 0x44, 0x52, 0x38, 0x00, 0x44, 0x52, 0x49, 0x00,
   0x44, 0x52, 0x8a, 0x00, 0x00, 0x00, 0x00, 0x00};
}
\BGColor {grey45}
\FGColor {lightyellow}
\BDColor {grey20}
\
\name	{lurnix.top.icon}
\class	{XPM}
\parent	{lurnix.top}
\script	{
	/*
	 * Got any niffty rotating pixmaps? If so, please send them to me!
	 */
	switch (arg[0]) {
	case "rotate": 
		/* Politically correct map-icon of the globe :-)
		 * thou only 2 views exists, for now...
		 */
		xx = get("label");
		set("label", get("content"));
		set("content", xx);
		clearWindow();
		render();
		after(120000, "lurnix.top.icon", "rotate"); /* 2 minutes */
		return;
	break;
	case "init":
		after(120000, "lurnix.top.icon", "rotate");
	break;
	case "buttonRelease":
		handle = lurnix.about("handle");
		lurnix.view.html("show", handle);
	break;
	}
	usual();
}
\width {31}
\height {31}
\maxWidth {31}
\label {/* XPM */
static char * gb [] = {
/* gb pixmap
 * width height ncolors chars_per_pixel */
"32 32 9 1",
" 	s c0	c grey45",
".	s c23	c white",
"X	s c19	c lightblue",
"o	s c46	c darkgreen",
"O	s c9	c gray",
"+	s c5	c blue",
"@	s c27	c #fbfbfb",
"#	s c29	c gray97",
"$	s c11	c brown",
/* pixels */
"           ...........          ",
"        X..........oo...        ",
"      XOO++.+.@...oo.oo..O      ",
"     XOO++++X..ooo.o.o....O     ",
"    XOO+O++#O..OO..oo.o....O    ",
"   .XO+O+++X...O.OOo.oo.ooo..   ",
"  .XO++OO++X+...OOOOXOOo.oo..O  ",
"  .++++++@++ooo..+.XO.o.oo.o..  ",
" ..+++++@++oooooooooo.oo...oo.O ",
" .+X+++++Xooooooooooo..o...X....",
" o+++++XXooooooooooooo..oo.XX..O",
"oo++++XX.ooooooooooooo+..+...XX+",
"oo++++++.ooooXoooo$oooo.XX++..X+",
"X..+++++X.$$o$.$o$oX$$XoXX++++O+",
"XX...++++X.XXX..Xo$$$$$ooX++++O+",
".....X++.+++..X..$$o$$.oX.++++++",
".oo....++++.++.XoooooooX..++++++",
"oooo.X.X+++++++..oooooo.+.+@+@+O",
"oooXo++..X+++++.Xoooooo.++.+++++",
"ooooX++++XX+++++XooooooX+.+X+++O",
"ooooo++++++++++XooooooXX..X++++O",
"oooo.++++++++++XXooooX.....+++O ",
" ooo.+++++++++++Xoooo....X+++++ ",
" ooo++++++++++++XXoo..+OO++++O  ",
"  oo+++++++++++++.oX.++OX++++O  ",
"  ooO++++++++++++..++XOX+++++O  ",
"   XX+++++++++++++++XO++++++O   ",
"    oo+++++++++++++OO++++++O    ",
"     o+X++++++++O+OO+++X++O     ",
"      +X+OO++.OOXXXX+X+OOO      ",
"        ++..OX...O.....O        ",
"           ..........           "};
}
\content {/* XPM */
static char * gb2 [] = {
/* g30 pixmap
 * width height ncolors chars_per_pixel */
"32 32 7 1",
" 	s c0	c grey45",
".	s c23	c white",
"X	s c5	c blue",
"o	s c27	c #fbfbfb",
"O	s c46	c darkgreen",
"+	s c19	c lightblue",
"@	s c11	c brown",
/* pixels */
"          .Xo.XooOo...          ",
"        .OOoOOOOooOO..o.        ",
"      O.O+OOOOOOOO+oooO...      ",
"     ..XXXX+.OOOOooOOoo.+X.     ",
"    ..ooXXXX.oooOOOOOOOO.o..    ",
"   .XXXXXoXXOOoOOOOOOOO.XXX.+   ",
"  .XXXoXXXXXOOooOOOOOOXXXX.XX   ",
"  .XXXoXXXXXXOOOooO@OOOXX+XXX.  ",
" ..XXXXXXXXXXXOOOo@@O...XXXXXX. ",
" .oXXXXXXXXXXX.O.OOXX+OO+XXXXXX ",
"X.oXXXXXXXXXXXXXOO+O.OO.OXXXXX..",
".X+XXXXXXXXXXXXXX+OOO+X..X.XXXX.",
".XXXXXXXXXXXXXXXXXXXO+.X.O.XXXXX",
".XXXXXXXXXXXXXXXXXXXX+OOOOO+XXX.",
".XXXXXXXXXXXXXXXXXXXX+X++OOOOOXX",
".XXXXXXXXXXXXXXXXXX+XX+OOOOOOoX.",
".X+XXXXXXXXXXXXXXXX.+XOOOOOOOoo.",
"O.XXXXXXXXXXXXXXXXXXXX.OOOOOOooO",
". .++XXXXXXXXXXXXXXXXO.OOOoOOOOO",
"...XXXXXXXXXXXXXXXXXXXX+OOOOOOO.",
".+XXX..+XXXXXXXXXXXXXXXXOOOOOOX.",
"X..X.XXXXXXXXXXXXXXXXXXXXOOOOOO.",
" .XXXX+XXoXXXXXXXXXXXXX+OOOOO.X ",
" ..XXXX+XXXXXXXXXXXXXX+XOoOOO.. ",
"  .XXXXXXXXXXXXXXXXXXX.OoOOOX.  ",
"  .XXXXXXXXXXXXXXXXXXX+OOOX+X   ",
"   OOXXXXXXXoXXXXoXXXX+OO.X..   ",
"    OOXXXXXXXXXXXXXXX.O.XX..    ",
"     .OXXXXXXXXXXXXXXOOO..      ",
"      .XXXXXooXXXXXO+...        ",
"        .ooXXooooooXoX.         ",
"          ..ooooooo...          "};
}
\BDColor {grey20}
\
\name	{lurnix.top.title}
\class	{txtLabel}
\parent	{lurnix.top}
\label {Lurnix}
\BGColor {grey45}
\FGColor {black}
\BDColor {grey20}
\font {bold_largest}
\
\name	{lurnix.top.prev}
\class	{XBMButton}
\parent	{lurnix.top}
\script	{
	switch (arg[0]) {
	case "buttonRelease":
		lurnix.view.html("prev");
	break;
	}
	usual();
}
\maxWidth {32}
\label {#define prev_width 32
#define prev_height 32
static char prev_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0xff, 0x3f, 0x00,
   0xe0, 0xff, 0x5f, 0x00, 0xe0, 0xff, 0xdf, 0x00, 0xe0, 0xff, 0xdf, 0x01,
   0xe0, 0xff, 0xdf, 0x03, 0xe0, 0xff, 0x1f, 0x04, 0xe0, 0x7f, 0xfc, 0x07,
   0xe0, 0x3f, 0xfc, 0x07, 0xe0, 0x1f, 0xfc, 0x07, 0xe0, 0x0f, 0xfc, 0x07,
   0xe0, 0x07, 0xfc, 0x07, 0xe0, 0x03, 0xfc, 0x07, 0xe0, 0x07, 0xfc, 0x07,
   0xe0, 0x0f, 0xfc, 0x07, 0xe0, 0x1f, 0xfc, 0x07, 0xe0, 0x3f, 0xfc, 0x07,
   0xe0, 0x7f, 0xfc, 0x07, 0xe0, 0xff, 0xff, 0x07, 0xe0, 0xff, 0xff, 0x07,
   0xe0, 0xff, 0xff, 0x07, 0xe0, 0xff, 0xff, 0x07, 0xe0, 0xff, 0xff, 0x07,
   0xe0, 0xff, 0xff, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
}
\BGColor {grey45}
\FGColor {lightyellow}
\BDColor {grey20}
\
\name	{lurnix.top.back}
\class	{XBMButton}
\parent	{lurnix.top}
\script	{
	switch (arg[0]) {
	case "buttonRelease":
		lurnix.view.html("back");
	break;
	}
	usual();
}
\maxWidth {32}
\label {#define back_width 32
#define back_height 32
static char back_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0xff, 0x3f, 0x00,
   0xe0, 0xff, 0x5f, 0x00, 0xe0, 0xff, 0xdf, 0x00, 0xe0, 0xff, 0xdf, 0x01,
   0xe0, 0xff, 0xdf, 0x03, 0xe0, 0xff, 0x1f, 0x04, 0xe0, 0xbf, 0xff, 0x07,
   0xe0, 0x1f, 0xff, 0x07, 0xe0, 0x0f, 0xfe, 0x07, 0xe0, 0x07, 0xfc, 0x07,
   0xe0, 0x03, 0xf8, 0x07, 0xe0, 0x01, 0xf0, 0x07, 0xe0, 0x01, 0xf0, 0x07,
   0xe0, 0x01, 0xf0, 0x07, 0xe0, 0xff, 0xff, 0x07, 0xe0, 0xff, 0xff, 0x07,
   0xe0, 0xff, 0xff, 0x07, 0xe0, 0xff, 0xff, 0x07, 0xe0, 0xff, 0xff, 0x07,
   0xe0, 0xff, 0xff, 0x07, 0xe0, 0xff, 0xff, 0x07, 0xe0, 0xff, 0xff, 0x07,
   0xe0, 0xff, 0xff, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
}
\BGColor {grey45}
\FGColor {lightyellow}
\BDColor {grey20}
\
\name	{lurnix.top.next}
\class	{XBMButton}
\parent	{lurnix.top}
\script	{
	switch (arg[0]) {
	case "buttonRelease":
		lurnix.view.html("next");
	break;
	}
	usual();
}
\maxWidth {32}
\label {#define next_width 32
#define next_height 32
static char next_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0xff, 0x3f, 0x00,
   0xe0, 0xff, 0x5f, 0x00, 0xe0, 0xff, 0xdf, 0x00, 0xe0, 0xff, 0xdf, 0x01,
   0xe0, 0xff, 0xdf, 0x03, 0xe0, 0xff, 0x1f, 0x04, 0xe0, 0x8f, 0xff, 0x07,
   0xe0, 0x0f, 0xff, 0x07, 0xe0, 0x0f, 0xfe, 0x07, 0xe0, 0x0f, 0xfc, 0x07,
   0xe0, 0x0f, 0xf8, 0x07, 0xe0, 0x0f, 0xf0, 0x07, 0xe0, 0x0f, 0xf8, 0x07,
   0xe0, 0x0f, 0xfc, 0x07, 0xe0, 0x0f, 0xfe, 0x07, 0xe0, 0x0f, 0xff, 0x07,
   0xe0, 0x8f, 0xff, 0x07, 0xe0, 0xff, 0xff, 0x07, 0xe0, 0xff, 0xff, 0x07,
   0xe0, 0xff, 0xff, 0x07, 0xe0, 0xff, 0xff, 0x07, 0xe0, 0xff, 0xff, 0x07,
   0xe0, 0xff, 0xff, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
}
\BGColor {grey45}
\FGColor {lightyellow}
\BDColor {grey20}
\
\name	{lurnix.top.home}
\class	{XPMButton}
\parent	{lurnix.top}
\script	{
	switch (arg[0]) {
	case "buttonRelease":
		lurnix.view.html("home");
	break;
	}
	usual();
}
\maxWidth {32}
\label {/* XPM */
static char * home [] = {
/* gb pixmap
 * width height ncolors chars_per_pixel */
"32 32 9 1",
" 	s c0	c grey45",
".	s c46	c red",
"X	s c46	c brown",
"o	s c46	c gray",
"O	s c23	c white",
"+	c black",
"@	c cyan",
"#	c yellow",
"$	c green",
/* pixels */
"                                ",
"                                ",
"                                ",
"             .....X oooo        ",
"           .X..X....oOOo        ",
"          ..+X+..X..oooo        ",
"         .X+XXX+....ooOO        ",
"        ..+XXXXX+...oooo        ",
"       ..+XX+++XX+.XOOOo.       ",
"      .X+XX++@++XX+..ooo..      ",
"     ..+XX+@+@+@+XX+..oo...     ",
"    ..+XXX+@+@+@+XXX+.X..X..    ",
"   X.+XXXX+@+@+@+XXXX+..X....   ",
"  ..+XXXXX+++++++XXXXX+....X.   ",
"  .XXXXXXXXXXXXXXXXXXXX+......  ",
"   +XXXXXXXXXXXXXXXXXXXX+++++   ",
"   +XXXXXXXXXXXXXXXXXXX+XXXX+   ",
"   +XXX@@XX++++XXX@@XXXXXXXX+   ",
"   +X+@@@@X+###X+@@@@XX+XXXX+   ",
"   +X+@@@@X+###X+@@@@XXXXXXX+   ",
"   +X+@@@@X+###X+@@@@XX+XXXX+   ",
"   +X+@@@@X+###X+@@@@XXXXXXX+   ",
"   +X+@@@@X+#O#X+@@@@XX+XXXX+   ",
"   +X+++++X+###X+++++XXXXXXX+   ",
"   +XXXXXXX+###XXXXXXXX+XXXX+   ",
"   +XXXXXXX+###XXXXXXXXXXXXX+$  ",
" $$+XXXXXXX+###XXXXXXXX+XXXX+$$ ",
" $$$$$$$$$$$$$$$$$$$$$$$$$$$$$  ",
"  $$$$$$$$$$$$$$$$$ $$$$$$$$$   ",
"     $$  $$$ $$$$$$$$$$$$$      ",
"  $   $           $ $ $$        ",
"                                "};
}
\BGColor {grey45}
\BDColor {grey20}
\
\name	{lurnix.top.help}
\class	{XBMButton}
\parent	{lurnix.top}
\script	{
	switch (arg[0]) {
	case "buttonRelease":
		new = clone(1);
		send(new, "init");
		send(new, "render");
		send(new, "info");
		return;
/*
		lurnix("help");
*/
	break;
	}
	usual();
}
\maxWidth {32}
\label {#define help_width 32
#define help_height 32
static char help_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0xfc, 0x03, 0x00, 0x00, 0xff, 0x0f, 0x00, 0x80, 0xff, 0x1f, 0x00,
   0xc0, 0x0f, 0x3e, 0x00, 0xc0, 0x03, 0x38, 0x00, 0xe0, 0x03, 0x78, 0x00,
   0xe0, 0x07, 0x78, 0x00, 0xe0, 0x07, 0x78, 0x00, 0xc0, 0x07, 0x3c, 0x00,
   0x80, 0x03, 0x3c, 0x00, 0x00, 0x00, 0x3e, 0x00, 0x00, 0x00, 0x1f, 0x00,
   0x00, 0x80, 0x0f, 0x00, 0x00, 0xc0, 0x03, 0x00, 0x00, 0xc0, 0x01, 0x00,
   0x00, 0xe0, 0x00, 0x00, 0x00, 0xe0, 0x01, 0x00, 0x00, 0xe0, 0x01, 0x00,
   0x00, 0xe0, 0x01, 0x00, 0x00, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0xe0, 0x01, 0x00, 0x00, 0xf0, 0x03, 0x00, 0x00, 0xf0, 0x03, 0x00,
   0x00, 0xf0, 0x03, 0x00, 0x00, 0xe0, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
}
\BGColor {grey45}
\FGColor {lightyellow}
\BDColor {grey20}
\
\name	{lurnix.title}
\class	{txtLabel}
\parent	{lurnix}
\script	{
	switch (arg[0]) {
	case "show":
		if (arg[1] == "") {
			set("label", "<No Title>");
		} else {
			set("label", arg[1]);
		}
		render();
		return;
	break;
	}
	usual();
}
\label {Welcome}
\wrap {1}
\maxHeight {22}
\BGColor {grey45}
\FGColor {white}
\font {bold_large}
\
\name	{lurnix.view}
\class	{hpane}
\parent	{lurnix}
\children {lurnix.view.sb lurnix.view.html}
\script {
	switch (arg[0]) {
	case "tear":
		/*
		lurnix.mesg.tf("flash", 
			"Sorry, tear page function not yet implemented.");
		*/
		tearPageID = tearPageID + 1;
		new = clone(tearPageID);
		tweak(new, "set(\"parent\", \"\");");
		send(new, "init");
		send(new, "render");
		send(new, "info");
		return;
	break;
	case "init":
		tearPageID = 0;
	break;
	}
	usual();
}
\
\name	{lurnix.view.sb}
\class	{vpane}
\parent	{lurnix.view}
\maxWidth {20}
\children {lurnix.view.sb.up lurnix.view.sb.down lurnix.view.sb.slider}
\
\name	{lurnix.view.sb.up}
\class	{XBMButton}
\parent	{lurnix.view.sb}
\script	{
	switch (arg[0]) {
	case "buttonRelease":
		lurnix.view.sb.slider("scroll", "up");
	break;
	}
	usual();
}
\BGColor {grey40}
\FGColor {grey99}
\BDColor {grey75}
\label {#define upButton20_width 20
#define upButton20_height 20
static char upButton20_bits[] = {
   0x00, 0x00, 0x00, 0xfe, 0xff, 0x07, 0xfe, 0xff, 0x03, 0x56, 0x55, 0x05,
   0xae, 0xae, 0x00, 0x56, 0x59, 0x05, 0xae, 0xb0, 0x00, 0x56, 0x60, 0x05,
   0x2e, 0xc0, 0x00, 0x16, 0x80, 0x05, 0xae, 0xb0, 0x00, 0x56, 0x51, 0x05,
   0xae, 0xb0, 0x00, 0x56, 0x51, 0x05, 0xae, 0xb0, 0x00, 0x56, 0x55, 0x05,
   0xae, 0xaa, 0x00, 0x06, 0x00, 0x04, 0xaa, 0xaa, 0x02, 0x00, 0x00, 0x00};
}
\maxHeight {19}
\
\name	{lurnix.view.sb.down}
\class	{XBMButton}
\parent	{lurnix.view.sb}
\script	{
	switch (arg[0]) {
	case "buttonRelease":
		lurnix.view.sb.slider("scroll", "down");
	break;
	}
	usual();
}
\BGColor {grey40}
\FGColor {grey99}
\BDColor {grey75}
\label {#define fff_width 20
#define fff_height 20
static char fff_bits[] = {
   0x00, 0x00, 0x00, 0xfe, 0xff, 0x03, 0xfe, 0xff, 0x05, 0xae, 0xaa, 0x00,
   0x56, 0x55, 0x05, 0xae, 0xb0, 0x00, 0x56, 0x51, 0x05, 0xae, 0xb0, 0x00,
   0x56, 0x51, 0x05, 0xae, 0xb0, 0x00, 0x16, 0x80, 0x05, 0x2e, 0xc0, 0x00,
   0x56, 0x60, 0x05, 0xae, 0xb0, 0x00, 0x56, 0x59, 0x05, 0xae, 0xae, 0x00,
   0x56, 0x55, 0x05, 0x06, 0x00, 0x00, 0xaa, 0xaa, 0x02, 0x00, 0x00, 0x00};
}
\maxHeight {19}
\
\name	{lurnix.view.sb.slider}
\class	{slider}
\parent	{lurnix.view.sb}
\BDColor {grey99}
\BGColor {grey45}
\FGColor {grey70}
\shownNotify {lurnix.view.html}
\
\name	{lurnix.view.html}
\parent	{lurnix.view}
\class	{HTML}
\script	{
	switch (arg[0]) {
	case "buttonRelease":
		if (tag = nextTag()) {
		} else tag = previousTag();
		if (tag) {
			if (nthChar(tag, 1) == '*') {
				print("script:\n");
				interpret(tag);
			} else {
				lurnix.view.html("show", tag);
				lurnix.view.html("historyRecord");
			}
		} else {
			/*bell();*/
			lurnix.mesg.tf("flash", 
				 "Only \\b( buttons ) may respond to clicks.");
		}
	break;
	case "home":
		lurnix.view.html("show", homeDoc);
		return;
	break;
	case "about":
	case "help":
		handle = lurnix.about("handle");
		lurnix.view.html("show", handle);
		return;
	break;
	case "show":
		lurnix.mesg.tf("show",
			    concatenate("Getting ", arg[1], " ..."));
		cursorShape("busy");

		if (set("HTMLAddress", arg[1]) == "") {
			lurnix.mesg.tf("show", 
				    concatenate("Failed to get ", arg[1]));
			cursorShape("idle");
			return 0;
		} else {
			lurnix.title("show", get("HTMLTitle"));
			render();
			lurnix.view.sb.slider("shownPositionV", 
					float(lineRowOffset()) / 
					float(totalLineCount() - 
					numberOfLinesDisplayed()) * 100.0);

			lurnix.mesg.tf("show", "");
			lurnix.udi.tf("show", arg[1]);
			lurnix.idx.label("index", get("HTMLIsIndex"));

			previousDoc = currentDoc;
			currentDoc = get("HTMLAddress");
			cursorShape("idle");
			return 1;
		}
	break;
	case "historyRecord":
		lurnixHistory("add", get("HTMLTitle"), get("HTMLAddress"));
		return;
	break;
	case "search":
		search(arg[1]);
		return;
	break;
	case "back":
		if (previousDoc != "") {
			lurnix.view.html("show", previousDoc);
		} else {
			lurnix.mesg.tf("flash", 
				"No Previous document to go back to.");
		}
		return;
	break;
	case "prev":
		wantIt = lurnixHistory("prev");
		if (wantIt != "") {
			lurnix.view.html("show", wantIt);
		} else {
			lurnix.mesg.tf("flash", 
				"No ``previous'' document to go to.");
		}
		return;
	break;
	case "next":
		wantIt = lurnixHistory("next");
		if (wantIt != "") {
			lurnix.view.html("show", wantIt);
		} else {
			lurnix.mesg.tf("flash", 
				"No ``next'' document to go to.");
		}
		return;
	break;
	case "keyPress":
		lurnix.idx.tf("focus");
		return;
	break;
	case "save":
		tmp = "/usr/tmp/out.html";	/* later, use dialog box */
		cmd = concatenate("www -n ", 
				get("HTMLAddress"), " > ", 
				tmp);
		system(cmd);
		return;
	break;
	case "queryAddress":
		return get("HTMLAddress");
	break;
	case "queryTitle":
		return get("HTMLTitle");
	break;
	case "tree":
		/* produce a n-level anchors tree by recursively fetching
		 * anchor links 
		 */
		return;
	break;
	case "init":

		initialize();

		homeDoc = environVar("LURNIX_HOME");
		if (homeDoc == "") 
		    homeDoc = accessible("/usr/local/lib/WWW/default.html");
		if (homeDoc == "") print("ViolaLURNIX: No page for home.\n");

		set("HTMLAddress", homeDoc);
/*		print("title1::::", get("HTMLTitle"), "\n");*/
/*		lurnix("show", homeDoc);*/
/*		print("title2::::", get("HTMLTitle"), "\n");*/

		return;
	break;
	case "editSrc":
		lurnix.mesg.tf("flash", 
			"Sorry, HTML source editing function not yet implemented.");
		return;
	break;
	case "print":
		/* makeTempFile() coming your way soon */
		/*tmp = mktemp("/usr/tmp/lurnixXXXXXX");*/
		tmp = "/usr/tmp/out.html";
		lprCmd = "lpr -Plw199b";	/* later, use WWW_PRINT */
		system(concatenate("rm ", tmp));
		system(concatenate("lurnix -n ", get("HTMLAddress"), " > ", tmp));
		system(concatenate(lprCmd, " ", tmp));
		lurnix.mesg.tf("flash", 
				concatenate("OK, printing document using ",
						lprCmd, "."));
		return;
 	break;
	case "enter":
		set("cursor", 0);
		return;
	break;
	}
	usual();
}
\shownDepend {lurnix.view.sb.slider}
\BGColor {lightyellow}
\FGColor {black}
\BDColor {grey75}
\font {usual_medium}
\
\name {lurnix.idx}
\class {hpane}
\parent	{lurnix}
\maxHeight {18}
\children {lurnix.idx.label lurnix.idx.tf lurnix.hist.label lurnix.tear.label lurnix.prt.label lurnix.src.label}
\
\name {lurnix.idx.label}
\class {XBM}
\parent	{lurnix.idx}
\label {#define idx_width 32
#define idx_height 16
static char idx_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x0e, 0x80, 0x01, 0x00, 0x04, 0xe0, 0x01, 0x00,
   0x04, 0xf0, 0x00, 0x00, 0x0e, 0x7c, 0x00, 0x00, 0x00, 0xff, 0x3f, 0x00,
   0x86, 0xff, 0xff, 0x07, 0xca, 0xff, 0xff, 0x7f, 0xca, 0xff, 0x37, 0x7e,
   0xc6, 0xff, 0xef, 0x00, 0xc0, 0xff, 0x1b, 0x01, 0xca, 0xff, 0xf7, 0x01,
   0x0a, 0xff, 0x8e, 0x00, 0x04, 0xfe, 0x79, 0x00, 0x0a, 0xe0, 0x67, 0x00,
   0x0a, 0x00, 0x1f, 0x00};
}
\maxWidth {80}
\script {
	switch (arg[0]) {
	case "index":
		if (arg[1] == 1) {
			set("FGColor", "green");
		} else {
			set("FGColor", "black");
		}
		render();
		return;
	break;
	}
	usual();
}
\FGColor {black}
\BGColor {grey45}
\BDColor {grey20}
\
\name {lurnix.idx.tf}
\class {txtDisp}
\parent {lurnix.idx}
\script	{
	switch (arg[0]) {
	case "keyPress":
		c = key();
		if (c == '\r') {
			if (saveMouse) {
				/* restore mouse position */
				setMouse(saveMousePos[0], saveMousePos[1]);
				saveMouse = 0;
			}
			lurnix("search", currentLine());
			set("content", "");
			render();
		}
		insert(c);
		return;
	break;
	case "show":
		set("content", arg[1]);
		render();
		return;
	break;
	case "focus":
		/* save current mouse position, to warp back after key-entry */
		saveMousePos = mouse();
		saveMouse = 1;
		winPos = windowPosition();
		setMouse(winPos[0] + 18, winPos[1] + 18);
		set("content", "");
		render();
		lurnix.idx.tf("keyPress");
		return;
	break;
	case "leave":
		/* cancel mouse warp to avoid confusion */
		if (saveMouse) saveMouse = 0;
	break;
	case "init":
		saveMouse = 0;
	break;
	}
	usual();
}
\BGColor {grey45}
\FGColor {white}
\BDColor {grey20}
\
\name {lurnix.hist.label}
\class {XBM}
\parent	{lurnix.idx}
\label {#define hist_width 16
#define hist_height 16
static char hist_bits[] = {
   0x00, 0x00, 0xf0, 0x0f, 0x08, 0x10, 0x18, 0x20, 0xfc, 0x7f, 0xfc, 0x07,
   0xfc, 0x07, 0xdc, 0x0e, 0xb8, 0x0d, 0x38, 0x1c, 0xb0, 0x3d, 0xa0, 0x3d,
   0xae, 0x3b, 0xf4, 0x1f, 0xf8, 0x0f, 0x00, 0x00};
}
\maxWidth {16}
\script {
	switch (arg[0]) {
	case "buttonRelease":
		lurnixHistory("render");
		return;
	break;
	}
	usual();
}
\FGColor {white}
\BGColor {grey45}
\BDColor {grey20}
\
\name {lurnix.tear.label}
\class {XBM}
\parent	{lurnix.idx}
\label {#define tear_width 16
#define tear_height 16
static char tear_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0xfc, 0x0f, 0x0e, 0x0c, 0xfc, 0x0f, 0x0a, 0x0c,
   0xfc, 0x1f, 0x1a, 0x18, 0xf4, 0x3f, 0x3a, 0x70, 0xf4, 0xff, 0xea, 0x0f,
   0x54, 0x15, 0xaa, 0x0a, 0x54, 0x15, 0x00, 0x00};
}
\maxWidth {16}
\script {
	switch (arg[0]) {
	case "buttonRelease":
		lurnix.view("tear");
		return;
	break;
	}
	usual();
}
\FGColor {white}
\BGColor {grey45}
\BDColor {grey20}
\
\name {lurnix.prt.label}
\class {XBM}
\parent	{lurnix.idx}
\label {#define prt_width 16
#define prt_height 16
static char prt_bits[] = {
   0x00, 0x00, 0xf8, 0x03, 0x88, 0x06, 0xf8, 0x0e, 0x88, 0x08, 0xf8, 0x0f,
   0x08, 0x08, 0xf8, 0x0f, 0x08, 0x08, 0xfc, 0x1f, 0x02, 0x20, 0x02, 0x60,
   0x1a, 0x60, 0x02, 0x20, 0xfe, 0x3f, 0x00, 0x00};
}
\maxWidth {16}
\script {
	switch (arg[0]) {
	case "buttonRelease":
		lurnix.view.html("print");
		return;
	break;
	}
	usual();
}
\FGColor {white}
\BGColor {grey45}
\BDColor {grey20}
\
\name {lurnix.src.label}
\class {XBM}
\parent	{lurnix.idx}
\label {#define src_width 16
#define src_height 16
static char src_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xcc, 0x31, 0x52, 0x0a, 0x42, 0x0a,
   0x42, 0x0a, 0xc4, 0x0b, 0x48, 0x09, 0x50, 0x09, 0x50, 0x09, 0x52, 0x0a,
   0x4c, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
}
\maxWidth {16}
\script {
	switch (arg[0]) {
	case "buttonRelease":
		lurnix.view.html("editSrc");
		return;
	break;
	}
	usual();
}
\FGColor {white}
\BGColor {grey45}
\BDColor {grey20}
\
\name {lurnix.mesg}
\class {hpane}
\parent	{lurnix}
\maxHeight {18}
\children {lurnix.mesg.label lurnix.mesg.tf}
\
\name {lurnix.mesg.label}
\class {txtLabel}
\parent	{lurnix.mesg}
\label {Message:}
\maxWidth {80}
\BGColor {grey45}
\FGColor {white}
\BDColor {grey20}
\
\name {lurnix.mesg.tf}
\class {txtDisp}
\parent {lurnix.mesg}
\script	{
	switch (arg[0]) {
	case "keyPress":
		return;
	break;
	case "show":
		set("content", arg[1]);
		if (get("window")) {
			set("FGColor", "100 90 70");
			render();
		}
		return;
	break;
	case "flash":
		set("content", " ");
		set("BGColor", "red");
		if (get("render")) {
			render();
			set("FGColor", "100 90 70");
			set("BGColor", "grey45");
			set("content", arg[1]);
			render();
			after(1000, "lurnix.mesg.tf", "fade1");
		}
		return;
	break;
	case "fade1":
		set("FGColor", "90 80 60");
		render();
		after(500, "lurnix.mesg.tf", "fade2");
		return;
	break;
	case "fade2":
		set("FGColor", "80 70 50");
		render();
		after(250, "lurnix.mesg.tf", "clear");
		return;
	break;
	case "clear":
		set("content", "");
		render();
		return;
	break;
	case "init":
		after(60000, "lurnix.mesg.tf", "clear");
	break;
	}
	usual();
}
\content {Click on a \b( button ) to follow link.}
\font {fixed}
\BGColor {grey45}
\FGColor {100 80 60}
\BDColor {grey20}
\
\name {lurnix.udi}
\class {hpane}
\parent	{lurnix}
\maxHeight {32}
\children {lurnix.udi.label lurnix.udi.tf}
\
\name {lurnix.udi.label}
\class {menu}
\parent	{lurnix.udi}
\label {UDI:}
\menuConfig {
. {UDI <= XClipBuffer}		{lurnix.udi.tf("getUDIFromClipBuffer");}
. {UDI => XClipBuffer} 		{lurnix.udi.tf("putUDIInClipBuffer");}
}
\BGColor {grey45}
\FGColor {white}
\BDColor {white}
\maxWidth {80}
\
\name {lurnix.udi.tf}
\class {txtDisp}
\parent {lurnix.udi}
\script	{
	switch (arg[0]) {
	case "getUDIFromClipBuffer":
		lurnix("show", getClipBuffer());
	break;
	case "putUDIInClipBuffer":
		setClipBuffer(lurnix.view.html("queryAddress"));
	break;
	case "appendUDIToHome":
		lurnix.mesg.tf("flash", 
			    "Sorry, can't yet append to home page.");
	break;
	case "show":
		set("content", arg[1]);
		render();
		return;
	break;
	}
	usual();
}
\font {fixed}
\BGColor {grey45}
\FGColor {white}
\BDColor {grey20}
\
\class {field}
\name {lurnix.about}
\script {
	switch (arg[0]) {
	case "handle":
		/* tmp = mktemp("/usr/tmp/lurnixXXXXXX.html");*/
		tmp = "/usr/tmp/aboutViola.html";
		saveFile(tmp, get("content"));
		return tmp;
	break;
	}
	usual();
}
\content {
<TITLE>Overview, Lurnix HyperTutorial</TITLE>
<H1>Lurnix Hypertext Tutorial</H1>
This is a demonstration of an interactive/hypertext tutorial 
system built for the <A HREF=aboutLurnix.html>Lurnix</A> group.
The base technology is the Viola interactive media authoring tool.
<P>
The teaching materials used in this demo is from the book 
<A HREF=aboutUPU.html>``UNIX Power Utiliites''</A>, by
<A HREF=aboutJMuster.html>John Muster</A>, 
<A HREF=aboutPBirns.html>Peter Birns</A>, 
and the <A HREF=aboutLurnixStaff.html>supporting staff of Lurnix</A>.
<P>
Etc, etc...

<H2>Status</H2>
<DL>
<DT>March 28, 1991
<DD>Prototype built for evaluation at Lurnix.
</DL>

<ADDRESS>
<A HREF=aboutPWei.html>Pei Y. Wei</A><P>
Experimental Computing Facility (XCF)<P>
University of California at Berkeley<P>
EMail: wei@xcf.berkeley.edu
}
\
\class {field}
\name {lurnix.help}
\script {
	switch (arg[0]) {
	case "handle":
		/* tmp = mktemp("/usr/tmp/lurnixXXXXXX.html");*/
		tmp = "/usr/tmp/doYouFeelLucky.html";
		saveFile(tmp, get("content"));
		return tmp;
	break;
	}
	usual();
}
\content {<TITLE>Lurnix HyperTutorial Help</TITLE>
<H1>How to use this tutorial</H1>
Explain ``hot words'', what information is displayed where, etc.
}
