\name	{clock}
\class	{vpane}
\parent	{}
\script	{
	usual();
}
\width {200}
\height {210}
\children {clock.dial clock.mesg}
\
\name	{clock.dial}
\class	{XPM}
\parent	{clock}
\script	{
	switch (arg[0]) {
	case "tick":

		date = date();
		clock.mesg("update");
		second = int(nthWord(date, 6));
		minute = int(nthWord(date, 5));
		hour = int(nthWord(date, 4));
		if (hour >= 12) hour = hour - 12;

		secondD = (second / 60.0 * 360.0) - 90.0;
		minuteD = (minute / 60.0 * 360.0) - 90.0;
		hourD = (hour / 12.0 * 360.0) - 90.0 + (minute / 60.0 * 30.0);

		secondX = secondR * cos(secondD) + centerX;
		secondY = secondR * sin(secondD) + centerY;
		minuteX = minuteR * cos(minuteD) + centerX;
		minuteY = minuteR * sin(minuteD) + centerY;
		hourX = hourR * cos(hourD) + centerX;
		hourY = hourR * sin(hourD) + centerY;

		if (lminuteX != minuteX) {
			clearWindow();
			clock.dial("render"); /* brutally redraw */
			drawLine(centerX, centerY, minuteX, minuteY);
			drawLine(centerX, centerY, hourX, hourY);
			invertLine(centerX, centerY,lsecondX,lsecondY);
		}
		invertLine(centerX, centerY,lsecondX,lsecondY);
		invertLine(centerX, centerY, secondX, secondY);

		lsecondX = secondX;
		lsecondY = secondY;
		lminuteX = minuteX;
		lminuteY = minuteY;
		lhourX = hourX;
		lhourY = hourY;
		after(1000, object("clock.dial"), "tick");
		return;
	break;
	case "render":
		usual();
		for (i = 1; i <= 12; i = i + 1) {
			x = letterR * cos((i / 12.0 * 360) - 90) +
				centerX - 10;	
			y = letterR * sin((i / 12.0 * 360) - 90) +
				centerY - 5;
			drawText(x, y, i, str(i));
		} 
		return;
	break;
	case "expose":
		lminuteX = 0; /* forces redrawing */
		lhourX = 0; /* forces redrawing */
	break;
	case "config":
		if (arg[3] < arg[4]) 
			radius = arg[3] / 2.0;
		else 
			radius = arg[4] / 2.0;

		centerX = arg[3] / 2.0;
		centerY = arg[4] / 2.0;
		secondR = radius * 0.95;
		minuteR = radius * 0.9;
		hourR 	= radius * 0.6;
		letterR = (radius - 9) * 0.94;

		after(2000, object("clock.dial"), "tick");
		lminuteX = 0;
	break;
	}
	usual();
}
\label {/* XPM */
static char * marble2.xpm [] = {
"112 118 17 1",
"  c #3F3F3F3F7F7F",
". c #3F3F7F7F3F3F",
"X c #3F3F7F7F7F7F",
"o c #3F3F3F3F3F3F",
"O c #00003F3F7F7F",
"+ c #00007F7F7F7F",
"@ c #00007F7F3F3F",
"# c #7F7F7F7FBFBF",
"$ c #7F7F7F7F7F7F",
"% c #3F3FBFBF7F7F",
"& c #7F7FBFBF7F7F",
"* c #7F7FBFBFBFBF",
"= c #3F3F7F7FBFBF",
"- c #00003F3F3F3F",
"; c #3F3FBFBFBFBF",
": c #7F7F7F7F3F3F",
"? c #7F7F3F3F7F7F",
" .X . . .XoXoXoXo . .Oo+o . .Xo.XXoXO. .XoX .oo . o@oo+oXXXX#$XXX%$X&*$&X&X$XX$%X&X$XXXX$XXX$X&$X&=&X$%$XX$XXXX$",
"X .Xo+oXoXXo-X .XX-Xo. . . @ . Xoo .oX. XX. -X- -. - @ .o .XXX. .XX$*$*$#X*X$;$**$%$X&X$%XXX&X#%#X$XXXXX$%XX.XX.",
".o+oXoXoXXoX .X . . @ o@ . .X .Xo+o@ -X.. X. oo.o-oXo . . .-Xo @ XXXX&X&X&X$%$X&#%$X&XXXXXX$X&X$%XXX$X$XXXXX . .",
"oXoX-XoX. .-Xo.O.X-XoXXoXoXXoXXXo.  . @ X. Xo@ o -o-. -. . . @XoX.XX$X$X*$%#X$&X$X$=$X$X$XXX$XXX$X$%XXX.Xo.X.XXX",
".O.XoXoX XXoXoXoXoXoX.XXXX.XX. .X @oXo.XoXXoXX. .oXo @oo-X-XooXXXXXXX%X$X&X$%X#X%$X&X$XX$X$%X&X$XXX$XX$XX XoXXoX",
" . .O. @oXo+ .XO. .X-XoX. XoXX. o. .O. XX.O. . Xo--oXoO. o.Oo+ooX.X$XX$%#X*$$%$$X$XXXXX%XX$XXXXX%XXX$XXX.X.$XoX.",
".OoXoXoXo+XoX-X. . .XXXXX.XXoX .O. X. .XoX.XX@XX . -XoX-.Oo.O.oX. .X.XX$%$%#%$X*X&XXXX$X.XX.$X$X$XX.XX.XX XXXXX ",
"o@o@ @ -Xo . . . @X . . . : XoX.XoX.XXX.X XoX . .Oo.O.o oX .oO.OXXX.XXXX$&#&#%$X$XXX.XX. oXXXXXXXX$o. X$X$. . .X",
"- . -XoXoX-X- @ . . XX.XX.XX.XoXX.X XX. +.O. .XXoXo+o .+o+o+oXo. . XoX.$X%$X&X$%XXX$XXXXXXXXXXX$XX. .X.XXXX.X. .",
".oO.oo+o.O. .oo-oO.o. XoX XoXXXoX .X.XXXoX. .XoXXoXoX-XoXoXoXo+ .X.XX.XX$X&XXXX$XX.X.X.XXXX:XX$XX. o . X$X. XoXo",
"oO.o+oo+o o- - . . +o+oXo.XXoX.XX. X . .XoX@ .XoX-X. .oX.X.XoX.X . XoXX$X&=$X$XXXo . X$X$XX X.XXo o@oXXX.X$XX. X",
"o.oOo+o .-Xoo.oO.OooX. .X . X. X. .. X. XXo . -XoXoX.OXo+oXOXoO.oX. XXX$XX$X$%$XXX.XXXXXXoXX. oXo-o-o-XXXXX. .Xo",
"- .oXo+oo -oOoo. o.- .X @ .X.XXX X @ .XXoX. -.o. .X-XoX. . .X.XoXXoX.X.XX$X&XX$$XXoXoXoXXX$o .oo@oo-oXoXX$. Xo+o",
"o- -. .O.-Xo-oOo.OoXoO. .oX-X .X.oXo. . . o.oOoO.O. .XoO. @Xo @XoXXoXX XXXXX$&=%$XXoX. .oX.Xo-o- oOo-XXX.XXX.XoX",
"O.-X-XooOooo o-o-oo-.o @o-X .X . Xo- .X .X-Xo. . . . -.oXooXX. XXoXXo.X.XX$XXX$XXX. . . XoX . - .oXooXoX$XXX .XX",
". o-oO.O.oO.. @o . o -ooOo.X .XX. @ -XoXo . -X-o+oXoXoOo+oX-XoX. X.Xo+oXX.XX$%XXXXoXoXX-X .o@ o.Oo+oXXXXXX?.X . ",
"O.- @o .-oo- -o-o-oo.Oo-.OoX. . +oo@o .X-X-Xo-XoXo-.- . . .XoX-X.X . .X .XXXXX$X. . .O.X. . o@ -o. @ .XoXoX.X. .",
"o .o @o oOoo@o oo - ooXoo. -X-X. . o@ . .oXoX. -. X . X-XoX@ X.X .XX. . . .X$XXX. .XoXo o@ o-ooX @ . . X.XoXoX- ",
"@oO.- .-.- o o-.O.o-.OoX- @ooX .Xo+ . .Oo- @ oXoX-.OX. . @XXoX .XoXoXO. . .X.X. o. . .Xoo .oXo+o. o@ @ . XXXoXo.",
" .oOooOoO.-o-.o-o oXoo-o.oo+o@Xo-X. . .. .oXoX. .O.oXo+oXoXXXX.Xo+o+oXo+oXoX XX. -X-oOo-o- @o-o -.OoXoXoX. o+oXo",
".Ooo+oo@o o+o oX-. -oX .OoXoXoXoXoXX. . @ . .OXXoXoX-XoX@ XX. Xo+oXoX. . .X.XoXoXo-. -.o @ooOo .o . . . -o.-o.Oo",
".o-oo- o-o-o .-oXooX-oXoXoX-XoX-XX. XXXoXoX.XoXXoX- . . . . $.Xo . . .X-XX XoXoX-ooo-o -ooO.o@o- @ @ .X.X . -o. ",
"oO.O.-o- . -o .OoOo-oooXoOo. . . . X.XXXoX- X. . @ .-Xo+oX..O. @o-.O.O.Xo. . -. . @ .-oo+ooOo - . . .OXoXo+oX-o-",
".o oOoXo-o- @o-oooo -Xo.o. o. .XXX.XXoXX. X. .o+oXoXoXoX. XoX-XoXo . . X .O.o -o+oo- oOoo-o-.- @oO.-XoXo+oXX.X .",
"O.-.o-oOoOoo -X-X-.-ooO. o. @ oXoX . X. X. .O. . @oX-.O. @ . . @ @ .-X.XoX. @o-XoX .-.o- @ oO.o @oXoX. .X. . X-o",
".OoOoX-.o+o+o.ooo o .oo-Xo .o- .XXoX.XX. X. .+oXoX-X . -. .X-Xo . . . XoXoXoXoXoX-XoX +oXo+o. @o . Xo+oX .XXo. .",
"oo. @o +ooXo+oO- -.- .OoX.o- .- . XoXoXX.XXXoX-.O. .-oXoXoX-Xo+o-X-X.X.Xo+ooXo+oX. . . . .oO. oX-X.O.XoX. .XXo+o",
"-X-o @ooX-oO. o.-o o- . .Oo -XoXoXo+oXoX . @ . . -XoXX-X--oXoXoXoXoX-X X .O.oXoX-Xo+o- @ +oXo+oXo-o. . .OXo. .oX",
"ooX-o @ o+o. . -oX-. -o+o @oXoXo+oX. X.XoXXoX-.O. .Xo+o. . -oX-X-o+oXX. . .OoO. . . . .o. . .oX-XoX- @ .. . .O.-",
"X-oX-. @ooOo-OoX-o-o-Xoo+o @o- @oX- .X-Xo+oXo+oo @oXoXoO. .XooXoXo. . .X-Xoo. .Oo. .-o+ . X-X-oX-Xo-. . X.Xo. . ",
"-o+o @o @ . o.-o-o-o-oOoo@o oXo ooXo-XoXoX-Xo.O.- .O.XoXo+o-XoO.o -. .O. .XO.OooX-o- . . @ .oXo @o . .X. X. @ .O",
"@ o@o @oo+o- - -o-o- o.O. o@ @o+.O. .o@oO.oO.Oo .- . @ @o . oXo @ . @ . . . . .- . .oO. . . .O.o-o+oX- . .XXXoXo",
"o@o @o @ o .O.o@ oOo-X-o-X- . .o .-X-Xo .- -o. @oX-. . . . @ .-XoXoXoXoXo+. . -o+o@ -. -XoXoXoO.Oo-Xo.-X. .oX.X.",
" ooXoOoo@ @oXo o-XoXo-XoXoo@oOo+oXo . @oO.o.O.- o-XoX-XoX-. . .oO.ooXoX-XoXo+.XoXooXo . . .O. . o-XoX-oX .XX. Xo",
".O.- .- .- o+o@Xo@ @ .o-oO. -. @oO.- oXooX- o+o.O.o+ooXoXo . .O. o @ .oXoXoXo .O.O.O. @o-XoXo.O.Oo.O.XooX.o .X. ",
" -oX-oX- .-Xo .- oXo.OoX-oo-Xo-oXo-X.-o+ooXo-oo-oOooX-XoX-X-XoXoXo. o@ @ .X.XoXoXooXoX X. .X. .o.-Xo .X-X .+oXXX",
"@oXo@ -.oOoo+o .-X- o o-. . -oX-o-oo XooOoo@ .OoXo@ oXo+o . oX- .Oo. .o .Oo @ -X-o+oX.XoXXoX-X .OXoX-XoX.oX.Xo. ",
"o -oo. -XoX-o.O. oo@ @oXooOo.Oo-oOo@o-oXo@ oo-.o-o @o+ooXo.-X-o-o. oXoO. .XoXo.oXooX .XX.O.XoXoXo. .o+oXoX . X.X",
".-.OoO.o- -o+o-Xo+o . o-Xoo-oo-Xo.- o @oo oo o oO-. o. @oO. -o-o oXo.-Xo+oo+o -X-X-.X-X XXoXX. .+oOoXo.O.oX.Xo+o",
" oXo@oOo.-o o-. @o+o-o+ooO.OoOo-oOo.OooOo-o.-Xo@oo-.Ooo .o-ooo-o@ .o -oXoX. .o@ ooXoXoX..XX. . . .X-oXoXXoX .XoX",
"@o- oX- - @oOoo- oo+o o-.- o@oo- o-o.O.o-Xo o-Xo -o @oOo- -o -o -o- @XoO.Oo@ Xo-.O.O.XoO. .XXoX.X .oXoX. X.Xo+o.",
". .-X-o.- oo.O. @ .oOo- o @o @ .-oX- o-oo-o-Xoo .-o- .-o -o.oO-oo-oo -XooXoXo-XoO.oXoX. XoXX.X @ . XoXXX. @ .X .",
" - .- oO.- - o-o.Oo+o.o-.- -Xo- .-o @o@ - .oo .-ooO.o- -o-o-oo-oXo @oXo+o+o-XoO.oO. - . .O. X . XX. X@oXXXoX.oX-",
".-. o@ ooO.o-. -oo.o - oOoo.oO.oOo@o -oo-oOo @oo- o-o o-o-o-Oo- @o-oX-XoX-oXo@oXoXo@Xo+. . .X.X. .X. XXoXoX. .oo",
"oX-o+o-X-. - -ooOoOo@ -.-oO-Xo @o oO.o-Xo o.oo -o-o-o-.oOo- o@o oXoX-oX-oo+oXoOo+o- oXo . .O. o .X X. .XXXo o- .",
"-oX-oo-.oOoo.o-oo@o -.oOo-oo @o @o@o- o- @o- -ooOo- o+o-. .-o .@ -. .O. @ o-oXoX-oXo@o-X-XoXoXX. .XX.XXXoX.o@o- ",
"X-o-X- o-.oOoo- - .-Xooo@ -.- .o - o-.O.ooOo-.-oo-o@oo oOoO.-o -.OoX-. oo-. @o-oX-o+oXoXo+oX-XooXoX $oXXX oo .oo",
".Oo.-o-XoOooO. o.-oo - -oo -XoX-X.o+o o- o-.o- -o- oX-@ .oo -.O. . @ o@ -X-o @ .O.ooOo+oXoXo. X. XoX.XXoX.-.oOo+",
" .- o -o-o-o- -oo-oOo.o-X-ooX-oXoO. -.-o.o- -o-oOo@o- oo- @o o. -.o @oXoooo+o @ oO.O.oXo-X- -.O. .XoX :Xo o-o.-o",
"o-o-o@o -. -.o.- oo.-oOo. @ - @oXoX-o-o- o.-oOoo-o- o-. -o @ @ .oO-. -o+o+o-. o.o-.oX-XoXooXoXoX. . .XX .oXoo -o",
"oOooOo-o-o-oOo-o-o - -o-Xo .o.oOo@ ooOoo-o- o@o-o-o-. -oo@o . .Oo.oOo@ o+o .Oo+o+o - o-X- -.Oo@ XX XX. .oXo.-o. ",
"o@o-o- @oOo-o oO.o-ooo- o@ @ - .oo-X-o--oXo--o - -. -oo+o -.Oo-o -o@oo@ o@oO.ooXo-. @oXo @oo. o@oX.XXX. oo- oOo-",
"o -. -oo-oo---o-o .- @o@o .oO.oOo+o-o-o-o--o--oo@ -oX@ o-oX-oXo@ . oOo @o .o @ -Xo . .O.-oX- @ o+oXoXoX .O.o@oo+",
"-ooO.o-o- - oo-o@oOo-o -o-X-. -.o ooo-o-oo-oo--o -.o- o-oOooOo- -o@o-.- o@ @ . o-o@ -oo . o.oo-Xoo . . .-o o @ o",
" .-. -oOo-o--o -oo-. @o @ ooO. - @- -oo--o- -o-o-. - .-Xo.-X-.Xo.Oo @ o@ oXooO.-X- . X-X-oX-XO.o-X-oO.oOoX-.o-o.",
"o-o @o -oX- .-oOoOoX- o@o-X@ .o+oo @o -ooOo-.- -oOo.-oo- -oo -X-o.-o -Xo-X-. .- oo@o-XooXO. .o X-o @oO.o-.o-Xo+o",
"O.-. .-.-oo- o@ooo-oo@ oOoooX- o-@o o@oOo-o - .-o@ - -Xo-X-X-.oO.Oo+ooo- o@ -Xo@ .  . X@ . .O. . @o .o - -o-oooO",
"oOo-o -ooOoo- o-X-o+oo-.o+o-. .- o @o-o. .-.o@ o -Xo. -Xooo@ oO.oooo@o+oo@ o. -XoO.-XoXoXXoXoX- @oX- -.o.oO. @ o",
"o@oX-. -o--o.- -o-o- - o+ooO. -o-o-ooOo-- oO oX-oX- -.-o- @oOo.- -X- -oXo .- . .-XoXoXoXo. .-oXo -o.- -o .oo- .-",
"o -o-o-Xo- - -o@o o.-Xo@o -.o-Xo+ooOo-oo-o-.-X-X-oX-Xo -Xo- .- o@ o@ .o- @o @o@ oXoXoXo+oO. .Oo@XoX-ooo@oOoOo-oX",
"@o-o- o-o-o-oo- -.Oo -Xoo@ -Xo-ooOo@oo-oO.- o@ o-X-oo+o.- .- .-Xo-Xo- -Xo @oo o+o@ . . o@o-o+o. o- o- - oo@oo@o-",
"oO.oo@-ooOooX-o-oO.-Xoo+o o.-XoOo@oo- -o-oOo+oo- o.OooOo.- .- o-oX-o.-Xo-Xo-X-. . -. @o+o . o- @oX.Xo.o-.O. -oO.",
"oo-X-o -X-oX-oXoXo .-Xo @o-X-oXo-o- --o-Xo-oo+oo@oO.o+. -XoO.o+o+oo+o-o+ooX-o o@ o. -Xo .-o-Xo. - oXoO. o .o-.o ",
"@ o-oOo@oo-o -o+o+oO.o+o -X- .-ooOo-oo-o-oX- o- o+oo+o . -.oOo-.oO.oO. o+o-Xo@ o@ .O. . o+oo@ -. @o .o @oX-X- @o",
"o-.-Xo@ oOoX-Xo-. . . .X.oo+o -X-.o @o-o- -.o@o@oo+oo+.-. -Xo.O .oO.o-o+oXo- -oXoO. . .+o o+ooXoXoX-X-. . . o. o",
".Ooo-. -.Oo+o- oO. .XXo @ . ..o-o o.oO. .oX-oO. -oo+o oX-Xo@ o.- @ o+oO. o+o. @o+o. . . .+ooXo+oXoOoo ooXoX. @ .",
" .-X- @ o. oXo-.oO.Oo. . -X- +oXo@ - .o- -oo+o o@Oo.O.OoXoXoO.Oo. -. @ o. . -. oo+o+o@ . o.Oo+oX .-X.O.O. XoX .O",
".Ooo@oo.O-.-oOo-o-oo . .O.oXoXoOooXo- @ @o+oo.- oXoXoX. @o-Xo-o@OoX- o.+ @ @ . @ o. . .-o+o-. .X. Xo -ooXoX-X. X",
"XoX- -X-o o+o.- o-o-.OoXo -.- .o+o-Xo@o.o-o@ O.o+o+oXo-Xo -o+o o.-oXo+ ooXo. o+o.O. . o . oXoXo +. .Xo+ XXoXXX.X",
"@ .oXo- .-ooOoo-oX- .oX-.oX- .OXoX.-XoX- Xo .- -ooo- @o .-Xoo@o- @o @o. -.OoXo.O. .Xo+. -Xo-XoX. o+oX.X. .XXoX X",
"o o+o-Xo-X- @oO.Ooo@ .o . o.o@oX. XoX- .oX@oX-. .O. . o@ .o+o @ - .X Xo+o . @ . o@ .X X. @ .X. @ . .X XXXXX.XX. ",
". . @ o.oOo. . o.- ooO.O.-XoX . X.XoXo.O. XoXoX @oX.O. . o+o@ .-. . @oO. . . .O. . . . . .XoX . .X-XoX. . . XoXX",
". @ oXoX . .O.O. o.O.o -oXo+ooXo. . .XoX.X-Xo+. o+oO. .-Xo. o-X . XX . . @ @ . .OoXoX-XoX .X.X-XoXoXXoXoX. .XXX ",
"-o. .O. XX. XoXoXO. .Oo. . . .o+ @XoXXoXXXXoXoX.XoXoXoXoXo+o+ooXoXo.XoX .XoXoX-XoX-XoX. .+ X .XX.O.oX-X. .X .X. ",
" .O. . X. XXoXoX. . .Xo+o+o. @ . . Xo+. . .X-X- .Oo. @ .-XoXo-X-X-X .+o+oXXoXoXo@ . . XoXo. .XXoXoXoX. oXoXoXoXo",
"o o.- .oXXoXXoXX XXXXX. .oXoXoX-X.X. .XX.X XXoX. XX-X .Oo .O. -. o. oXoXoXo+oX-XoXo+oX-Xo+o+. .XXoX. . .- @o-X .",
"+.OoX- . .Xo . .X. .XX .X @ @ . oX X. . XX.. .X X.XoX. .+o+ooXo @ .+oXoXoXo @ oXo+oXoXoX. XoX-XoX. +o+o .- o -XX",
"ooo-oXo+o oXoXX oXoX.XXXX.XXoX . .oXXXXX. -XoX.X.X . +. -XoOo+o@ . oX-XX-X-Xo. -Xo. . @ XoXo. -oO. . . @o @o@o. ",
"X- .Ooo @o+oXoX.XoXX .X$oXXXXoX@ . . .XXoXo .-X .XX@XoX-XoX. oXo @oX-XoX . - o+o. X-XoXo.O.O. .XoXoXo+o o-oo . .",
"Oo-oo+o.oOoXoX XoXoX.XXXXXoXoX. XX.X. .XXo+o .o+o. Xo-Xo. -X-X-oXoXo @ . @oX.oXoX-XoXoXo+oXo @ . @ .Oo. . @o+o -",
"o.o+oo - . .O.oXo @ oXoXoX. .X .XoX .O. o@ @oO.o @o.O. . X. . . @ @ . . @ oO. -Xo .oX-Xo . .O. -XoXo. .O. oOoX-.",
".OooXoX-oO. . o+oXoXXXXX. X.O.XoXoX-XoX.- .O.o+oX @ . X-X-. -X-XoXo.O.XoXo.oXoXo-.Oo-oXo+ . .oXXoXoXo+oXXX.o.-o ",
" .oXoo-Xo. XoO. X. . . XX. .X . @ .oX.oXoX-. @ . . @ .XoXXo+ooX . . . XXoX .- -X .oXX- . .XoX . .o+oXoXooXo Xoo-",
"oXo @ oXoO. . .X XXXX.X. .X XXX. .O.- .XXoXo . @ @ . -XoXoOoX .Xo+oOo+oXX.XX. .o.OXo-Xo+oXoXX.O.O. . . . .O.oXoX",
"Xo+oo@ o-oXo . ..X.X X X. X.X. .+o-Xo+o-Xo+o+oXoXoXoX. XoX. @XoO. .oo@ .XXX X.X oX-XoX. .OX. XoXoXoXo . .O. . -o",
" -oXoo-o -o@ .X XX X.X.XXoX . .OoXo+oX. .Xo+oX-Xo+o+oX. @ .- . .X o+o . .XX. XoX+o. . XoXXoXX. .XoXoXo+ . . .-Xo",
" .o-O.Oo-. oXXXXXoXXX . @ @o+ @oX-XoXo+o-XXoX.X . . .OoXoOoX- . .X-o.-o+ . Xo.X . XoXo+oX X. X. . oXoXoXo-X-XoX-",
"- . o-o-oOo+oXXoXXo.oX-oX- -. o+o. .+o. . @ oO.XX-o-XoX-. @ooXXXXX .  . .XXo-o .XX. .O. .XoX.  .O.o .XXoXoooo+oX",
" .-o+o -.- .X .XoX-XoO. -.oXo+o.Oo+ .Xo+. .X@ . . X .OooO. oXX.Xo+oO.-O. . oOo@ oX X. . XoX .X- o @ -X. .O. @ . ",
". oOo@o -XoX-XoX-XoX-. @ oX-XoX- .oXXXXoXXo . -XoXo. .+ooXXXo+XXXoX. .oOo+o.o o-X.X @ XoXO.oXoXo@o . XoXoXoXo@ .",
" @o.Oo-Xo@ -. . . @ o+oo@ -Xo-Xo. @ . . -.X@ . . @X-Xo X-Xo+. . .XoXoO.o . -X-XooO. . .+. Xo+oOo -Xo. XoX-X-o .X",
"X- .-Xo-oOooO. @ -o@ o-Xo.o-Xo-X- .oO.X. X Xo-@ . o- @oXoXoXoXoX .O.X. +o-. o.- -oXoXoX o+oXoXXoo.oOo.oXoXo-o-X ",
" .-XoX-X-o-.XoX-. .Oo@ .OoXoX-Xo .O.o oo@ .-Xo -o+oX. .O.O.O. @XoX. -X-oX-o@ O.oXoXo+oX-XoXXXoXoOoO. -XoOoXoO. .",
" o--o+oo-X- -Xo+o- .oXooX. @ o. @oo @o@ o-Xo-.-Xo-XoXoXXoXoX-Xo-X-Xo. .-oXoXo.O. @ . . . @ oXXoXo. o. o+oX-ooXoX",
".O. -oXoX-oXX. . X-o+o+o+oXo. -XoX-XoOo-XoO.  o- o-Xo+oX+ .Ooo+o. -X-- X-X-XoO. . . - @ ooX.oX .O. -o+ooXoXXoO. ",
" .o-Xo-X- .oXo+o+o.O. . oo @ . oXoX-o. -o.o --.o@ o+o . .X-.XoOoO.oo @o@ oXoXoX-XXoXo- .O.Oo+o@ . -. oXooXo+oXoX",
"@ @ -oO.o@ -X- .o+ . . .X-. -XoX.O. o-.oOoOoo-oOo-oo@oO. .X -Xo.oO.O.- oXo@ .O. .oXoXo@ o-oXoXo @o -. .oO. oXoXo",
"o@oo.O.- o.Oo.o+ . . .X oXoXoXoX .o+oX-oX-.-o+ooO.O. -.O.O.Xo-+o .oo .-.O. . . . .O.- o-.Oo-Xo+oXoXo+o .o-Xo-X- ",
"o X @ oX-X-oX-XoXoX. . .+oO.oXo@o -oOo.Ooo . o+oo-oo- ooXo -Xoo+o- @XoX . .O. @ @ o . @ o-Xo-XoXXXXX .XoXo-Xo-.X",
"O.oXo.Oo-o @ oXoXoX-Xo+oXoX-XX  .oXo.Oo. @oO.-o @ .O.-.Oo@ .o+ooXoXoX-X. . . . oo+o@ .o-o -oXoXoXX .XoX- . oo -X",
"-o+oOo@oX-oXoX-X-o+oX . .X . ..oOo@ . @ -o o-Xo-.O.o o-oXo-Xo -Xo+o+oX . X. .-o+ooXo-oO. .o+o-X-X.XoX . .-Xo-. .",
"Xoo@oOoo-X-o+oXoXo .oXX.X .XX . o. . .o-X-.-ooOoooX-.O. -o -o+oXo .oX-XoXo+o @ o+o-XoOo-. o-Xo oOoX .O. . oXoO.X",
"-XoO.o+o-oXoX- @-X-XX. XoXX .Xo@ . X- . -oOoO.o- @o Xo-. o.XoXo+o@ @ . .O. .Xo-. . -.o+o @XoX-X.oXoX. Xo . oXXXX",
"X-. -o-XoOo@ .-oXoXoXX.XXoX. X . X. .- .o -oo-o-o- . . -XoO. . oXoXo @oX. . oX .O.oX- o.OoXoXo @ @ .O. . .O.XoXo",
" .-Xo+oo+oXo-oXo-X.X . .XXoX.X. . . -.- @o-o-oo-o-o+o+o @ .X +.- @ @oXo+oX.O.o+ooOo-Xo+oo+oX-X. . .O. .XOX. XX-.",
".Oo @oOoo@oO.Oo+ooX. . XoXXXXoXX.XoXo .-o -oo+o-o-oXoXo. -XoXoXoXooX- . . X. . .Oo@ooX- @o o.Oo+oXoXo+oX. X. . @",
"oo@o o.O.Oo.Xo+o-Xo .oooXoXoXXoo Xo @o- -o--o-o- -oO.oOoXo+o+o+o-X- .-XoX.oXX XX. o+oXo. -X- . . @ .XoXoXXX.+oX ",
"+o @oOoo-o -Xo-ooO. - -.o . . . .oXooO.o-oo-o-o . . XoX-oO. . oX .o@ oX-X-XoXX. Xo@ . +oXoXo+o-XoXoX-X-X. . o+oX",
"o@ooO.-X-XoXoO.O.oX-.o -o-Xo.Xoo -oOoo-oo--oOo+oO.O.Xo@ @oXoXo+o.OXo.O. ooXXX. .oXo .-Xo-X-. . .O.XoXo. @ .-XoXo",
"@ -.oOoooO.- o-oo+o o-oX .oXoXX.XoX-.-o-o- o. o-o-ooO. ooXo+ . @ o- -. .XXoXXXoX .XoXoX .OoX- @ . .O.O. o-XoXoX-",
"o-oO.o-X-oOo@X.+oo+. @ .oX @ . - -o-o -o -.O.-X-oOo-Xo@ @ X.Xo+o-X.oX .X XXXoXXXXXX @ -. . -. .o+oXoXoO.+oXo@ -X",
"Oo@oO.Oo-.oOo oXoXoXoo@ .-XoXoX-.o+o-o--o-o Xo-o-o-oXo .XoXoXoo+ooX .XXXX.XXXoXoXX.X .Xo+oXoX-X . .XoXo. .-X .oO",
"oOoo@o-ooO.oX@o+o+oX+ . Xo-oX-. @ o.Oo-o- ..O. -o-o-XX. X.Xo+o+o .O.XXXX X.XoXoXoX XXX . . @ .XoX. +o+oX- .oX-Xo",
".o@ - -X-X @o . . . . .O.O. @ o- .-o-o-o-oOXo-Xo- @ .O.XoXX-Xoo-XoXX XX.XoX ooo- ..XX.XX . .XX.XXX. X.XoXoX-Xo- ",
"O. -oXo-. . o+oXoXXX. -. o.Oo. .-o -o-o-oo. . .O. .oXoX . . -XoXoXXX.X X .oo.- o-o-oX$XX. XXX$XX$XXXXXoX.Oo.-X.-",
" -oo@ - . o@ o-X@ .Xo+oX-X-oX-oX .OoXo-o-Xo+oXoXoXo+oO.Xo+o. -o+oXoX .Xo. - -X-o-o oX XoXX$$$&#$X$X$XXXo .oOoOoX",
"@o-Oo@ -oXOoo+ooXoX-XoX . .OoX-o@ . @ . XoO. @XXXXo-XoXX. X-XoXXXXX.XoX o@ooooo-Xo-. .XXXX$X%#&***$X$. .oO. .-oo",
"  .o+ooX-ooX-oX-o+oo-o-Xo@ooXoX-o @oXoXoXo.OoXoXoXo+o-. X. . Xo.o. oX-.oO XX. -XoXX .XX$XX.$X$****$XXXoXo@o-oX- "};

}
\BGColor {grey45}
\FGColor {white}
\BDColor {grey20}
\
\name	{clock.mesg}
\parent	{clock}
\class	{txtLabel}
\script	{
	switch (arg[0]) {
	case "time":
		return currentLine();
	break;
	case "update":
		set("label", date());
		render();
		return;
	break;
	}
	usual();
}
\label {Tue Feb 18 16:55:16 1992}
\BGColor {grey30}
\FGColor {lightyellow}
\BDColor {grey20}
\font {usual_small}
\maxHeight {17}
\
