/*
 * Copyright 1990 Pei-Yuan Wei.	All rights reserved.
 *
 * Permission to use, copy, and/or distribute for any purpose and
 * without fee is hereby granted, provided that both the above copyright
 * notice and this permission notice appear in all copies and derived works.
 * Fees for distribution or use of this software or derived works may only
 * be charged with express written permission of the copyright holder.
 * This software is provided ``as is'' without express or implied warranty.
 */
/*
 * class	: txtLabel
 * superClass	: txt
 */
#include <stdio.h>
#include <ctype.h>
#include "error.h"
#include "mystrings.h"
#include "hash.h"
#include "ident.h"
#include "obj.h"
#include "packet.h"
#include "class.h"
#include "slotaccess.h"
#include "classlist.h"
#include "cl_txtLabel.h"
#include "misc.h"
#include "glib.h"

SlotInfo cl_txtLabel_NCSlots[] = {
	NULL
};
SlotInfo cl_txtLabel_NPSlots[] = {
{
	NULL
}
};
SlotInfo cl_txtLabel_CSlots[] = {
{
	STR_class,
	PTRS | SLOT_RW,
	(long)"txtLabel"
},{
	STR_classScript,
	PTRS,
	(long)"\n\
		switch (arg[0]) {\n\
		case \"mouseMove\":\n\
		case \"enter\":\n\
		case \"leave\":\n\
		case \"keyPress\":\n\
		case \"keyRelease\":\n\
		case \"buttonPress\":\n\
		case \"buttonRelease\":\n\
		break;\n\
		case \"expose\":\n\
			render();\n\
		break;\n\
		case \"render\":\n\
			render();\n\
		break;\n\
		case \"config\":\n\
			config(arg[1], arg[2], arg[3], arg[4]);\n\
			render();\n\
		break;\n\
		case \"info\":\n\
			info();\n\
		break;\n\
		case \"init\":\n\
			initialize();\n\
		break;\n\
		default:\n\
			print(\"unknown message, clsss = txtLabel: args: \");\n\
			for (i = 0; i < arg[]; i++) print(arg[i], \", \");\n\
			print(\"\n\");\n\
		break;\n\
		}\n\
	",
},{
	NULL
}
};
SlotInfo cl_txtLabel_PSlots[] = {
{
	STR__classInfo,
	CLSI,
	(long)&class_txtLabel
},{
	NULL
}
};

SlotInfo *slots_txtLabel[] = {
	(SlotInfo*)cl_txtLabel_NCSlots,
	(SlotInfo*)cl_txtLabel_NPSlots,
	(SlotInfo*)cl_txtLabel_CSlots,
	(SlotInfo*)cl_txtLabel_PSlots
};

MethodInfo meths_txtLabel[] = {
	/* local methods */
{
	STR_config,
	meth_txtLabel_config,
},{
	STR_get,
	meth_txtLabel_get,
},{
	STR_initialize,
	meth_txtLabel_initialize
},{
	STR_render,
	meth_txtLabel_render
},{
	STR_set,
	meth_txtLabel_set
},{
	NULL
}
};

ClassInfo class_txtLabel = {
	slots_txtLabel,		/* class slot information	*/
	meths_txtLabel,		/* class methods		*/
	STR_txtLabel,		/* class identifier number	*/
	&class_txt,		/* super class info		*/
};

int meth_txtLabel_config(self, result, argc, argv)
	VObj *self;
	Packet *result;
	int argc;
	Packet argv[];
{
	return meth_txt_config(self, result, argc, argv);
}

int meth_txtLabel_get(self, result, argc, argv)
	VObj *self;
	Packet *result;
	int argc;
	Packet argv[];
{
	return meth_txt_get(self, result, argc, argv);
}

int meth_txtLabel_initialize(self, result, argc, argv)
	VObj *self;
	Packet *result;
	int argc;
	Packet argv[];
{
	return meth_txt_initialize(self, result, argc, argv);
}

int meth_txtLabel_render(self, result, argc, argv)
	VObj *self;
	Packet *result;
	int argc;
	Packet argv[];
{
	Window w;

	if (!meth_txt_render(self, result, argc, argv)) return 0;

	if (w = GET_window(self)) {
		char *str = GET_label(self);
		int fontID = GET__font(self);
		if (str) {
			GLDrawText(w, fontID, 
			  (GET_width(self) - GLTextWidth(fontID, str)) / 2,
			  (GET_height(self) - GLTextHeight(fontID, str)) / 2,
			  str);
			return 1;
		}
	}
	return 0;
	
}

/*
 * returns non-zero if set operation succeded, zero otherwise.
 */
int meth_txtLabel_set(self, result, argc, argv)
	VObj *self;
	Packet *result;
	int argc;
	Packet argv[];
{
	return meth_txt_set(self, result, argc, argv);
}



