/*	Macros for general use					HTUtils.h
*/

/* extern void *malloc(size_t size); */

#ifndef HTUTILS_H
#define HTUTILS_H

/*	Debug message control.
*/
#ifdef DEBUG
#define TRACE (WWW_TraceFlag)
#define PROGRESS(str) printf(str)
extern int WWW_TraceFlag;
#else
#define TRACE 0
#define PROGRESS(str) /* nothing for now */
#endif
#define CTRACE if(TRACE)fprintf
#define tfp stdout

/*	Standard C library for malloc() etc
*/
#ifdef vax
#ifdef unix
#define ultrix	/* Assume vax+unix=ultrix */
#endif
#endif

#ifndef VMS
#ifndef ultrix
#ifdef NeXT
#include <libc.h>	/* NeXT */
#endif
#include <stdlib.h>	/* ANSI */
#else
#include <malloc.h>	/* ultrix */
#include <memory.h>
#include <stdio.h>
#endif

#else				/* VMS */
#include <stdio.h>
#include <ctype.h>
#endif

#define PUBLIC			/* Accessible outside this module     */
#define PRIVATE static		/* Accessible only within this module */

#ifdef __STDC__
#define CONST const		/* "const" only exists in STDC */
#define NOPARAMS (void)
#define PARAMS(parameter_list) parameter_list
#define NOARGS (void)
#define ARGS1(t,a) \
  (t a)
#define ARGS2(t,a,u,b) \
  (t a, u b)
#define ARGS3(t,a,u,b,v,c) \
  (t a, u b, v c)
#define ARGS4(t,a,u,b,v,c,w,d) \
  (t a, u b, v c, w d)
#define ARGS5(t,a,u,b,v,c,w,d,x,e) \
  (t a, u b, v c, w d, x e)
#define ARGS6(t,a,u,b,v,c,w,d,x,e,y,f) \
  (t a, u b, v c, w d, x e, y f)
#define ARGS7(t,a,u,b,v,c,w,d,x,e,y,f,z,g) \
  (t a, u b, v c, w d, x e, y f, z g)
#define ARGS8(t,a,u,b,v,c,w,d,x,e,y,f,z,g,s,h) \
  (t a, u b, v c, w d, x e, y f, z g, s h)
#define ARGS9(t,a,u,b,v,c,w,d,x,e,y,f,z,g,s,h,r,i) \
  (t a, u b, v c, w d, x e, y f, z g, s h, r i)

#else  /* not ANSI */

#define CONST
#define NOPARAMS ()
#define PARAMS(parameter_list) ()
#define NOARGS ()
#define ARGS1(t,a) (a) \
  t a;
#define ARGS2(t,a,u,b) (a,b) \
  t a; u b;
#define ARGS3(t,a,u,b,v,c) (a,b,c) \
  t a; u b; v c;
#define ARGS4(t,a,u,b,v,c,w,d) (a,b,c,d) \
  t a; u b; v c; w d;
#define ARGS5(t,a,u,b,v,c,w,d,x,e) (a,b,c,d,e) \
  t a; u b; v c; w d; x e;
#define ARGS6(t,a,u,b,v,c,w,d,x,e,y,f) (a,b,c,d,e,f) \
  t a; u b; v c; w d; x e; y f;
#define ARGS7(t,a,u,b,v,c,w,d,x,e,y,f,z,g) (a,b,c,d,e,f,g) \
  t a; u b; v c; w d; x e; y f; z g;
#define ARGS8(t,a,u,b,v,c,w,d,x,e,y,f,z,g,s,h) (a,b,c,d,e,f,g,h) \
  t a; u b; v c; w d; x e; y f; z g; s h;
#define ARGS9(t,a,u,b,v,c,w,d,x,e,y,f,z,g,s,h,r,i) (a,b,c,d,e,f,g,h,i) \
  t a; u b; v c; w d; x e; y f; z g; s h; r i;

#endif /* __STDC__ (ANSI) */

#ifndef NULL
#define NULL ((void *)0)
#endif

/* Note: GOOD and BAD are already defined (differently) on RS6000 aix */
/* #define GOOD(status) ((status)&1)	 VMS style status: test bit 0	      */
/* #define BAD(status)  (!GOOD(status))	 Bit 0 set if OK, otherwise clear   */

#ifndef BOOLEAN_DEFINED
typedef char	BOOLEAN;		/* Logical value */
#ifndef TRUE
#define TRUE	(BOOLEAN)1
#define	FALSE	(BOOLEAN)0
#endif
#define BOOLEAN_DEFINED
#endif

#ifndef BOOL
#define BOOL BOOLEAN
#endif
#ifndef YES
#define YES (BOOLEAN)1
#define NO (BOOLEAN)0
#endif

#define TCP_PORT 2784		/* Arbitrary value -- should be allocated */

/*	Is character c white space? */

#ifndef NOT_ASCII
#define WHITE(c) (((unsigned char)(c))<=' ')	/* Assumes ASCII but faster */
#else
#define WHITE(c) ( ((c)==' ') || ((c)=='\t') || ((c)=='\n') || ((c)=='\r') )
#endif

#define HT_LOADED (29999)		/* Instead of a socket */

#include "HTString.h"  /* String utilities */

#endif /* HTUTILS_H */

