#include <stdio.h>
#include <ctype.h>
#include "hash.h"
#include "obj.h"
#include "packet.h"
#include "class.h"
#include "slotaccess.h"
#include "mystrings.h"
#include "glib.h"
#include "slib.h"
#include "misc.h"
#include "event.h"
#include "cexec.h"
#include "tfed.h"

/*
 * Used to set num_of_lines without rendering
 * bug: does not take breakc into account 
 */
int scanVerticalMetrics(tf)
	TFStruct *tf;
{
	TFLineNode *currentp;
	TFChar *linep, *tfcp;
	int yoffset, maxFontHeight, maxFontDescent, pwidthlimit;
	int fontID, lfontID = -1;
	int segpx;
	FontInfo *fip;
	int inViewP = 0;
	int old_num_of_lines;

	pwidthlimit = tf->xLR;
	currentp = tf->firstp;
	yoffset = tf->yUL;

	old_num_of_lines = tf->num_of_lines;
	tf->num_of_lines = 0;
	tf->lineNodeCount = 0;
	tf->lineVisibleCount = 0;

	while (currentp) {
		linep = currentp->linep;
		if (!linep) break;

		tf->lineNodeCount++;
		tf->lineVisibleCount++;

		if (currentp == tf->offsetp) inViewP = 1;

		if (!TFCChar(linep)) {
			fip = &fontInfo[TFCFontID(linep)];
			maxFontHeight = currentp->maxFontHeight = 
				fip->maxheight;
			maxFontDescent = currentp->maxFontDescent = 
				fip->descent;
		} else {
			maxFontHeight = 0;
			maxFontDescent = 0;
			currentp->breakc = 1;
			lfontID = -1;
			segpx = tf->xUL;
			for (tfcp = linep; TFCChar(tfcp); ++tfcp) {
				segpx += TFCWidth(tfcp);
				if (segpx > pwidthlimit) {
					if (tfcp > currentp->linep) {
						TFCFlags(tfcp-1) |= MASK_WRAP;
						currentp->breakc++;
						tf->lineVisibleCount++;
					}
					segpx = tf->xUL;
				}
				if (TFCFontID(tfcp) != lfontID) {
					fontID = TFCFontID(tfcp);
					fip = &fontInfo[fontID];
					if (maxFontHeight < fip->maxheight)
						maxFontHeight = fip->maxheight;
					if (maxFontDescent < fip->descent)
						maxFontDescent = fip->descent;
					lfontID = fontID;
				}
			}
			currentp->maxFontHeight = maxFontHeight;
			currentp->maxFontDescent = maxFontDescent;
		}
		if (inViewP) {
			if (yoffset > tf->height) inViewP = 0;
			tf->num_of_lines += 1;
			yoffset += maxFontHeight;
		}
		currentp = currentp->next;
	}
	return 1;
}

