#include <stdio.h>
#include <math.h>
#include "mystrings.h"
#include "hash.h"
#include "ident.h"
#include "obj.h"
#include "glib.h"
#include "packet.h"
#include "class.h"
#include "classlist.h"
#include "loader.h"
#include "cgen.h"
#include "cexec.h"
#include "slotaccess.h"
#include "misc.h"

char *version = "Viola=2.0.4, date=April 4, 1992";
char *usage = {"\
-f			start up viola file (send render message to it).\n\
-i			command interpreter.\n\
-h			print this message.\n\
-path			object file lookup path.\n\
-r			print release info.\n\
-laf		 	look and feel of widgets.\n\
-v			verbose mode.\n\
\n\
(for debugging)\n\
-wt			window tracking.\n\
-pa			print AST.\n\
-pc			print PCode.\n\
-pe			print PCode execution trace.\n\
-ar			argument that is script accessible.\n\
"};

void main(argc, argv)
	int argc;
	char **argv;
{
	HashEntry *entry;
	int i = 0, startWithCommandLineInterpreter = 0;
	char *violaPath = DEFAULT_VIOLA_PATH;

	while (argv[++i]) {
		/*fprintf(stderr, "arg[%d]=%s\n", i, argv[i]);*/

		if (noCaseStrCmp(argv[i], "-f")) {

		} else if (noCaseStrCmp(argv[i], "-i")) {
			startWithCommandLineInterpreter = 1;

		} else if (noCaseStrCmp(argv[i], "-nocliprompt")) {
			extern int flag_cliprompt;
			flag_cliprompt = 0;

		} else if (noCaseStrCmp(argv[i], "-ar")) {
			passthru_argument = argv[++i];

		} else if (noCaseStrCmp(argv[i], "-pa")) {
			flag_printAST = 1;

		} else if (noCaseStrCmp(argv[i], "-pc")) {
			flag_printPCode = 1;

		} else if (noCaseStrCmp(argv[i], "-pe")) {
			flag_printExec = 1;

		} else if (noCaseStrCmp(argv[i], "-release") 
			   || noCaseStrCmp(argv[i], "-r")) {
			fprintf(stderr, "%s\n", version);
			exit(0);

		} else if (noCaseStrCmp(argv[i], "-cmd_history")) {
			cmd_history = 1;

		} else if (noCaseStrCmp(argv[i], "-verbose")
			   || noCaseStrCmp(argv[i], "-v")) {
			verbose = 1;
			
		} else if (noCaseStrCmp(argv[i], "-lookAndFeel")
			   || noCaseStrCmp(argv[i], "-LAF")
			   || noCaseStrCmp(argv[i], "-laf")) {
		
			lookAndFeel = atoi(argv[++i]);
			
		} else if (noCaseStrCmp(argv[i], "-noarg")) {

		} else if (noCaseStrCmp(argv[i], "-wt")) {
			extern int flag_window_tracking;
			flag_window_tracking = 1;

		} else if (noCaseStrCmp(argv[i], "-path")
		           || noCaseStrCmp(argv[i], "-p")) {
			violaPath = argv[++i];

		} else {
			fputs(usage, stderr);
			exit(0);
		}
		if (i >= argc) break;
	}
	/*fprintf(stderr, "2violaPath=%s\n", violaPath ? violaPath : "none");*/
	if (!init_tfed()) exit(1);
	if (!init_sys()) exit(2);
	if (!init_sys()) exit(3);
	if (!init_ident()) exit(4);
	if (!init_class()) exit(5);
	if (!init_obj()) exit(6);
	if (!init_scanutils()) exit(7);
	if (!init_ast()) exit(8);
	if (!init_packet()) exit(9);
	if (!init_glib()) exit(10);
	if (!init_event()) exit(11);
	if (!init_cexec()) exit(12);
	if (!init_html()) exit(13);
	if (!init_loader(violaPath)) exit(14);

	load_object("res.font.v");
	entry = getHashEntry(objID2Obj, storeIdent("res.font"));
	if (!entry) {
		fprintf(stderr, 
			"can't find: font resource file (\"res.font.v\").\n");
		exit(15);
	}
	if (verbose) 
		fprintf(stderr, 
			"loaded: font resource file (\"res.font.v\").\n");

	VFontResourceObj = (VObj*)entry->val;
	if (!init_fonts()) {
		fprintf(stderr, 
			"aborting due to font related problem.\n");
		exit(16);
	}
	if (verbose) 
		fprintf(stderr, 
			"initialized font resources.\n");

	load_object("res.v");
	entry = getHashEntry(objID2Obj, storeIdent("res"));
	if (!entry) {
		fprintf(stderr, "can't find: resource file (\"res.v\").\n");
		exit(17);
	}
	if (!(entry->val)) {
		fprintf(stderr, "can't find: resource file (\"res.v\").\n");
		exit(18);
	}
	VPrevObj = VTargetObj = VResourceObj = VCurrentObj = (VObj*)entry->val;

	if (startWithCommandLineInterpreter) {
		Packet *result = borrowPacket();
		meth_generic_cli(VCurrentObj, result, 0, 0);
		returnPacket();
	}

	sendMessage1(VCurrentObj, "render");

	if (verbose) fprintf(stderr, "entering event loop.\n");

	eventLoop();

	exit(0);
}




