/*
 * Copyright 1990 Pei-Yuan Wei.	All rights reserved.
 *
 * Permission to use, copy, and/or distribute for any purpose and
 * without fee is hereby granted, provided that both the above copyright
 * notice and this permission notice appear in all copies and derived works.
 * Fees for distribution or use of this software or derived works may only
 * be charged with express written permission of the copyright holder.
 * This software is provided ``as is'' without express or implied warranty.
 */
/* 
 * glib_x.c
 */
#include <stdio.h>
#include <ctype.h>
#include <sys/param.h>
#include <sys/types.h>
#include <signal.h>
#include <pwd.h>
/*#include <math.h>*/
#include "mystrings.h"
#include "error.h"
#include "file.h"
#include "hash.h"
#include "ident.h"
#include "obj.h"
#include "packet.h"
#include "slotaccess.h"
#include "vlist.h"
#include "attr.h"
#include "glib.h"
#include "event.h"
#include "xpm.h"
#include "misc.h"

#define RADIAN_TO_DEGREE_RATIO 0.017453293

/****************************************************************************
 * window stuff
 */
Display *display = NULL;
int screen_number;
Window rootWindow;

/****************************************************************************
 * font stuff 
 */
/*
	if F_SLANTED, slant the cursor as well! :-)
	the flags hint font access?
fontInfo = {
{	F_BOLD | F_SLANTED, 
	"-misc-fixed-medium-r-normal-*-10-*-*-*-c-60-iso8859-1",
}
}
*/
char *defaultFonts[] = {
	"-misc-fixed-medium-r-normal-*-10-*-*-*-c-60-iso8859-1",/* 0 */
	"-adobe-*-bold-r-*-*-10-*-*-*-*-*-*-*",			/* 1 */
	"-adobe-*-medium-r-*-*-*-80-*-*-m-*-*-*",		/* 2 */
	"-adobe-*-medium-r-*-*-*-100-*-*-m-*-*-*",		/* 3 */
	"-adobe-*-medium-r-*-*-*-120-*-*-m-*-*-*",		/* 4 */
	"-adobe-*-medium-r-*-*-*-140-*-*-m-*-*-*",		/* 5 */
	"-adobe-*-medium-r-*-*-*-180-*-*-m-*-*-*",		/* 6 */
	"-adobe-*-medium-r-*-*-*-240-*-*-m-*-*-*",		/* 7 */
	"-adobe-*-bold-r-*-*-*-80-*-*-m-*-*-*",			/* 8 */
	"-adobe-*-bold-r-*-*-*-100-*-*-m-*-*-*",		/* 9 */
	"-adobe-*-bold-r-*-*-*-120-*-*-m-*-*-*",		/* 10 */
	"-adobe-*-bold-r-*-*-*-140-*-*-m-*-*-*",		/* 11 */
	"-adobe-*-bold-r-*-*-*-180-*-*-m-*-*-*",		/* 12 */
	"-adobe-*-bold-r-*-*-*-240-*-*-m-*-*-*",		/* 13 */
	"-adobe-*-medium-r-*-*-10-*-*-*-*-*-*-*",		/* 14 */
	"-*-times-medium-r-*-*-34-*-*-*-*-*-*-*",		/* 15 */
	"-*-times-medium-i-*-*-34-*-*-*-*-*-*-*",		/* 16 */
	NULL
};
int numberOfFontIDs = 0;

int fontID_fixed = -1;
int fontID_normal = -1;
int fontID_bold = -1;
int fontID_normal_large = -1;
int fontID_bold_large = -1;
int fontID_normal_largest = -1;
int fontID_bold_largest = -1;

/****************************************************************************
 * color stuff
 */
Colormap colormap;
int numOfDisplayColors;
int FGPixel, BGPixel, BDPixel, InvertPixel;
int DefaultFGPixel, DefaultBGPixel, DefaultBDPixel;
int *colorReferenceTable;

/****************************************************************************
 * GC stuff
 */
GC gc;
GC gc_fg;
GC gc_bg;
GC gc_bd;
GC gc_invert;
GC gc_invert_dash;
GC gc_copy;
GC gc_or;
GC gc_dash;
GC gc_mesh;
GC gc_subWindow;

/****************************************************************************
 * bitmap stuff
 */
Pixmap pixmap = NULL;

#define mesh_width	2
#define mesh_height	2
static char mesh_bits[] = {0x01, 0x02};

static char menuXBM_bits[] = {0x00, 0xff, 0x7f, 0xbe, 0x5c, 0x28, 0x10, 0x00};
Pixmap menuPixmap = NULL;

Pixmap togglePixmap_button0 = NULL;
Pixmap togglePixmap_button1 = NULL;
Pixmap togglePixmap_check0 = NULL;
Pixmap togglePixmap_check1 = NULL;
Pixmap togglePixmap_disc0 = NULL;
Pixmap togglePixmap_disc1 = NULL;

/*
 * toggle button style: boolean -- "0" protruding, "1" protruding
 */
#define toggleXBM_button0_width	16
#define toggleXBM_button0_height 16
static char toggleXBM_button0_bits[] = {
   0xf8, 0x0f, 0x08, 0x18, 0x88, 0x18, 0x88, 0x18, 0x88, 0x18, 0xff, 0x1f,
   0x01, 0x30, 0xe1, 0x70, 0x11, 0x71, 0x11, 0x71, 0x11, 0x71, 0xe1, 0x70,
   0x01, 0x70, 0xff, 0x6f, 0xfe, 0x5f, 0xfc, 0x3f
};
#define toggleXBM_button1_width	16
#define toggleXBM_button1_height 16
static char toggleXBM_button1_bits[] = {
   0xff, 0x1f, 0x01, 0x30, 0x41, 0x70, 0x41, 0x70, 0x41, 0x70, 0x41, 0x70,
   0x41, 0x70, 0x01, 0x70, 0xff, 0x6f, 0x0e, 0x5c, 0xcc, 0x34, 0x28, 0x0d,
   0x28, 0x0d, 0xc8, 0x0c, 0x08, 0x0c, 0xf8, 0x0f
};

/*
 * toggle button style: check -- unchecked box, checked box
 */
#define toggleXBM_check0_width	16
#define toggleXBM_check0_height 16
static char toggleXBM_check0_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x1f, 0x04, 0x10, 0x04, 0x10,
   0x04, 0x10, 0x04, 0x10, 0x04, 0x10, 0x04, 0x10, 0x04, 0x10, 0x04, 0x10,
   0x04, 0x10, 0xfc, 0x1f, 0x00, 0x00, 0x00, 0x00
};
#define toggleXBM_check1_width	16
#define toggleXBM_check1_height 16
static char toggleXBM_check1_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x5f, 0x04, 0x60, 0x04, 0x30,
   0x04, 0x18, 0x04, 0x0c, 0x34, 0x16, 0x64, 0x13, 0xc4, 0x11, 0x84, 0x10,
   0x04, 0x10, 0xfc, 0x1f, 0x00, 0x00, 0x00, 0x00
};

/*
 * toggle button style: disc -- empty circle, filled circle
 */
#define toggleXBM_disc0_width  16
#define toggleXBM_disc0_height 16
static char toggleXBM_disc0_bits[] = {
   0xe0, 0x03, 0x18, 0x0c, 0x04, 0x10, 0x02, 0x20, 0x02, 0x20, 0x01, 0x40,
   0x01, 0x40, 0x01, 0x40, 0x01, 0x40, 0x01, 0x40, 0x02, 0x20, 0x02, 0x20,
   0x04, 0x10, 0x18, 0x0c, 0xe0, 0x03, 0x00, 0x00
};
#define toggleXBM_disc1_width  16
#define toggleXBM_disc1_height 16
static char toggleXBM_disc1_bits[] = {
   0xe0, 0x03, 0x18, 0x0c, 0xe4, 0x13, 0xfa, 0x2f, 0xfa, 0x2f, 0xfd, 0x5f,
   0xfd, 0x5f, 0xfd, 0x5f, 0xfd, 0x5f, 0xfd, 0x5f, 0xfa, 0x2f, 0xfa, 0x2f,
   0xe4, 0x13, 0x18, 0x0c, 0xe0, 0x03, 0x00, 0x00
};

/****************************************************************************
 * XPM stuff
 *
 * need these variables be persistant? investigate later...
 */
typedef struct _XpmIcon {
	Pixmap pixmap;
	Pixmap mask;
	XpmAttributes attributes;
} XpmIcon;
unsigned int xpm_numsymbols = 0; 
XpmColorSymbol xpm_symbols[10];
unsigned long xpm_valuemask = 0;

/* A smugy fingerprint pixmap ... 
 */
int thumbXPM_width;
int thumbXPM_height;
Pixmap thumbXPM;
static char * thumbXPM_src = {"/* XPM */\n\
static char * thumb [] = {\n\
\"16 16 3 1\",\n\
\" 	s None	c None\",\n\
\".	c green\",\n\
\"X	c black\",\n\
\"   ......       \",\n\
\"  .XXXXXX.      \",\n\
\" .X......XX.    \",\n\
\"   XXXXX...X.   \",\n\
\" .X     XX..X.  \",\n\
\"   ....X  XX.X  \",\n\
\" .. XXX...  X.  \",\n\
\" XX    XXXX. X. \",\n\
\".  .XXX    X. X \",\n\
\"  .X   XXX. X.X \",\n\
\"  X  ..   X. X  \",\n\
\" .X .XXX.  X X. \",\n\
\" . .X   X. X. X \",\n\
\" X .X    X. X X \",\n\
\"   .X     X   X \",\n\
\"                \"};\n\
"};

/****************************************************************************
 * cursor stuff
 */
Cursor cursor_arrow;
Cursor cursor_watch;
int mouseCursorIsBusy = 0;

/****************************************************************************
 * styling
 */
int borderStyleThickness[BORDER_STYLE_COUNT]; 



/****************************************************************************
 * procedures
 */

/****************************************************************************
 * procedures
 */

/*
 *
 */
int GLInit()
{
	Screen *screen;
	extern double pow();
	char dash_list[2];
        XGCValues gcvalues;
	int i;

	if (!(display = XOpenDisplay(NULL))) {
		fprintf(stderr, "Can't open display! Aborting.\n");
		return 0;
	}
	/* if (async_event) */
	XSynchronize(display, 1);

	screen_number = DefaultScreen(display);
	screen = ScreenOfDisplay(display, screen_number);
	rootWindow = RootWindow(display, screen_number);

	colormap = XDefaultColormapOfScreen(screen);
	numOfDisplayColors = pow(2.0, ((double)DefaultDepthOfScreen(screen)));
	if (numOfDisplayColors <= 2) {
		/* monochrome display */
		FGPixel = XWhitePixelOfScreen(screen);
		BGPixel = XBlackPixelOfScreen(screen);
		BDPixel = XWhitePixelOfScreen(screen);
	} else {
		/* color display */
		FGPixel = WhitePixel(display, screen_number);
		BGPixel = BlackPixel(display, screen_number);
		BDPixel = WhitePixel(display, screen_number);
	}
	DefaultFGPixel = FGPixel;
	DefaultBGPixel = BGPixel;
	DefaultBDPixel = BDPixel;

	InvertPixel = FGPixel ^ BGPixel;

	/*
	 * make a colormap reference table
	 * table of all colors (by colormap index) allocated by viola
	 */
	colorReferenceTable = (int*)malloc(sizeof(int) * numOfDisplayColors);
	for (i = 0; i < numOfDisplayColors; colorReferenceTable[i++] = 0);

        ++colorReferenceTable[BDPixel];
        ++colorReferenceTable[BGPixel];
        ++colorReferenceTable[FGPixel];

	gc = DefaultGC(display, screen_number);
	XSetState(display, gc, FGPixel, BGPixel, GXcopy, AllPlanes);

	borderStyleThickness[BORDER_NONE] = BORDER_NONE_THICKNESS;
	borderStyleThickness[BORDER_BOX] = BORDER_BOX_THICKNESS;
	borderStyleThickness[BORDER_FIELD] = BORDER_FIELD_THICKNESS;
	borderStyleThickness[BORDER_BUTTON] = BORDER_BUTTON_THICKNESS;
	borderStyleThickness[BORDER_THINBUTTON] = BORDER_THINBUTTON_THICKNESS;
	borderStyleThickness[BORDER_FRAME] = BORDER_FRAME_THICKNESS;
	borderStyleThickness[BORDER_BORDER] = BORDER_BORDER_THICKNESS;
	borderStyleThickness[BORDER_MENU] = BORDER_MENU_THICKNESS;
	borderStyleThickness[BORDER_SUBWINDOW] = BORDER_SUBWINDOW_THICKNESS;

	cursor_arrow = XCreateFontCursor(display, XC_top_left_arrow);
	cursor_watch = XCreateFontCursor(display, XC_watch);

	/* initialze GCs (do only once)
	 */
	gcvalues.foreground = FGPixel;
	gcvalues.background = BGPixel;
	gcvalues.dash_offset = 1;
	gcvalues.line_style = LineOnOffDash;
	dash_list[0] = 1;
	dash_list[1] = 1;
	gc_dash = XCreateGC(display, rootWindow, 
			GCForeground | GCBackground | GCLineStyle |
			GCLineStyle, &gcvalues);

	XSetDashes(display, gc_dash, 2, dash_list, 2);

	/* gc_invert_dash */
	gcvalues.function = GXinvert;
	gcvalues.plane_mask = InvertPixel;
	gc_invert_dash = XCreateGC(display, rootWindow, 
			GCForeground | GCBackground | GCLineStyle |
			GCLineStyle | GCFunction | GCPlaneMask,
			&gcvalues);
	XSetDashes(display, gc_invert_dash, 2, dash_list, 2);

	/* gc_fg */
	gcvalues.foreground = FGPixel;
	gcvalues.background = BGPixel;
	gc_fg = XCreateGC(display, rootWindow, GCForeground | GCBackground, 
			  &gcvalues);

	/* gc_bg */
	gcvalues.foreground = BGPixel;
	gcvalues.background = FGPixel;
	gc_bg = XCreateGC(display, rootWindow, GCForeground | GCBackground, 
			  &gcvalues);

	/* gc_bd */
	gcvalues.foreground = BDPixel;
	gcvalues.background = BGPixel;
	gc_bd = XCreateGC(display, rootWindow, GCForeground | GCBackground, 
			  &gcvalues);

	/* gc_invert */
	gcvalues.function = GXinvert;
	gcvalues.plane_mask = InvertPixel;
	gc_invert = XCreateGC(display, rootWindow, GCFunction | GCPlaneMask, 
			      &gcvalues);

	/* gc_copy */
	gcvalues.foreground = BGPixel;
	gcvalues.background = FGPixel;
	gc_copy = XCreateGC(display,rootWindow, GCForeground | GCBackground,
				&gcvalues);

	/* gc_or */
	gcvalues.foreground = BGPixel;
	gcvalues.background = FGPixel;
	gcvalues.function = GXor;
	gc_or = XCreateGC(display,rootWindow, 
			    GCFunction | GCForeground | GCBackground,
			    &gcvalues);

	/* gc_mesh */
	gcvalues.foreground = FGPixel;
	gcvalues.background = BGPixel;

	gcvalues.fill_style = FillOpaqueStippled;
	gcvalues.stipple = XCreateBitmapFromData(display, rootWindow, 
				mesh_bits, mesh_width, mesh_height);

	gc_mesh = XCreateGC(display, rootWindow, GCForeground | GCBackground |
				GCFillStyle | GCStipple, &gcvalues);

	/* subwindow */
	gcvalues.function = GXinvert;
	gcvalues.plane_mask = InvertPixel;
	gcvalues.subwindow_mode = IncludeInferiors;
	gcvalues.foreground = 1;
	gcvalues.background = 1;
	gcvalues.line_style = LineOnOffDash;
	gc_subWindow = XCreateGC(display, rootWindow,
				 GCFunction | GCPlaneMask | 
				 GCForeground | GCBackground |
				 GCLineStyle | GCSubwindowMode,
				 &gcvalues);

	menuPixmap = XCreateBitmapFromData(display, rootWindow,
			menuXBM_bits, menuPixmap_width, menuPixmap_height);
	togglePixmap_button0 = XCreateBitmapFromData(display, rootWindow,
			toggleXBM_button0_bits, 
			togglePixmap_width, togglePixmap_height);
	togglePixmap_button1 = XCreateBitmapFromData(display, rootWindow,
			toggleXBM_button1_bits, 
			togglePixmap_width, togglePixmap_height);
	togglePixmap_check0 = XCreateBitmapFromData(display, rootWindow,
			toggleXBM_check0_bits, 
			togglePixmap_width, togglePixmap_height);
	togglePixmap_check1 = XCreateBitmapFromData(display, rootWindow,
			toggleXBM_check1_bits, 
			togglePixmap_width, togglePixmap_height);
	togglePixmap_disc0 = XCreateBitmapFromData(display, rootWindow,
			toggleXBM_disc0_bits, 
			togglePixmap_width, togglePixmap_height);
	togglePixmap_disc1 = XCreateBitmapFromData(display, rootWindow,
			toggleXBM_disc1_bits, 
			togglePixmap_width, togglePixmap_height);

	thumbXPM = GLMakeXPMFromASCII(rootWindow, thumbXPM_src, 
				&thumbXPM_width, &thumbXPM_height, 
				&i, &i);

	return 1;
}

int init_fonts()
{
	Attr *attrp;
	char *fontRef, *xspec;
	Packet *pk;

	if (!VFontResourceObj) {
		fprintf(stderr, 
			"init_fonts(): no font resource found\n");
		return 0;
	}
	attrp = GET__varList(VFontResourceObj);
	numberOfFontIDs = 0;
	for (; attrp; attrp = attrp->next) {
		fontRef = (char*)getHashEntry(symID2Str, attrp->id)->val;
		pk = (Packet*)(attrp->val);
		xspec = PkInfo2Str(pk);
		if (xspec[0] != '\0') {
/*			fprintf(stderr, "fontID=%d, vspec=%s, xspec=%s\n", 
			       numberOfFontIDs, fontRef, xspec);
*/
			if (!GLDefineNewFont(fontInfo, numberOfFontIDs, 
					     fontRef, xspec)) {
				fprintf(stderr, 
					"font=%s, ID=%d: using any font...", 
					fontRef, numberOfFontIDs);
				if (!GLDefineNewFont(fontInfo, 
					numberOfFontIDs, fontRef, "*")) {
					fprintf(stderr, "failed.\n");
					return 0;
				} else {
					fprintf(stderr, "done.\n");
				}
			}
			if (!STRCMP(fontRef, "fixed")) {
				fontID_fixed = numberOfFontIDs;
			} else if (!STRCMP(fontRef, "normal")) {
				fontID_normal = numberOfFontIDs;
			} else if (!STRCMP(fontRef, "bold")) {
				fontID_bold = numberOfFontIDs;
			} else if (!STRCMP(fontRef, "normal_large")) {
				fontID_normal_large = numberOfFontIDs;
			} else if (!STRCMP(fontRef, "bold_large")) {
				fontID_bold_large = numberOfFontIDs;
			} else if (!STRCMP(fontRef, "normal_largest")) {
				fontID_normal_largest = numberOfFontIDs;
			} else if (!STRCMP(fontRef, "bold_largest")) {
				fontID_bold_largest = numberOfFontIDs;
			}
			numberOfFontIDs++;
		}
	}
	if (fontID_fixed == -1) {
		fprintf(stderr, 
			"warning: ``fixed'' font not specified.\n");
		fontID_fixed = 0; /*XXX unsafe */
	}
	if (fontID_normal == -1) {
		fprintf(stderr, 
			"warning: ``normal'' font not specified.\n");
		fontID_normal = fontID_fixed;
	}
	if (fontID_bold == -1) {
		fprintf(stderr, 
			"warning: ``bold font not specified.\n");
		fontID_bold = fontID_normal;
	}
	if (fontID_normal_large == -1) {
		fprintf(stderr, 
			"warning: ``normal_large'' font not specified.\n");
		fontID_normal_large = fontID_normal;
	}
	if (fontID_bold_large == -1) {
		fprintf(stderr, 
			"warning: ``bold_large'' font not specified.\n");
		fontID_bold_large = fontID_bold;
	}
	if (fontID_normal_largest == -1) {
		fprintf(stderr, 
			"warning: ``normal_largest'' font not specified.\n");
		fontID_normal_largest = fontID_normal_large;
	}
	if (fontID_bold_largest == -1) {
		fprintf(stderr, 
			"warning: ``bold_largest'' font not specified.\n");
		fontID_bold_largest = fontID_bold_large;
	}
	return 1;
}

/*
** window procedures 
**
*/ 

Window GLOpenWindow(self, x, y, width, height, isGlass)
	VObj *self;
	int x, y, width, height;
	int isGlass;
{
	Window w, parentWindow = NULL;
	int borderThickness;
	XSetWindowAttributes attrs;
	XWMHints hints;
	XClassHint classHints;
	XSizeHints sizeHints;

	if (width == 0) width = 1;
	if (height == 0) height = 1;

	borderThickness = borderStyleThickness[GET_border(self)];

	parentWindow = bossWindow(self);
	if (!parentWindow) parentWindow = rootWindow;

	if (isGlass) {
		w = XCreateWindow(display, parentWindow,
				  x, y, width, height,
				  0,		/* border thickness */
				  0,		/* depth */
				  InputOnly,	/* class */
				  0,		/* visual*/
				  0,
				  0);
	} else {
		attrs.background_pixel = BGPixel;
		attrs.border_pixel = BDPixel;
		attrs.event_mask = StructureNotifyMask | KeyPressMask |
		  		   SubstructureRedirectMask;
		attrs.cursor = NULL;
/*printf("####%s %d %d\n", GET_name(self), BGPixel, BDPixel);*/
		w = XCreateWindow(display, parentWindow,
				  x, y, width, height,
				  borderThickness,
				  CopyFromParent,
				  CopyFromParent, 
				  CopyFromParent, 
				  CWBorderPixel | CWEventMask | CWBackPixel |
				  CWCursor,
				  &attrs);
	}
	if (!w) return 0;

	XStoreName(display, w, GET_name(self));
	hints.input = True;
	hints.flags = InputHint;
	XSetWMHints(display, w, &hints);

	classHints.res_name = classHints.res_class = "Viola";
	XSetClassHint(display, w, &classHints); /* set class name */

	sizeHints.x = x;
	sizeHints.y = y;
	sizeHints.width = width;
	sizeHints.height = height;

/*	sizeHints.min_width = min_width;
	sizeHints.min_height = min_height;
*/
	sizeHints.flags = PPosition | PSize;
	XSetWMNormalHints(display, w, &sizeHints);

	XMapRaised (display, w);

	if (isGlass) {
		XSelectInput(display, w, 
			     KeyPressMask | KeyReleaseMask | 
			     ButtonPressMask | ButtonReleaseMask |
			     PointerMotionMask | PointerMotionHintMask |
			     EnterWindowMask | LeaveWindowMask | 
			     Button1MotionMask | StructureNotifyMask);
	} else {
		XSelectInput(display, w, 
			     KeyPressMask | KeyReleaseMask | 
			     ButtonPressMask | ButtonReleaseMask |
			     PointerMotionMask | PointerMotionHintMask |
			     EnterWindowMask | LeaveWindowMask | 
			     Button1MotionMask | StructureNotifyMask | 
			     ExposureMask | VisibilityChangeMask);
	}

	SET_window(self, w);

	if (!putHashEntry(window2Obj, (int)w, (int)self)) {
		/* error recovery */
	}

	return w;
}

/*
 * closeWindow - look up and destroy the window associated with the object.
 * returns destroyed window if successful.
 * returns NULL if no window found
 */
Window GLCloseWindow(w)
	Window w;
{
	if (w) {
		/* DeleteAssoc(ObjWinAssocList, (char*)w);*/
		XDestroyWindow(display, w);
		return w;
	}
	return 0;
}

int GLDestroyWindow(w)
	Window w;
{
	/* printf("destroyWindow (w = 0x%x = %ld)\n", w, w);*/
	XDestroyWindow(display, w);
	return 1;
}

int GLWindowSize(w, height, width)
	Window w;
	int *height, *width;
{
	XWindowAttributes xwa;

	if (!w) return 0;
	if (XGetWindowAttributes(display, w, &xwa) == 0){
		sprintf(buff, 
			"windowSize(): XGetWindowAttributes() failed.\n");
		messageToUser(NULL, MESSAGE_ERROR, buff);
		*height = *width = 0;
	} else {
		*height = xwa.height;
		*width = xwa.width;
		return 1;
	}
	return 0;
}

int GLClearWindow(w)
	Window w;
{
	XClearWindow(display, w);
	return 1;
}

void GLLowerWindow(w)
	Window w;
{
	XLowerWindow(display, w);
}

void GLRaiseWindow(w)
	Window w;
{
	XRaiseWindow(display, w);
}

int GLSetWindowName(w, windowName)
	Window w;
	char *windowName;
{
	if (XStoreName(display, w, windowName)) return 1;
	return 0;
}

Window GLQueryWindow()
{
	Window rootw, childw, w = rootWindow;
	unsigned int mask;
	int i; /* dummy */

	for (;;) {
		XQueryPointer(display, w, &rootw, &childw, &i, &i, &i, &i, 
				&mask);
		if (!childw) return w;
		w = childw;
	}
}

/*
** cursor
**
*/ 

/*
 * calculate an object's position relative to the root window 
 */
void GLRootPosition(w, root_xp, root_yp)
	Window w;
	int *root_xp, *root_yp;
{
	Window rw, pw, *cw;
	int i;

	/*printf("*in w=%x rx=%d ry=%d\n", w, (int)(*root_xp), (int)(*root_yp));*/
	if (w) {
		unsigned int dum;
		int x, y;

		XQueryTree(display, w, &rw, &pw, &cw, &i);
		XGetGeometry(display, w, &rw, &x, &y, &dum, &dum, &dum, &dum);
		if (pw == rw) {
			*root_xp = x;
			*root_yp = y;
		} else {
			GLRootPosition(pw, root_xp, root_yp);
			*root_xp += x;
			*root_yp += y;
		}
	} else {
		fprintf(stderr, "rootPosition: window == NULL\n");
		*root_xp = 0;
		*root_yp = 0;
	}
	/* printf("*out rx=%d ry=%d\n", (int)(*root_xp), (int)(*root_yp));*/
}

Window GLQueryMouse(w, rootx, rooty, wx, wy)
	Window w;
	int *rootx, *rooty;
	int *wx, *wy;
{
	Window rootw, childw;
	unsigned int mask;

	XQueryPointer(display, w, &rootw, &childw, rootx, rooty, wx, wy, 
			&mask);
			
	return childw;
}
/*
 * 
 */
void GLChangeToBusyMouseCursor(w)
	Window w;
{
	if (mouseCursorIsBusy == 1) return;
	XDefineCursor(display, w, cursor_watch);
	mouseCursorIsBusy = 1;
}

/*
 * 
 */
void GLChangeToNormalMouseCursor(w)
	Window w;
{
	if (mouseCursorIsBusy == 0) return;
	XDefineCursor(display, w, cursor_arrow);
	mouseCursorIsBusy = 0;
}

/*
** line
**
*/
int GLPaintLine(w, gc, x1, y1, x2, y2)
	Window w;
	GC gc;
	int x1, y1, x2, y2;
{
	XDrawLine(display, w, gc, x1, y1, x2, y2);
	return 1;
}

/*
** Rectangle
**
*/

int GLPaintRect(w, gc, x1, y1, x2, y2)
	Window w;
	GC gc;
	int x1, y1, x2, y2;
{
	XPoint pts[5];

	pts[0].x = x1; pts[0].y = y1;
	pts[1].x = x2; pts[1].y = y1;
	pts[2].x = x2; pts[2].y = y2;
	pts[3].x = x1; pts[3].y = y2;
	pts[4].x = x1; pts[4].y = y1;

	XDrawLines(display, w, gc, pts, 5, CoordModeOrigin);
	return 1;
}

/*
 * paints the rectangle with opposite corners (x0,y0) and (x1,y1)
 * to background in w. 
 */
int GLPaintFillRect(w, gc, x0, y0, x1, y1)
	Window w;
	GC gc;
	int x0, y0, x1, y1;
{
	XFillRectangle(display, w, gc, x0, y0, x1 - x0 + 1, y1 - y0 + 1);
	return 1;
}

/*
** circle/oval
**
*/

int GLPaintOval(w, gc, x, y, width, height)
	Window w;
	GC gc;
	int x, y, width, height;
{
	XDrawArc(display, w, gc, x, y, width, height, 90 * 64, 360 * 64);
	return 1;
}

int GLPaintFillOval(w, gc, x, y, width, height)
	Window w;
	GC gc;
	int x, y, width, height;
{
	XFillArc(display, w, gc, x, y, width, height, 90 * 64, 360 * 64);
	return 1;
}

/*
** text
**
*/

int GLDefineNewFont(fontInfo, id, fontReferenceName, fontPatternName)
	FontInfo *fontInfo;
	int id;
	char *fontReferenceName;
	char *fontPatternName;
{
	Font font;
	int i;
	char **clist;

	if (id < 0 || id >= MAXFONTS) {
		sprintf(buff, "GLDefineNewFont: Illegal font number %d.\n",
			id);
		messageToUser(NULL, MESSAGE_ERROR, buff);
		return 0;
	}
	/* first see if the font is already loaded, to reduce X calls */
/*

- for fonts, don't load until actually needed...
- also, check to see if the font is already loaded under another name...

	for (i = 0; i < numberOfFontIDs; i++) {
	}
*/
	clist = XListFonts(display, fontPatternName, 1, &i);
	if (i > 0) {
		if (font = XLoadFont(display, clist[0])) {
			FontFont(id) = font;
			FontRef(id) = fontReferenceName;
			FontSpec(id) = SaveString(clist[0]);
			GLUpdateFontInfo(fontInfo, id);
			XFreeFontNames(clist);
			return 1;
		}
		XFreeFontNames(clist);
	}
	sprintf(buff, "couldn't load any font matching \"%s\"\n", fontPatternName);
	messageToUser(NULL, MESSAGE_WARNING, buff);
	return 0;
}

int GLUpdateFontInfo(fontInfo, id)
	FontInfo *fontInfo;
	int id;
{
	static XFontStruct *xfontStruct = NULL;
	int i;

	if (id < 0 || id >= MAXFONTS || (FontFont(id)) == NULL) {
		sprintf(buff, "setFontInfo(id=%d): Invalid font id.\n", id);
		messageToUser(NULL, MESSAGE_ERROR, buff);
		return 0;
	}
	xfontStruct = XQueryFont(display, FontFont(id));
	if (!xfontStruct) return 0;

	FontFontStruct(id) = xfontStruct;
	FontMaxWidth(id) = xfontStruct->max_bounds.width;
	/** is this correct? Check on cheat **/
	FontMaxHeight(id) = xfontStruct->ascent + xfontStruct->descent; 
	FontDescent(id) = xfontStruct->descent;

	if (!FontWidths(id))
		FontWidths(id) = (short*)malloc(sizeof(short) * 128);
	if (!FontWidths(id)) return 0;

	if (xfontStruct->per_char) {
		for (i = 0; i < xfontStruct->min_char_or_byte2; i++) {
				FontWidths(id)[i] = 0;
/*				printf("[%d,?,0] ", i);*/
		}
		for (; i < 128; i++) {
			if (isprint((char)i)) {
				FontWidths(id)[i] = xfontStruct->per_char[i -
					xfontStruct->min_char_or_byte2].width;
/*				printf("(%d,%c,%d) ", 
					(int)i, i, FontWidths(id)[i]);
*/
			} else {
				FontWidths(id)[i] = 0;
/*				printf("(%d,?,0) ", i);*/
			}
		}
	} else {
		for (i = 0; i < 128; i++)
			FontWidths(id)[i] = xfontStruct->min_bounds.width;
		/*printf("fixed width = %d", FontWidths(id)[0]);*/
	}
/*	printf("\n");*/

	/*FontDescent(id) = FontDescent(id) = fontStruct->max_bounds.descent;*/
	/*XFreeFontNames(clist);*/

	return 1;
}

/* currently assumes that all fonts are of equal width */
int GLTextWidth(fontID, str)
	int fontID;
	char *str;
{
	return XTextWidth(FontFontStruct(fontID), str, strlen(str));
}

int GLTextHeight(fontID, str)
	int fontID;
	char *str;
{
	return FontMaxHeight(fontID);
}

int GLPaintText(w, gc, fontID, x0, y0, str)
	Window w;
	GC gc;
	int fontID;
	int x0, y0;
	char *str;
{
	XTextItem item;
	item.chars = str;
	item.nchars = strlen(str);
	item.delta = 0;
	item.font = FontFont(fontID);

	XDrawText(display, w, gc, x0, 
		y0 + FontMaxHeight(fontID) - FontDescent(fontID),
		&item, 1);
	return 1;
}

int GLPaintTextLength(w, gc, fontID, x0, y0, str, length)
	Window w;
	GC gc;
	int fontID;
	int x0, y0;
	char *str;
	int length;
{
	XTextItem item;
	item.chars = str;
	item.nchars = length;
	item.delta = 0;
	item.font = FontFont(fontID);

	XDrawText(display, w, gc, x0, 
		  y0 + FontMaxHeight(fontID) - FontDescent(fontID), &item, 1);
	return 1;
}

/*
** bitmap
**
*/
Pixmap GLMakeXBMFromASCII(w, bitmapStr, width, height, hotx, hoty)
	Window w;
	char *bitmapStr;
	int *width, *height, *hotx, *hoty;
{
	Pixmap bitmap;
	char *data;
	FILE bitmapfd;

#ifdef SYSV
	bitmapfd._cnt = strlen(bitmapStr);
	bitmapfd._base = bitmapfd._ptr = bitmapStr;
	bitmapfd._flag = stdin->_flag;
	bitmapfd._file = _NFILE;
	_bufend(&bitmapfd) = bitmapStr + bitmapfd._cnt;
#else
	bitmapfd._cnt = bitmapfd._bufsiz = strlen(bitmapStr);
	bitmapfd._base = bitmapStr;
	bitmapfd._ptr = bitmapStr;
	bitmapfd._flag = stdin->_flag;
	bitmapfd._file = _IOREAD | _IOSTRG;
#endif

	if (XmuReadBitmapData(&bitmapfd, &width, &height, &data,
				&hotx, &hoty) == BitmapSuccess) {
		bitmap = XCreateBitmapFromData(display, w, data,
				(unsigned int)width, (unsigned int)height);
		return bitmap;
	}
	return 0;
}
Pixmap GLMakeXPMFromASCII(w, bitmapStr, width, height, hotx, hoty)
	Window w;
	char *bitmapStr;
	int *width, *height, *hotx, *hoty;
{
	static char *tmpFile = NULL;
	XpmIcon view;
	int status;

	if (!tmpFile) {
		/* should be able to avoid this kludge soon, when 
		 * XPM functions take as data string or file pointer...
		 */
		tmpFile = saveString("/usr/tmp/violaXXXXXX");
		mktemp(tmpFile);
	}
	if (saveFile(tmpFile, bitmapStr) != 0) return 0;
	view.attributes.colorsymbols = xpm_symbols;
	view.attributes.numsymbols = xpm_numsymbols;
	view.attributes.valuemask = xpm_valuemask;
	view.attributes.valuemask |= XpmReturnInfos;
	view.attributes.valuemask |= XpmReturnPixels;
	view.attributes.colorTable = 0;
	view.attributes.hints_cmt = 0;
	view.attributes.colors_cmt = 0;
	view.attributes.pixels_cmt = 0;
	view.attributes.pixels = 0;
	view.attributes.x_hotspot = 0;
	view.attributes.x_hotspot = 0;
	status = XpmReadFileToPixmap(display, w, tmpFile, &view.pixmap, 
					&view.mask, &view.attributes);
	unlink(tmpFile);
	if (status != XpmSuccess) return 0;
	*width = view.attributes.width; 
	*height = view.attributes.height;
	*hotx = view.attributes.x_hotspot;
	*hoty = view.attributes.x_hotspot;

	return view.pixmap;
}

int GLDisplayXBMFromASCII(w, x, y, bitmapStr)
	Window w;
	int x, y;
	char *bitmapStr;
{
	Pixmap bitmap;
	int width, height, hotx, hoty;

	if (!w || !bitmapStr) return 0;

	bitmap = GLMakeXBMFromASCII(w, bitmapStr, &width, &height, &hotx, &hoty);
	if (!bitmap) return 0;
	XSetBackground(display, gc_fg, BGPixel); /* this is convoluted */
	XCopyPlane(display, bitmap, w, gc_fg, 0, 0, 
			width, height, x, y, (unsigned long)1);
	return 1;
}

int GLDisplayXPMFromASCII(w, x, y, bitmapStr)
	Window w;
	int x, y;
	char *bitmapStr;
{
	Pixmap bitmap;
	int width, height, hotx, hoty;

	if (!w || !bitmapStr) return 0;

	bitmap = GLMakeXPMFromASCII(w, bitmapStr, &width, &height, &hotx, &hoty);
	if (!bitmap) return 0;
	XCopyPlane(display, bitmap, w, gc_fg, 0, 0, 
			width, height, x, y, (unsigned long)1);
	return 1;
}

int GLDisplayXBM(w, x, y, width, height, bitmap)
	Window w;
	int x, y, width, height;
	Pixmap bitmap;
{
	if (!w || !bitmap) return 0;

	XSetBackground(display, gc_fg, BGPixel); /* this is convoluted */
	XCopyPlane(display, bitmap, w, gc_fg, 0, 0, width, height,
			x, y, (unsigned long)1);
	return 1;
}

int GLDisplayXPM(w, x, y, width, height, bitmap)
	Window w;
	int x, y, width, height;
	Pixmap bitmap;
{
	if (!w || !bitmap) return 0;
/*	XCopyPlane(display, bitmap, w, gc_fg, 0, 0, width, height,
			x, y, (unsigned long)1);
*/
	XSetWindowBackgroundPixmap(display, w, bitmap);
	return 0;
}

int GLFreeXBM(bitmap)
	Pixmap bitmap;
{
	XFreePixmap(display, bitmap);
}

int GLFreeXPM(bitmap)
	Pixmap bitmap;
{
/*	XFreePixmap(display, bitmap);*/
	return 0;
}

XImage *GLReadBitmapImage (w, image, filename)
	Window w;
	XImage *image;
	char *filename;
{
	unsigned int width, height;
	int x_hot, y_hot;
	char *data;

	if (XmuReadBitmapDataFromFile(filename, &width, &height, &data, 
					&x_hot, &y_hot)) {
		sprintf(buff, 
			"XmuReadBitmapDataFromFile(\"%s\",...) failed.\n",
			filename);
		messageToUser(NULL, MESSAGE_ERROR, buff);
		return 0;
	}
	pixmap = XCreateBitmapFromData(display, w, (char *)data, 
				 (unsigned int)width, (unsigned int)height);
	image->format = XYBitmap;
	image->width = width;
	image->height = height;
	image->bytes_per_line = (width + 7) / 8;
	return image;
}

/*
** widget drawings
**
*/
void GLDrawBorder(w, x1, y1, x2, y2, style)
	Window w;
	int x1, y1, x2, y2;
	int style;
{
	switch(style){
	case BORDER_NONE:
	case BORDER_BORDER:
	case BORDER_FIELD:
	break;

	case BORDER_MENU:
	case BORDER_BUTTON: {

/*
		XPoint *pts[5];

		pts[0].x = x1+1;	pts[0].y = y2-2;
		pts[1].x = x2-1; 	pts[1].y = y2-2;
		pts[2].x = x2-2;	pts[2].y = y2-2;
		pts[3].x = x2-1;	pts[3].y = y2-1;
		pts[4].x = x1+1;	pts[4].y = y2-2;

		XDrawLines(display, w, gc_dash, pts, 5, CoordModeOrigin);

		XDrawLine(display, w, gc_bd, 
x1+1, y1+1, x2-2, y1+1); 
x1+1, y1+1, x1+1, y2-2); 
x1, y1, x2, y1); 
x1, y1, x1, y2); 
*/
/*
		XSetForeground(display, gc_dash, BDPixel);
		XDrawLine(display, w, gc_bd, x1, y1, x2-1, y1);
		XDrawLine(display, w, gc_bd, x1+1, y1+1, x2-2, y1+1);

		XDrawLine(display, w, gc_dash, x1+1, y2-2, x2-1, y2-2);
		XDrawLine(display, w, gc_dash, x1, y2-1, x2-1, y2-1);

		XDrawLine(display, w, gc_bd, x1, y1, x1, y2-1);
		XDrawLine(display, w, gc_bd, x1+1, y1+1, x1+1, y2-2);

		XDrawLine(display, w, gc_dash, x2-2, y1+1, x2-2, y2-2);
		XDrawLine(display, w, gc_dash, x2-1, y1, x2-1, y2-1);
*/
		XSetForeground(display, gc_mesh, BDPixel);
		XSetBackground(display, gc_mesh, BGPixel);
		XDrawRectangle(display, w, gc_mesh, x1, y2-2, x2-x1-2, 1);
		XDrawRectangle(display, w, gc_mesh, x2-2, y1, 1, y2-y1-2);
		XDrawLine(display, w, gc_bd, x1, y1, x2-1, y1);
		XDrawLine(display, w, gc_bd, x1+1, y1+1, x2-2, y1+1);
		XDrawLine(display, w, gc_bd, x1, y1, x1, y2-1);
		XDrawLine(display, w, gc_bd, x1+1, y1+1, x1+1, y2-2);
	} break;

	case BORDER_THINBUTTON: {
		XSetForeground(display, gc_dash, BDPixel);
		XDrawLine(display, w, gc_bd, x1, y1, x2-1, y1);
		XDrawLine(display, w, gc_dash, x1, y2-1, x2-1, y2-1);
		XDrawLine(display, w, gc_bd, x1, y1, x1, y2-1);
		XDrawLine(display, w, gc_dash, x2-1, y1, x2-1, y2-1);
	} break;
		
	case BORDER_SUBWINDOW:
		XDrawLine(display, w, gc_subWindow, x1, y1, x2, y1);
		XDrawLine(display, w, gc_subWindow, x1, y1, x1, y2);
		XDrawLine(display, w, gc_subWindow, x1 - 1, y2, x2 - 1, y2);
		XDrawLine(display, w, gc_subWindow, x2, y1 - 1, x2, y2 - 1);
	break;

	default:
	case BORDER_BOX:
		XDrawLine(display, w, gc_bd, x1, y1, x2, y1);
		XDrawLine(display, w, gc_bd, x1, y1, x1, y2);
		XDrawLine(display, w, gc_bd, x1 - 1, y2, x2 - 1, y2);
		XDrawLine(display, w, gc_bd, x2, y1 - 1, x2, y2 - 1);
	break;
	}
}

void GLEraseBorder(w, x1, y1, x2, y2, style)
	Window w;
	int x1, y1, x2, y2;
	int style;
{

	switch (style) {
	case BORDER_FIELD: 
	case BORDER_BORDER:
	case BORDER_NONE:
	break;

	case BORDER_BUTTON: {
		XDrawLine(display, w, gc_bg, x1, y1, x2-1, y1);
		XDrawLine(display, w, gc_bg, x1+1, y1+1, x2-2, y1+1);

		XDrawLine(display, w, gc_bg, x1+1, y2-2, x2-1, y2-2);
		XDrawLine(display, w, gc_bg, x1, y2-1, x2-1, y2-1);

		XDrawLine(display, w, gc_bg, x1, y1, x1, y2-1);
		XDrawLine(display, w, gc_bg, x1+1, y1+1, x1+1, y2-2);

		XDrawLine(display, w, gc_bg, x2-2, y1+1, x2-2, y2-2);
		XDrawLine(display, w, gc_bg, x2-1, y1, x2-1, y2-1);
	}
	break;

	default:
	case BORDER_BOX:
		XDrawLine(display, w, gc_bd, x1, y1, x2, y1);
		XDrawLine(display, w, gc_bd, x1, y1, x1, y2);
		XDrawLine(display, w, gc_bd, x1 - 1, y2, x2 - 1, y2);
		XDrawLine(display, w, gc_bd, x2, y1 - 1, x2, y2 - 1);
	break;
	}
}

int GLDrawRubberFrame(w, x1, y1, x2, y2)
	Window w;
	int x1, y1, x2, y2;
{
	XDrawLine(display, w, gc_subWindow, x1, y1, x2, y1);
	XDrawLine(display, w, gc_subWindow, x1, y1, x1, y2);
	XDrawLine(display, w, gc_subWindow, x1, y2, x2, y2);
	XDrawLine(display, w, gc_subWindow, x2, y1, x2, y2);
	return 1;
}

void GLDrawScrollBarH(w, widith, start, end, thickness)
	Window w;
	int widith, start, end, thickness;
{
/*	XClearWindow(display, w);*/
/*
	XFillRectangle(display, w, gc_fg, x1 + 2, y1 + 2, x2 - x1 - 2, 
			y2 - y1 - 2);
	XDrawLine(display, w, gc_bd, x1, y1, x2-1, y1);
	XDrawLine(display, w, gc_bd, x1+1, y1+1, x2-2, y1+1);
	XDrawLine(display, w, gc_bd, x1, y1, x1, y2-1);
	XDrawLine(display, w, gc_bd, x1+1, y1+1, x1+1, y2-2);
	XSetForeground(display, gc_dash, BDPixel);
	XDrawLine(display, w, gc_dash, x1+1, y2-2, x2-1, y2-2);
	XDrawLine(display, w, gc_dash, x1, y2-1, x2-1, y2-1);
	XDrawLine(display, w, gc_dash, x2-2, y1+1, x2-2, y2-2);
	XDrawLine(display, w, gc_dash, x2-1, y1, x2-1, y2-1);
*/
}
/*XXXXX use stippled rectangle for dashing... */
void GLDrawScrollBarV(w, height, start, end, thickness)
	Window w;
	int height, start, end, thickness;
{
	if (BDPixel == BGPixel) {
		XSetForeground(display, gc_dash, FGPixel);
		XSetBackground(display, gc_dash, BGPixel);
		XSetForeground(display, gc_bd, FGPixel);
	} else {
		XSetForeground(display, gc_dash, BDPixel);
	}

	XFillRectangle(display, w, gc_fg, 3, start, thickness-5, end-start+1);
	XFillRectangle(display, w, gc_bg, 0, 0, thickness, start);
	XFillRectangle(display, w, gc_bg, 0, end+1, thickness, height-end);

	/* clear background for the dash lines...*/
/*	XFillRectangle(display, w, gc_bg, thickness-2, start, 3, end-start);
	if (lookAndFeel == LAF_VIOLA || 
	    lookAndFeel == LAF_OPENL || 
	    lookAndFeel == LAF_MOTIF)
*/
	if (lookAndFeel != LAF_BARE) {

		/* outer top */
		XDrawLine(display, w, gc_bd, 1, start, thickness-1, start);
		/* inner top */
		XDrawLine(display, w, gc_bd, 2, start+1, thickness-2, start+1);

		/* outer bottom */
		XDrawLine(display, w, gc_dash, 1, end, thickness-1, end);
		/* inner bottom */
		XDrawLine(display, w, gc_dash, 2, end-1, thickness-2, end-1);

		/* outer left */
		XDrawLine(display, w, gc_bd, 1, start, 1, end);
		/* inner left */
		XDrawLine(display, w, gc_bd, 2, start, 2, end-1);

		/* outer right */
		XDrawLine(display, w, gc_dash, thickness-1, start, 
				thickness-1, end);
		/* inner right */
		XDrawLine(display, w, gc_dash, thickness-2, start+1, 
				thickness-2, end-1);

		XSetForeground(display, gc_dash, FGPixel);
		/* outer right (background) */
		XDrawLine(display, w, gc_dash, thickness-1, start+1, 
				thickness-1, end-1);
		/* inner right (background) */
		XDrawLine(display, w, gc_dash, thickness-2, start+2, 
				thickness-2, end-1);
		/* outer bottom (background) */
		XDrawLine(display, w, gc_dash, 2, end, thickness-1, end);

	}
}

/*
** widget geometry
**
*/

void GLUpdateGeometry(parentWindowIsRoot, w, x, y, width, height)
	int parentWindowIsRoot;
	Window w;
	int x, y, width, height;
{
	if (!w) return;
	/*
	 * this is so that moving/resizing object (by altering param) won't 
	 * cause ConfigRequest event to be sent (events will cause invoke 
	 * resizing methods)
	 */
	if (parentWindowIsRoot) {
		XWindowChanges wc;

		wc.x = x;
		wc.y = y;
		wc.width = width;
		wc.height = height - 20;
		if (wc.height <= 1) wc.height = 2;
		if (wc.width <= 1) wc.width = 2;

		if (verbose) 
			fprintf(stderr, 
				"GLUpdateGeometry 1: rootP=1, %d %d %d %d\n",
				x, y, width, height);

		XConfigureWindow(display, w, 
				 CWX | CWY | CWWidth | CWHeight,
				 &wc);
	} else {
		XSetWindowAttributes attrs;

		attrs.override_redirect = True; 
		if (width <= 1 || height <= 1) {
			printf("GLUpdateGeometry, width or height <= 1!\n");
			return;
		}
		if (verbose) 
			fprintf(stderr, 
				"GLUpdateGeometry rootP=0, %d %d %d %d\n", 
				x, y, width, height);

		XChangeWindowAttributes(display, w, CWOverrideRedirect,&attrs);
		XMoveResizeWindow(display, w, x, y, width, height);
		attrs.override_redirect = False; 
		XChangeWindowAttributes(display, w, CWOverrideRedirect,&attrs);
	}
}

void GLUpdatePosition(parentWindowIsRoot, w, x, y)
	int parentWindowIsRoot;
	Window w;
	int x, y;
{
	if (parentWindowIsRoot) {
		XSetWindowAttributes attrs;

		attrs.override_redirect = True; 
		XChangeWindowAttributes(display, w, CWOverrideRedirect,&attrs);
		XMoveWindow(display, w, x, y);
		attrs.override_redirect = False; 
		XChangeWindowAttributes(display, w, CWOverrideRedirect,&attrs);
	} else {
		XWindowChanges wc;

		wc.x = x;
		wc.y = y;
		XConfigureWindow(display, w, CWX | CWY, &wc);
	}
}

/*
** widget color
**
*/

ColorInfo *GLInitColorInfo()
{
	ColorInfo *colorInfo;

	if (colorInfo = (ColorInfo*)malloc(sizeof(struct ColorInfoStruct))) {
		colorInfo->fg.name = 
			colorInfo->bg.name = 
				colorInfo->bd.name = NULL;
		colorInfo->fg.xcolor.pixel = 
			colorInfo->bg.xcolor.pixel = 
				colorInfo->bd.xcolor.pixel = -1;
	}
	return colorInfo;
}

int GLSetColor(color, colorname, defaultColorName, defaultPixel)
	struct ColorStruct *color;
	char *colorname;
	char *defaultColorName;
	long defaultPixel;
{
	XColor exactcolor;
	long oldIndex;

	oldIndex = color->xcolor.pixel;

	if (AllBlank(colorname)) {
		if (color->name) free(color->name);
		color->name = SaveString(defaultColorName);
		color->xcolor.pixel = defaultPixel;
		GLUpdateColorReference(oldIndex, color->xcolor.pixel);
		return 1;
	}
	if (isdigit(*colorname)) {
		/* color name should be of RGB format "<r> <g> <b>" 
		 * in percentages, ie: "100 0 0" for red.
		 */
		extractWord(colorname, 1, 1, buff);
		color->xcolor.red = atoi(buff) * 650;
		extractWord(colorname, 2, 2, buff);
		color->xcolor.green = atoi(buff) * 650;
		extractWord(colorname, 3, 3, buff);
		color->xcolor.blue = atoi(buff) * 650;

		color->xcolor.flags = DoRed | DoGreen | DoBlue;

		if (XAllocColor(display, colormap, &(color->xcolor))) {
			if (color->name) free(color->name);
			color->name = SaveString(colorname);
			GLUpdateColorReference(oldIndex, color->xcolor.pixel);
			return 1;
		}
	} else {
		if (XAllocNamedColor(display, colormap, colorname, 
			 &(color->xcolor), &exactcolor)) {
			if (color->name) free(color->name);
			color->name = SaveString(colorname);
			GLUpdateColorReference(oldIndex, color->xcolor.pixel);
			return 1;
		}
	}

	sprintf(buff, "failed to allocate '%s' color. setting to default background color\n", colorname);
	messageToUser(NULL, MESSAGE_WARNING, buff);

	if (color->name) free(color->name);
	color->name = SaveString(defaultColorName);
	color->xcolor.pixel = defaultPixel;
	GLUpdateColorReference(oldIndex, color->xcolor.pixel);

	return 0;
}

int GLSetBDColor(self, colorname)
	VObj *self;
	char *colorname;
{
	ColorInfo *colorInfo = GET__colorInfo(self);

	if (!colorInfo) return 0;
	if (!GLSetColor(&(colorInfo->bd), colorname, BD_COLOR, DefaultBDPixel))
		return 0;

	return 1;
}

int GLSetBGColor(self, colorname)
	VObj *self;
	char *colorname;
{
	Window w = GET_window(self);
	ColorInfo *colorInfo = GET__colorInfo(self);

	if (!colorInfo) return 0;
	if (!GLSetColor(&(colorInfo->bg), colorname, BG_COLOR, DefaultBGPixel))
		return 0;
	if (w) XSetWindowBackground(display, w, colorInfo->bg.xcolor.pixel);

	return 1;
}

int GLSetFGColor(self, colorname)
	VObj *self;
	char *colorname;
{
	ColorInfo *colorInfo = GET__colorInfo(self);

	if (!colorInfo) return 0;
	if (!GLSetColor(&(colorInfo->fg), colorname, FG_COLOR, DefaultFGPixel))
		return 0;

	return 1;
}

char *GLGetBDColor(self)
	VObj *self;
{
	ColorInfo *colorInfo = GET__colorInfo(self);
	return colorInfo->bd.name;
}
char *GLGetBGColor(self)
	 VObj *self;
{
	ColorInfo *colorInfo = GET__colorInfo(self);
	return colorInfo->bg.name;
}

char *GLGetFGColor(self)
	VObj *self;
{
	ColorInfo *colorInfo = GET__colorInfo(self);
	return colorInfo->fg.name;
}

ColorInfo *GLPrepareObjColor(self)
	VObj *self;
{
	ColorInfo *colorInfo = GET__colorInfo(self);

	if (!colorInfo) return NULL;

	BDPixel = colorInfo->bd.xcolor.pixel;
	BGPixel = colorInfo->bg.xcolor.pixel;
	FGPixel = colorInfo->fg.xcolor.pixel;

	/* sigh... this isn't right. */
	XSetForeground(display, gc_bd, BDPixel);
	XSetForeground(display, gc_bg, BGPixel);
	XSetForeground(display, gc_fg, FGPixel);
	XSetForeground(display, gc_dash, FGPixel);
	XSetForeground(display, gc_mesh, BDPixel);
	XSetForeground(display, gc_copy, FGPixel);

	if (numOfDisplayColors > 2) return colorInfo;

	/*
	 * precaution against displaying foreground to be same as 
	 * background color.
	 */
	if (colorInfo->fg.xcolor.pixel == colorInfo->bg.xcolor.pixel)
		if (STRCMP(colorInfo->fg.name, colorInfo->bg.name))
			if (colorInfo->fg.xcolor.pixel == DefaultFGPixel)
				colorInfo->fg.xcolor.pixel = DefaultBGPixel;
			else
				colorInfo->fg.xcolor.pixel = DefaultFGPixel;

	return colorInfo;
}

void GLDumpColorRef()
{
	int i;
	
	for (i = 0; i < numOfDisplayColors; i++)
		printf("%d: %d\n", i, colorReferenceTable[i]);
}

/*
 * keep count of color 
 * if the object's current color is no longer needed 
 */
void GLUpdateColorReference(oldColorIndex, newColorIndex)
	 long oldColorIndex, newColorIndex;
{
	if (oldColorIndex != -1) --colorReferenceTable[oldColorIndex];
	++colorReferenceTable[newColorIndex];

	if (oldColorIndex != -1) {
		if (colorReferenceTable[oldColorIndex] <= 0) {
			long pixarray[1];

			/*
			 * since no other viola object is using this colormap
			 * entry, try to free it, so other applications or 
			 * future viola objects can use it.
			 */
			pixarray[0] = oldColorIndex;
/*			XFreeColors(display, colormap, pixarray, 1, 
					(unsigned long)0);
			printf("freed %ld\n", oldColorIndex);
*/
		}
	}
}

/*
** renounce selection duty
**
*/
void GLClearSelection()
{
	extern VObj *xselectionObj;

	if (xselectionObj) {
/*		printf("GLClearSelection: %s\n", GET_name(xselectionObj));*/
		sendMessage1(xselectionObj, "clearSelection");
	} else {
		if (sharedSelectionBuffer) free(sharedSelectionBuffer);
		sharedSelectionBuffer = NULL;
	}
	XSetSelectionOwner(display, XA_PRIMARY, None, CurrentTime);
}

/*
** get content of the X cut buffer
*/
int GLGetSelection(result)
	Packet *result;
{
	extern VObj *xselectionObj;
	int n;

/*	printf("GLGetSelection: %s\n", GET_name(xselectionObj));*/
	if (xselectionObj) {
		return callMeth(xselectionObj, result, 0, NULL, 
				STR__getSelection);
	}
	if (sharedSelectionBuffer) {
		result->info.s = sharedSelectionBuffer;
		result->type = PKT_STR;
		return 1;
	}
	result->info.s = XFetchBuffer(display, &n, 0);
	result->type = PKT_STR;
	return 1;
}

/*
** set cut buffer
**
*/
int GLSetSelection(self, val)
	VObj *self;
	char *val;
{
	extern VObj *xselectionObj;
	Window w = GET_window(self);

	xselectionObj = self;
	if (val) {
		if (sharedSelectionBuffer) free(sharedSelectionBuffer);
		sharedSelectionBuffer = val;
	} else {
		if (w) {
/*		printf("GLSetSelection: %s\n", GET_name(xselectionObj));*/
			XSetSelectionOwner(display, XA_PRIMARY, w, 
						CurrentTime);
			return 1;
		} else {
			xselectionObj = NULL;
			XSetSelectionOwner(display, XA_PRIMARY, None, 
						CurrentTime);
			return 0;
		}
	}
}


