/*
 * event_x.c
 */
#include "X11/Xlib.h"
#include "X11/Xmu/Xmu.h"
#include "X11/cursorfont.h"
#include "X11/keysym.h"
#include "X11/keysymdef.h"
#include <sys/param.h>
#include <sys/types.h>
#include <signal.h>
#include <sys/time.h>
#include <pwd.h>
#include <stdio.h>
#include <ctype.h>
#include "mystrings.h"
#include "error.h"
#include "hash.h"
#include "ident.h"
#include "obj.h"
#include "vlist.h"
#include "packet.h"
#include "class.h"
#include "slotaccess.h"
#include "classlist.h"
#include "glib.h"
#include "event.h"
#include "misc.h"

typedef struct TimeInfo {
	struct timeval time;
	struct TimeInfo *next;
	int (*func)();
	VObj *obj;
	int argc;
	Packet *argv;
} TimeInfo;

#define EVENT_MASK_ABSOLUTE \
	Button1MotionMask | StructureNotifyMask | ExposureMask | \
	VisibilityChangeMask

#define EVENT_MASK_DEFAULT \
	KeyPressMask | KeyReleaseMask | ButtonPressMask | ButtonReleaseMask | \
	PointerMotionMask | PointerMotionHintMask | EnterWindowMask | \
	LeaveWindowMask | Button1MotionMask | StructureNotifyMask | \
	ExposureMask | VisibilityChangeMask

int finish = 0;
int obj_track = 0;
int mouse_track = 0;
int objectPeekFlag = 0;
int flag_window_tracking = 0;
int mouseButtonPressedState = 0;

IntPair mouse;

XEvent e;

#define KEYBUFSIZE 10
char keybuf[KEYBUFSIZE];

char keyStat_key;
int keyStat_control;
int keyStat_shift;

int max_socks = NOFILE;
fd_set read_mask;
VObj *objFDList[NOFILE]; /* list of association between fd and object */
TimeInfo *firstTimeInfo = NULL;

int async_event = 0;

/* forward decl */
char eventChar();
void processPeekKeys();
int checkParam();
void process_event();

VObj *reparented_obj = NULL;
VObj *floatingObject = NULL;

VObj *xselectionObj = NULL; /* object that has data for x clip buffer */
char *sharedSelectionBuffer = NULL;

/*
 * to be initialized by init_event 
 */
Packet *result;		/* scrap packets */
Packet *result2;

int init_event()
{
	int i;

	/* initialize object-fileDescriptor list */
	for (i = 0; i < max_socks; i++) objFDList[i] = NULL;

	result = makePacket();
	result2 = makePacket();
	return 1;
}

/*
 * 
 */
int eventLoop()
{
	VObj *topObj, *obj;
	HashEntry *hentry;
	TimeInfo *tip;
	int lock = 0;
	int i;
	Window w;
	fd_set cur_read_mask;
	struct timeval timeout, timenow, *timeval = NULL;
	int bits;

	FD_SET(ConnectionNumber(display), &read_mask);

	while (!finish) {

		if (async_event) {
			/* Handle async_event */
			async_event = 0;
		}
		/* changeToNormalMouseCursor();*/

		if (XPending(display)) {
			FD_SET(ConnectionNumber(display), &cur_read_mask);
		} else {
			struct timeval time;

			if (firstTimeInfo) {
				tip = firstTimeInfo;
				gettimeofday(&timenow, (struct timezone*)NULL);

				timeout.tv_sec = firstTimeInfo->time.tv_sec -
							timenow.tv_sec;
				timeout.tv_usec = firstTimeInfo->time.tv_usec -
							timenow.tv_usec;

				if (timeout.tv_usec > 1000000) {
					timeout.tv_usec -= 1000000;
					timeout.tv_sec += 1;
				}
				if (timeout.tv_sec < 0) timeout.tv_sec = 0;
				if (timeout.tv_usec < 0) timeout.tv_usec = 0;
				timeval = &timeout;
/*
				gettimeofday(&time, (struct timezone*)NULL);
				printf("before select: %d,%d now\n",
					time.tv_sec, time.tv_usec);
				printf("timeout      : %d,%d \n",
					timeout.tv_sec, timeout.tv_usec);
*/
			}
			bcopy(&read_mask, &cur_read_mask,sizeof cur_read_mask);

			bits = select(max_socks, &cur_read_mask, 
					(fd_set*)NULL,
					(fd_set*)NULL, 
					(struct timeval*)timeval);

/*
printf("*******enter select, timeval=%d\n", timeval);
printf("*******left select, timeval=%d bit=%d\n", timeval, bits);
*/
			if (timeval && !bits) {
/*				gettimeofday(&time, (struct timezone*)NULL);
				printf("left select: %d,%d now\n",
					time.tv_sec, time.tv_usec);
*/
				tip = firstTimeInfo;
				firstTimeInfo = firstTimeInfo->next;
				(tip->func)(tip->obj, tip->argv, tip->argc);
				if (tip->argv) free(tip->argv);
				free(tip);
			}
			timeval = NULL;
		}

		if (!FD_ISSET(ConnectionNumber(display), &cur_read_mask)) {
			for (i = 0; bits && i < max_socks; i++) {
				if (!FD_ISSET(i, &cur_read_mask)) continue;
				/* tell object to handle socket data */
				if (obj = objFDList[i]) {

					if (verbose) {
						sprintf(buff,
							"data in socket number = %d, obj = %s\n", 
							i, GET_name(obj));
						fprintf(stderr, buff);

						messageToUser(NULL, MESSAGE_DEBUG, buff);
					}
					sendMessage1(obj, "input");
				} else {
					sprintf(buff,
						"data in fd = %d, but no associated object. closing it.\n",
						i);
/*
					messageToUser(NULL, MESSAGE_DEBUG, buff);
*/
					fprintf(stderr, buff);
					close(i);
				}
				bits--;
			}
		} else {
			XNextEvent(display, &e);

			w = eventWindow(e);
			mouse.x = mouseX(e);
			mouse.y = mouseY(e);

			if (mouse_track) {
				fprintf(stderr, "mouse.x=%d, mouse.y%d\n",
					 mouse.x, mouse.y);
			}
			hentry = getHashEntry(window2Obj, (long)w);
			if (hentry) {
				obj = (VObj*)hentry->val;
				if (obj) {
				 	VCurrentObj = obj;
	  				if (flag_window_tracking &&
					    VCurrentObj != VPrevObj) {
						fprintf(stderr, 
							"CurrentObj=\"%s\"\n", 
							GET_name(VCurrentObj));
					}
					if (GET_lock(VCurrentObj) 
					    && GET_window(VCurrentObj)) {
						process_event(&e, ACTION_TOOL);
					} else {
						process_event(&e, currentTool);
					}
				}
			} else {
				fprintf(stderr, 
				"can't find object associated with window.\n");
			}
		}
	}
}

void process_event(ep, tool)
	XEvent *ep;
	int tool;
{
	static VObj *dragObj = NULL;
	static int resize_corner, mouseDown = 0, from_x, from_y;
	Window w = GET_window(VCurrentObj);

	if (verbose) 
		fprintf(stderr, "**	type=%d	VCurrentObj =%x %s\n", 
			eventType(*ep), VCurrentObj, 
			GET_name(VCurrentObj));

	if (dragObj) {
		if (GET_window(dragObj) == 0) {
			if (verbose)
				fprintf(stderr, 
					"** w=0 in dragObj =%s\n", GET_name(dragObj));
			dragObj = NULL;
			return;
		}
	}
	switch (eventType(*ep)) {
	case KeyPress:
		handle_KeyPress(ep);
	break;

	case KeyRelease:
		handle_KeyRelease(ep);
	break;
			
	case EnterNotify:
		handle_EnterNotify(ep, &dragObj, tool, &mouseDown);
	break;

	case LeaveNotify:
		handle_LeaveNotify(ep, &dragObj, tool, &mouseDown);
		keyStat_control = 0;
		keyStat_shift = 0;
		/*processPeekKeys();*/
	break;

	case ButtonPress:
		handle_ButtonPress(ep, &dragObj, tool, &resize_corner,
				   &mouseDown, &from_x, &from_y);
	break;

	case ButtonRelease:
		handle_ButtonRelease(ep, &dragObj, tool, &resize_corner, 
				     &mouseDown);
		break;

	case MotionNotify:
		handle_MotionNotify(ep, &dragObj, tool, &resize_corner, 
				    &mouseDown, &from_x, &from_y);
		break;

	case MapNotify:
		if (reparented_obj) {
			GLDrawRubberFrame(GET_window(reparented_obj),
					GET_x(reparented_obj) + 1, 
					GET_y(reparented_obj) + 1,
					GET_width(reparented_obj) - 1, 
					GET_height(reparented_obj) - 1);
			reparented_obj = NULL;
		}
		break;

	case Expose:
		while(XCheckTypedWindowEvent(display, eventWindow(*ep), Expose,
			ep));
		handle_ExposeNotify(ep);
		break;

	case ResizeRequest:
		handle_ResizeRequest(ep);
		break;

	case ConfigureNotify:
/*		fprintf(stderr, "configureNotify!\n");*/
		handle_ConfigureNotify(ep);
		break;

	case VisibilityNotify:
/*		fprintf(stderr, "visibleNotify!\n");*/
		break;

	case SelectionClear:
		if (xselectionObj) {
/*			sendMessage1(xselectionObj, "clearSelection");*/
			GLClearSelection();
		}
		break;

	case SelectionRequest:
		if (xselectionObj) {
			Packet *result = borrowPacket();
			XSelectionEvent reply;
			XSelectionRequestEvent *sep = (XSelectionRequestEvent *)ep;
			char *cp;
			int length;

/*			printf("SelectionRequest.\n");*/
			callMeth(xselectionObj, result, 0, NULL,
					STR_getSelection);

			cp = PkInfo2Str(result);
			if (cp) {
				length = strlen(cp);
/*				printf("SelectionRequest>>%s<<\n", cp);*/

				XChangeProperty(ep->xselectionrequest.display,
					ep->xselectionrequest.requestor,
					ep->xselectionrequest.property,
					XA_STRING, 8, 
					PropModeReplace, 
					cp, length);

				reply.type = SelectionNotify;
				reply.serial = 0;
				reply.send_event = True;
				reply.display = sep->display;
				reply.requestor = sep->requestor;
				reply.selection = sep->selection;
				reply.target = sep->target;
				reply.time = sep->time;

				if (sep->property == None) 
					reply.property = sep->target;
				else 
					reply.property = sep->property;
			  

				XSendEvent(reply.display, reply.requestor, 
						False, 0, (XEvent *)&reply);
				returnPacket();
			}
		}
		break;
	}
}

handle_KeyPress(ep)
	XKeyEvent *ep;
{
	VObj *obj = findWindowObject(ep->window);
	if (eventChar(ep) && obj) sendMessage1(obj, "keyPress");

	/* printf("control=%d shift=%d\n", keyStat_control, keyStat_shift);*/
}

handle_KeyRelease(ep)
	XKeyEvent *ep;
{
	VObj *obj = findWindowObject(ep->window);
	if (eventChar(ep) && obj) sendMessage1(obj, "keyRelease");
}

handle_EnterNotify(ep, dragObjp, tool, mouseDown)
	XEnterWindowEvent *ep;
	VObj **dragObjp;
	int tool;
	int *mouseDown;
{
	if (VCurrentObj == NULL) return;
	if (ep->detail == NotifyVirtual || 
	    ep->detail == NotifyNonlinearVirtual) return;

	if ((tool != ACTION_TOOL) && (*mouseDown == 0)) {
		GLDrawRubberFrame(GET_window(VCurrentObj),
				0, 0,
				GET_width(VCurrentObj) - 1, 
				GET_height(VCurrentObj) - 1);
	} else {
		sendMessage1(VCurrentObj, "enter");
	}
}

handle_LeaveNotify(ep, dragObjp, tool, mouseDown)
	XLeaveWindowEvent *ep;
	VObj **dragObjp;
	int tool;
	int *mouseDown;
{
	if (VCurrentObj == NULL) return;
	if (ep->detail == NotifyVirtual ||
	    ep->detail == NotifyNonlinearVirtual) return;

	/*
	 * the cursor has moved off the top window... onto root.
	 */
	if ((tool != ACTION_TOOL) && (*mouseDown == 0)) {
		GLDrawRubberFrame(GET_window(VCurrentObj),
				0, 0,
				GET_width(VCurrentObj) - 1, 
				GET_height(VCurrentObj) - 1);
	} else {
		sendMessage1(VCurrentObj, "leave");
	}
}

handle_ButtonPress(ep, dragObjp, tool, resize_corner, mouseDown, from_x,from_y)
	XButtonEvent *ep;
	VObj **dragObjp;
	int tool;
	int *resize_corner;
	int *mouseDown;
	int *from_x, *from_y;
{
	int root_x, root_y;

	mouseButtonPressedState = ep->state;

	/* only the combination of control-key & middle mouse button
	 * will get you the CLI 
	 */
	if (keyStat_control) {
		execScript(VCurrentObj, result, "shell(\"render\");");
		return;
	}

	switch (tool) {
	case ACTION_TOOL: { /* press */

		if (cmd_history) {
			sprintf(buff, "%s;mouseDown\n", 
				GET_name(VCurrentObj));
			messageToUser(NULL, MESSAGE_HISTORY, buff);
		}
		*dragObjp = VCurrentObj;
		sendMessage1(VCurrentObj, "buttonPress");

/*		method_generic_send(*dragObjp, result, *dragObjp, 
				    "mouseDownRender");
		method_generic_send(*dragObjp, result, *dragObjp, 
				    "mouseDown");
*/
	}
	break;

	case TARGET_TOOL: /* press */
		VTargetObj = VCurrentObj;
		sendMessage1(VResourceObj, "targetSet");
	break;

	case REPARENT_TOOL: {/* press */

		VObj *stack;
		Window w = GET_window(VCurrentObj);
/*		Window w = eventWindow(*((XEvent*)ep));*/
		int child_x, child_y;

		*dragObjp = VCurrentObj;
		if (!*dragObjp) {
			IERROR("reparent tool: can't find the object! abort.\n");
		}
		if (!w) {
			MERROR(*dragObjp, "reparent to root window failed.\n");
			*dragObjp = NULL;
			return;
		}
/*
		if (!ScanAttr(*dragObjp, "G")) {
}*/
		if (1) {
			XSetWindowAttributes attrs;
			attrs.save_under = True;
			XChangeWindowAttributes(display, w, CWSaveUnder, &attrs);
		}

#ifdef dsdsgs
		if (stack = ObjStack(*dragObjp)) {
			Window stackw = GET_window(stack);
			int stack_x, stack_y;

			w = GET_window(*dragObjp);
			GLRootPosition(w, &child_x, &child_y);
			GLRootPosition(stackw, &stack_x, &stack_y);

			/* 
			 * dragObject's param is relative to the stack object.
			 * from_{x,y} is relative to the root window.
			 */
			GLDrawRubberFrame(GET_window(*dragObjp),
					GET_x(*dragObjp) + 1, 
					GET_y(*dragObjp) + 1,
					GET_width(*dragObjp) - 1, 
					GET_height(*dragObjp) - 1);

			SET_x(*dragObjp, child_x - stack_x);
			SET_y(*dragObjp, child_y - stack_y);

			callMethod(stack, "self", result2);
			callMethod(*dragObjp, "set", result, "parent", 
					result2, NULL);

			callMethod(VResourceObj, "self", result2);
			callMethod(*dragObjp, "set", result, "parent", 
					result2, NULL);
	
			if (!ScanAttr(*dragObjp, "G")) {
				XSetWindowAttributes attrs;
				attrs.save_under = True;
				XChangeWindowAttributes(display, w, 
							CWSaveUnder, &attrs);
				XSelectInput(display, w,
					KeyPressMask | 
					ButtonPressMask | 
					ButtonReleaseMask | 
					Button1MotionMask| 
					PointerMotionMask | 
					PointerMotionHintMask |
					EnterWindowMask | 
					LeaveWindowMask |
					SubstructureRedirectMask |
					VisibilityChangeMask);
			}
			*mouseDown = 1;
			GLQueryMouse(rootWindow, &root_x, &root_y, &(mouse.x),
					&(mouse.y));

			*from_x = root_x - GET_x(*dragObjp);
			*from_y = root_y - GET_y(*dragObjp);
		} else {
			*dragObjp = NULL;
			IERROR("stack attribute is not set for object `%s'\n", GET_name(stack));
		}
#endif

printf("*	from %d,%d\n", *from_x, *from_y);
printf("	 x,y %d,%d\n", GET_x(*dragObjp), GET_y(*dragObjp));

	}
	break;

	case MOVE_TOOL: { /* press */

		Window w = GET_window(VCurrentObj);
/*		Window w = eventWindow(*((XEvent*)ep));*/

		/* restrict user from moving non-field (stack, card...) */
		*dragObjp = VCurrentObj;
		if (*dragObjp == NULL) {
			IERROR("move tool: can't find the object! abort.\n");
		}
		GLDrawRubberFrame(GET_window(*dragObjp),
				0, 0,
				GET_width(*dragObjp) - 1, 
				GET_height(*dragObjp) - 1);
/*
		if (!ScanAttr(*dragObjp, "G")) {
}*/
		if (1) {
			XSetWindowAttributes attrs;
			attrs.save_under = True;
			XChangeWindowAttributes(display, w, CWSaveUnder, 
						&attrs);
			XSelectInput(display, w,
					KeyPressMask |
					ButtonPressMask | 
					ButtonReleaseMask |
					Button1MotionMask | 
					PointerMotionMask | 
					PointerMotionHintMask |
					EnterWindowMask | 
					LeaveWindowMask |
					SubstructureRedirectMask |
					VisibilityChangeMask);
		}
		*mouseDown = 1;
		GLQueryMouse(rootWindow, &root_x, &root_y, 
				&(mouse.x), &(mouse.y));
		*from_x = root_x;
		*from_y = root_y;
		/* printf("* root %d,%d\n", root_x, root_y);*/
	}
	break;

	case RESIZE_TOOL: { /* press */

		Window w = GET_window(VCurrentObj);
/*		Window w = eventWindow(*((XEvent*)ep));*/

		*dragObjp = VCurrentObj;
/*
		if (!ScanAttr(*dragObjp, "G")) {
}
*/
		if (1) {
			XSetWindowAttributes attrs;

			attrs.save_under = True;
			XChangeWindowAttributes(display, w, CWSaveUnder, 
						&attrs);
			XSelectInput(display, w,
					KeyPressMask | 
					ButtonPressMask | 
					ButtonReleaseMask |
					Button1MotionMask | 
					PointerMotionMask | 
					PointerMotionHintMask |
					EnterWindowMask | 
					LeaveWindowMask |
					SubstructureRedirectMask |
					VisibilityChangeMask);
		}
		*mouseDown = 1;
		GLQueryMouse(w, &root_x, &root_y, &(mouse.x), &(mouse.y));
		*from_x = root_x;
		*from_y = root_y;
			
		if (mouse.x < (int)(GET_width(*dragObjp) / 2)) {
			if (mouse.y < (int)(GET_height(*dragObjp) / 2))
				*resize_corner = RC_UPPER_LEFT;
			else
				*resize_corner = RC_LOWER_LEFT;
		} else {
			if (mouse.y < (int)(GET_height(*dragObjp) / 2))
				*resize_corner = RC_UPPER_RIGHT;
			else
				*resize_corner = RC_LOWER_RIGHT;
		}
	}
	break;
	}
}

handle_ButtonRelease(ep, dragObjp, tool, resize_corner, mouseDown)
	XButtonEvent *ep;
	VObj **dragObjp;
	int tool;
	int *resize_corner;
	int *mouseDown;
{
	Window w = GET_window(VCurrentObj);
/*	Window w = ep->window;*/

	mouseButtonPressedState = ep->state;

	/*printf("BN=%d\n", buttonNumber(*ep));*/
	switch (tool) {
	case ACTION_TOOL: /* release */
		if (VCurrentObj == *dragObjp) {
			if (cmd_history) {
				sprintf(buff, 
					"%s;mouseDown\n", GET_name(*dragObjp));
				messageToUser(NULL, MESSAGE_HISTORY, buff);
			}
			sendMessage1(*dragObjp, "buttonRelease");
		}
		*dragObjp = NULL;
		*mouseDown = 0;
	break;

	case MOVE_TOOL:	{ /* release */
		if (*dragObjp) {
/*
			if (!ScanAttr(*dragObjp, "G")) {
}
*/
			if (1) {
				XSetWindowAttributes attrs;

				attrs.save_under = False;
				XChangeWindowAttributes(display, w, 
							CWSaveUnder, &attrs);
				XSelectInput(display, w, 
						KeyPressMask | 
						KeyReleaseMask | 
						ButtonPressMask | 
						ButtonReleaseMask |
						PointerMotionMask | 
						PointerMotionHintMask |
						EnterWindowMask | 
						LeaveWindowMask | 
						Button1MotionMask |
						StructureNotifyMask | 
						ExposureMask |
						VisibilityChangeMask);
			}
			callMeth(*dragObjp, result, 0, result2, STR_render);
			GLDrawRubberFrame(GET_window(*dragObjp),
					0, 0,
					GET_width(*dragObjp) - 1,
					GET_height(*dragObjp) - 1);
		}
		*dragObjp = NULL;
		*mouseDown = 0;
		break;
	}
	case REPARENT_TOOL: /* release */
		if (*dragObjp) {
			VObj parent;
			Window pw, w = GET_window(*dragObjp);
			int parent_rx, parent_ry, child_rx, child_ry;

/*
			if (!ScanAttr(*dragObjp, "G")) {
}
*/
			if (1) {
				XSetWindowAttributes attrs;
				attrs.save_under = False;
				XChangeWindowAttributes(display, w, 
							CWSaveUnder, &attrs);

				XSelectInput(display, w, 
						KeyPressMask | 
						KeyReleaseMask | 
						ButtonPressMask | 
						ButtonReleaseMask |
						PointerMotionMask | 
						PointerMotionHintMask |
						EnterWindowMask | 
						LeaveWindowMask | 
						Button1MotionMask |
						StructureNotifyMask | 
						ExposureMask |
						VisibilityChangeMask);
			}
			GLRootPosition(w, &child_rx, &child_ry);
			unMapObject(*dragObjp);

			if (pw = GLQueryWindow()) {
				GLRootPosition(pw, &parent_rx, &parent_ry);
			} else {
				MERROR(*dragObjp, 
					"reparent tool can't find the new parent window.\n");
			}
/*
			if (parent = findWindowObject(pw)) {
				if (ScanAttr(parent, "G") && 
				    !ScanAttr(*dragObjp, "G")) {
					MERROR(*dragObjp, 
"Sorry, X11R4 does not allow visible inferiors to InputOnly windows.\n");
					} else {
						SET_x(*dragObjp, 
							child_rx - parent_rx);
						SET_y(*dragObjp, 
							child_ry - parent_ry); 

						callMethod(parent, "self", result2);
						callMethod(*dragObjp, "set", result, "parent", result2, NULL);

						callMethod(*dragObjp, "set", result, "visible", packetConst_1, NULL);
					}
				reparented_obj = *dragObjp;
			} else {
				MERROR(*dragObjp, 
					"reparent tool can't figure out the new parent\n");
			}
*/
		}
		*dragObjp = NULL;
		*mouseDown = 0;
		floatingObject = NULL;
	break;

	case RESIZE_TOOL: /* release */

		if (*dragObjp) {
			GLDrawRubberFrame(GET_window(*dragObjp),
					GET_x(*dragObjp) + 1, 
					GET_y(*dragObjp) + 1,
					GET_width(*dragObjp) - 1, 
					GET_height(*dragObjp) - 1);
/*
			if (!ScanAttr(*dragObjp, "G")) {
}*/
		if (1) {
				XSetWindowAttributes attrs;
		
				attrs.save_under = 0;
				XChangeWindowAttributes(display, w, 
							CWSaveUnder, &attrs);
				XSelectInput(display, w, 
						KeyPressMask | 
						KeyReleaseMask | 
						ButtonPressMask | 
						ButtonReleaseMask |
						PointerMotionMask | 
						PointerMotionHintMask |
						EnterWindowMask | 
						LeaveWindowMask | 
						Button1MotionMask |
						StructureNotifyMask | 
						ExposureMask |
						VisibilityChangeMask);
			}

			/* set the param the proper way... so various geometry 
			 * related information gets updated correctly
			 */
/*
			sprintf(buff, "{%d,%d,%d,%d}",
				GET_x(*dragObjp), GET_y(*dragObjp),
				GET_width(*dragObjp), GET_height(*dragObjp));
			setPacketContent(result2, buff);
			callMethod(*dragObjp, "set", result, "param", result2,
				   NULL);
			callMethod(*dragObjp, "render");
*/
			GLDrawRubberFrame(GET_window(*dragObjp),
					GET_x(*dragObjp) + 1, 
					GET_y(*dragObjp) + 1,
					GET_width(*dragObjp) - 1, 
					GET_height(*dragObjp) - 1);
		}
		*dragObjp = NULL;
		*mouseDown = 0;
		break;
	}
}

handle_MotionNotify(ep, dragObjp, tool, resize_corner,mouseDown, from_x,from_y)
	XEvent *ep;
	VObj **dragObjp;
	int tool;
	int *resize_corner;
	int *mouseDown;
	int *from_x, *from_y;
{
	if (((XMotionEvent*)ep)->is_hint != NotifyHint) return;

	switch (tool) {
	case ACTION_TOOL: {
		int root_x, root_y, dx, dy;
/*		Window w = eventWindow(*((XEvent*)ep));*/
		Window w = GET_window(VCurrentObj);

		if (VCurrentObj && w) {
			GLQueryMouse(w, &root_x, &root_y, 
					&(mouse.x), &(mouse.y));
			sendMessage1N2int(VCurrentObj, "mouseMove", 
					mouse.x, mouse.y);
		}
/*
		GLPrepareObjColor(VCurrentObj);

		method_generic_send(VCurrentObj, result, VCurrentObj, 
				    "mouseMove");
*/
	} break;

	case MOVE_TOOL:

		if (*mouseDown && *dragObjp) {
			Window w = GET_window(VCurrentObj);
/*			Window w = eventWindow(*((XEvent*)ep));*/
			int root_x, root_y, dx, dy;

/*			if (*dragObjp != findWindowObject(w)) return;
*/
			GLQueryMouse(rootWindow, &root_x, &root_y, 
				     &(mouse.x), &(mouse.y));
		
			printf("* from %d,%d root %d,%d\n", 
					*from_x, *from_y, root_x, root_y);
			dx = root_x - *from_x;
			dy = root_y - *from_y;
			*from_x = root_x;
			*from_y = root_y;

			*(PTR_x(*dragObjp)) += dx;
			*(PTR_y(*dragObjp)) += dy;
			XMoveWindow(display, w, 
					GET_x(*dragObjp), GET_y(*dragObjp));
		}
	break;

	case REPARENT_TOOL:

		if (*mouseDown && *dragObjp) {
			Window w;
			int root_x, root_y, dx, dy;
			XSetWindowAttributes attrs;

			w = GET_window(*dragObjp);
			GLQueryMouse(rootWindow, &root_x, &root_y, 
				   &(mouse.x), &(mouse.y));

			SET_x(*dragObjp, root_x - *from_x);
			SET_y(*dragObjp, root_y - *from_y);

			printf("*from %d,%d\n", *from_x, *from_y);
			printf(" param %d,%d\n", GET_x(*dragObjp), GET_y(*dragObjp));

			attrs.override_redirect = True; 
			XChangeWindowAttributes(display, w, CWOverrideRedirect,
						&attrs);
			if (GET__parent(*dragObjp))
				GLUpdatePosition(0, w, 
					GET_x(*dragObjp), GET_y(*dragObjp));
			else
				GLUpdatePosition(1, w, 
					GET_x(*dragObjp), GET_y(*dragObjp));

			attrs.override_redirect = 0; 
			XChangeWindowAttributes(display, w, CWOverrideRedirect,
						&attrs);
		}
		break;

	case RESIZE_TOOL: /* motion */

		if (*mouseDown && *dragObjp) {
			Window pw, w = eventWindow(*((XEvent*)ep));
			VObj *parent;
			int root_x, root_y, dx, dy;

			if (*dragObjp != findWindowObject(w)) return;

			if (parent = GET__parent(*dragObjp))
				pw = GET_window(parent);
			else 
				pw = rootWindow;

			GLDrawRubberFrame(pw,
				GET_x(*dragObjp) + 1,
				GET_y(*dragObjp) + 1,
				GET_x(*dragObjp) + GET_width(*dragObjp), 
				GET_y(*dragObjp) + GET_height(*dragObjp));

			GLQueryMouse(rootWindow, &root_x, &root_y, 
				   &(mouse.x), &(mouse.y));
			
			dx = root_x - *from_x;
			dy = root_y - *from_y;
			*from_x = root_x;
			*from_y = root_y;

			switch (*resize_corner) {
			case RC_UPPER:
				SET_y(*dragObjp, GET_y(*dragObjp) + dy);
				SET_height(*dragObjp, 
						GET_height(*dragObjp) - dy);
				*resize_corner = 
					checkParam(*dragObjp, *resize_corner);
				XMoveResizeWindow(display, w,
						GET_x(*dragObjp), 
						GET_y(*dragObjp),
						GET_width(*dragObjp), 
						GET_height(*dragObjp));
			break;

			case RC_LOWER:
				SET_height(*dragObjp, 
						GET_height(*dragObjp) + dy);
				*resize_corner = 
					checkParam(*dragObjp, *resize_corner);
				XMoveResizeWindow(display, w,
						GET_x(*dragObjp), 
						GET_y(*dragObjp),
						GET_width(*dragObjp), 
						GET_height(*dragObjp));
			break;

			case RC_LEFT:
				SET_x(*dragObjp, GET_x(*dragObjp) + dx);
				SET_width(*dragObjp,
					GET_width(*dragObjp) - dx);
				*resize_corner = 
					checkParam(*dragObjp, *resize_corner);
				XMoveResizeWindow(display, w,
						GET_x(*dragObjp), 
						GET_y(*dragObjp),
						GET_width(*dragObjp), 
						GET_height(*dragObjp));
			break;
		
			case RC_RIGHT:
				SET_width(*dragObjp, 
					GET_width(*dragObjp) + dx);
				*resize_corner = 
					checkParam(*dragObjp, *resize_corner);
				XResizeWindow(display, w, 
						GET_width(*dragObjp), 
						GET_height(*dragObjp));
			break;
		
			case RC_UPPER_LEFT:
				SET_x(*dragObjp, GET_x(*dragObjp) + dx);
				SET_y(*dragObjp, GET_y(*dragObjp) + dy);
				SET_width(*dragObjp, 
						GET_width(*dragObjp) - dx);
				SET_height(*dragObjp, 
						GET_height(*dragObjp) - dy);
				*resize_corner = 
					checkParam(*dragObjp, *resize_corner);
				XMoveResizeWindow(display, w,
						GET_x(*dragObjp), 
						GET_y(*dragObjp),
						GET_width(*dragObjp),
						GET_height(*dragObjp));
			break;
		
			case RC_LOWER_LEFT:
				SET_x(*dragObjp, GET_x(*dragObjp) + dx);
				SET_y(*dragObjp, GET_y(*dragObjp));
				SET_width(*dragObjp, 
						GET_width(*dragObjp) - dx);
				SET_height(*dragObjp, 
						GET_height(*dragObjp) + dy);
				*resize_corner = 
					checkParam(*dragObjp, *resize_corner);
				XMoveResizeWindow(display, w,
						GET_x(*dragObjp),
						GET_y(*dragObjp),
						GET_width(*dragObjp),
						GET_height(*dragObjp));
			break;
		
			case RC_UPPER_RIGHT:
				SET_x(*dragObjp, GET_x(*dragObjp));
				SET_y(*dragObjp, GET_y(*dragObjp) + dy);
				SET_width(*dragObjp, 
						GET_width(*dragObjp) + dx);
				SET_height(*dragObjp, 
						GET_height(*dragObjp) - dy);
				*resize_corner = 
					checkParam(*dragObjp, *resize_corner);
				XMoveWindow(display, w, GET_x(*dragObjp), 
						GET_y(*dragObjp));
				XResizeWindow(display, w, 
						GET_width(*dragObjp), 
						GET_height(*dragObjp));
			break;
		
			case RC_LOWER_RIGHT:
				SET_width(*dragObjp, 
						GET_width(*dragObjp) + dx);
				SET_height(*dragObjp, 
						GET_height(*dragObjp) + dy);
				*resize_corner = 
					checkParam(*dragObjp, *resize_corner);
				XResizeWindow(display, w, 
						GET_width(*dragObjp), 
						GET_height(*dragObjp));
			break;
			}
			callMeth(*dragObjp, result, 0, 0, STR_render);

			GLDrawRubberFrame(pw,
				GET_x(*dragObjp) + 1, 
				GET_y(*dragObjp) + 1,
				GET_x(*dragObjp) + GET_width(*dragObjp), 
				GET_y(*dragObjp) + GET_height(*dragObjp));
		}
		break;
	}
}

handle_ExposeNotify(ep)
	XExposeEvent *ep;
{
	VObj *obj = findWindowObject(ep->window);

	if (obj) {
		sendMessage1N4int(obj, "expose", 
				  ep->x, ep->y,
				  ep->width, ep->height);
	}
}

handle_ResizeRequest(ep)
	XResizeRequestEvent *ep;
{
	VObj *obj = findWindowObject(ep->window);

	if (obj) {
		sendMessage1N4int(obj, "config", 
			GET_x(obj), GET_y(obj), ep->width, ep->height);
	}
}

handle_ConfigureNotify(ep)
	XConfigureEvent *ep;
{ 
	VObj *obj = findWindowObject(ep->window);

	if (obj) {
/*		printf("**** confignotify\n");*/
		sendMessage1N4int(obj, "config", 
			ep->x, ep->y, ep->width, ep->height);
/*
		if (ep->above != 0) {
			sendMessage1N4int(obj, "config", 
				ep->x, ep->y, ep->width, ep->height);
		} else {
			sendMessage1N4int(obj, "config", 
				GET_x(obj), GET_y(obj), 
				ep->width, ep->height);
		}
*/
	}
}

char eventChar(e)
	XKeyEvent *e;
{
	KeySym ks;

	keybuf[0] = '\0';
	XLookupString (e, keybuf, KEYBUFSIZE, &ks, NULL);

	if (ks != NoSymbol) {
		/* printf("e=%ld, key[0]='%c'\n", (long)e, keybuf[0]);*/

		switch (ks) {
		case XK_Shift_L:
			if (keyStat_shift) keyStat_shift = 0;
			else keyStat_shift = 1;
			keyStat_key = '\0';
			return 0;
		case XK_Control_L:
			if (keyStat_control) keyStat_control = 0;
			else keyStat_control = 1;
			keyStat_key = '\0';
			return 0;
		default:
			keyStat_key = keybuf[0];
		}
		if (keyStat_key != '\0') return 1;
	}
/*	processPeekKeys();*/

	return NULL;
}

void processPeekKeys()
{
	if (keyStat_control && keyStat_shift) {
/*
		method_generic_renderObjectParam(CurrentObj);
*/
		objectPeekFlag = 1;
	} else {
		if (objectPeekFlag) {
			objectPeekFlag = 0;
/*
			method_generic_renderObjectParam(CurrentObj);
*/
		}
	}
}

int checkParam(self, resize_corner)
	VObj *self;
	int resize_corner;
{
	if (GET_width(self) < 1) {
		SET_width(self, 1);
		if ((resize_corner == RC_LEFT) ||
		    (resize_corner == RC_UPPER_LEFT) ||
		    (resize_corner == RC_LOWER_LEFT))
			resize_corner = RC_RIGHT;
		else 
			resize_corner = RC_LEFT;

	} else if (GET_height(self) < 1) {
		SET_height(self, 1);
		if ((resize_corner == RC_UPPER) ||
		    (resize_corner == RC_UPPER_RIGHT) ||
		    (resize_corner == RC_UPPER_LEFT))
			resize_corner = RC_LOWER;
		else 
			resize_corner = RC_UPPER;
	}
	return resize_corner;
}

long scheduleEvent(delay, func, obj, argc, argv)
	int delay;	/* milliseconds */
	int (*func)();
	VObj *obj;
	int argc;
	Packet *argv;
{
	TimeInfo *ltip = NULL, *tip, *new;

	/* later, do recycling by making a circular linked list... 
	 */
	if (!(new = (TimeInfo*)malloc(sizeof(struct TimeInfo)))) return 0;
	gettimeofday(&new->time, (struct timezone*)NULL);
	new->time.tv_sec += delay / 1000;
	new->time.tv_usec += (delay % 1000) * 1000;
	if (new->time.tv_usec > 1000000) {
		new->time.tv_usec -= 1000000;
		new->time.tv_sec += 1;
	}
	new->func = func;
	new->obj = obj;
	new->argc = argc;
	new->argv = argv;

	if (!firstTimeInfo) {
		firstTimeInfo = new;
		new->next = NULL;
		return (long)new;
	}
	for (tip = firstTimeInfo; tip; tip = tip->next) {
		if (new->time.tv_sec < tip->time.tv_sec) {
			if (ltip) ltip->next = new;
			else firstTimeInfo = new;
			new->next = tip;
			return (long)new;
		} else if (new->time.tv_sec == tip->time.tv_sec) {
			if (new->time.tv_usec <= tip->time.tv_usec) {
				if (ltip) ltip->next = new;
				else firstTimeInfo = new;
				new->next = tip;
				return (long)new;
			}
		}
		ltip = tip;
	}
	ltip->next = new;
	new->next = NULL;

	return (long)new;
}

int cancelEvent(timeInfoID)
	long timeInfoID;
{
	TimeInfo *ltip = NULL, *tip;

	for (tip = firstTimeInfo; tip; tip = tip->next) {
		if ((long)tip == timeInfoID) {
			if (ltip) ltip->next = tip->next;
			else firstTimeInfo = tip->next;
			if (tip->argv) free(tip->argv);
			free(tip);
			return 1;
		}
		ltip = tip;
	}
	return 0;
}

void dumpSchedule()
{
	TimeInfo *tip;
	struct timeval time;
	int i;

	gettimeofday(&time, (struct timezone*)NULL);
	printf("%d,%d now\n", time.tv_sec, time.tv_usec);

	for (tip = firstTimeInfo; tip; tip = tip->next) {
		printf("%d,%d: obj=%s \t", 
			tip->time.tv_sec,
			tip->time.tv_usec,
			GET_name(tip->obj));
		for (i = 0; i < tip->argc; i++) {
			dumpPacket(&(tip->argv[i]));
		}
		printf("\n");
	}
}

