/*
 * Copyright 1990-1992 Pei-Yuan Wei.  All rights reserved.
 *
 * Permission to use, copy, and/or distribute for any purpose and
 * without fee is hereby granted, provided that both the above copyright
 * notice and this permission notice appear in all copies and derived works.
 * Fees for distribution or use of this software or derived works may only
 * be charged with express written permission of the copyright holder.
 * This software is provided ``as is'' without express or implied warranty.
 */
#include <stdio.h>
#include <ctype.h>
#include "mystrings.h"
#include "hash.h"
#include "obj.h"
#include "packet.h"
#include "class.h"
#include "classlist.h"
/*
#include "cl_cosmic.h"		
#include "cl_field.h"		
#include "cl_project.h"		
#include "cl_generic.h"		
#include "cl_pane.h"		
#include "cl_vpane.h"		
#include "cl_hpane.h"		
#include "cl_rubber.h"		
#include "cl_tray.h"		
#include "cl_txt.h"		
#include "cl_txtButton.h"	
#include "cl_txtLabel.h"	
#include "cl_txtDisp.h"		
#include "cl_txtEdit.h"		
#include "cl_slider.h"		
#include "cl_XBM.h"		
#include "cl_XBMButton.h"	
#include "cl_XPM.h"		
#include "cl_XPMButton.h"	
#include "cl_GIF.h"		
#include "cl_dial.h"		
#include "cl_menu.h"		
#include "cl_toggle.h"		
#include "cl_BCard.h"		
#include "cl_FCard.h"		
#include "cl_stack.h"		
#include "cl_client.h"		
#include "cl_TTY.h"		
#include "cl_socket.h"		
*/
/*
 * List of classes, in order of initialization.
 */
ClassInfo *classList[] = {
	&class_cosmic,		/* (internal) root of class hierarchy	*/
	&class_field,		/* general window field			*/
	&class_project,		/* top level window shell		*/
	&class_generic,		/* (internal) for sharing misc methods	*/
	&class_pane,		/* configurable pane			*/
	&class_vpane,		/* vertical pane geometry manager	*/
	&class_hpane,		/* horizontal pane geometry manager	*/
	&class_rubber,		/* rubber geometry manager		*/
	&class_tray,		/* */
	&class_txt,		/* (internal) for sharing text methods	*/
	&class_txtButton,	/* single line text button		*/
	&class_txtLabel,	/* single line text label		*/
	&class_txtDisp,		/* text field for viewing (cursor off)	*/
	&class_txtEdit,		/* text field for ediging (cursor on) 	*/
	&class_HTML,		/* HyperText Markup Language		*/
	&class_slider,		/* sliding valuator			*/
	&class_XBM,		/* MIT's bitmap format 			*/
	&class_XBMButton,	/* XBM with button border		*/
	&class_XPM,		/* BullGroup's XPM color bitmap format	*/
	&class_XPMButton,	/* XPM with button border		*/
	&class_GIF,		/* GIF viewer				*/
	&class_dial,		/* rotating dial valuator		*/
	&class_menu,		/* pull-down menu			*/
	&class_toggle,		/* toggler				*/
	&class_BCard,		/* background card 			*/
	&class_FCard,		/* foreground card 			*/
	&class_stack,		/* stack of f/b cards 			*/
	&class_client,		/* (internal) for sharing IPC code	*/
	&class_TTY,		/* IPC through stdI/O (pseudo-terminal)	*/
	&class_socket,		/* IPC through sockets			*/
	NULL
};

