/*
 * Copyright 1990 Pei-Yuan Wei.	All rights reserved.
 *
 * Permission to use, copy, and/or distribute for any purpose and
 * without fee is hereby granted, provided that both the above copyright
 * notice and this permission notice appear in all copies and derived works.
 * Fees for distribution or use of this software or derived works may only
 * be charged with express written permission of the copyright holder.
 * This software is provided ``as is'' without express or implied warranty.
 */
/*
 * class	: XPM
 * superClass	: field
 */
#include <stdio.h>
#include <ctype.h>
#include "error.h"
#include "mystrings.h"
#include "hash.h"
#include "ident.h"
#include "obj.h"
#include "packet.h"
#include "class.h"
#include "slotaccess.h"
#include "classlist.h"
#include "cl_XPM.h"
#include "misc.h"
#include "glib.h"
#include "event.h"

SlotInfo cl_XPM_NCSlots[] = {
	NULL
};
SlotInfo cl_XPM_NPSlots[] = {
	NULL
};
SlotInfo cl_XPM_CSlots[] = {
{
	STR_class,
	PTRS | SLOT_RW,
	(long)"XPM"
},{
	STR_classScript,
	PTRS,
	(long)"\n\
		switch (arg[0]) {\n\
		case \"mouseMove\":\n\
		case \"enter\":\n\
		case \"leave\":\n\
		case \"keyPress\":\n\
		case \"keyRelease\":\n\
		case \"buttonPress\":\n\
		case \"buttonRelease\":\n\
		case \"shownPositionH\":\n\
		case \"shownPositionV\":\n\
		break;\n\
		case \"config\":\n\
			config(arg[1], arg[2], arg[3], arg[4]);\n\
		break;\n\
		case \"expose\":\n\
		case \"render\":\n\
			render();\n\
		break;\n\
		case \"init\":\n\
			initialize();\n\
		break;\n\
		case \"info\":\n\
			info();\n\
		break;\n\
		default:\n\
			print(\"unknown message, clsss = XPM: args: \");\n\
			for (i = 0; i < arg[]; i++) print(arg[i], \", \");\n\
			print(\"\n\");\n\
		break;\n\
		}\n\
	",
},{
	NULL
}
};
SlotInfo cl_XPM_PSlots[] = {
{
	STR__classInfo,
	CLSI,
	(long)&class_XPM
},{
	NULL
}
};

SlotInfo *slots_XPM[] = {
	(SlotInfo*)cl_XPM_NCSlots,
	(SlotInfo*)cl_XPM_NPSlots,
	(SlotInfo*)cl_XPM_CSlots,
	(SlotInfo*)cl_XPM_PSlots
};

MethodInfo meths_XPM[] = {
	/* local methods */
{
	STR_config,
	meth_XPM_config
},{
	STR_get,
	meth_XPM_get,
},{
	STR_initialize,
	meth_XPM_initialize
},{
	STR_render,
	meth_XPM_render
},{
	STR_set,
	meth_XPM_set
},{
	NULL
}
};

ClassInfo class_XPM = {
	slots_XPM,		/* class slot information	*/
	meths_XPM,		/* class methods		*/
	STR_XPM,		/* class identifier number	*/
	&class_field,		/* super class info		*/
};

int meth_XPM_config(self, result, argc, argv)
	VObj *self;
	Packet *result;
	int argc;
	Packet argv[];
{
	return meth_field_config(self, result, argc, argv);
}

int meth_XPM_get(self, result, argc, argv)
	VObj *self;
	Packet *result;
	int argc;
	Packet argv[];
{
	int labelID = getIdent(PkInfo2Str(argv));

	switch (labelID) {
	case STR_direction:
		result->info.s = GET_direction(self);
		result->type = PKT_STR;
		return 1;
	}
	return meth_field_get(self, result, argc, argv);
}

int meth_XPM_initialize(self, result, argc, argv)
	VObj *self;
	Packet *result;
	int argc;
	Packet argv[];
{
	meth_field_initialize(self, result, argc, argv);
	return 1;
}

/*
 * returns non-zero if set operation succeded, zero otherwise.
 */
int meth_XPM_set(self, result, argc, argv)
	VObj *self;
	Packet *result;
	int argc;
	Packet argv[];
{
	int labelID = getIdent(PkInfo2Str(argv));

	switch (labelID) {
	case STR_label: {
		Window w = GET_window(self);
		result->info.s = SaveString(PkInfo2Str(&argv[1]));
		SET_label(self, result->info.s);
		if (w) {
			int width, height, hotx, hoty;
			Pixmap pixmap = GLMakeXPMFromASCII(w, result->info.s, 
					    &width, &height, &hotx, &hoty);
			SET__label(self, pixmap);
		} else {
			SET__label(self, NULL);
		}
		result->type = PKT_STR;
		return 1;
	}
	}
	return meth_field_set(self, result, argc, argv);
}

int meth_XPM_render(self, result, argc, argv)
	VObj *self;
	Packet *result;
	int argc;
	Packet argv[];
{
	Window w = GET_window(self);
	Pixmap pixmap;

	if (!w) meth_field_render(self, result, argc, argv);
	
	if (!(w = GET_window(self))) return 0;
	if (pixmap = (Pixmap)GET__label(self)) {
		GLDisplayXPM(w, 0, 0, GET_width(self), GET_height(self),
				pixmap); 
	} else {
		int width, height, hotx, hoty;
		char *cp;

		if (!(cp = GET_label(self))) return 0;
		pixmap = GLMakeXPMFromASCII(w, cp, &width, &height, 
						&hotx, &hoty);
		SET__label(self, pixmap);
		GLDisplayXPM(w, 0, 0, GET_width(self), GET_height(self),
			     pixmap);
	}
	return 1;
}








