\name	{www}
\class	{vpane}
\parent	{}
\script	{
	/* ViolaWWW 0.2, release date: April 3, 1992
	 * Author: Pei Y. Wei (wei@xcf.berkeley.edu)
	 */
	switch (arg[0]) {
	case "show":
		if (www.view.html("show", arg[1]))
			www.view.html("historyRecord");
		return;
	break;
	case "search":
		www.view.html("search", arg[1]);
		return;
	break;
	case "showButNoRecord":
		www.view.html("show", arg[1]);
		return;
	break;
	case "about":
		www.view.html("about");
		return;
	break;
	case "help":
		www.view.html("help");
		return;
	break;
	case "home":
		www.view.html("home");
		return;
	break;
	case "quit":
		quit();
	break;
	}
	usual();
}
\width {600}
\height {600}
\children {www.top www.title www.view www.idx www.mesg www.udi}
\
\name	{www.top}
\class	{hpane}
\parent	{www}
\BGColor {grey45}
\FGColor {white}
\children {www.top.home www.top.prev www.top.back www.top.next www.top.mark www.top.links www.top.title www.top.icon www.top.help www.top.quit}
\maxHeight {32}
\
\name	{www.top.links}
\class	{menu}
\parent	{www.top}
\label {Marked Documents}
\script	{
	switch (arg[0]) {
	case "add":
		set("menuConfig", concatenate(get("menuConfig"), "\n", 
			".{", arg[1], "} {www(\"show\", \"", arg[2], "\");}"));
		return;
	break;
	case "init":
		path = accessible("~/.WWWBookMarks");
		if (path != "") {
			set("menuConfig", loadFile(path));
		} else {
			set("menuConfig", get("content"));
		}
	break;
	}
	usual();
}
\content {
.{About this application}	{www("about");}
.{Help}				{www("help");}
.{Home}				{www("home");}
.{                            } {}
.{Projects Info}
..{WWW @cern.ch} 		{www("show", "http://info.cern.ch/hypertext/WWW/TheProject.html");}
..{Viola @xcf.berkeley.edu} 	{www("show", "file://xcf.berkeley.edu/misc/ht/projects/viola/overview.html");}

.{SF Weather (@umn.edu)} {www("show", "gopher://mermaid.micro.umn.edu:150/00/Weather/California/San%20Francisco");}

.{Info by Index (@cern.ch)}	{www("show", "http://info.cern.ch/hypertext/DataSources/bySubject/Overview.html");}
.{Info by Organization (@cern.ch)}	{www("show", "http://info.cern.ch/hypertext/DataSources/byOrganization/Overview.html");}

.{CIA Factbook}		{www("show", "gopher://mudhoney.micro.umn.edu:70/11/CIA-Factbook-1990");}
.{Jargons (@graz.ac.at)} {www("show", "http://iicm.tu-graz.ac.at/jargon/index");}
.{Gophers (@umn.edu)}	{www.view.html("show", "gopher://gopher.micro.umn.edu:70/11/Other%20Gopher%20and%20Information%20Servers");}

}
\maxWidth {180}
\BGColor {grey45}
\FGColor {white}
\BDColor {white}
\
\name	{www.top.mark}
\class	{XBMButton}
\parent	{www.top}
\script	{
	switch (arg[0]) {
	case "buttonRelease":
		title = www.view.html("queryTitle");
		address = www.view.html("queryAddress");
		www.top.links("add", title, address);
	break;
	}
	usual();
}
\maxWidth {32}
\label {#define mark_width 32
#define mark_height 32
static char mark_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0xff, 0x1f, 0x00,
   0xe0, 0xff, 0x2f, 0x00, 0xe0, 0xff, 0x6f, 0x00, 0xe0, 0xff, 0xef, 0x00,
   0xe0, 0xff, 0x0f, 0x01, 0xe0, 0xff, 0xff, 0x01, 0xe0, 0xff, 0xff, 0x09,
   0xe0, 0xff, 0xff, 0x19, 0xe0, 0xff, 0xff, 0x39, 0xe0, 0xff, 0x01, 0x7e,
   0xe0, 0xff, 0xff, 0x39, 0xe0, 0xff, 0xff, 0x59, 0xe0, 0xff, 0xff, 0x29,
   0xe0, 0xff, 0xff, 0x11, 0xe0, 0xff, 0xff, 0x09, 0xe0, 0xff, 0xff, 0x01,
   0xe0, 0xff, 0xff, 0x01, 0xe0, 0xff, 0xff, 0x01, 0xe0, 0xff, 0xff, 0x01,
   0xe0, 0xff, 0xff, 0x01, 0xa4, 0x33, 0xb6, 0x01, 0x8c, 0xa1, 0xd5, 0x01,
   0x94, 0xad, 0xe5, 0x01, 0x44, 0x52, 0x38, 0x00, 0x44, 0x52, 0x49, 0x00,
   0x44, 0x52, 0x8a, 0x00, 0x00, 0x00, 0x00, 0x00};
}
\BGColor {grey45}
\FGColor {lightyellow}
\BDColor {grey20}
\
\name	{www.top.icon}
\class	{XPM}
\parent	{www.top}
\script	{
	/*
	 * Got any niffty rotating pixmaps? If so, please send them to me!
	 */
	switch (arg[0]) {
	case "rotate": 
		/* Politically correct map-icon of the globe :-)
		 * thou only 2 views exists, for now...
		 */
		xx = get("label");
		set("label", get("content"));
		set("content", xx);
		clearWindow();
		render();
		after(120000, "www.top.icon", "rotate"); /* 2 minutes */
		return;
	break;
	case "init":
		after(120000, "www.top.icon", "rotate");
	break;
	case "buttonRelease":
		handle = www.about("handle");
		www.view.html("show", handle);
	break;
	}
	usual();
}
\width {31}
\height {31}
\maxWidth {31}
\label {/* XPM */
static char * gb [] = {
/* gb pixmap
 * width height ncolors chars_per_pixel */
"32 32 9 1",
" 	s c0	c grey45",
".	s c23	c white",
"X	s c19	c lightblue",
"o	s c46	c darkgreen",
"O	s c9	c gray",
"+	s c5	c blue",
"@	s c27	c #fbfbfb",
"#	s c29	c gray97",
"$	s c11	c brown",
/* pixels */
"           ...........          ",
"        X..........oo...        ",
"      XOO++.+.@...oo.oo..O      ",
"     XOO++++X..ooo.o.o....O     ",
"    XOO+O++#O..OO..oo.o....O    ",
"   .XO+O+++X...O.OOo.oo.ooo..   ",
"  .XO++OO++X+...OOOOXOOo.oo..O  ",
"  .++++++@++ooo..+.XO.o.oo.o..  ",
" ..+++++@++oooooooooo.oo...oo.O ",
" .+X+++++Xooooooooooo..o...X....",
" o+++++XXooooooooooooo..oo.XX..O",
"oo++++XX.ooooooooooooo+..+...XX+",
"oo++++++.ooooXoooo$oooo.XX++..X+",
"X..+++++X.$$o$.$o$oX$$XoXX++++O+",
"XX...++++X.XXX..Xo$$$$$ooX++++O+",
".....X++.+++..X..$$o$$.oX.++++++",
".oo....++++.++.XoooooooX..++++++",
"oooo.X.X+++++++..oooooo.+.+@+@+O",
"oooXo++..X+++++.Xoooooo.++.+++++",
"ooooX++++XX+++++XooooooX+.+X+++O",
"ooooo++++++++++XooooooXX..X++++O",
"oooo.++++++++++XXooooX.....+++O ",
" ooo.+++++++++++Xoooo....X+++++ ",
" ooo++++++++++++XXoo..+OO++++O  ",
"  oo+++++++++++++.oX.++OX++++O  ",
"  ooO++++++++++++..++XOX+++++O  ",
"   XX+++++++++++++++XO++++++O   ",
"    oo+++++++++++++OO++++++O    ",
"     o+X++++++++O+OO+++X++O     ",
"      +X+OO++.OOXXXX+X+OOO      ",
"        ++..OX...O.....O        ",
"           ..........           "};
}
\content {/* XPM */
static char * gb2 [] = {
/* g30 pixmap
 * width height ncolors chars_per_pixel */
"32 32 7 1",
" 	s c0	c grey45",
".	s c23	c white",
"X	s c5	c blue",
"o	s c27	c #fbfbfb",
"O	s c46	c darkgreen",
"+	s c19	c lightblue",
"@	s c11	c brown",
/* pixels */
"          .Xo.XooOo...          ",
"        .OOoOOOOooOO..o.        ",
"      O.O+OOOOOOOO+oooO...      ",
"     ..XXXX+.OOOOooOOoo.+X.     ",
"    ..ooXXXX.oooOOOOOOOO.o..    ",
"   .XXXXXoXXOOoOOOOOOOO.XXX.+   ",
"  .XXXoXXXXXOOooOOOOOOXXXX.XX   ",
"  .XXXoXXXXXXOOOooO@OOOXX+XXX.  ",
" ..XXXXXXXXXXXOOOo@@O...XXXXXX. ",
" .oXXXXXXXXXXX.O.OOXX+OO+XXXXXX ",
"X.oXXXXXXXXXXXXXOO+O.OO.OXXXXX..",
".X+XXXXXXXXXXXXXX+OOO+X..X.XXXX.",
".XXXXXXXXXXXXXXXXXXXO+.X.O.XXXXX",
".XXXXXXXXXXXXXXXXXXXX+OOOOO+XXX.",
".XXXXXXXXXXXXXXXXXXXX+X++OOOOOXX",
".XXXXXXXXXXXXXXXXXX+XX+OOOOOOoX.",
".X+XXXXXXXXXXXXXXXX.+XOOOOOOOoo.",
"O.XXXXXXXXXXXXXXXXXXXX.OOOOOOooO",
". .++XXXXXXXXXXXXXXXXO.OOOoOOOOO",
"...XXXXXXXXXXXXXXXXXXXX+OOOOOOO.",
".+XXX..+XXXXXXXXXXXXXXXXOOOOOOX.",
"X..X.XXXXXXXXXXXXXXXXXXXXOOOOOO.",
" .XXXX+XXoXXXXXXXXXXXXX+OOOOO.X ",
" ..XXXX+XXXXXXXXXXXXXX+XOoOOO.. ",
"  .XXXXXXXXXXXXXXXXXXX.OoOOOX.  ",
"  .XXXXXXXXXXXXXXXXXXX+OOOX+X   ",
"   OOXXXXXXXoXXXXoXXXX+OO.X..   ",
"    OOXXXXXXXXXXXXXXX.O.XX..    ",
"     .OXXXXXXXXXXXXXXOOO..      ",
"      .XXXXXooXXXXXO+...        ",
"        .ooXXooooooXoX.         ",
"          ..ooooooo...          "};
}
\BDColor {grey20}
\
\name	{www.top.title}
\class	{txtLabel}
\parent	{www.top}
\label {ViolaWWW}
\BGColor {grey45}
\FGColor {black}
\BDColor {grey20}
\font {bold_largest}
\
\name	{www.top.prev}
\class	{XBMButton}
\parent	{www.top}
\script	{
	switch (arg[0]) {
	case "buttonRelease":
		www.view.html("prev");
	break;
	}
	usual();
}
\maxWidth {32}
\label {#define prev_width 32
#define prev_height 32
static char prev_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0xff, 0x3f, 0x00,
   0xe0, 0xff, 0x5f, 0x00, 0xe0, 0xff, 0xdf, 0x00, 0xe0, 0xff, 0xdf, 0x01,
   0xe0, 0xff, 0xdf, 0x03, 0xe0, 0xff, 0x1f, 0x04, 0xe0, 0x7f, 0xfc, 0x07,
   0xe0, 0x3f, 0xfc, 0x07, 0xe0, 0x1f, 0xfc, 0x07, 0xe0, 0x0f, 0xfc, 0x07,
   0xe0, 0x07, 0xfc, 0x07, 0xe0, 0x03, 0xfc, 0x07, 0xe0, 0x07, 0xfc, 0x07,
   0xe0, 0x0f, 0xfc, 0x07, 0xe0, 0x1f, 0xfc, 0x07, 0xe0, 0x3f, 0xfc, 0x07,
   0xe0, 0x7f, 0xfc, 0x07, 0xe0, 0xff, 0xff, 0x07, 0xe0, 0xff, 0xff, 0x07,
   0xe0, 0xff, 0xff, 0x07, 0xe0, 0xff, 0xff, 0x07, 0xe0, 0xff, 0xff, 0x07,
   0xe0, 0xff, 0xff, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
}
\BGColor {grey45}
\FGColor {lightyellow}
\BDColor {grey20}
\
\name	{www.top.back}
\class	{XBMButton}
\parent	{www.top}
\script	{
	switch (arg[0]) {
	case "buttonRelease":
		www.view.html("back");
	break;
	}
	usual();
}
\maxWidth {32}
\label {#define back_width 32
#define back_height 32
static char back_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0xff, 0x3f, 0x00,
   0xe0, 0xff, 0x5f, 0x00, 0xe0, 0xff, 0xdf, 0x00, 0xe0, 0xff, 0xdf, 0x01,
   0xe0, 0xff, 0xdf, 0x03, 0xe0, 0xff, 0x1f, 0x04, 0xe0, 0xbf, 0xff, 0x07,
   0xe0, 0x1f, 0xff, 0x07, 0xe0, 0x0f, 0xfe, 0x07, 0xe0, 0x07, 0xfc, 0x07,
   0xe0, 0x03, 0xf8, 0x07, 0xe0, 0x01, 0xf0, 0x07, 0xe0, 0x01, 0xf0, 0x07,
   0xe0, 0x01, 0xf0, 0x07, 0xe0, 0xff, 0xff, 0x07, 0xe0, 0xff, 0xff, 0x07,
   0xe0, 0xff, 0xff, 0x07, 0xe0, 0xff, 0xff, 0x07, 0xe0, 0xff, 0xff, 0x07,
   0xe0, 0xff, 0xff, 0x07, 0xe0, 0xff, 0xff, 0x07, 0xe0, 0xff, 0xff, 0x07,
   0xe0, 0xff, 0xff, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
}
\BGColor {grey45}
\FGColor {lightyellow}
\BDColor {grey20}
\
\name	{www.top.next}
\class	{XBMButton}
\parent	{www.top}
\script	{
	switch (arg[0]) {
	case "buttonRelease":
		www.view.html("next");
	break;
	}
	usual();
}
\maxWidth {32}
\label {#define next_width 32
#define next_height 32
static char next_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0xff, 0x3f, 0x00,
   0xe0, 0xff, 0x5f, 0x00, 0xe0, 0xff, 0xdf, 0x00, 0xe0, 0xff, 0xdf, 0x01,
   0xe0, 0xff, 0xdf, 0x03, 0xe0, 0xff, 0x1f, 0x04, 0xe0, 0x8f, 0xff, 0x07,
   0xe0, 0x0f, 0xff, 0x07, 0xe0, 0x0f, 0xfe, 0x07, 0xe0, 0x0f, 0xfc, 0x07,
   0xe0, 0x0f, 0xf8, 0x07, 0xe0, 0x0f, 0xf0, 0x07, 0xe0, 0x0f, 0xf8, 0x07,
   0xe0, 0x0f, 0xfc, 0x07, 0xe0, 0x0f, 0xfe, 0x07, 0xe0, 0x0f, 0xff, 0x07,
   0xe0, 0x8f, 0xff, 0x07, 0xe0, 0xff, 0xff, 0x07, 0xe0, 0xff, 0xff, 0x07,
   0xe0, 0xff, 0xff, 0x07, 0xe0, 0xff, 0xff, 0x07, 0xe0, 0xff, 0xff, 0x07,
   0xe0, 0xff, 0xff, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
}
\BGColor {grey45}
\FGColor {lightyellow}
\BDColor {grey20}
\
\name	{www.top.home}
\class	{XPMButton}
\parent	{www.top}
\script	{
	switch (arg[0]) {
	case "buttonRelease":
		www.view.html("home");
	break;
	}
	usual();
}
\maxWidth {32}
\label {/* XPM */
static char * home [] = {
/* gb pixmap
 * width height ncolors chars_per_pixel */
"32 32 9 1",
" 	s c0	c grey45",
".	s c46	c red",
"X	s c46	c brown",
"o	s c46	c gray",
"O	s c23	c white",
"+	c black",
"@	c cyan",
"#	c yellow",
"$	c green",
/* pixels */
"                                ",
"                                ",
"                                ",
"             .....X oooo        ",
"           .X..X....oOOo        ",
"          ..+X+..X..oooo        ",
"         .X+XXX+....ooOO        ",
"        ..+XXXXX+...oooo        ",
"       ..+XX+++XX+.XOOOo.       ",
"      .X+XX++@++XX+..ooo..      ",
"     ..+XX+@+@+@+XX+..oo...     ",
"    ..+XXX+@+@+@+XXX+.X..X..    ",
"   X.+XXXX+@+@+@+XXXX+..X....   ",
"  ..+XXXXX+++++++XXXXX+....X.   ",
"  .XXXXXXXXXXXXXXXXXXXX+......  ",
"   +XXXXXXXXXXXXXXXXXXXX+++++   ",
"   +XXXXXXXXXXXXXXXXXXX+XXXX+   ",
"   +XXX@@XX++++XXX@@XXXXXXXX+   ",
"   +X+@@@@X+###X+@@@@XX+XXXX+   ",
"   +X+@@@@X+###X+@@@@XXXXXXX+   ",
"   +X+@@@@X+###X+@@@@XX+XXXX+   ",
"   +X+@@@@X+###X+@@@@XXXXXXX+   ",
"   +X+@@@@X+#O#X+@@@@XX+XXXX+   ",
"   +X+++++X+###X+++++XXXXXXX+   ",
"   +XXXXXXX+###XXXXXXXX+XXXX+   ",
"   +XXXXXXX+###XXXXXXXXXXXXX+$  ",
" $$+XXXXXXX+###XXXXXXXX+XXXX+$$ ",
" $$$$$$$$$$$$$$$$$$$$$$$$$$$$$  ",
"  $$$$$$$$$$$$$$$$$ $$$$$$$$$   ",
"     $$  $$$ $$$$$$$$$$$$$      ",
"  $   $           $ $ $$        ",
"                                "};
}
\BGColor {grey45}
\BDColor {grey20}
\
\name	{www.top.help}
\class	{XBMButton}
\parent	{www.top}
\script	{
	switch (arg[0]) {
	case "buttonRelease":
		www("help");
	break;
	}
	usual();
}
\maxWidth {32}
\label {#define help_width 32
#define help_height 32
static char help_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0xfc, 0x03, 0x00, 0x00, 0xff, 0x0f, 0x00, 0x80, 0xff, 0x1f, 0x00,
   0xc0, 0x0f, 0x3e, 0x00, 0xc0, 0x03, 0x38, 0x00, 0xe0, 0x03, 0x78, 0x00,
   0xe0, 0x07, 0x78, 0x00, 0xe0, 0x07, 0x78, 0x00, 0xc0, 0x07, 0x3c, 0x00,
   0x80, 0x03, 0x3c, 0x00, 0x00, 0x00, 0x3e, 0x00, 0x00, 0x00, 0x1f, 0x00,
   0x00, 0x80, 0x0f, 0x00, 0x00, 0xc0, 0x03, 0x00, 0x00, 0xc0, 0x01, 0x00,
   0x00, 0xe0, 0x00, 0x00, 0x00, 0xe0, 0x01, 0x00, 0x00, 0xe0, 0x01, 0x00,
   0x00, 0xe0, 0x01, 0x00, 0x00, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0xe0, 0x01, 0x00, 0x00, 0xf0, 0x03, 0x00, 0x00, 0xf0, 0x03, 0x00,
   0x00, 0xf0, 0x03, 0x00, 0x00, 0xe0, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
}
\BGColor {grey45}
\FGColor {lightyellow}
\BDColor {grey20}
\
\name	{www.top.quit}
\class	{txtButton}
\parent	{www.top}
\script	{
	switch (arg[0]) {
	case "buttonRelease":
		www("quit");
	break;
	}
	usual();
}
\label {Quit}
\maxWidth {80}
\
\name	{www.title}
\class	{txtLabel}
\parent	{www}
\script	{
	switch (arg[0]) {
	case "show":
		if (arg[1] == "") {
			set("label", "<No Title>");
		} else {
			set("label", arg[1]);
		}
		render();
		return;
	break;
	}
	usual();
}
\label {Home page}
\wrap {1}
\maxHeight {22}
\BGColor {grey45}
\FGColor {white}
\font {bold_large}
\
\name	{www.view}
\class	{hpane}
\parent	{www}
\children {www.view.sb www.view.html}
\script {
	switch (arg[0]) {
	case "tear":
		tearPageID = tearPageID + 1;
		new = clone(tearPageID);
		tweak(new, "set(\"parent\", \"\");");
		send(new, "torn");
		send(new, "render");
		return;
	break;
	case "torn":
		windowName(send(nthChild(1), "queryTitle"));
		objectListSend("children", "torn");
		return;
	break;
	case "init":
		tearPageID = 0;
	break;
	case "quit":
		set("visible", 0);
		return;
	break;
	}
	usual();
}
\
\name	{www.view.sb}
\class	{vpane}
\parent	{www.view}
\maxWidth {20}
\script {
	switch (arg[0]) {
	case "tear":
	case "quit":
		send(get("parent"), arg[0]);
		return;
	break;
	case "torn":
		send(nthChild(0), "torn");
		return;
	break;
	}
	usual();
}
\children {www.view.sb.tear www.view.sb.up www.view.sb.down www.view.sb.slider}
\
\name {www.view.sb.tear}
\class {XBM}
\parent	{www.view.sb}
\label {#define tear_width 16
#define tear_height 16
static char tear_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0xfc, 0x0f, 0x0e, 0x0c, 0xfc, 0x0f, 0x0a, 0x0c,
   0xfc, 0x1f, 0x1a, 0x18, 0xf4, 0x3f, 0x3a, 0x70, 0xf4, 0xff, 0xea, 0x0f,
   0x54, 0x15, 0xaa, 0x0a, 0x54, 0x15, 0x00, 0x00};
}
\content {#define destroy_width 16
#define destroy_height 16
static char destroy_bits[] = {
   0xe0, 0x04, 0x00, 0x07, 0x00, 0x38, 0xf0, 0x3f, 0x10, 0x20, 0x50, 0x35,
   0x50, 0x35, 0x50, 0x35, 0x50, 0x35, 0x50, 0x35, 0x50, 0x35, 0x50, 0x35,
   0x58, 0x35, 0x14, 0x20, 0xe6, 0x1f, 0x00, 0x00};
}
\maxHeight {19}
\script {
	switch (arg[0]) {
	case "buttonRelease":
		if (isTorn == 1) {
/*			send(get("parent"), "quit");*/
			send(get("parent"), "tear");
		} else {
			send(get("parent"), "tear");
		}
		return;
	break;
	case "torn":
/*		set("label", get("content"));
		if (get("window") != 0) render();
*/
		isTorn = 1;
		return;
	break;
	}
	usual();
}
\FGColor {white}
\BGColor {grey45}
\BDColor {grey20}
\
\name	{www.view.sb.up}
\class	{XBMButton}
\parent	{www.view.sb}
\script	{
	switch (arg[0]) {
	case "buttonRelease":
		send(nthSibling(3), "scroll", "up");
	break;
	}
	usual();
}
\BGColor {grey40}
\FGColor {grey99}
\BDColor {grey75}
\label {#define upButton20_width 20
#define upButton20_height 20
static char upButton20_bits[] = {
   0x00, 0x00, 0x00, 0xfe, 0xff, 0x07, 0xfe, 0xff, 0x03, 0x56, 0x55, 0x05,
   0xae, 0xae, 0x00, 0x56, 0x59, 0x05, 0xae, 0xb0, 0x00, 0x56, 0x60, 0x05,
   0x2e, 0xc0, 0x00, 0x16, 0x80, 0x05, 0xae, 0xb0, 0x00, 0x56, 0x51, 0x05,
   0xae, 0xb0, 0x00, 0x56, 0x51, 0x05, 0xae, 0xb0, 0x00, 0x56, 0x55, 0x05,
   0xae, 0xaa, 0x00, 0x06, 0x00, 0x04, 0xaa, 0xaa, 0x02, 0x00, 0x00, 0x00};
}
\maxHeight {19}
\
\name	{www.view.sb.down}
\class	{XBMButton}
\parent	{www.view.sb}
\script	{
	switch (arg[0]) {
	case "buttonRelease":
		send(nthSibling(3), "scroll", "down");
	break;
	}
	usual();
}
\BGColor {grey40}
\FGColor {grey99}
\BDColor {grey75}
\label {#define fff_width 20
#define fff_height 20
static char fff_bits[] = {
   0x00, 0x00, 0x00, 0xfe, 0xff, 0x03, 0xfe, 0xff, 0x05, 0xae, 0xaa, 0x00,
   0x56, 0x55, 0x05, 0xae, 0xb0, 0x00, 0x56, 0x51, 0x05, 0xae, 0xb0, 0x00,
   0x56, 0x51, 0x05, 0xae, 0xb0, 0x00, 0x16, 0x80, 0x05, 0x2e, 0xc0, 0x00,
   0x56, 0x60, 0x05, 0xae, 0xb0, 0x00, 0x56, 0x59, 0x05, 0xae, 0xae, 0x00,
   0x56, 0x55, 0x05, 0x06, 0x00, 0x00, 0xaa, 0xaa, 0x02, 0x00, 0x00, 0x00};
}
\maxHeight {19}
\
\name	{www.view.sb.slider}
\class	{slider}
\parent	{www.view.sb}
\BDColor {grey99}
\BGColor {grey45}
\FGColor {grey70}
\shownNotify {www.view.html}
\
\name	{www.view.html}
\parent	{www.view}
\class	{HTML}
\script	{
	switch (arg[0]) {
	case "buttonRelease":
		if (isTorn) {
			www.mesg.tf("flash", 
				"Link direction from another page"); 
		}
		if (tag = nextTag()) {
		} else tag = previousTag();
		if (tag) {
			if (nthChar(tag, 1) == '*') {
				print("script:\n");
				interpret(tag);
			} else {
				www.view.html("show", tag);
				www.view.html("historyRecord");
			}
		} else {
			/*bell();*/
			www.mesg.tf("warn", 
				 "Only \\b( buttons ) may respond to clicks.");
		}
	break;
	case "home":
		www.view.html("show", homeDoc);
		return;
	break;
	case "about":
		www.view.html("show", www.about("handle"));
		return;
	break;
	case "help":
		www.view.html("show", www.help("handle"));
		return;
	break;
	case "show":
		www.mesg.tf("show",
			    concatenate("Getting ", arg[1], " ..."));
		cursorShape("busy");

		if (set("HTMLAddress", arg[1]) == "") {
			www.mesg.tf("show", 
				    concatenate("Failed to get ", arg[1]));
			cursorShape("idle");
			return 0;
		} else {
			www.title("show", get("HTMLTitle"));
			render();
			www.view.sb.slider("shownPositionV", 
					float(lineRowOffset()) / 
					float(totalLineCount() - 
					numberOfLinesDisplayed()) * 100.0);

			www.mesg.tf("show", "");
			www.udi.tf("show", arg[1]);
			www.idx.label("index", get("HTMLIsIndex"));

			previousDoc = currentDoc;
			currentDoc = get("HTMLAddress");
			cursorShape("idle");
			return 1;
		}
	break;
	case "historyRecord":
		wwwHistory("add", get("HTMLTitle"), get("HTMLAddress"));
		return;
	break;
	case "search":
		search(arg[1]);
		return;
	break;
	case "back":
		if (previousDoc != "") {
			www.view.html("show", previousDoc);
		} else {
			www.mesg.tf("alert", 
				    "No Previous document to go back to.");
		}
		return;
	break;
	case "prev":
		wantIt = wwwHistory("prev");
		if (wantIt != "") {
			www.view.html("show", wantIt);
		} else {
			www.mesg.tf("alert", 
				"No ``previous'' document to go to.");
		}
		return;
	break;
	case "next":
		wantIt = wwwHistory("next");
		if (wantIt != "") {
			www.view.html("show", wantIt);
		} else {
			www.mesg.tf("alert", 
				"No ``next'' document to go to.");
		}
		return;
	break;
	case "keyPress":
		www.idx.tf("focus");
		return;
	break;
	case "save":
		tmp = "/usr/tmp/out.html";	/* later, use dialog box */
		cmd = concatenate("www -n ", 
				get("HTMLAddress"), " > ", 
				tmp);
		system(cmd);
		return;
	break;
	case "queryAddress":
		return get("HTMLAddress");
	break;
	case "queryTitle":
		return get("HTMLTitle");
	break;
	case "tree":
		/* produce a n-level anchors tree by recursively fetching
		 * anchor links 
		 */
		return;
	break;
	case "init":
		initialize();

		homeDoc = environVar("WWW_HOME");
		if (homeDoc == "") 
		    homeDoc = accessible("/usr/local/lib/WWW/default.html");
		if (homeDoc == "") print("WWW: No page for home.\n");

		set("HTMLAddress", homeDoc);
		return;
	break;
	case "editSrc":
		wwwSrc("show", get("HTMLAddress"), get("HTMLSource"));
		return;
	break;
	case "print":
		/* This facility could be much better. But for now...
		 * ToDo:
		 * 	use WWW_PRINT 
		 * 	generate postscript (use variable width font)
		 * 	use internal formatter (no need to call www)
		 * 	use cached HTMLSource (no need to fetch html file)
		 */
		/*tmp = mktemp("/usr/tmp/wwwXXXXXX");*/
		tmp = "/usr/tmp/out.html";
		lprCmd = "lpr -Plw199b";
		www.mesg.tf("flash", 
				concatenate("Printing document using ",
						lprCmd, "."));
		system(concatenate("rm ", tmp));
		system(concatenate("www -n ", get("HTMLAddress"), " > ", tmp));
		system(concatenate(lprCmd, " ", tmp));
		return;
 	break;
	case "torn":
		isTorn = 1;
		return;
	break;
	case "enter":
		set("cursor", 0); /*lame...*/
		return;
	break;
	}
	usual();
}
\shownDepend {www.view.sb.slider}
\BGColor {100 100 85}
\FGColor {black}
\BDColor {grey75}
\font {usual_medium}
\
\name {www.idx}
\class {hpane}
\parent	{www}
\maxHeight {18}
\children {www.idx.label www.idx.tf www.hist.label www.prt.label www.src.label}
\
\name {www.idx.label}
\class {XBM}
\parent	{www.idx}
\content {#define idx_width 32
#define idx_height 16
static char idx_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x0e, 0x80, 0x01, 0x00, 0x04, 0xe0, 0x01, 0x00,
   0x04, 0xf0, 0x00, 0x00, 0x0e, 0x7c, 0x00, 0x00, 0x00, 0xff, 0x3f, 0x00,
   0x86, 0xff, 0xff, 0x07, 0xca, 0xff, 0xff, 0x7f, 0xca, 0xff, 0x37, 0x7e,
   0xc6, 0xff, 0xef, 0x00, 0xc0, 0xff, 0x1b, 0x01, 0xca, 0xff, 0xf7, 0x01,
   0x0a, 0xff, 0x8e, 0x00, 0x04, 0xfe, 0x79, 0x00, 0x0a, 0xe0, 0x67, 0x00,
   0x0a, 0x00, 0x1f, 0x00};
}
\maxWidth {80}
\script {
	switch (arg[0]) {
	case "index":
		if (arg[1] == 1) {
			set("label", get("content"));
			set("FGColor", "green");
		} else {
			set("label", "");
			set("FGColor", "black");
		}
		render();
		return;
	break;
	}
	usual();
}
\FGColor {black}
\BGColor {grey45}
\BDColor {grey20}
\
\name {www.idx.tf}
\class {txtDisp}
\parent {www.idx}
\script	{
	switch (arg[0]) {
	case "keyPress":
		c = key();
		if (c == '\r') {
			if (saveMouse) {
				/* restore mouse position */
				setMouse(saveMousePos[0], saveMousePos[1]);
				saveMouse = 0;
			}
			www("search", currentLine());
			set("content", "");
			render();
		} else {
			insert(c);
		}
		return;
	break;
	case "show":
		set("content", arg[1]);
		render();
		return;
	break;
	case "focus":
		/* save current mouse position, to warp back after key-entry */
		saveMousePos = mouse();
		saveMouse = 1;
		winPos = windowPosition();
		setMouse(winPos[0] + 18, winPos[1] + 18);
		set("content", "");
		render();
		www.idx.tf("keyPress");
		return;
	break;
	case "leave":
		/* cancel mouse warp to avoid confusion */
		if (saveMouse) saveMouse = 0;
	break;
	case "init":
		saveMouse = 0;
	break;
	}
	usual();
}
\BGColor {grey45}
\FGColor {white}
\BDColor {grey20}
\
\name {www.hist.label}
\class {XBM}
\parent	{www.idx}
\label {#define hist_width 16
#define hist_height 16
static char hist_bits[] = {
   0x00, 0x00, 0xf0, 0x0f, 0x08, 0x10, 0x18, 0x20, 0xfc, 0x7f, 0xfc, 0x07,
   0xfc, 0x07, 0xdc, 0x0e, 0xb8, 0x0d, 0x38, 0x1c, 0xb0, 0x3d, 0xa0, 0x3d,
   0xae, 0x3b, 0xf4, 0x1f, 0xf8, 0x0f, 0x00, 0x00};
}
\maxWidth {16}
\script {
	switch (arg[0]) {
	case "buttonRelease":
		wwwHistory("render");
		return;
	break;
	}
	usual();
}
\FGColor {white}
\BGColor {grey45}
\BDColor {grey20}
\
\name {www.prt.label}
\class {XBM}
\parent	{www.idx}
\label {#define prt_width 16
#define prt_height 16
static char prt_bits[] = {
   0x00, 0x00, 0xf8, 0x03, 0x88, 0x06, 0xf8, 0x0e, 0x88, 0x08, 0xf8, 0x0f,
   0x08, 0x08, 0xf8, 0x0f, 0x08, 0x08, 0xfc, 0x1f, 0x02, 0x20, 0x02, 0x60,
   0x1a, 0x60, 0x02, 0x20, 0xfe, 0x3f, 0x00, 0x00};
}
\maxWidth {16}
\script {
	switch (arg[0]) {
	case "buttonRelease":
		www.view.html("print");
		return;
	break;
	}
	usual();
}
\FGColor {white}
\BGColor {grey45}
\BDColor {grey20}
\
\name {www.src.label}
\class {XBM}
\parent	{www.idx}
\label {#define src_width 16
#define src_height 16
static char src_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xcc, 0x31, 0x52, 0x0a, 0x42, 0x0a,
   0x42, 0x0a, 0xc4, 0x0b, 0x48, 0x09, 0x50, 0x09, 0x50, 0x09, 0x52, 0x0a,
   0x4c, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
}
\maxWidth {16}
\script {
	switch (arg[0]) {
	case "buttonRelease":
		www.view.html("editSrc");
		return;
	break;
	}
	usual();
}
\FGColor {white}
\BGColor {grey45}
\BDColor {grey20}
\
\name {www.mesg}
\class {hpane}
\parent	{www}
\maxHeight {18}
\children {www.mesg.label www.mesg.tf}
\
\name {www.mesg.label}
\class {txtLabel}
\parent	{www.mesg}
\label {Message:}
\maxWidth {80}
\BGColor {grey45}
\FGColor {white}
\BDColor {grey20}
\
\name {www.mesg.tf}
\class {txtDisp}
\parent {www.mesg}
\script	{
	switch (arg[0]) {
	case "keyPress":
		return;
	break;
	case "show":
		set("content", arg[1]);
		if (get("window")) {
			set("FGColor", "100 90 70");
			render();
		}
		return;
	break;
	case "alert":
		if (get("render")) {
			set("BGColor", "red");
			set("content", " ");
			render();
			set("BGColor", "grey45");
			set("FGColor", "90 90 90");
			set("content", arg[1]);
			after(10, "www.mesg.tf", "fade1");
		}
		return;
	break;
	case "warn":
		if (get("render")) {
			set("BGColor", "yellow");
			set("content", " ");
			render();
			set("BGColor", "grey45");
			set("FGColor", "90 90 90");
			set("content", arg[1]);
			after(10, "www.mesg.tf", "fade1");
		}
		return;
	break;
	case "flash":
		if (get("render")) {
			set("BGColor", "green");
			set("content", " ");
			render();
			set("BGColor", "grey45");
			set("FGColor", "90 90 90");
			set("content", arg[1]);
			after(10, "www.mesg.tf", "fade1");
		}
		return;
	break;
	case "fade1":
		if (get("render")) {
			render();
			set("FGColor", "70 70 70");
			after(2000, "www.mesg.tf", "fade2");
		}
		return;
	break;
	case "fade2":
		render();
		set("FGColor", "20 20 20");
		after(500, "www.mesg.tf", "clear");
		return;
	break;
	case "clear":
		render();
		set("content", "");
		render();
		return;
	break;
	case "init":
		after(60000, "www.mesg.tf", "clear");
	break;
	}
	usual();
}
\content {Click on a \b( button ) to follow link.}
\font {fixed}
\BGColor {grey45}
\FGColor {100 80 60}
\BDColor {grey20}
\
\name {www.udi}
\class {hpane}
\parent	{www}
\maxHeight {32}
\children {www.udi.label www.udi.tf}
\
\name {www.udi.label}
\class {menu}
\parent	{www.udi}
\label {UDI:}
\menuConfig {
. {UDI <= XClipBuffer}		{www.udi.tf("getUDIFromClipBuffer");}
. {UDI => XClipBuffer} 		{www.udi.tf("putUDIInClipBuffer");}
. {UDI => home page}		{www.udi.tf("appendUDIToHome");}
}
\BGColor {grey45}
\FGColor {white}
\BDColor {white}
\maxWidth {80}
\
\name {www.udi.tf}
\class {txtDisp}
\parent {www.udi}
\script	{
	switch (arg[0]) {
	case "getUDIFromClipBuffer":
		www("show", getClipBuffer());
		return;
	break;
	case "putUDIInClipBuffer":
		www.mesg.tf("alert", 
			    "Sorry, clipBuffer-setting doesn't yet work.");
		setClipBuffer(www.view.html("queryAddress"));
		return;
	break;
	case "appendUDIToHome":
		www.mesg.tf("alert", 
			    "Sorry, can't yet append to home page.");
		return;
	break;
	case "show":
		set("content", arg[1]);
		render();
		return;
	break;
	}
	usual();
}
\font {fixed}
\BGColor {grey45}
\FGColor {white}
\BDColor {grey20}
\
\class {field}
\name {www.about}
\script {
	switch (arg[0]) {
	case "handle":
		/* tmp = mktemp("/usr/tmp/wwwXXXXXX.html");*/
		tmp = "/usr/tmp/aboutViola.html";
		saveFile(tmp, get("content"));
		return tmp;
	break;
	}
	usual();
}
\content {
<TITLE>Overview, ViolaWWW</TITLE>
<H1>ViolaWWW Hypertext Browser</H1>
ViolaWWW implements an X-Windows browser client to the 
<A HREF=http://info.cern.ch/hypertext/WWW/TheProject.html>World-Wide Web</A> 
system. This browser has the basic navigation mechanisms of 
clickable-hot-words, history list (previous/back/next document traversal),
and book-mark list. It has keyword search entry, and can do page cloning 
(multiple windows). There exists a simple printer hook, and a HTML source
viewer (not editor).
<P>
Incidentally, ViolaWWW (the browser) is a demonstration application 
of the <A HREF=file://xcf.berkeley.edu/misc/ht/projects/viola/overview.html>
Viola</A> interactive media tool. This browser application is being
developed as the core viola software itself is being developed. 
<P>
See also:
<A HREF=file://xcf.berkeley.edu/misc/ht/projects/viola/violaWWW/todo.html>
ToDo list</A>.
<P>Thanks for taking the time to do bug reports, and suggestions!

<H2>Status</H2>
<DL>
<DT>March 9, 1992
<DD>Pre-pre-alpha release (0.1) to CERN, for feedback...
<DT>April 3, 1992
<DD>Pre-alpha release (0.2) to CERN, round two.
</DL>

<P>
Check out the 
<A HREF=file://xcf.berkeley.edu/misc/ht/projects/viola/violaWWW/news.html>
ViolaWWW bulletin</A> at the XCF for the latest announcements, releases,
and bug-fixes regarding this software.
<P>

<ADDRESS><A HREF=file://xcf.berkeley.edu/misc/ht/people/wei/disclaimer.html>
Pei Y. Wei</A><P>
Experimental Computing Facility (XCF)<P>
University of California at Berkeley<P>
EMail: wei@xcf.berkeley.edu
</ADDRESS>
}
\
\class {field}
\name {www.help}
\script {
	switch (arg[0]) {
	case "handle":
		/* tmp = mktemp("/usr/tmp/wwwXXXXXX.html");*/
		tmp = "/usr/tmp/doYouFeelLucky.html";
		saveFile(tmp, get("content"));
		return tmp;
	break;
	}
	usual();
}
\content {<TITLE>User's Guide</TITLE>
<H1>User's Guide to ViolaWWW</H1>
This guide is not available as of this writing. But,
<A HREF=file://xcf.berkeley.edu/misc/ht/projects/viola/violaWWW/news.html>
click here</A> to see if it now exists at the XCF.
}
